<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>用卡记录</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--引入私有css文件--%>
    <!--TODO-->
</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul></ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont iconliebiao1"></i>
                  <span class="name-text">用卡记录</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main">
        <!--业务模块-->
        <div class="main-block">
            <div class="m-table-list">
                <div class="m-search-list">
                    <div class="search-form">
                        <div class="row">
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item">
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item">
                                    <input id="mcName" placeholder="请输入商铺名称">
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item">
                                    <input id="cardNum" placeholder="请输入卡号">
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item">
                                    <input id="typeName" placeholder="请输入卡类型">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="search-btn">
                        <button id="query-but" type="button" class="u-btn u-btn-primary u-btn-sm">
                            查询
                        </button>
                    </div>
                </div>
                <section class="content f-mt20">
                    <table>
                        <thead>
                        <tr>
                            <th class="m-table-col-1">编号</th>
                            <th class="m-table-col-2">卡号</th>
                            <th class="m-table-col-4">卡类型</th>
                            <th class="m-table-col-4">使用商铺</th>
                            <th class="m-table-col-4">使用商品</th>
                            <th class="m-table-col-2">消费数量</th>
                            <th class="m-table-col-2">流水类型</th>
                            <th class="m-table-col-2">流水时间</th>
                            <th class="m-table-col-2">流水状态</th>
                        </tr>
                        </thead>
                        <tbody id="recordsOfBo">

                        </tbody>
                    </table>
                </section>
            </div>

            <!--分页开始-->
            <div id="recordslaypage" class="f-mt20"></div>
            <!--分页结束-->
        </div>
        <!--业务模块结束-->
    </section>
    <!--内容区结束-->
</div>

<%--table模板--%>
<table id="templateTable" class="f-dn">
    <tr>
        <td><div class="f-tac label1"></div></td>
        <td><div class="f-tac label2 clickQuery f-csp"></div></td>
        <td><div class="f-tac label3"></div></td>
        <td><div class="f-tac label4"></div></td>
        <td><div class="f-tac label5"></div></td>
        <td><div class="f-tac label6"></div></td>
        <td><div class="f-tac label7"></div></td>
        <td><div class="f-tac label8"></div></td>
        <td><div class="f-tac label9"></div></td>
    </tr>
</table>

<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/laypage.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/init-page.js"></script>

<script>
    /*初始化分页信息*/
    var page = {
        currPage:0,
        pageSize:10,
    };

    /*卡记录状态*/
    var recordStatusArray = [
        {
            'value':'0',
            'label':'失败'
        }, {
            'value': '1',
            'label': '成功'
        }, {
            'value': '2',
            'label': '待处理'
        }
    ];

    /*用卡记录类型*/
    var recordTypeArray = [
        {
            'value':'10',
            'label':'赠送'
        }, {
            'value': '20',
            'label': '取消赠送'
        }, {
            'value': '21',
            'label': '支付消费'
        }, {
            'value': '30',
            'label': '信用调增'
        }, {
            'value': '31',
            'label': '还款'
        }, {
            'value': '40',
            'label': '信用调减'
        }, {
            'value': '41',
            'label': '信用支付消费'
        }, {
            'value': '60',
            'label': '年卡商品使用'
        }, {
            'value': '61',
            'label': '年卡商品使用预约'
        }, {
            'value': '70',
            'label': '优惠商品使用'
        }, {
            'value': '71',
            'label': '优惠商品使用预约'
        }
    ];

    //客户实体ID
    var boId = '${boId}';

    //记录类型
    var recordType = dyCom.getUrlParams('recordType');

    $().ready(function(){

        //查询用卡记录列表
        queryMCardRecordOfMineCustomer();

        $('#query-but').off('click').on('click',function () {
            queryMCardRecordOfMineCustomer();
        })

        //根据状态值，调整页面显示内容
        if (recordType || '0' == recordType) {
            if ('61' == recordType) {
                //流水类型：61 预约记录
                $('.wrapper-header .name-text').text('预约记录');
                $('.wrapper-option ul:first-child').find('a').html('补录预约记录');
            }
        }
    });

    /*获取用卡记录列表ajax需要的参数*/
    function getRecordsParams(){
        var paramsStr = '?';
        var paramsJson = [
            'page='+page.currPage,
            'size='+page.pageSize
        ];
        paramsJson.push('onlymc=3');

        //条件查询
        var mcName = $('#mcName').val();
        var cardNum = $('#cardNum').val();
        var typeName = $('#typeName').val();
        if(mcName){
            paramsJson.push('mcName='+mcName);
        }
        if(cardNum){
            paramsJson.push('cardNum='+cardNum);
        }
        if(typeName){
            paramsJson.push('typeName='+typeName);
        }

        if (recordType) {
            paramsJson.push('recordType=' + recordType);
        }

        if(token){
            paramsJson.push('token='+token);
        }
        paramsStr += paramsJson.join('&');
        return paramsStr;
    }
    //查询用卡记录列表
    function queryMCardRecordOfMineCustomer() {
        var recordsParams = getRecordsParams();
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/userecords/sp/'+boId+'/userecords'+recordsParams)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 渲染用卡记录列表
                setDataList(data);
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    //渲染用卡记录列表
    function setDataList(data) {
        //清空旧数据
        $("#recordsOfBo").html('');

        if(data && data.result){
            var objs = data.result;
            $.each(objs, function (i, obj) {
                /*克隆table 模板*/
                var trClone = $('#templateTable tr').clone();
                /*赋值*/
                trClone.find('.label1').text(i+1);
                trClone.find('.label2').text((obj.cardNum?obj.cardNum:''));
                trClone.find('.clickQuery').data('recordid',obj.recordId);

                trClone.find('.label3').text((obj.typeName?obj.typeName:''));
                trClone.find('.label4').text((obj.mcName?obj.mcName:''));
                trClone.find('.label5').html((obj.cmName?obj.cmName:''));
                trClone.find('.label6').html((obj.consumeNum?obj.consumeNum:''));
                trClone.find('.label7').html((obj.recordType ? recordTypeArray.find(x => x.value === obj.recordType).label : ''));
                trClone.find('.label8').html((obj.recordTime?obj.recordTime:''));
                trClone.find('.label9').html((obj.status ? recordStatusArray.find(x => x.value === obj.status).label : ''));

                /*追加HTML*/
                $("#recordsOfBo").append(trClone);
            });

            //查看配置项详情
            $('#recordsOfBo .clickQuery').off('click').on('click',function () {
                var recordId = $(this).data('recordid');
                <%--window.location.href = '${ctx}/userecords/'+encodeURI(recordId);--%>
            });


        }
        //分页
        dyPlugins.Page.init("recordslaypage",data.totalPage,data.currPage,data.pageSize,data.totalRows,function(pageData){
            //页码+1
            page.currPage = pageData.curr;
            queryMCardRecordOfMineCustomer();
        });
    }
</script>
</body>
</html>