<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<c:set var="ctx_ebmgrweb" value="/ebmcmgrweb"/>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>会员卡预约</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--引入私有css文件--%>
    <!--引入下拉框组件-->
    <link rel="stylesheet" href="${static_plugins}/select/pc/dist/css/select.css" />
</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul>
            <!--TODO-->
        </ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont icondaishenpiliebiao"></i>
                  <span class="name-text">会员卡预约</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main">
        <!--业务模块-->
        <div class="main-block">
            <div id="formValidate" class="m-table-detail m-form-list m-form-nolabel">
                <header class="title"><span>查询预约会员卡</span></header>
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4">
                                <span class="label-required"></span>卡号
                            </th>
                            <td colspan="2" class="m-table-col-20 td-edit">
                                <div class="item-form">
                                    <input id="cardNum" type="text" data-datatype="*" class="required" placeholder="请输入卡号">
                                </div>
                            </td>
                            <td>
                                <div class="item-form">
                                    <button id="getCard" type="button" class="u-btn u-btn-primary-outline u-btn-xs">
                                        查询
                                    </button>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </section>
                <header class="title f-dn" id="bindInfoT"><span>选中景区</span></header>
                <section class="content f-dn" id="bindInfoC">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4">卡类型名称</th>
                            <td colspan="3" class="m-table-col-20 td-edit">
                                <div class="item-form" id="typeName">

                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4">姓名</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="userName">
                                </div>
                            </td>
                            <th class="m-table-col-4">手机号</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="mobile">
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4">卡状态</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="cardStatus">
                                </div>
                            </td>
                            <th class="m-table-col-4">有效期</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="valid">
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4"><span class="label-required"></span>适用景区</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <input type="hidden" id="mcId">
                                    <input id="mcName" class="item-input" data-datatype="*" class="required"  placeholder="请选择" readonly>
                                </div>
                            </td>
                            <th class="m-table-col-4"><span class="label-required"></span>预约商品</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <input type="hidden" id="cmId">
                                    <span id="cmName"></span>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </section>
                <header class="title f-dn" id="reserveT"><span>选择预约时间</span></header>
                <section class="content f-dn" id="reserveC">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4"><span class="label-required"></span>预约时间</th>
                            <td colspan="3" class="m-table-col-20 td-edit">
                                <div class="item-form">
                                    <select class="s-select" id="recordTime"></select>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </section>
            </div>
        </div>
        <!--业务模块结束-->
        <div class="u-btn-fixed-placeholder"></div>
        <div class="f-tac u-btn-fixed-b24">
            <button type="button" class="u-btn u-btn-default" id="cancal">
                取消
            </button>
            <button id="submit" type="button" class="u-btn u-btn-primary f-ml20" data-click="true">
                确定
            </button>
        </div>
    </section>
    <!--内容区结束-->
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<%--选择时间组件--%>
<script src="${static_plugins}/third_party/lay_date-v5.0.9/laydate.js" type="text/javascript" charset="utf-8"></script>
<!--引入下拉框组件-->
<script  src="${static_plugins}/select/pc/dist/js/select.js" type="text/javascript" charset="utf-8"></script>
<!--引入表单验证-->
<script src="${static_js}/validate/validate.js" type="text/javascript" charset="utf-8"></script>
<%--js引入私有 枚举值信息--%>
<script src="${ctx}/static_new_new/js/data/mcardConstant.js"></script>
<script src="${ctx}/static_new_new/js/data/common.js"></script>
<script>
    //卡类型ID
    var typeId = '';
    /*用卡记录类型*/
    var recordTypeArray = [
        {
            'value':'10',
            'label':'赠送'
        }, {
            'value': '20',
            'label': '取消赠送'
        }, {
            'value': '21',
            'label': '支付消费'
        }, {
            'value': '30',
            'label': '信用调增'
        }, {
            'value': '31',
            'label': '还款'
        }, {
            'value': '40',
            'label': '信用调减'
        }, {
            'value': '41',
            'label': '信用支付消费'
        }, {
            'value': '60',
            'label': '年卡商品使用'
        }, {
            'value': '61',
            'label': '年卡商品使用预约'
        }, {
            'value': '70',
            'label': '优惠商品使用'
        }, {
            'value': '71',
            'label': '优惠商品使用预约'
        }
    ];

    /*1.初始化*/
    $().ready(function(){
        //数据验证初始化
        dyPlugins.Validate.init("#formValidate");

        //用卡记录类型下拉框初始化
        setRecordTypeToSelelct();

        //查询会员卡信息
        $("#getCard").off('click').on('click', function () {
            queryMCardInfo();
        });

        //选择使用商铺
        $('#mcName').off('click').on('click', function () {
            selectedMc();
        });

        //取消
        $('#cancal').off('click').on('click',function () {
            history.go(-1);
        })
        //提交
        $('#submit').off('click').on('click', function () {
            submitReserveInfo();
        });

    });
    /* 2.业务方法  */

    //用卡记录类型下拉框填充
    function setRecordTypeToSelelct(){
        $('#recordType').val('');

        var optionStatus = {
            domId: "#recordTypeSelect",
            selectName: "选择流水类型",
            keyName: "label",
            valueName: "value",
            selectedValue: ""
        };
        optionStatus.callback = function(selectObj) {
            $('#recordType').val(selectObj.value);
        };
        var selectData = recordTypeArray;
        dyPlugins.selectModel.init(optionStatus, selectData);
    }


    /*获取会员卡信息ajax需要的参数*/
    function getMCardParams(){
        var paramsStr = '?';
        if(token){
            paramsStr += 'token='+token;
        }
        return paramsStr;
    }
    //根据卡号查询会员卡信息
    function queryMCardInfo() {
        var cardNum = $('#cardNum').val();
        if(!cardNum){
            layer.msg( '请输入卡号');
            return false;
        }
        /*添加遮罩*/
        var loading = layer.load(1, {
            shade: [0.1,'#000'] //0.1透明度的白色背景
        });
        var mCardParams = getMCardParams(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcards/'+cardNum+mCardParams)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){

            //关闭遮罩
            layer.close(loading);
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setMCardInfoData(data.result);

            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);

    }
    //回显会员卡信息
    function setMCardInfoData(data) {
        if (data) {
            typeId = data.typeId;
            //获取会员卡类型信息
            if(typeId){
                /*卡类型信息*/
                queryCardType(typeId);
            }
            //用户信息
            $('#userName').html(dyCom.stringFiltedNull(data.userName));
            $('#mobile').html(dyCom.stringFiltedNull(data.mobile));
            //卡状态
            var status = getValue(cardStatusList, data.cardStatus);
            $('#cardStatus').html(status);
            //卡有效期
            var validStartDate = dyCom.stringFiltedNull(data.validStartDate);
            var validEndDate = dyCom.stringFiltedNull(data.validEndDate);
            $('#valid').html('<span>'+validStartDate+'至'+validEndDate+'</span>');

            //展示出绑定信息
            $('#bindInfoT').removeClass('f-dn');
            $('#bindInfoC').removeClass('f-dn');
        } else {
            layer.msg('会员卡不存在！');
        }
    }

    /*获取会员卡类型信息ajax需要的参数*/
    function getCardTypeParams(){
        var paramsStr = '?';
        if(token){
            paramsStr += 'token='+token;
        }
        return paramsStr;
    }
    //查询会员卡类型信息
    function queryCardType(typeId) {

        var cardTypeParams = getCardTypeParams(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcardtypes/'+typeId+cardTypeParams)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setMCardTypeInfoData(data.result);
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);

    }
    //会员卡信息回显
    function setMCardTypeInfoData(data) {
        if (data) {
            $('#typeName').html(dyCom.stringFiltedNull(data.typeName));
        }
    }


    //选择分销商铺
    /*
        * tabTitleList 0,1,3,4  必填  0 自营商铺 sp  1 分销商铺 ag 3圈子下的实体的商铺(目前没有接口)
        * token 必填
        * 特殊情况 必填项
        * customId 当tabTitleList=1的时候 必填 其他时候不必填
        * cgroupId 当当tabTitleList=3的时候 必填 其他时候不必填
        *
        * */
    function selectedMc() {
        var childWindow = null;
        layer.open({
            id: "selectRepLayer",
            type: 2,
            title: "商铺",
            shadeClose: true,
            shade: 0.6,
            maxmin: true, //开启最大化最小化按钮
            area: ["750px", "560px"],
            content:
                ctx +
                "/mcards/choosemcfree?isMulChoice=false&tabTitleList=0&typeId=" + typeId + '&token=' +
                token,
            success: function(ee) {
                //初始化完成之后  例如修改的时候 需要处理
                var frameId = document
                    .getElementById("selectRepLayer")
                    .getElementsByTagName("iframe")[0].id;
                childWindow = $("#" + frameId)[0].contentWindow;
                // item  必须字段 objType itemId  name
                childWindow.setItemsList([]);
            },
            btn: ["确定", "取消"],
            yes: function(index) {
                var datalist = childWindow.getItemsList();
                if(datalist && datalist.length){
                    setMcInfo(datalist[0]);
                }
                layer.close(index);
            },
            btn2: function(index) {}
        });
    }
    //填充选中景区信息
    function setMcInfo(info) {
        //景区名称
        $('#mcName').val(dyCom.stringFiltedNull(info.mcName));
        //景区ID
        $('#mcId').val(dyCom.stringFiltedNull(info.mcId));
        //商品ID
        $('#cmId').val(dyCom.stringFiltedNull(info.cmId));
        //商品名称
        $('#cmName').text(dyCom.stringFiltedNull(info.cmName));

        //显示出预约时间框
        $('#reserveT').removeClass('f-dn');
        $('#reserveC').removeClass('f-dn');

        //查询可预约日期
        queryMcardReserveDayList(info.mcId);
    }

    /*获取预约提交数据*/
    function getReserveParams(){
        var paramsStr = {};
        //卡信息
        paramsStr['cardNum'] = $('#cardNum').val();         //会员卡卡号
        //使用记录
        paramsStr['mcId'] = $('#mcId').val();         //商铺ID
        paramsStr['cmId'] = $('#cmId').val();         //商品ID
        paramsStr['recordTime'] = $('#recordTime').val();         //预约日期
        paramsStr['consumeNum'] = '1';         //次数
        return paramsStr;
    }
    //提交预约记录
    function submitReserveInfo() {
        //防止多次提交
        var clickFlag = $("#submit").data("click");
        if (!clickFlag) {
            return false;
        }
        //提交之前验证
        $("#submit").data("click", false); //设置不可点击提交按钮
        //提交验证 errTime 返回 0的时候 说明验证都通过 >0 说明 有errTime处有信息问题
        var errTime = dyPlugins.Validate.checkAll();
        // console.log(errTime + "错误次数");
        if (errTime > 0) {
            $("#submit").data("click", true); //设置可以点击
        }else{
            var svrParamsString = getReserveParams(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条

            //ajax请求配置
            var optionsAjax = {
                url: ctx+'/ajax/post?restPath='+encodeURI('/mcardsvr/mcards/reserve?token='+token)+'&token='+token,  //请求url
                type: "post",         //请求类型 默认get
                async: true,            //异步|同步加载 默认异步
                dataType: "json",      //数据类型      默认json
                data:JSON.stringify({appData:svrParamsString})
            }
            optionsAjax.callback = function(type,data){
                //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
                //返回结果处理
                if(type==1){
                    layer.msg('会员卡预约成功');
                    //跳转查询预约记录列表
                    location.href = ctx+'/userecords/sp/mine/userecords';
                }else{
                    layer.msg(data?data:'会员卡预约失败！');
                }
            }
            dyCom.ajaxRequest(optionsAjax);
        }
    }

    //选择预约日期
    function selectDate(begin, end) {
        console.log(begin, end);
        laydate.render({
            elem: '#recordTime'
            ,min: begin
            ,max: end
        });
    }

    //获取景区预约日期列表需要的参数
    function getMcardReserveDayParams() {
        var paramsStr = '?';
        var paramsJson = [];

        if(token){
            paramsJson.push('token='+token);
        }

        paramsStr += paramsJson.join('&');
        return paramsStr;
    }

    //获取景区预约日期列表
    function queryMcardReserveDayList(mcId) {
        if (mcId) {
            var params = getMcardReserveDayParams(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
            var paramsJson = {
                restPath:encodeURI('/ebsvr/mcs/'+ mcId +'/reservecal'+params)
            };
            var optionsAjax = {
                url: ctx+'/ajax/get',  //请求url
                type: "get",         //请求类型 默认get
                async: true,            //异步|同步加载 默认异步
                dataType: "json",      //数据类型      默认json
                data:paramsJson
            }
            optionsAjax.callback = function(type,data){

                //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
                //返回结果处理
                if(type==1){
                    //1 数据渲染
                    setSelect(data.result);
                }else{
                    layer.open({
                        content: data
                        ,skin: 'msg'
                        ,time: 2 //2秒后自动关闭
                    });

                    $('#cardListModel').addClass('f-dn');
                    $('#cardTypeListModel').removeClass('f-dn');
                }
            }
            dyCom.ajaxRequest(optionsAjax);
        }
    }

    //填充预约日期选择框
    function setSelect(dataList) {
        if (dataList) {
            $('#recordTime').html('');
            for(var i = 0, len = dataList.length; i < len; i++) {
                var date = dataList[i];
                var context = date.reserveDay + '(上限：'+ date.reserveMaxNumber + '人,余量：'+
                    date.reserveMarginNumber+'人）';
                $('#recordTime').append('<option value="'+date.reserveDay+'">'+context+'</option>');
            }
        }
    }

</script>
</body>
</html>