<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>卡调配记录详情</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--下拉框 样式--%>
    <link href="${static_plugins}/select/pc/dist/css/select.css" rel="stylesheet">

</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul></ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont icondescribe"></i>
                  <span class="name-text">卡调配记录详情</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main">
        <div class="main-block">
            <div id="formValidate" class="m-table-detail m-form-list m-form-nolabel">
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4"><span class="label-required"></span>调出客户：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="boName"></div>
                            </td>
                            <th class="m-table-col-4"><span class="label-required"></span>调入客户：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="allocateBoName"></div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4"><span class="label-required"></span>调出机构：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="organName"></div>
                            </td>
                            <th class="m-table-col-4"><span class="label-required"></span>调入机构：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="allocateOrganName"></div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4"><span class="label-required"></span>操作人：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="accountName"></div>
                            </td>
                            <th class="m-table-col-4"><span class="label-required"></span>接收人：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="allocateAccountName"></div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4"><span class="label-required"></span>操作时间：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="allocateDate"></div>
                            </td>
                            <th class="m-table-col-4"><span class="label-required"></span>接收时间：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="receiveDate"></div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4">卡类型：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <span class="f-ib" id="typeName"></span>--
                                    <span class="f-ib" id="childtypeName"></span>
                                </div>
                            </td>
                            <th class="m-table-col-4">调配数量：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <span id="cardCountActual"></span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4">卡号段：</th>
                            <td colspan="3" class="m-table-col-20 td-edit">
                                <div class="item-form">
                                    <span class="f-ib" id="cardSegmentStart"></span>--
                                    <span class="f-ib" id="cardSegmentEnd"></span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4">说明：</th>
                            <td colspan="3" class="m-table-col-20 td-edit">
                                <div class="item-form" id="memo"></div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </section>
            </div>
        </div>

    </section>
    <!--内容区结束-->
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>

<script>

    var recordId = '${recordId}';
    /*1.初始化*/
    $().ready(function(){
        /*获取卡调配记录详情*/
        getMCardAllocateRecord();
    });
    /* 2.业务方法  */

    /*获取卡调配记录详情需要的参数*/
    function getAllocateParams() {
        var paramsStr = '?';
        if(token){
            paramsStr += 'token='+token;
        }
        return paramsStr;
    }
    /*获取卡调配记录详情*/
    function getMCardAllocateRecord() {
        var allocateParams = getAllocateParams();
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/allocates/'+recordId+allocateParams)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 渲染卡调配记录详情
                setAllocateRecordData(data.result);

            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    /*渲染卡调配记录详情*/
    function setAllocateRecordData(obj) {
        if(obj){
            //处理基本信息
            for (var key in obj) {
                $('#'+key).html(obj[key]);
            }
        }
    }

</script>
</body>
</html>
