<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>卡调配</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--下拉框 样式--%>
    <link href="${static_plugins}/select/pc/dist/css/select.css" rel="stylesheet">

</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul></ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont icontiaobo"></i>
                  <span class="name-text">卡调配</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main">
        <div class="main-block">
            <div id="formValidate" class="m-table-detail m-form-list m-form-nolabel">
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4"><span class="label-required"></span>调出客户：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <input type="hidden" id="boId">
                                    <input type="text" id="boName" placeholder="请选择调出客户" data-datatype="*" class="required" readonly>
                                </div>
                            </td>
                            <th class="m-table-col-4"><span class="label-required"></span>调入客户：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <input type="hidden" id="allocateBoId">
                                    <input type="text" id="allocateBoName" placeholder="请选择调入出客户" data-datatype="*" class="required" readonly>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4"><span class="label-required"></span>调出机构：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <input type="hidden" id="organId">
                                    <input type="text" id="organName" placeholder="请选择调出机构" data-datatype="*" class="required" readonly>
                                </div>
                            </td>
                            <th class="m-table-col-4"><span class="label-required"></span>调入机构：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <input type="hidden" id="allocateOrganId">
                                    <input type="text" id="allocateOrganName" placeholder="请选择调入机构" data-datatype="*" class="required" readonly>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4"><span class="label-required"></span>操作人：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <input type="hidden" id="accountId">
                                    <input type="text" id="accountName" placeholder="请选择操作人" data-datatype="*" class="required" readonly>
                                </div>
                            </td>
                            <th class="m-table-col-4"><span class="label-required"></span>接收人：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <input type="hidden" id="allocateAccountId">
                                    <input type="text" id="allocateAccountName" placeholder="请选择接收人" data-datatype="*" class="required" readonly>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4"><span class="label-required"></span>操作时间：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <input type="text" id="allocateDate" placeholder="请选择操作时间" data-datatype="*" class="required" readonly>
                                </div>
                            </td>
                            <th class="m-table-col-4"><span class="label-required"></span>接收时间：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <input type="text" id="receiveDate" placeholder="请选择接收时间" data-datatype="*" class="required" readonly>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4">卡类型：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <div class="m-select f-ib" id="selectCardType" style="width: 49%;"></div>
                                    <div class="m-select f-ib" id="selectChildCardType" style="width: 49%;"></div>
                                </div>
                            </td>
                            <th class="m-table-col-4">调配数量：</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <input type="text" id="cardCountActual" placeholder="请输入调配数量" data-datatype="*" class="required">
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4">卡号段：</th>
                            <td colspan="3" class="m-table-col-20 td-edit">
                                <div class="item-form">
                                    <input type="text" id="cardSegmentStart" placeholder="请输入起始号" data-datatype="*" class="required" style="width: 49%;">
                                    <input type="text" id="cardSegmentEnd" placeholder="请输入截止号" data-datatype="*" class="required" style="width: 49%;">
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4">说明：</th>
                            <td colspan="3" class="m-table-col-20 td-edit">
                                <div class="item-form">
                                    <textarea id="memo"></textarea>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </section>
            </div>
        </div>
        <!--业务模块结束-->
        <div class="u-btn-fixed-placeholder"></div>
        <div class="f-tac u-btn-fixed-b24">
            <button type="button" class="u-btn u-btn-default" id="cancalBut">
                取消
            </button>
            <button id="submitBut" type="button" class="u-btn u-btn-primary f-ml20" data-click="true">
                确定
            </button>
        </div>
    </section>
    <!--内容区结束-->
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<%--<!--js引入私有 下拉选择组件-->--%>
<script type="text/javascript" charset="utf-8" src="${static_plugins}/select/pc/dist/js/select.js"></script>
<%--选择时间--%>
<script type="text/javascript" charset="utf-8" src="${static_plugins}/third_party/lay_date-v5.0.9/laydate.js"></script>
<!--引入表单验证-->
<script src="${static_js}/validate/validate.js" type="text/javascript" charset="utf-8"></script>

<script>
    /*卡类型*/
    var cardTypeArray = [];
    /*子卡类型*/
    var childCardTypeArray = [];

    /*1.初始化*/
    $().ready(function(){

        /*选择调出客户实体*/
        $("#boName").off("click").on("click", function() {
            selectData('customer','callout')
        });
        /*选择调入客户实体*/
        $("#allocateBoName").off("click").on("click", function() {
            selectData('customer','callin')
        });

        /*选择调出机构*/
        $("#organName").off("click").on("click", function() {
            selectData('organ','callout')
        });
        /*选择调入机构*/
        $("#allocateOrganName").off("click").on("click", function() {
            selectData('organ','callin')
        });

        /*选择调出操作员*/
        $("#accountName").off("click").on("click", function() {
            selectData('account','callout')
        });
        /*选择调入接收员*/
        $("#allocateAccountName").off("click").on("click", function() {
            selectData('account','callin')
        });

        /*选择调出操作时间*/
        laydate.render({
            elem: '#allocateDate'
            ,type: 'datetime'
        });

        /*选择调入接收时间*/
        laydate.render({
            elem: '#receiveDate'
            ,type: 'datetime'
        });

        /*初始化 卡类型下拉框*/
        selectCardType();
        /*初始化 子卡类型下拉框*/
        selectChildCardType();

        //取消
        $("#cancalBut").off("click").on("click", function() {
            history.go(-1);
        });

        //点击提交
        $('#submitBut').off('click').on('click', function () {
            createSubmit();
        })
    });
    /* 2.业务方法  */
    /*公共选择组件*/
    function selectData(type,operate) {
        layer.open({
            type: 2,
            title: '选择实体、组织、人',
            shadeClose: true,
            shade: false,
            maxmin: true, //开启最大化最小化按钮
            area: ['893px', '600px'],
            btn: ['确定', '取消'],
            yes: function(index, layero){
                layer.close(index);
                //选择实体后回显
                showSelectedData(type,operate,layero);
            },btn2: function(index, layero){
                layer.close(index);
            },
            content: '/rbweb/stakeholders/addStakeholders'
        });
    }

    //回显弹框选择的信息
    function showSelectedData(type,operate,layero) {
        var stakeholderJson = layero.find("iframe")[0].contentWindow.$("#stakeholderList").val();

        if(stakeholderJson){
            var stakeholderMap = new Map();
            /*JSON字符串转Map*/
            stakeholderMap = _objToStrMap(JSON.parse(stakeholderJson));
            for(var [key,value] of stakeholderMap){
                if(type == 'customer'){
                    if(operate == 'callout'){
                        $("#boId").val(value.customerId);
                        $("#boName").val(value.customerName);

                        /*查询指定客户实体发行的卡类型*/
                        queryMCardTypeOfCustomer(value.customerId);

                    }else {
                        $("#allocateBoId").val(value.customerId);
                        $("#allocateBoName").val(value.customerName);
                    }
                }
                if(type == 'organ'){
                    if(operate == 'callout'){
                        $("#organId").val(value.organId);
                        $("#organName").val(value.organName);
                    }else {
                        $("#allocateOrganId").val(value.organId);
                        $("#allocateOrganName").val(value.organName);
                    }

                }
                if(type == 'account'){
                    if(operate == 'callout'){
                        $("#accountId").val(value.accountId);
                        $("#accountName").val(value.accountName);
                    }else {
                        $("#allocateAccountId").val(value.accountId);
                        $("#allocateAccountName").val(value.accountName);
                    }

                }
                //只取第一个人
                break;
            }
        }
    }
    //JSON 转 Map
    function _objToStrMap(obj){
        let strMap = new Map();
        for (let k of Object.keys(obj)) {
            strMap.set(k,obj[k]);
        }
        return strMap;
    }


    //下拉选择卡类型
    function selectCardType() {
        var option = {
            domId: "#selectCardType",
            selectName: "卡类型",
            keyName: "typeName",
            valueName: "typeId",
            selectedValue: ""
        };
        option.callback = function (selectObj) {
            var cardTypeId = selectObj.value;

            /*获取指定卡类型下的子卡类型列表*/
            queryMCardChildTypeOfCardType(cardTypeId);
        };
        dyPlugins.selectModel.init(option, cardTypeArray);
    }

    //下拉选择子卡类型
    function selectChildCardType() {
        var option = {
            domId: "#selectChildCardType",
            selectName: "卡类型",
            keyName: "childtypeName",
            valueName: "childtypeId",
            selectedValue: ""
        };
        option.callback = function (selectObj) {};
        dyPlugins.selectModel.init(option, childCardTypeArray);
    }


    /*获取发行的卡类型ajax需要的参数*/
    function getMCardTypesParams(){
        var paramsStr = '?';
        var paramsJson = [];
        /*卡类型*/
        if(token){
            paramsJson.push('token='+token);
        }
        paramsStr += paramsJson.join('&');
        return paramsStr;
    }
    /*查询指定客户实体发行的卡类型*/
    function queryMCardTypeOfCustomer(boId){
        var typesParams = getMCardTypesParams();
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcardtypes/operator/' + boId + '/mcardtypes'+typesParams)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                if(data && data.result){
                    cardTypeArray = data.result;
                    /*初始化 卡类型下拉框*/
                    selectCardType();
                    /*初始化 子卡类型下拉框*/
                    selectChildCardType();
                }
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }

    /*获取发行的子卡类型ajax需要的参数*/
    function getMCardChildTypesParams(){
        var paramsStr = '?';
        var paramsJson = [];
        /*卡类型*/
        if(token){
            paramsJson.push('token='+token);
        }
        paramsStr += paramsJson.join('&');
        return paramsStr;
    }
    /*获取指定卡类型下的子卡类型列表*/
    function queryMCardChildTypeOfCardType(tid){
        var typesParams = getMCardChildTypesParams();
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcardtypes/'+tid+'/childtypes'+typesParams)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                if(data && data.result){
                    childCardTypeArray = data.result;

                }else {
                    childCardTypeArray = [];
                    /*TODO 生产制卡 是否必须指定子卡类型？？？暂定必须*/
                    layer.msg('该卡类型暂无子卡类型，请切换卡类型');
                }
            }else{
                layer.msg(data);
                childCardTypeArray = [];
            }

            selectChildCardType();
        }
        dyCom.ajaxRequest(optionsAjax);
    }


    /*ajax需要的参数*/
    function ajaxPostCreateParams() {
        var paramsObj = {};
        var cardTypeId = $('#selectCardType select').val();
        var childCardTypeId = $('#selectChildCardType select').val();

        if(cardTypeId){
            paramsObj.typeId = cardTypeId;
        }
        if(childCardTypeId){
            paramsObj.childtypeId = childCardTypeId;
        }

        //配置项基本信息
        $('#formValidate .item-form>input').each(function (i,n) {
            var name = $(n).attr('id');
            var value = $(n).val();
            if(value){
                paramsObj[name] = value;
            }
        });
        $('#formValidate .item-form>textarea').each(function (i,n) {
            var name = $(n).attr('id');
            var value = $(n).val();
            if(value){
                paramsObj[name] = value;
            }
        });

        return paramsObj;
    }
    /**/
    function createSubmit() {
        var clickFlag = $("#submitBut").data("click");
        if (!clickFlag) {
            return false;
        }
        //提交之前验证
        $("#submitBut").data("click", false); //设置不可点击提交按钮
        //提交验证 errTime 返回 0的时候 说明验证都通过 >0 说明 有errTime处有信息问题
        var errTime = dyPlugins.Validate.checkAll();
        if (errTime > 0) {
            $("#submitBut").data("click", true); //设置可以点击
        }else{
            var params = ajaxPostCreateParams();

            var optionsAjax = {
                url: '${ctx}/ajax/post?restPath='+encodeURIComponent('/mcardsvr/allocates/apply?token=${sessionScope.token}'),  //请求url
                type: "post",         //请求类型 默认get
                async: true,            //异步|同步加载 默认异步
                dataType: "json",      //数据类型      默认json
                data:JSON.stringify({appData:params})
            }
            optionsAjax.callback = function(type,data){
                //返回结果处理
                if(type==1){
                    layer.msg('卡调配成功！');
                    window.location.href = "${ctx}/allocates/allocate"
                }else{
                    layer.msg(data?data:'卡调配成功失败！');
                }
                $("#submitBut").data("click", true); //设置可以点击
            }
            dyCom.ajaxRequest(optionsAjax);
        }
    }
</script>
</body>
</html>
