<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>会员卡类型基本信息</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-js.jsp" %>
    <!--引入私有 卡类型竖版页面样式-->
    <link rel="stylesheet" href="${ctx}/static_new_new/css/view/cardType/cardTypeStyle.css"/>
</head>
<body>
<div class="app-wrapper">
    <!--头部开始-->
    <header id="dyPluginHeaderTemplate"></header>
    <!--头部结束-->
    <!--内容区开始-->
    <section class="f-mt15">
        <div class="m-table-list">
            <!--会员卡基本信息 开始-->
            <div class="primaryImg" id="primaryImg"></div>
            <section class="content">
                <table>
                    <tbody class="cardInfoTab" id="cardDataInfo">
                    <tr>
                        <th width="40%" id="typeName"></th>
                        <th width="60%" id="showTypeStatus"></th>
                    </tr>
                    <tr>
                        <th>发行机构</th>
                        <td id="organName"></td>
                    </tr>
                    <tr>
                        <th>发行时间</th>
                        <td id="createTime"></td>
                    </tr>
                    <tr>
                        <th>简介</th>
                        <td id="cardDesc"></td>
                    </tr>
                    </tbody>
                </table>
            </section>
            <!--会员卡基本信息 结束-->
                <div class="main-block">
                    <ul class="m-tab-list" id="tabList">
                        <li class="list-item active" data-catid="1">
                            <span class="item-label">基本信息</span>
                            <span class="item-line"></span>
                        </li>
                        <li class="list-item" data-catid="2" onclick="queryChildTypes()">
                            <span class="item-label">子卡</span>
                            <span class="item-line"></span>
                        </li>
                        <li class="list-item" data-catid="3" onclick="queryMcFrees()">
                            <span class="item-label">适用商铺</span>
                            <span class="item-line"></span>
                        </li>
                        <li class="list-item" data-catid="4" onclick="queryMcCatalogs()">
                            <span class="item-label">优惠目录</span>
                            <span class="item-line"></span>
                        </li>
                    </ul>
                </div>
                <!--基本信息开始-->
                <section class="content">
                <table>
                    <tbody class="cardInfoTab">
                    <tr>
                        <th colspan="2">销售规则</th>
                    </tr>
                    <tr>
                        <th width="40%">价格</th>
                        <td id="showCardPrice"></td>
                    </tr>
                    <tr>
                        <th>续费时间</th>
                        <td id="showAdvanceBuyDay"></td>
                    </tr>
                    <tr>
                        <th>每人最多可绑定</th>
                        <td id="showHaveNumber"></td>
                    </tr>
                    <tr>
                        <th colspan="2">使用规则</th>
                    </tr>
                    <tr>
                        <th>有效期方式</th>
                        <td id="showValidWay"></td>
                    </tr>
                    <tr>
                        <th>有效期</th>
                        <td id="showValidDate"></td>
                    </tr>
                    </tbody>
                </table>
                </section>
                <!--基本信息结束-->
            </section>
            <%--会员卡基本信息 结束--%>

        </div>
    </section>
    <!--内容区结束-->
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-footer-js.jsp" %>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-global-var-script.jsp" %>
<!--js私有 菜单导航-->
<script type="text/javascript" src="${static_js}/menu/menu_mgr_top_bar.js?v=202101121813"></script>
<%--引入私有  卡类型状态--%>
<script src="${ctx}/static_new_new/js/data/cardTypeConstant.js"></script>
<%--引入私有  卡类型状态处理--%>
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeShowConstant.js"></script>
<%--引入私有  卡类型数据处理--%>
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeInfo_app.js"></script>
<script>
    /*会员卡类型Id*/
    var typeId = '${typeId}';
    //会员卡信息请求路径
    var getUrl = '/mcardsvr/mcardtypes/' + encodeURI(typeId) + '/details';
    //子卡列表请求路径
    var getChildListUrl = '/mcardsvr/mcardtypes/' + encodeURI(typeId) + '/childtypes';
    $().ready(function () {

        //头部加载  判断是否显示 在微信 在app中
        var option = {
            domId: "#dyPluginHeaderTemplate",
            fixed: true,
            title: "会员卡类型基本信息",
            isHistory: false,
            isApp: true,
            jumpCallback: function () {
                //当isHistory等于false的生效
                history.go(-1);
            }
        };
        dyPlugins.Header.init(option);

        //头部导航 如果有头部导航的话 覆盖原来的头部标题
        menuMgrTopBarInit();
        //获取会员卡类型信息
        getDataInfo(getUrl);
        //获取当前卡类型下的子卡类型列表
        getChildCardTypes(getChildListUrl)

    });

    /*点击工具栏--跳转到相应的页面*/
    function queryMcFrees() {
        window.event.returnValue = false;
        window.location.href = "${ctx}/mcardtypes/" + encodeURI(typeId) + "/cmfrees";
    }
    function queryMcCatalogs() {
        window.event.returnValue = false;
        window.location.href = "${ctx}/mcardtypes/" + encodeURI(typeId) + "/mccatalogs";
    }
    function queryChildTypes() {
        window.event.returnValue = false;
        window.location.href = "${ctx}/mcardtypes/" + encodeURI(typeId) + "/childtypes";
    }
</script>
</body>
</html>
