<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>子卡类型的基本信息</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-js.jsp"%>
    <!--引入私有 卡类型竖版页面样式-->
    <link rel="stylesheet" href="${ctx}/static_new_new/css/view/cardType/cardTypeStyle.css" />
</head>
<body>
<div class="app-wrapper">
    <!--头部开始-->
    <header id="dyPluginHeaderTemplate"></header>
    <!--头部结束-->
    <!--内容区开始-->
    <section class="f-mt15">
        <div class="m-table-list" id="childCardBaseInfo">
            <%--会员卡基本信息 开始--%>
            <div class="primaryImg" id="primaryImg"></div>
            <section class="content">
                <table>
                    <tbody class="cardInfoTab">
                    <tr>
                        <th width="40%" id="childtypeName"></th>
                        <th width="60%" id="showTypeStatus"></th>
                    </tr>
                    <tr>
                        <th>所属卡类型</th>
                        <td id="typeName"></td>
                    </tr>
                    <tr>
                        <th>子卡说明</th>
                        <td id="childcardDesc"></td>
                    </tr>
                    <tr>
                        <td colspan="2">&nbsp;</td>
                    </tr>
                    <tr>
                        <th colspan="2">卡号规则</th>
                    </tr>
                    <tr>
                        <th>卡号前缀</th>
                        <td id="cardNumPrefix"></td>
                    </tr>
                    <tr>
                        <th>卡号长度</th>
                        <td id="cardNumLen"></td>
                    </tr>
                    <tr>
                        <th>卡面值</th>
                        <td id="cardPrice"></td>
                    </tr>
                    <tr>
                        <th>是否带校验位（最后1位）</th>
                        <td id="cardNumCheck"></td>
                    </tr>
                    <tr>
                        <th>是否支持虚拟卡</th>
                        <td id="isVirtualCard"></td>
                    </tr>
                    <tr>
                        <th>备注</th>
                        <td id="childCardDemo"></td>
                    </tr>
                    </tbody>
                </table>
            </section>
            <%--会员卡基本信息 结束--%>
        </div>
    </section>
    <!--内容区结束-->
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-global-var-script.jsp"%>
<!--js私有 菜单导航-->
<script type="text/javascript" src="${static_js}/menu/menu_mgr_top_bar.js?v=202101121813"></script>
<%--引入私有  卡类型状态--%>
<script src="${ctx}/static_new_new/js/data/cardTypeConstant.js"></script>
<%--引入私有  卡类型状态处理--%>
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeShowConstant.js"></script>
<%--引入私有  卡类型数据处理--%>
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeInfo_app.js"></script>
<script>
    /*会员卡类型Id*/
    var childtypeId = '${childtypeId}';
    //会员卡信息请求路径
    var getUrl = '/mcardsvr/mcardtypes/childtypes/' + encodeURI(childtypeId);
    $().ready(function(){

        //头部加载  判断是否显示 在微信 在app中
        var option = {
            domId: "#dyPluginHeaderTemplate",
            fixed: true,
            title: "子卡类型的基本信息",
            isHistory: true,
            isApp: true,
            jumpCallback: function() {
                //当isHistory等于false的生效
            }
        };
        dyPlugins.Header.init(option);

        //头部导航 如果有头部导航的话 覆盖原来的头部标题
        menuMgrTopBarInit();

        //获取会员卡类型信息
        getDataInfo(getUrl);

    });
</script>
</body>
</html>
