<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>我运营管理的卡类型列表</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-js.jsp"%>
    <%--引入私有 下拉选择组件--%>
    <link href="${static_plugins}/select/app/dist/css/iosSelect.css" rel="stylesheet">
    <%--引入私有 分页组件--%>
    <link href="${static_plugins}/pages/app/dist/css/ajax_pages_app.css" rel="stylesheet">
    <!--引入私有 卡类型竖版页面样式-->
    <link rel="stylesheet" href="${ctx}/static_new_new/css/view/cardType/cardTypeStyle.css" />
</head>
<body>
<div class="app-wrapper">
    <!--头部开始-->
    <header id="dyPluginHeaderTemplate"></header>
    <!--头部结束-->
    <!--内容区开始-->
    <section class="f-mt15">
        <div class="cardTypeList">
            <!--搜索开始-->
            <div class="m-search-list-single m-search-list-multi">
                <div class="search-input">
                    <input id="cardTypeName" type="text" placeholder="请输入" />
                    <div class="select" id="selectStatus">
                        <input type="text" placeholder="请选择状态" readonly/>
                        <span class="search-arrow-right"><i class="iconfont iconjinru"></i></span>
                    </div>
                </div>
                <span class="search-icon" id="searchList"><i class="iconfont iconchaxun"></i></span>
            </div>
            <!--搜索结束-->
            <ul class="f-pr10" id="cardDataList">
            </ul>
        </div>
    </section>
    <!--内容区结束-->
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-global-var-script.jsp"%>
<!--js私有 菜单导航-->
<script type="text/javascript" src="${static_js}/menu/menu_mgr_top_bar.js?v=202101121813"></script>

<%--js引入私有 分页组件--%>
<script src="${static_plugins}/pages/app/dist/js/ajax_pages_app_v1.2.js" type="text/javascript" charset="utf-8"></script>
<%--js引入私有 下拉选择组件--%>
<script src="${static_plugins}/select/app/dist/js/iosSelect.js"></script>
<%--引入私有  卡类型状态--%>
<script src="${ctx}/static_new_new/js/data/cardTypeConstant.js"></script>
<%--引入私有  卡类型状态处理--%>
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeShowConstant.js"></script>
<%--引入私有  卡类型数据处理--%>
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeSetData_app.js"></script>
<script>
    //请求路径
    var getUrl='/mcardsvr/mcardtypes/ag/mine/mcardtypes';

    $().ready(function(){
        //头部加载  判断是否显示 在微信 在app中
        var option = {
            domId: "#dyPluginHeaderTemplate",
            fixed: true,
            title: "我代理的卡类型",
            isHistory: true,
            isApp: true,
            jumpCallback: function() {
                //当isHistory等于false的生效
                //history.go(-1);
            }
        };
        dyPlugins.Header.init(option);

        //头部导航 如果有头部导航的话 覆盖原来的头部标题
        menuMgrTopBarInit();

        //加载列表数据
        getDataList(getUrl);
        //初始化搜索样式
        selectStatus();
    });

    /*会员卡类型信息管理*/
    $('#cardDataList').on('click',"li",function(){
        var typeId = $(this).data('id');
        window.location.href = '${ctx}/mcardtypes/'+encodeURI(typeId)+'/manage';
    });
</script>
</body>
</html>
