<%--
  Created by IntelliJ IDEA.
  User: Administrator
  Date: 2020/5/15
  Time: 19:50
  To change this template use File | Settings | File Templates.
--%>
<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>会员卡列表</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-js.jsp"%>
    <%--引入私有css文件--%>
    <!--引入下拉框组件-->
    <link rel="stylesheet" href="${static_plugins}/select/app/dist/css/iosSelect.css" />
    <%--pages css文件--%>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/pages/app/dist/css/ajax_pages_app.css"/>

    <style>
        .m-message-block-textLR .list-item {
            background-color: #ffffff;
        }
        .m-message-block-textLR .list-item .item-header .header-option {
            margin-left: -1.2rem;
        }
        .f-mt8 {
            margin-top: 0.08rem;
        }
    </style>
</head>
<body>
<div class="app-wrapper">
    <!--头部开始-->
    <header id="dyPluginHeaderTemplate"></header>
    <!--头部结束-->
    <!--内容区开始-->
    <section id="scrollEvent" class="f-mt15" style="overflow: hidden;overflow-y: auto;">
        <%--条件搜索区 开始--%>
        <div class="m-search-list-single m-search-list-multi">
            <div class="search-input">
                <input id="cardNumParam" type="text" placeholder="请输入卡号" />
                <div id="cardStatusSelet" class="select">
                    <input id="showStatus" type="text" placeholder="请选择状态" readonly/>
                    <input id="cardStatus" type="hidden">
                    <span class="search-arrow-right"><i class="iconfont iconjinru"></i></span>
                </div>
            </div>
            <span class="search-icon"><i class="iconfont iconchaxun"></i></span>
        </div>
        <%--条件搜索区 结束--%>
        <%--列表展示区 开始--%>
        <div id="dataList" class="m-message-block-textLR">

        </div>
        <div id="dy-pages" class="f-tac"></div>
        <%--列表展示区 结束--%>
    </section>
    <!--内容区结束-->
</div>

<div id="template" class="m-message-block-textLR f-dn">
    <section class="list-item">
        <div class="item-header">
            <div class="header-border">
                <div class="header-title cardNum f-tar">
                    --
                </div>
                <div class="header-option">
                    <span class="f-fr no f-mt8">--</span>
                </div>
            </div>
        </div>
        <div class="item-main">
            <div>
                <lable>面值：</lable>
                <span class="s-c-primary cardPrice">--</span>
            </div>
            <div>
                <lable>绑定：</lable>
                <span class="s-c-primary userName">--</span>
            </div>
        </div>
        <div class="item-footer f-tar">
            <div class="f-fs14 s-c-333333 f-toe cardStatus"></div>
        </div>
    </section>
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-global-var-script.jsp"%>
<!--js引入私有 时间组件-->
<!--js私有 菜单导航-->
<script type="text/javascript" src="${static_js}/menu/menu_mgr_top_bar.js?v=202101121813"></script>
<%--枚举值信息及公共方法--%>
<script src="${ctx}/static_new_new/js/data/mcardConstant.js"></script>
<script src="${ctx}/static_new_new/js/data/common.js"></script>
<%--下拉组件--%>
<script src="${static_plugins}/select/app/dist/js/iosSelect.js"></script>
<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/app/dist/js/ajax_pages_app_v1.2.js"></script>

<script>
    //title
    var title = '${title}';
    //接口地址
    var url = '${url}';
    //点击列表项跳转地址
    var next = '${next}';
    //role角色：1 发行机构；2 销售机构（代理机构也算作销售机构）
    var role = '${role}';

    /*1、初始化方法*/
    $().ready(function(){
        dyCom.setScrollHeight('#scrollEvent',60);
        //头部加载  判断是否显示 在微信 在app中
        var option = {
            domId: "#dyPluginHeaderTemplate",
            fixed: false,
            title: title,
            isHistory: true,
            isApp: true,
            jumpCallback: function() {
                //当isHistory等于false的生效

            }
        };
        dyPlugins.Header.init(option);

        //头部导航 如果有头部导航的话 覆盖原来的头部标题
        menuMgrTopBarInit();

        //查询会员卡列表
        queryMcardList();

        //会员卡状态选择事件
        $('#showStatus').off('click').on('click', function () {
            selectedCardStatus();
        });
        //查询按钮绑定事件
        $('.search-icon').off('click').on('click', function () {
            queryMcardList();
        });

    });

    /*2、业务处理*/
    //选择卡状态
    function selectedCardStatus() {
        var typeSelect = new IosSelect(1,
            [cardStatusList],
            {
                title: '选择卡状态',
                oneLevelId: 'cardStatusSelet',
                itemHeight: 0.7,
                headerHeight: 0.88,
                itemShowCount: 3,
                cssUnit: 'rem',
                callback: function (selectOneObj) {
                    $('#showStatus').val(selectOneObj.value);
                    $('#cardStatus').val(selectOneObj.id);
                }
            });
    }

    //获取ajax需要的参数
    function getItemsParams(){
        var paramsStr = '?';
        var cardNumParam = $('#cardNumParam').val();
        var cardStatusParam = $('#cardStatus').val();
        console.log(cardStatusParam);
        var paramsJson = [
            'page=$page',
            'size=$pageSize'
        ];
        if(token){
            paramsJson.push('token='+token);
        }
        //处理条件参数
        if (cardNumParam) {
            paramsJson.push('cardNum=' + cardNumParam);
        }
        if (cardStatusParam || cardStatusParam === 0) {
            paramsJson.push('cardStatus=' + cardStatusParam);
        }

        paramsStr += paramsJson.join('&');
        return paramsStr;
    }
    //查询会员卡列表
    function queryMcardList() {
        var itemTypeParams = getItemsParams();
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcards' + url + itemTypeParams)
        };
        var options = {
            contentDomId: '#dataList', //填充内容的节点ID 如：“#myrelease_container”
            pagesDomId: "#dy-pages",    //分页节点ID  "#dy-pages"
            scrollDom: $("#scrollEvent")[0],               //window对象  为了滑动使用 目前使用的是body滚动  所有传递的是window对象
            currPage: 0,                          //当前页 默认为0 从0开始计算页码
            pageSize: 30,                       //每页多少条
            itemHeight: 158,                  //每条的高度  为了计算滑动的当前页使用 需要计算目前所在的页
            static_image:'',
            ajaxParems:{                         //ajax请求的参数 对jquery的ajax 二次封装
                url: ctx+'/ajax/get',                        //请求地址  需要全地址
                type: "GET",                       //请求方式
                async: true,                        //异步|同步  默认true异步
                dataType: "JSON",             //数据格式
                data:paramsJson                              //ajax请求传参
            },
            callback:function(type,data){   //回调  ajax请求返回的数据  data
                //接收到数据 判断 type是否等于1如果等于1做业务处理  比如调用渲染页面方法
                if(type==1){
                    //1 渲染配置项列表
                    setMcardList(data.result);
                }else{
                    layer.open({
                        content: data
                        ,skin: 'msg'
                        ,time: 2 //2秒后自动关闭
                    });
                }
            }
        }
        dyPlugins.ajaxPages.Init(options);
    }
    //填充会员卡列表数据
    function setMcardList(dataList) {
        if(dataList && dataList.length){
            $.each(dataList, function (i, obj) {
                /*克隆table 模板*/
                var itemClone = $('#template .list-item').clone();
                /*赋值*/
                var num = $('#dataList').children('.list-item').length;
                var no = num+1;
                itemClone.find('.no').html('No.' + no);
                itemClone.find('.cardNum').html(dyCom.stringFiltedNull(obj.cardNum));
                //TODO 卡类型名称完善后再处理
                // itemClone.find('.typeName').html(dyCom.stringFiltedNull(obj.typeId));
                var cardPrice = dyCom.numDiv(dyCom.stringFiltedNull(obj.cardPrice), '100');
                itemClone.find('.cardPrice').html(cardPrice + '元');
                var cardStatus = getValue(cardStatusList, dyCom.stringFiltedNull(obj.cardStatus))
                itemClone.find('.cardStatus').html(cardStatus);
                itemClone.find('.userName').html(dyCom.stringFiltedNull(obj.userName));
                itemClone.data('cardNum', obj.cardNum);

                /*追加HTML*/
                $("#dataList").append(itemClone);
            });
            /*基本信息 点击事件*/
            $('#dataList .list-item').off('click').on('click',function(){
                var cardNum = $(this).data('cardNum');
                var url = ctx + '/mcards/'+cardNum+'/';
                if (dyCom.stringFiltedNull(next)) {
                    //如果参数中有下一页的路径，使用参数路径
                    url += next + '?token='+token;
                } else {
                    //默认跳往详情页
                    url += 'detail?token='+token;
                }
                //如果存在角色参数，在地址尾部追加参数
                if (dyCom.stringFiltedNull(role)) {
                    url += '&role=' + role;
                }
                window.location.href = url;
            })
            //设置可以加载 分页组件
            dyPlugins.ajaxPages.setAjaxFlag(true);
        }
    }
</script>
</body>
</html>
