<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>会员卡管理</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-js.jsp"%>
    <%--引入私有css文件--%>
    <%--分页css文件--%>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/pages/app/dist/css/ajax_pages_app.css"/>
    <style>
        .m-table-list .content table tr td {
            padding: 0px 0.05rem 0px 0.05rem;
        }
        .m-message-block-textLR .list-item {
            background-color: #ffffff;
        }
        .m-message-block-textLR .list-item .item-header .header-option {
            margin-left: -1.2rem;
        }
        .f-mt8 {
            margin-top: 0.08rem;
        }
        .wrapper-option {
            width: 100%;
            background: #ffffff;
            padding: 0;
            font-size: 0;
            height: 0.80rem;
            border-bottom: solid 0.08rem #f2f2f2;
        }
        .wrapper-option ul {
            height: 0.75rem;
            width: 100%;
            border: solid 0.01rem #dee3e6;
        }
        .wrapper-option ul li {
            min-width: 1.70rem;
            display: inline-block;
            padding: 0 0.16rem;
            border-right: solid 0.01rem #dee3e6;
        }
        .wrapper-option ul li a {
            display: block;
            padding: 0.15rem 0 0.08rem 0;
            text-align: center;
            border-bottom: solid 0.04rem #0aabf6;
            font-size: 0.30rem;
            color: #333333;
        }
        a {
            text-decoration: none;
        }
    </style>
</head>
<body>
<div class="app-wrapper">
    <!--头部开始-->
    <header id="dyPluginHeaderTemplate"></header>
    <!--头部结束-->
    <%--工具栏按钮 开始--%>
    <nav class="wrapper-option">
        <ul id="optionContiner" class="f-tar">

        </ul>
    </nav>
    <%--工具栏按钮 结束--%>
    <!--内容区开始-->
    <section class="f-mt15">
        <div class="m-form-list">
            <div class="form-item">
                <label class="item-label g-w200">卡号</label>
                <div id="cardNum" class="item-input g-w280">--</div>
                <label id="cardStatus" class="item-input g-w200"></label>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">卡类型</label>
                <div id="cardType" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">发卡机构</label>
                <div id="applyOrgan" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">虚拟卡</label>
                <div id="isVirtualCard" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">制卡时间</label>
                <div id="createDate" class="item-input g-w496">--</div>
            </div>

            <div class="form-title">
                <span class="title-icon"></span>
                <span class="title-text">销售</span>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">面值</label>
                <div id="cardPrice" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">销售时间</label>
                <div id="saleTime" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">销售方式</label>
                <div id="applyMode" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">渠道</label>
                <div id="applyBoName" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">网点</label>
                <div id="applyOrganName" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">销售员</label>
                <div id="applyAccountName" class="item-input g-w496">--</div>
            </div>

            <div class="form-title">
                <span class="title-icon"></span>
                <span class="title-text">绑定</span>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">绑定时间</label>
                <div id="activateTime" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">绑定</label>
                <div id="useInfo" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">有效期</label>
                <div id="validDate" class="item-input g-w496">--</div>
            </div>

            <div class="form-title">
                <span class="title-icon"></span>
                <span class="title-text">使用</span>
            </div>
            <section id="scrollEvent" class="f-mt15" style="overflow: hidden;overflow-y: auto;">
                <%--列表展示区 开始--%>
                <div id="dataList" class="m-message-block-textLR">

                </div>
                <div id="dy-pages" class="f-tac"></div>
                <%--列表展示区 结束--%>
            </section>
        </div>
    </section>
    <!--内容区结束-->
</div>
<div id="template" class="m-message-block-textLR f-dn">
    <section class="list-item">
        <div class="item-header">
            <div class="header-border">
                <div class="header-title recordTime f-tar s-c-999999">
                    --
                </div>
                <div class="header-option">
                    <span class="f-fr no f-mt8">--</span>
                </div>
            </div>
        </div>
        <div class="item-main">
            <div>
                <span class="s-c-primary recordType">--</span>
            </div>
            <div>
                <span class="s-c-primary mcName s-c-333333">--</span>
            </div>
            <div>
                <span class="s-c-primary cmName s-c-333333">--</span>
            </div>
        </div>
        <div class="item-footer f-tar">
            <div class="f-fs14 s-c-333333 f-toe status"></div>
        </div>
    </section>
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-global-var-script.jsp"%>
<!--js引入私有 时间组件-->
<!--js私有 菜单导航-->
<script type="text/javascript" src="${static_js}/menu/menu_mgr_top_bar.js?v=202101121813"></script>
<%--js引入私有 枚举值信息及公共方法--%>
<script src="${ctx}/static_new_new/js/data/mcardConstant.js"></script>
<script src="${ctx}/static_new_new/js/data/common.js"></script>
<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/app/dist/js/ajax_pages_app_v1.2.js"></script>
<script>
    //会员卡卡号
    var cardNum = '${cardNum}';
    //role角色：1 发行机构；2 销售机构（代理机构也算作销售机构）
    var role = dyCom.getUrlParams('role');
    //会员卡卡ID
    var cardId = '';
    //分页
    var pageSize = 10; //每页多少条
    var pageIndex = 0; //当前页
    //管理功能列表
    var optionList = [
        {
            num : 0,
            text: '绑定',
            flag: 'bind',
            status: ['1']
        },
        {
            num : 1,
            text: '修改绑定',
            flag: 'modify',
            status: ['2']
        },
        {
            num : 2,
            text: '卡解绑',
            flag: 'unbind',
            status: ['2']
        },
        {
            num : 3,
            text: '赠送有效期',
            flag: 'gift',
            status: ['1', '2', '4']
        },
        {
            num : 4,
            text: '冻结',
            flag: 'freeze',
            status: ["0", "01", "1", "2", "3", "4", "5", "6"]
        }
    ];

    /*1.初始化*/
    $().ready(function(){

        //头部加载  判断是否显示 在微信 在app中
        var option = {
            domId: "#dyPluginHeaderTemplate",
            fixed: false,
            title: "会员卡管理",
            isHistory: true,
            isApp: true,
            jumpCallback: function() {
                //当isHistory等于false的生效
            }
        };
        dyPlugins.Header.init(option);

        //头部导航 如果有头部导航的话 覆盖原来的头部标题
        menuMgrTopBarInit();

        //查询会员卡信息
        getCardInfo();
        //查询用卡记录
        queryCardRecordList();
    });
    /* 2.业务方法  */
    //根据角色和卡的状态显示不同的工具栏操作按钮
    function initOptionBtn(cardStatus, isFrozen) {
        //操作列表
        var optionHtml = '';
        for (var i = 0, len = optionList.length; i < len; i++) {
            //查看会员卡状态是否符合当前的操作，如果符合加入操作列表
            var statusIndex = optionList[i].status.indexOf(cardStatus);
            if (role == '1' && '-1' != statusIndex) {
                console.log(optionList[i].text)
                optionHtml+= '<li><a id="' + optionList[i].flag + '">' + optionList[i].text + '</a></li>';
            } else if (role == '2' && '-1' != statusIndex && optionList[i].flag != 'gift') {
                //销售机构不能赠送有效期
                optionHtml+= '<li><a id="' + optionList[i].flag + '">' + optionList[i].text + '</a></li>';
            }
        }
        console.log(optionHtml);
        $('#optionContiner').html(optionHtml);
        //绑定功能事件
        $('#bind').off('click').on('click', function () {
            window.location.href = ctx+'/mcards/bind?cardNum='+cardNum+'&role='+ role;
        });
        //修改绑定功能事件
        $('#modify').off('click').on('click', function () {
            window.location.href = ctx+'/mcards/modify?cardNum='+cardNum+'&role='+ role;
        });
        //解绑卡功能事件
        $('#unbind').off('click').on('click', function () {
            window.location.href = ctx+'/mcards/unbind?cardNum='+cardNum+'&cardId='+cardId+'&role='+ role;
        });
        //赠送有效期事件
        $('#gift').off('click').on('click', function () {
            window.location.href = ctx+'/mcards/giftValidTime?cardNum='+cardNum+'&role='+ role;
        });
        //冻结/解冻事件
        $('#freeze').off('click').on('click', function () {
            window.location.href = ctx+'/mcards/freeze?cardNum='+cardNum+'&role='+ role;
        });
        //维护冻结/解冻按钮的名字
        if ('1' == isFrozen) {
            $('#freeze').text('解冻');
        }
    }
    /*获取ajax需要的参数*/
    function getSvrParamsSting(){
        var paramsStr = '?';
        if(token){
            paramsStr += 'token='+token;
        }
        // console.log(paramsStr);
        return paramsStr;
    }
    //查询会员卡信息
    function getCardInfo(){
        var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcards/'+cardNum+svrParamsString)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setInfoData(data.result);

            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    //填充基本信息的数据
    function setInfoData(info) {
        if (info) {
            //遍历实体对象下的属性
            for (var key in info) {
                var tempKey = dyCom.stringFiltedNull(info[key]);
                $('#'+key).html(tempKey);
            }
            //处理枚举值信息
            //状态
            var cardStatus = getValue(cardStatusList, dyCom.stringFiltedNull(info.cardStatus))
            $('#cardStatus').html(cardStatus);
            //虚拟卡
            var virtualCard = getValue(isVirtualCard, dyCom.stringFiltedNull(info.isVirtualCard))
            $('#isVirtualCard').html(virtualCard);
            //面值
            var cardPrice = dyCom.numDiv(dyCom.stringFiltedNull(info.cardPrice), '100');
            $('#cardPrice').html(cardPrice + '元');
            //销售方式
            var applyMode = getValue(applyModeList, dyCom.stringFiltedNull(info.applyMode))
            $('#applyMode').html(applyMode);
            //用户信息
            var useInfoStr = '<span>' + dyCom.stringFiltedNull(info.userName) + '</span>';
            useInfoStr += '<span class="f-ml15">' + dyCom.stringFiltedNull(info.mobile) + '</span><br>';
            var certificateType = getValue(certificateTypeList, dyCom.stringFiltedNull(info.certificateType))
            useInfoStr += '<span class="f-mt5">' + certificateType + '</span>';
            useInfoStr += '<span class="f-mt5 f-ml15">' + dyCom.stringFiltedNull(info.certificateNumber) + '</span><br>';
            $('#useInfo').html(useInfoStr);
            //有效期
            $('#validDate').html(dyCom.stringFiltedNull(info.validStartDate) + '--' + dyCom.stringFiltedNull(info.validEndDate));
            //给卡ID赋值
            cardId = info.cardId;
            console.log("页面内容填充完成")
            //根据会员卡状态初始化工具栏按钮
            initOptionBtn(info.cardStatus, info.isFrozen);
        }
    }
    //获取查询用卡记录的参数
    function getRecordParamsSting() {
        var paramsStr = '?';
        var paramsJson = [
            'page='+pageIndex ,
            'size='+pageSize
        ];
        if(token){
            paramsJson.push('token='+token);
        }
        paramsStr += paramsJson.join('&');
        // console.log(paramsStr);
        return paramsStr;
    }
    //查询用卡记录列表
    function queryCardRecordList() {
        var svrParamsString = getRecordParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/userecords/card/' + cardNum + '/userecords'+svrParamsString)
        };

        var options = {
            contentDomId: '#dataList', //填充内容的节点ID 如：“#myrelease_container”
            pagesDomId: "#dy-pages",    //分页节点ID  "#dy-pages"
            scrollDom: $("#scrollEvent")[0],               //window对象  为了滑动使用 目前使用的是body滚动  所有传递的是window对象
            currPage: 0,                          //当前页 默认为0 从0开始计算页码
            pageSize: 30,                       //每页多少条
            itemHeight: 190,                  //每条的高度  为了计算滑动的当前页使用 需要计算目前所在的页
            static_image:'',
            ajaxParems:{                         //ajax请求的参数 对jquery的ajax 二次封装
                url: ctx+'/ajax/get',                        //请求地址  需要全地址
                type: "GET",                       //请求方式
                async: true,                        //异步|同步  默认true异步
                dataType: "JSON",             //数据格式
                data:paramsJson                              //ajax请求传参
            },
            callback:function(type,data){   //回调  ajax请求返回的数据  data
                //接收到数据 判断 type是否等于1如果等于1做业务处理  比如调用渲染页面方法
                if(type==1){
                    //1 渲染配置项列表
                    setDataList(data.result);
                }else{
                    layer.open({
                        content: data
                        ,skin: 'msg'
                        ,time: 2 //2秒后自动关闭
                    });
                }
            }
        }
        dyPlugins.ajaxPages.Init(options);
    }

    //填充数据
    function setDataList(dataList) {
        if(dataList && dataList.length){
            $("#dataList").html('');
            $.each(dataList, function (i, obj) {
                /*克隆table 模板*/
                var itemClone = $('#template .list-item').clone();
                /*赋值*/
                //序号，根据现有记录数+1
                var num = $('#dataList').children('.list-item').length;
                var no = num+1;
                itemClone.find('.no').html('No.' + no);
                //记录类型
                var recordType = getValue(recordTypeList, dyCom.stringFiltedNull(obj.recordType))
                itemClone.find('.recordType').html(recordType);
                //流水时间
                itemClone.find('.recordTime').html(dyCom.stringFiltedNull(obj.recordTime));
                //商铺名称
                itemClone.find('.mcName').html('景区：' + dyCom.stringFiltedNull(obj.mcName));
                //商品名称
                itemClone.find('.cmName').html(dyCom.stringFiltedNull(obj.cmName));
                //记录类型
                var status = getValue(reacordStatusList, obj.status);
                itemClone.find('.status').html(status);
                /*追加HTML*/
                $("#dataList").append(itemClone);
            });
            //如果卡用过，不能进行解绑操作
            if (dataList.length > 0) {
                $('#unbind').parent().remove();
            }
            //设置可以加载 分页组件
            dyPlugins.ajaxPages.setAjaxFlag(true);
        }
    }
</script>
</body>
</html>