<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>修改绑定</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-js.jsp"%>
    <%--引入私有css文件--%>
    <!--引入下拉框组件-->
    <link rel="stylesheet" href="${static_plugins}/select/app/dist/css/iosSelect.css" />
</head>
<body>
<div class="app-wrapper">
    <!--头部开始-->
    <header id="dyPluginHeaderTemplate"></header>
    <!--头部结束-->
    <!--内容区开始-->
    <section class="f-mt15">
        <div class="m-form-list">
            <div class="form-item">
                <label class="item-label g-w200">卡号</label>
                <div id="cardNum" class="item-input g-w280">--</div>
                <label id="cardStatus" class="item-input g-w200"></label>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">卡类型</label>
                <div id="cardType" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">发卡机构</label>
                <div id="applyOrgan" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">虚拟卡</label>
                <div id="isVirtualCard" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">制卡时间</label>
                <div id="createDate" class="item-input g-w496">--</div>
            </div>

            <div class="form-title">
                <span class="title-icon"></span>
                <span class="title-text">销售</span>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">面值</label>
                <div id="cardPrice" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">销售时间</label>
                <div id="saleTime" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">销售方式</label>
                <div id="applyMode" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">渠道</label>
                <div id="applyBoName" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">网点</label>
                <div id="applyOrganName" class="item-input g-w496">--</div>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label g-w200">销售员</label>
                <div id="applyAccountName" class="item-input g-w496">--</div>
            </div>

            <div class="form-title">
                <span class="title-icon"></span>
                <span class="title-text">用户信息</span>
            </div>
            <div id="formValidate" class="m-form-list">
                <div class="form-item f-mt16">
                    <label class="item-label">姓名</label>
                    <input id="userName" class="item-input" placeholder="请输入">
                </div>
                <div class="form-item f-mt16">
                    <label class="item-label">手机</label>
                    <input id="mobile" class="item-input" placeholder="请输入">
                </div>
                <div class="form-item">
                    <label class="item-label g-w280">证件类型</label>
                    <input id="certificateType" type="hidden">
                    <input id="typeSelect" class="item-select g-w400" placeholder="请选择" readonly>
                    <span class="item-arrows-right"></span>
                </div>
                <div class="form-item f-mt16">
                    <label class="item-label">证件号</label>
                    <input id="certificateNumber" class="item-input" placeholder="请输入">
                </div>
            </div>

            <div class="f-tac f-mt45">
                <button id="submit" type="button" class="u-btn u-btn-primary f-ml20" data-click="true">
                    绑定
                </button>
            </div>
        </div>
    </section>
    <!--内容区结束-->
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-global-var-script.jsp"%>
<!--js引入私有 时间组件-->
<!--js私有 菜单导航-->
<script type="text/javascript" src="${static_js}/menu/menu_mgr_top_bar.js?v=202101121813"></script>
<%--js引入私有 枚举值信息及公共方法--%>
<script src="${ctx}/static_new_new/js/data/mcardConstant.js"></script>
<script src="${ctx}/static_new_new/js/data/common.js"></script>
<!--引入表单验证-->
<script src="${static_js}/validate/validate.js" type="text/javascript" charset="utf-8"></script>
<%--下拉组件--%>
<script src="${static_plugins}/select/app/dist/js/iosSelect.js"></script>

<script>
    //会员卡卡号
    var cardNum = dyCom.getUrlParams('cardNum');
    //会员卡卡ID
    var cardId = dyCom.getUrlParams('cardId');
    //role角色：1 发行机构；2 销售机构（代理机构也算作销售机构）
    var role = dyCom.getUrlParams('role');

    /*1.初始化*/
    $().ready(function(){

        //头部加载  判断是否显示 在微信 在app中
        var option = {
            domId: "#dyPluginHeaderTemplate",
            fixed: false,
            title: "修改绑定",
            isHistory: true,
            isApp: true,
            jumpCallback: function() {
                //当isHistory等于false的生效
            }
        };
        dyPlugins.Header.init(option);

        //头部导航 如果有头部导航的话 覆盖原来的头部标题
        menuMgrTopBarInit();

        //查询会员卡信息
        getCardInfo();

        //解绑按钮绑定事件
        $('#submit').off('click').on('click', function () {
            modifyBindSubmit();
        });
        //会员卡状态选择事件
        $('#typeSelect').off('click').on('click', function () {
            selectedCertificateType();
        });
    });
    /* 2.业务方法  */
    /*获取ajax需要的参数*/
    function getSvrParamsSting(){
        var paramsStr = '?';
        if(token){
            paramsStr += 'token='+token;
        }
        return paramsStr;
    }
    //查询会员卡信息
    function getCardInfo(){
        var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcards/'+cardNum+svrParamsString)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setInfoData(data.result);
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    //填充基本信息的数据
    function setInfoData(info) {
        if (info) {
            //遍历实体对象下的属性
            for (var key in info) {
                var tempKey = dyCom.stringFiltedNull(info[key]);
                $('#'+key).html(tempKey);
            }
            //处理枚举值信息
            //状态
            var cardStatus = getValue(cardStatusList, dyCom.stringFiltedNull(info.cardStatus))
            $('#cardStatus').html(cardStatus);
            //虚拟卡
            var virtualCard = getValue(isVirtualCard, dyCom.stringFiltedNull(info.isVirtualCard))
            $('#isVirtualCard').html(virtualCard);
            //面值
            var cardPrice = dyCom.numDiv(dyCom.stringFiltedNull(info.cardPrice), '100');
            $('#cardPrice').html(cardPrice + '元');
            //销售方式
            var applyMode = getValue(applyModeList, dyCom.stringFiltedNull(info.applyMode))
            $('#applyMode').html(applyMode);
            //有效期
            $('#validDate').html(dyCom.stringFiltedNull(info.validStartDate) + '--' + dyCom.stringFiltedNull(info.validEndDate));
            //用户信息赋值
            //姓名
            $('#userName').val(dyCom.stringFiltedNull(info.userName));
            //手机号
            $('#mobile').val(dyCom.stringFiltedNull(info.mobile));
            //证件类型
            var certificateType = getValue(certificateTypeList, dyCom.stringFiltedNull(info.certificateType));
            $('#typeSelect').val(certificateType);
            $('#certificateType').val(dyCom.stringFiltedNull(info.certificateType));
            //证件号
            $('#certificateNumber').val(dyCom.stringFiltedNull(info.certificateNumber));
            //给卡ID赋值
            cardId = info.cardId;
        }
    }

    //获取用户参数
    function getUserInfoParam() {
        var paramsStr = {};
        $('#formValidate .form-item>input').each(function (i,n) {
            var name = $(n).attr('id');
            var value = $(n).val();
            if(value){
                paramsStr[name] = value;
            }
        });

        paramsStr.cardNum = cardNum;
        return paramsStr;
    }
    //修改绑定提交
    function modifyBindSubmit() {
        var svrParamsString = getUserInfoParam(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        console.log(svrParamsString);
        //ajax请求配置
        var optionsAjax = {
            url: ctx+'/ajax/post?restPath='+encodeURIComponent('/mcardsvr/mcards/modify?token='+token)+'&token='+token,  //请求url
            type: "post",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:JSON.stringify({appData:svrParamsString})
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                layer.open({
                    content: "修改绑卡成功"
                    ,skin: 'msg'
                    ,time: 2 //2秒后自动关闭
                });
                window.location.href = ctx+'/mcards/'+cardNum+'/manage?token='+token+'&role='+ role;
            }else{
                layer.open({
                    content: data?data:'修改绑卡失败！'
                    ,skin: 'msg'
                    ,time: 2 //2秒后自动关闭
                });
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    //选择证件类型
    function selectedCertificateType() {
        var typeSelect = new IosSelect(1,
            [certificateTypeList],
            {
                title: '选择证件类型',
                oneLevelId: 'typeSelect',
                itemHeight: 0.7,
                headerHeight: 0.88,
                itemShowCount: 3,
                cssUnit: 'rem',
                callback: function (selectOneObj) {
                    $('#typeSelect').val(selectOneObj.value);
                    $('#certificateType').val(selectOneObj.id);
                }
            });
    }
</script>
</body>
</html>