<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>用卡记录</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-js.jsp"%>
    <%--分页组件--%>
    <link href="${static_plugins}/pages/app/dist/css/ajax_pages_app.css" rel="stylesheet">
    <style type="text/css">
        .m-message-block-textLR .list-item {
            background-color: #ffffff;
        }
    </style>
</head>
<body>
<div class="app-wrapper">
    <!--头部开始-->
    <header id="dyPluginHeaderTemplate"></header>
    <!--头部结束-->
    <!--内容区开始-->
    <section class="f-mt15">
        <%--用卡记录列表--%>
        <div id='mCardRecords' class="m-message-block-textLR"></div>
            <div id="dy-pages"></div>
    </section>
    <!--内容区结束-->
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-global-var-script.jsp"%>

<!--js私有 菜单导航-->
<script type="text/javascript" src="${static_js}/menu/menu_mgr_top_bar.js?v=202101121813"></script>
<!--分页组件-->
<script src="${static_plugins}/pages/app/dist/js/ajax_pages_app_v1.2.js" type="text/javascript" charset="utf-8"></script>

<script>

    /*卡记录状态*/
    var recordStatusArray = [
        {
            'value':'0',
            'label':'失败'
        }, {
            'value': '1',
            'label': '成功'
        }, {
            'value': '2',
            'label': '待处理'
        }
    ];


    /*用卡记录类型*/
    var recordTypeArray = [
        {
            'value':'10',
            'label':'赠送'
        }, {
            'value': '20',
            'label': '取消赠送'
        }, {
            'value': '21',
            'label': '支付消费'
        }, {
            'value': '30',
            'label': '信用调增'
        }, {
            'value': '31',
            'label': '还款'
        }, {
            'value': '40',
            'label': '信用调减'
        }, {
            'value': '41',
            'label': '信用支付消费'
        }, {
            'value': '60',
            'label': '年卡商品使用'
        }, {
            'value': '61',
            'label': '年卡商品使用预约'
        }, {
            'value': '70',
            'label': '优惠商品使用'
        }, {
            'value': '71',
            'label': '优惠商品使用预约'
        }
    ];

    //组织Id
    var organId = '${organId}';

    $().ready(function(){

        //头部加载  判断是否显示 在微信 在app中
        var option = {
            domId: "#dyPluginHeaderTemplate",
            fixed: true,
            title: "用卡记录",
            isHistory: false,
            isApp: true,
            jumpCallback: function() {
                //当isHistory等于false的生效
                history.go(-1);
            }
        };
        dyPlugins.Header.init(option);

        //头部导航 如果有头部导航的话 覆盖原来的头部标题
        menuMgrTopBarInit();

        //查询用卡记录列表
        queryMCardRecordOfMineCustomer();

    });

    /*获取用卡记录列表ajax需要的参数*/
    function getRecordsParams(){
        var paramsStr = '?';
        var paramsJson = [
            'page=$page' ,
            'size=$pageSize'
        ];
        paramsJson.push('onlymc=3');
        if(token){
            paramsJson.push('token='+token);
        }
        paramsStr += paramsJson.join('&');
        return paramsStr;
    }
    //查询用卡记录列表
    function queryMCardRecordOfMineCustomer() {
        var recordsParams = getRecordsParams(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/userecords/organ/' + organId + '/userecords'+recordsParams)
        };

        var ajaxUrl = ctx+'/ajax/get';
        var options = {
            contentDomId: "#agencys", //填充内容的节点ID 如：“#myrelease_container”
            pagesDomId: "#dy-pages",    //分页节点ID  "#dy-pages"
            scrollDom: '',               //window对象  为了滑动使用 目前使用的是body滚动
            currPage: 0,                          //当前页 默认为0 从0开始计算页码
            pageSize: 30,                       //每页多少条
            itemHeight: 85,                  //每条的高度  为了计算滑动的当前页使用 需要计算目前所在的页 注意：每行如果是两个以上信息块， 按照 一个信息块高度除以数量 就是当前的每条的高度
            static_image:static_images,  //图片地址   ${static_images}  如：webapp/static_new/images
            ajaxParems:{                         //ajax请求的参数 对jquery的ajax 二次封装
                url: ajaxUrl,                        //请求地址  需要全地址
                type: "GET",                       //请求方式
                async: true,                        //异步|同步  默认true异步
                dataType: "JSON",             //数据格式
                data:paramsJson                               //ajax请求传参
            },
            callback:function(type,data){   //回调  ajax请求返回的数据  data
                //接收到数据 判断 type是否等于1如果等于1做业务处理  比如调用渲染页面方法
                if(type==1){
                    setDataList(data.result);
                }else{
                    layer.open({
                        content: data
                        ,skin: 'msg'
                        ,time: 2 //2秒后自动关闭
                    });
                }
            }
        }
        dyPlugins.ajaxPages.Init(options);
    }
    //填充列表
    function setDataList(datas) {
        var htmlStr = '';
        if(datas && Array.isArray(datas)){
            $(datas).each(function (index, obj) {

                htmlStr+='<section class="list-item" data-id="'+obj.recordId+'">';
                htmlStr+='  <div class="item-header">';
                htmlStr+='    <div class="header-border">';
                htmlStr+='        <div class="header-title">';
                htmlStr+=            dyCom.stringFiltedNull(obj.cardNum);
                htmlStr+='        </div>';
                htmlStr+='        <div class="header-option"></div>';
                htmlStr+='     </div>';
                htmlStr+='  </div>';
                htmlStr+='  <div class="item-main">';
                htmlStr+='     <div>';
                htmlStr+='        <lable>卡类型名称：</lable>';
                htmlStr+='        <span class="s-c-primary">'+dyCom.stringFiltedNull(obj.typeName)+'</span>';
                htmlStr+='     </div>';
                htmlStr+='     <div>';
                htmlStr+='        <lable>使用商铺：</lable>';
                htmlStr+='        <span class="s-c-primary">'+dyCom.stringFiltedNull(obj.mcName)+'</span>';
                htmlStr+='     </div>';
                htmlStr+='     <div>';
                htmlStr+='        <lable>使用商品：</lable>';
                htmlStr+='        <span class="s-c-primary">'+dyCom.stringFiltedNull(obj.cmName)+'</span>';
                htmlStr+='     </div>';
                htmlStr+='     <div>';
                htmlStr+='        <lable>消费数量：</lable>';
                htmlStr+='        <span class="s-c-primary">'+dyCom.stringFiltedNull(obj.consumeNum)+'</span>';
                htmlStr+='     </div>';
                htmlStr+='     <div>';
                htmlStr+='        <lable>流水类型：</lable>';
                if(dyCom.stringFiltedNull(obj.recordType)){
                    htmlStr += '<span class="s-c-primary">' + recordTypeArray.find(x => x.value === obj.recordType).label;
                }
                htmlStr+='     </div>';
                htmlStr+='     <div>';
                htmlStr+='        <lable>流水时间：</lable>';
                htmlStr+='        <span class="s-c-primary">'+dyCom.stringFiltedNull(obj.recordTime)+'</span>';
                htmlStr+='     </div>';
                htmlStr+='     <div>';
                htmlStr+='        <lable>流水状态：</lable>';
                if(dyCom.stringFiltedNull(obj.status)){
                    htmlStr += '<span class="s-c-primary">' + recordStatusArray.find(x => x.value === obj.status).label;
                }
                htmlStr+='     </div>';
                htmlStr+='  </div>';
                htmlStr+='</section>';

            });
            $('#mCardRecords').append(htmlStr);
            //设置可以加载 分页组件
            dyPlugins.ajaxPages.setAjaxFlag(true);

            //用卡记录基本信息
            $('#mCardRecords  .list-item').off('click').on('click',function(){
                var recordId = $(this).data('id');
                <%--window.location.href = '${ctx}/userecords/'+encodeURI(recordId);--%>
            })
        }

    }

</script>
</body>
</html>
