<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<c:set var="ctx_ebmgrweb" value="/ebmcmgrweb"/>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>补录用卡记录</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-js.jsp"%>
    <!--引入下拉框组件-->
    <link rel="stylesheet" href="${static_plugins}/select/app/dist/css/iosSelect.css" />
    <%--drag弹框样式--%>
    <link href="/rbweb/static_new/plugins/attention/drag/style.css" rel="stylesheet">

</head>
<body>
<div class="app-wrapper">
    <!--头部开始-->
    <header id="dyPluginHeaderTemplate"></header>
    <!--头部结束-->
    <!--内容区开始-->
    <section class="f-mt15">
        <div class="m-form-list" id="formValidate">
            <div class="form-title">
                <span class="title-icon"></span>
                <span class="title-text">补录信息</span>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label">卡号：</label>
                <input type="text" id="cardNum" class="item-input" placeholder="请输入卡号">
            </div>
            <div class="form-item f-mt16">
                <label class="item-label">卡类型：</label>
                <input type="text" id="typeName" class="item-input" readonly>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label">姓名：</label>
                <input type="text" id="userName" class="item-input" readonly>
            </div>
            <div class="form-item">
                <label class="item-label">手机号：</label>
                <input type="text" id="mobile" class="item-select" readonly>
            </div>
            <div class="form-item f-mt16">
                <label class="item-label">消费商铺：</label>
                <input type="hidden" id="mcId">
                <input id="mcName" class="item-input" placeholder="请选择">
            </div>
            <div class="form-item f-mt16">
                <label class="item-label">消费商品：</label>
                <input type="hidden" id="cmId">
                <input id="cmName" class="item-input" placeholder="请选择">
            </div>
            <div class="form-item f-mt16">
                <label class="item-label">消费数量：</label>
                <input type="text" id="consumeNum" class="item-input" placeholder="请输入">
            </div>
            <div class="form-item f-mt16">
                <label class="item-label">消费类型：</label>
                <input type="hidden" id="recordType">
                <input id="show_recordType" class="item-input" placeholder="请选择">
            </div>
            <div class="form-item f-mt16">
                <label class="item-label">消费时间：</label>
                <input type="hidden" id="recordTime">
                <input id="show_recordTime" class="item-input" data-year="" data-month="" data-date="" placeholder="请选择">
            </div>
        </div>
    </section>
    <!--内容区结束-->
    <%--按钮--%>
    <div class="f-tac f-mt5 f-pA10" style="background-color: #ffffff;">
        <button type="button" class="u-btn u-btn-default u-btn-sm" id="cancal">
            取消
        </button>
        <button id="submit" type="button" class="u-btn u-btn-primary f-ml20 u-btn-sm" data-click="true">
            保存
        </button>
    </div>
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-global-var-script.jsp"%>
<!--js私有 菜单导航-->
<script type="text/javascript" src="${static_js}/menu/menu_mgr_top_bar.js?v=202101121813"></script>
<%--下拉组件--%>
<script src="${static_plugins}/select/app/dist/js/iosSelect.js"></script>
<!--引入表单验证-->
<script src="${static_js}/validate/validate.js" type="text/javascript" charset="utf-8"></script>
<%--选择关联人组件--%>
<script src="/rbweb/static_new/js/stakeholder/stakeholder.js" type="text/javascript" charset="utf-8"></script>
<script src="/rbweb/static_new/plugins/attention/drag/drag.js" type="text/javascript" charset="utf-8"></script>
<script src="/rbweb/static_new/plugins/attention/drag/dialog.js" type="text/javascript" charset="utf-8"></script>

<script>

    /*用卡记录类型*/
    var recordTypeArray = [
        {
            'id':'10',
            'value':'赠送'
        }, {
            'id': '20',
            'value': '取消赠送'
        }, {
            'id': '21',
            'value': '支付消费'
        }, {
            'id': '30',
            'value': '信用调增'
        }, {
            'id': '31',
            'value': '还款'
        }, {
            'id': '40',
            'value': '信用调减'
        }, {
            'id': '41',
            'value': '信用支付消费'
        }, {
            'id': '60',
            'value': '年卡商品使用'
        }, {
            'id': '61',
            'value': '年卡商品使用预约'
        }, {
            'id': '70',
            'value': '优惠商品使用'
        }, {
            'id': '71',
            'value': '优惠商品使用预约'
        }
    ];

    $().ready(function(){

        //头部加载  判断是否显示 在微信 在app中
        var option = {
            domId: "#dyPluginHeaderTemplate",
            fixed: true,
            title: "补录用卡记录",
            isHistory: false,
            isApp: true,
            jumpCallback: function() {
                //当isHistory等于false的生效
                history.go(-1);
            }
        };
        dyPlugins.Header.init(option);

        //头部导航 如果有头部导航的话 覆盖原来的头部标题
        menuMgrTopBarInit();

        //数据验证初始化
        dyPlugins.Validate.init("#formValidate");


        $('#cancal').off('click').on('click',function () {
            history.go(-1);
        })
        //提交
        $('#submit').off('click').on('click', function () {
            submitRecordInfo();
        });
        //查询会员卡信息
        $("#cardNum").off('blur').on('blur', function () {
            queryMCardInfo();
        });


        //选择使用商铺
        $('#mcName').off('click').on('click', function () {
            selectedMc();
        });

        //选择使用商品
        $('#cmName').off('click').on('click', function () {
            selectedCm();
        });

        //选择流水类型
        $('#show_recordType').off('click').on('click', function () {
            selectedRecordType();
        });
        //选择流水时间
        $('#show_recordTime').off('click').on('click', function () {
            selectedRecordTime();
        });
    });

    /*获取会员卡信息ajax需要的参数*/
    function getMCardParams(){
        var paramsStr = '?';
        if(token){
            paramsStr += 'token='+token;
        }
        return paramsStr;
    }
    //根据卡号查询会员卡信息
    function queryMCardInfo() {
        var cardNum = $('#cardNum').val();
        if(!cardNum){
            layer.open({
                content: '请输入卡号'
                ,skin: 'msg'
                ,time: 2 //2秒后自动关闭
            });
            return false;
        }
        /*添加遮罩*/
        var loading = layer.open({type: 2});
        var mCardParams = getMCardParams(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcards/'+cardNum+mCardParams)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){

            //关闭遮罩
            layer.close(loading);
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setMCardInfoData(data.result);

            }else{
                layer.open({
                    content: data
                    ,skin: 'msg'
                    ,time: 2 //2秒后自动关闭
                });
            }
        }
        dyCom.ajaxRequest(optionsAjax);

    }
    //回显会员卡信息
    function setMCardInfoData(data) {
        if (data) {
            var typeId = data.typeId;
            //获取会员卡类型信息
            if(typeId){
                /*卡类型信息*/
                queryCardType(typeId);
            }

            $('#userName').val(dyCom.stringFiltedNull(data.userName));
            $('#mobile').val(dyCom.stringFiltedNull(data.mobile));
        }
    }

    /*获取会员卡类型信息ajax需要的参数*/
    function getCardTypeParams(){
        var paramsStr = '?';
        if(token){
            paramsStr += 'token='+token;
        }
        return paramsStr;
    }
    //查询会员卡类型信息
    function queryCardType(typeId) {

        var cardTypeParams = getCardTypeParams(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcardtypes/'+typeId+cardTypeParams)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setMCardTypeInfoData(data.result);
            }else{
                layer.open({
                    content: data
                    ,skin: 'msg'
                    ,time: 2 //2秒后自动关闭
                });
            }
        }
        dyCom.ajaxRequest(optionsAjax);

    }
    //会员卡信息回显
    function setMCardTypeInfoData(data) {
        if (data) {
            $('#typeName').val(dyCom.stringFiltedNull(data.typeName));
        }
    }


    //选择分销商铺
    function selectedMc() {
        var supplierBoId = '${customerId}';
        var iframeHtml = '<iframe id="shopListIframe" src="'+ctx+'/mcs/choosemc?isMulChoice=false&tabTitleList=0,1&customId='+supplierBoId+'&token='+token+'" style="height:100%;border: 0;" border="0"></iframe>';
        var childWindow = null;
        var pageii = layer.open({
            type: 1
            ,content: iframeHtml
            ,anim: 'left'
            ,btn: ['确定', '取消']
            ,style: 'position:fixed; right:0; top:50px; width:6rem; height:calc(100% - 50px); border: none; -webkit-animation-duration: .5s; animation-duration: .5s;',
            success:function(layObj){
                $(layObj).css('z-index',15);
                var iframePHeight = $(layObj).find('.layui-m-layerchild').height();
                $(layObj).find('.layui-m-layercont').css('height',(iframePHeight-50).toString()+'px');

                //初始化完成之后  例如修改的时候 需要处理
                childWindow = $(layObj).find("#shopListIframe")[0].contentWindow;
                // item  必须字段 objType itemId  name
                var dataList = [];
                if($("#mcId").val() && $("#mcName").val()){
                    dataList = [{'mcId':$("#mcId").val(),'mcName':$("#mcName").val()}];
                }
                if(childWindow.setItemsList){
                    childWindow.setItemsList(dataList);
                }else{
                    var setIntervalTime = setInterval(function(){
                        if(childWindow.setItemsList){
                            clearInterval(setIntervalTime);
                            childWindow.setItemsList(dataList);
                        }
                    },20);
                }
            }
            ,yes: function(index){
                var datalist = childWindow.getItemsList();
                if(datalist && datalist.length){
                    $("#mcId").val(datalist[0].mcId);
                    $("#mcName").val(datalist[0].mcName);
                }
                layer.close(index)
            }
            ,no: function(index){
                layer.close(index)
            }
        });
    }

    //选择分销商品
    function selectedCm() {
        var mcId = $('#mcId').val();
        if(!mcId){
            layer.open({
                content: '请选择商铺'
                ,skin: 'msg'
                ,time: 2 //2秒后自动关闭
            });
            return false;
        }
        var iframeHtml = '<iframe id="shopListIframe" src="${ctx_ebmgrweb}/cms/choosecm?isMulChoice=false&tabTitleList=4&mcId='+mcId+'&token='+token+'" style="height:100%;border: 0;" border="0"></iframe>';
        var childWindow = null;
        var pageii = layer.open({
            type: 1
            ,content: iframeHtml
            ,anim: 'left'
            ,btn: ['确定', '取消']
            ,style: 'position:fixed; right:0; top:50px; width:6rem; height:calc(100% - 50px); border: none; -webkit-animation-duration: .5s; animation-duration: .5s;',
            success:function(layObj){
                $(layObj).css('z-index',15);
                var iframePHeight = $(layObj).find('.layui-m-layerchild').height();
                $(layObj).find('.layui-m-layercont').css('height',(iframePHeight-50).toString()+'px');

                //初始化完成之后  例如修改的时候 需要处理
                childWindow = $(layObj).find("#shopListIframe")[0].contentWindow;
                // item  必须字段 objType itemId  name
                var dataList = [];
                if($("#cmId").val() && $("#cmName").val()){
                    dataList = [{'cmId':$("#cmId").val(),'cmName':$("#cmName").val()}];
                }

                if(childWindow.setItemsList){
                    childWindow.setItemsList(dataList);
                }else{
                    var setIntervalTime = setInterval(function(){
                        if(childWindow.setItemsList){
                            clearInterval(setIntervalTime);
                            childWindow.setItemsList(dataList);
                        }
                    },20);
                }
            }
            ,yes: function(index){
                var datalist = childWindow.getItemsList();
                if(datalist && datalist.length){
                    $("#cmId").val(datalist[0].cmId);
                    $("#cmName").val(datalist[0].cmName);
                }
                layer.close(index)
            }
            ,no: function(index){
                layer.close(index)
            }
        });
    }

    //选择流水类型
    function selectedRecordType() {
        var recordId = $('#agencyPriceType').val();
        var typeSelect = new IosSelect(1,
            [recordTypeArray],
            {
                title: '选择流水类型',
                oneLevelId: recordId,
                itemHeight: 0.7,
                headerHeight: 0.88,
                itemShowCount: 3,
                cssUnit: 'rem',
                callback: function (selectOneObj) {
                    $('#show_recordType').val(selectOneObj.value);
                    $('#recordType').val(selectOneObj.id);
                }
            });
    }

    //选择时间
    function selectedRecordTime() {
        var showDateDom = $('#show_recordTime');

        // 初始化时间
        var now = new Date();
        var nowYear = now.getFullYear();
        var nowMonth = now.getMonth() + 1;
        var nowDate = now.getDate();
        showDateDom.attr('data-year', nowYear);
        showDateDom.attr('data-month', nowMonth);
        showDateDom.attr('data-date', nowDate);
        // 数据初始化
        function formatYear (nowYear) {
            var arr = [];
            for (var i = nowYear - 5; i <= nowYear + 5; i++) {
                arr.push({
                    id: i + '',
                    value: i + '年'
                });
            }
            return arr;
        }
        function formatMonth () {
            var arr = [];
            for (var i = 1; i <= 12; i++) {
                arr.push({
                    id: i + '',
                    value: i + '月'
                });
            }
            return arr;
        }
        function formatDate (count) {
            var arr = [];
            for (var i = 1; i <= count; i++) {
                arr.push({
                    id: i + '',
                    value: i + '日'
                });
            }
            return arr;
        }
        var yearData = function(callback) {
            callback(formatYear(nowYear))
        }
        var monthData = function (year, callback) {
            callback(formatMonth());
        };
        var dateData = function (year, month, callback) {
            if (/^(1|3|5|7|8|10|12)$/.test(month)) {
                callback(formatDate(31));
            }
            else if (/^(4|6|9|11)$/.test(month)) {
                callback(formatDate(30));
            }
            else if (/^2$/.test(month)) {
                if (year % 4 === 0 && year % 100 !==0 || year % 400 === 0) {
                    callback(formatDate(29));
                }
                else {
                    callback(formatDate(28));
                }
            }
            else {
                throw new Error('month is illegal');
            }

        };

        var oneLevelId = showDateDom.attr('data-year');
        var twoLevelId = showDateDom.attr('data-month');
        var threeLevelId = showDateDom.attr('data-date');
        var iosSelect = new IosSelect(3,
            [yearData, monthData, dateData],
            {
                title: '选择时间',
                itemHeight: 35,
                oneLevelId: oneLevelId,
                twoLevelId: twoLevelId,
                threeLevelId: threeLevelId,
                showLoading: true,
                callback: function (selectOneObj, selectTwoObj, selectThreeObj) {
                    showDateDom.attr('data-year', selectOneObj.id);
                    showDateDom.attr('data-month', selectTwoObj.id);
                    showDateDom.attr('data-date', selectThreeObj.id);
                    showDateDom.val(selectOneObj.value + ' ' + selectTwoObj.value + ' ' + selectThreeObj.value);
                    $('#recordTime').val(selectOneObj.id + '-' + selectTwoObj.id + '-' + selectThreeObj.id);
                }
            });
    }


    /*获取补录提交数据*/
    function getRecordParams(){
        var paramsStr = {};
        $('#formValidate .form-item>input').each(function (i,n) {
            var name = $(n).attr('id');
            var value = $(n).val();
            if(name.indexOf("show_") != 0){
                if(value){
                    paramsStr[name] = value;
                }
            }

        });
        return paramsStr;
    }
    //提交补录记录
    function submitRecordInfo() {
        //防止多次提交
        var clickFlag = $("#submit").data("click");
        if (!clickFlag) {
            return false;
        }
        //提交之前验证
        $("#submit").data("click", false); //设置不可点击提交按钮
        //提交验证 errTime 返回 0的时候 说明验证都通过 >0 说明 有errTime处有信息问题
        var errTime = dyPlugins.Validate.checkAll();
        // console.log(errTime + "错误次数");
        if (errTime > 0) {
            $("#submit").data("click", true); //设置可以点击
        }else{
            var svrParamsString = getRecordParams(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条

            //ajax请求配置
            var optionsAjax = {
                url: ctx+'/ajax/post?restPath='+encodeURI('/mcardsvr/mcards/use/makeup?token='+token)+'&token='+token,  //请求url
                type: "post",         //请求类型 默认get
                async: true,            //异步|同步加载 默认异步
                dataType: "json",      //数据类型      默认json
                data:JSON.stringify({appData:svrParamsString})
            }
            optionsAjax.callback = function(type,data){
                //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
                //返回结果处理
                if(type==1){
                    layer.open({
                        content: "补录信息成功"
                        ,skin: 'msg'
                        ,time: 2 //2秒后自动关闭
                    });
                    //跳转查询补录记录列表
                    location.href = ctx+'/userecords/bo/mine/userecords';
                }else{
                    layer.open({
                        content: data?data:'补录信息失败！'
                        ,skin: 'msg'
                        ,time: 2 //2秒后自动关闭
                    });
                }
            }
            dyCom.ajaxRequest(optionsAjax);
        }
    }

</script>
</body>
</html>
