<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/jsp/common/include/include-taglib.jsp" %>

<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>

<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include/include-meta-info.jsp" %>
    <title></title >
    <%@ include file="/WEB-INF/jsp/common/include/include-css.jsp" %>
    <link rel="stylesheet" type="text/css" href="${static_css}/temp/common.css"/>
    <link href="${static_plugins}/bootstrapFileinput/css/fileinput.css" media="all" rel="stylesheet" type="text/css"/>
    <link href="${static_plugins}/bootstrapFileinput/css/theme.css" media="all" rel="stylesheet" type="text/css"/>

</head>
<body>
<form id= "uploadForm">
    <input type="hidden" name="hidden" id="fileList" value="" style="width:100%;">
    <div class="body-div">
        <!--下部-->
        <div class="main-content clearfix">
            <div style="width: 100%;">
                <input id="kv-explorer" name = "file" type="file" multiple>
            </div>
        </div>
    </div>
</form>
</body>
<%@ include file="/WEB-INF/jsp/common/include/include-js.jsp" %>
<script src="${static_plugins}/bootstrapFileinput/js/fileinput.js" type="text/javascript"></script>
<script src="${static_plugins}/bootstrapFileinput/js/theme.js" type="text/javascript"></script>
<script src="${static_plugins}/bootstrapFileinput/locales/zh.js"></script>
<script>
    var token = "${token}";

    $("#kv-explorer").fileinput({
        'language': 'zh', //设置语言
        'theme': 'explorer',
        'uploadUrl': '<%=baseResourcePath%>/commonsvr/docs/uploadMulti?token='+token,//上传的地址，同时服务器需返回json数组
        'type': 'POST',
        uploadAsync:true,//设置同步，异步 （同步）
        overwriteInitial: false,//不覆盖已存在的图片
        initialPreviewAsData: true,
        //指出上传的文件
        initialPreview: [
        ],
        initialPreviewConfig: [
        ]

    });

    $('#kv-explorer').on('fileuploaderror', function(event, data, msg) {
        console.log(data.id);
        console.log(data.index);
        console.log(data.file);
        console.log(data.reader);
        console.log(data.files);
    });
    //异步上传返回结果处理
    var inputValue;
    $("#kv-explorer").on("fileuploaded", function (event, data, previewId, index) {
        //返回的是file list Json 串，file包含 docName，docId
        //赋值给fileList
        var obj = data.response;
        //fileList 置空 for 解决缓存问题
        $("#fileList").attr("value", "");

        inputValue = $("#fileList").val();
        $("#fileList").val(inputValue + JSON.stringify(obj.result));
    });
</script>
</html>