<%@ page import="com.dayouzc.e2eplatform.core.util.NetworkUtils" %>
<%@ page import="com.dayouzc.e2eplatform.core.util.SpringUtils" %>
<%@ page import="org.apache.commons.lang3.StringUtils" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<c:set var="ctx" value="${pageContext.request.contextPath}"/>
<c:set var="static_css" value="${pageContext.request.contextPath}/static/css"/>
<c:set var="dist_bootstrap" value="${pageContext.request.contextPath}/dist/lib/bootstrap/"/>
<c:set var="dist_jquery" value="${pageContext.request.contextPath}/dist/lib/jquery"/>

<%
    String basePathWithoutContextPath = NetworkUtils.getBasePathWithoutContextPath(request);
    // 开发环境&本地运行时需要特殊处理， TODO 统一使用本地ajax转发来规避这个问题
    if (StringUtils.equals("dev", SpringUtils.getActive()) && StringUtils.containsAny(basePathWithoutContextPath, "localhost", "127.0.0.1")) {
        String rbsvrIp = SpringUtils.getApplicationContext().getEnvironment().getProperty("e2e.svr.rbsvr-ip");
        String rbsvrPort = SpringUtils.getApplicationContext().getEnvironment().getProperty("e2e.svr.rbsvr-port");
        basePathWithoutContextPath = "http://" + rbsvrIp + ":" + rbsvrPort;;
    }
%>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>选择关联人</title>
    <link rel="stylesheet" type="text/css" href="${static_css}/bootstrap.min.css"/>
    <link rel="stylesheet" type="text/css" href="${static_css}/common.css"/>
    <link rel="stylesheet" href="${static_css}/demo.css" type="text/css">
    <link rel="stylesheet" href="${static_css}/zTreeStyle.css" type="text/css">
    <style>
        .modal-body {
            font-size: 12px;
            font-family: "微软雅黑";
        }
        .nav-tabs>li>a {
            background-color: #C8DAF1;
            height: 30px;
            line-height: 30px;
        }
        .nav-tabs>li.active>a, .nav-tabs>li.active>a:focus, .nav-tabs>li.active>a:hover {
            color: #ffffff;
            background-color: #0070C1;
            height: 30px;
            line-height: 30px;
        }
        div.zTreeDemoBackground {
            width: 100%;
            height: 240px;
            margin-bottom: 10px;
        }
        ul.ztree {
            width: 100%;
            height: 230px;
            border: 1px solid #ddd;
            font-size: 12px;
            background:#F4F6F5
        }
        .ztree li span {
            font-size: 12px;
        }
        .ztree li a.curSelectedNode {
            height: 100%;
            background-color: #D9D9D9;
            border: 1px #D9D9D9 solid;
        }
        .ztree li a:hover {
            text-decoration: none;
        }
        .start-people-message {
            min-height: 40px;
        }
        .customer-table>thead>tr {
            background-color: #0070C1;
        }
        .customer-table>thead>tr>th {
            width: 25%;
        }
        .customer-table>tbody>tr>td>a {
            text-decoration: none;
            color: #000000;
        }
        .customer-table>tbody>tr>td>a:hover {
            text-decoration: none;
            background-color: #C8DAF1;
        }
    </style>
</head>
<body style="background-color: #FFFFFF;">
    <div class="col-xs-12">
        <div class="col-xs-12 modal-body">
            <!--<form  role="form">-->
            <input type="hidden" name="hidden" id="stakeholderList" value="" style="width: 100%;">
            <div id="personList" class="col-xs-12 start-people-message">
            </div>
            <div class="col-xs-12" style="margin: 10px 0px 10px;border-top: 1px solid #B2C5DD;">
            </div>
            <div class="col-xs-12">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href='#selectPerson' data-toggle='tab'>选择个人</a>
                    </li>
                    <li>
                        <a href='#selectOrgan' data-toggle='tab'>选择组织</a>
                    </li>
                    <li>
                        <a href='#selectCustomer' data-toggle='tab' onclick="customers()">选择客户实体</a>
                    </li>
                </ul>
            </div>
            <div class="tab-content">
                <div class="tab-pane fade in active" id="selectPerson">
                    <!--选择个人开始-->
                    <div class="col-xs-12 swlDetail">
                        <div class="col-xs-5">
                            <div class="col-xs-12 zTreeDemoBackground left">
                                <ul id="treeDemo" class="col-xs-12 ztree"></ul>
                            </div>
                        </div>
                        <div class="col-xs-7">
                            <div class="col-xs-12 cz-content add-button" style="text-align: left;">
                                <div style="width: 40%;float: left;padding-right: 10px;">
                                    <input type="text" name="" value="" placeholder="姓名" style="width: 100%;"/>
                                </div>
                                <div style="width: 40%;float: left;">
                                    <input type="text" name=""  value="" placeholder="职位" style="width: 100%;"/>
                                </div>
                                <div style="width: 20%;float: left;">
                                    <button class="btn btn-primary" onclick="search()">查询</button>
                                </div>
                            </div>
                            <div id="peopleList" class="col-xs-12 data-range" style="height:210px;overflow-y:scroll;margin-top:10px;">
                                <table border="" cellspacing="" cellpadding="" class="add-person-table" id="zz-table">
                                    <thead>
                                    <tr>
                                        <th><input  type="checkbox" id="checkAllChange" data-name="全选"/></th>
                                        <th>姓名</th>
                                        <th>职位</th>
                                        <th>手机号</th>
                                    </tr>
                                    </thead>
                                    <tbody id="accounts">
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!--选择个人结束-->
                </div>
                <div class="tab-pane fade" id="selectOrgan">
                    <div class="col-xs-12 swlDetail">
                        <!--选择组织开始-->
                        <div class="col-xs-6 zTreeDemoBackground left" style="width: 100%;">
                            <ul id="organTreeDemo" class="ztree"></ul>
                        </div>
                        <!--选择组织结束-->
                    </div>
                </div>
                <div class="tab-pane fade" id="selectCustomer">
                    <div class="col-xs-12 data-range">
                        <!--选择客户实体开始-->
                        <table border="" cellspacing="" cellpadding="" class="add-person-table customer-table">
                            <thead>
                            <tr>
                                <th><input  type="checkbox" id="checkAll" data-name="全选"/></th>
                                <th>客户姓名</th>
                                <th>地址</th>
                                <th>负责人</th>
                            </tr>
                            </thead>
                            <tbody id="customers">
                            </tbody>
                        </table>
                        <!--选择客户实体结束-->
                    </div>
                </div>
            </div>
            <!--</form>-->
        </div>
        <div class="modal-footer add-button">
        </div>
    </div><!-- /.modal-content -->
</body>
<script src="${dist_jquery}/jquery.js" type="text/javascript" charset="utf-8"></script>
<script src="${dist_bootstrap}/bootstrap.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript" src="${dist_jquery}/jquery.ztree.core.js"></script>
<script type="text/javascript" src="${dist_jquery}/jquery.ztree.excheck.js"></script>
<script type="text/javascript">
    var setting = {
        view: {
            showIcon: false//不显示文件夹

        },
        check: {
            enable: false,
            chkStyle: "radio",
            radioType: "all"
        },
        data: {
            simpleData: {
                enable: true,
                idKey:"id",
                pIdKey:"pId",
                rootPId:0
            }
        },
        callback:{
            onClick:onClick
        }
    };

    function onClick(event,treeId,treeNode){
        var id = treeNode.id;
        var name = treeNode.name;
        getPerson(id,name);
    }

    var organSetting = {
        view: {
            showIcon: false//不显示文件夹

        },
        check: {
            enable: false
        },
        data: {
            simpleData: {
                enable: true,
                idKey:"id",
                pIdKey:"pId",
                rootPId:0
            }
        },
        callback:{
            onClick:organOnClick
        }
    };


    //组织树的点击事件
    function organOnClick(event,treeId,treeNode){
        var name = treeNode.name;
        var id = treeNode.id;
        var children = treeNode.children;
        getSelectValue(id,name,children);
    }

    $(function() {
        var zNodes = ${jsonStr};
        $.fn.zTree.init($("#treeDemo"), setting, zNodes);
        $.fn.zTree.init($("#organTreeDemo"), organSetting, zNodes);
    });


    var token = "${sessionScope.token}";

    //获取组织人员列表
    var page = "0";
    var size = "10";
    var organId;
    var organName;
    function getPerson(id,name){
        organId = id;
        organName = name;
        var accounts = "";
        $.ajax({
            type:"get",
//            url:"http://172.16.9.59:8080/rbsvr/organs/"+encodeURI(id)+"/accounts?page="+encodeURI(page)+"&size="+encodeURI(size)+"&token="+encodeURI(token),
            url:"<%=basePathWithoutContextPath%>/rbsvr/organs/"+encodeURI(id)+"/accounts?page="+encodeURI(page)+"&size="+encodeURI(size)+"&token="+encodeURI(token),
            dataType:"json",
            success:function(data){
                var lists = JSON.stringify(data.result);//JSON.stringify(obj)将JSON转为字符串。
                var myobj=eval("(" + lists + ")");//将字符串转化为对象
                $.each(myobj,function(i,list){
                    accounts += '<tr><td class="includeinput"><input class="personId" style="height:14px;" type="checkbox" name="checkbox" id="personId" value="'+list.account.accountId+'" data-name="'+list.account.userName+'"/></td >' +
                        '<td>'+list.account.userName+'</td>' +
                        '<td>'+list.userPosition+'</td>' +
                        '<td>'+list.account.mobilePhone+'</td> </tr>';
                });
                $('#accounts').html(accounts);
            }
        });
        $(window).scroll(
            function() {
                var bot = 50; //bot是底部距离的高度

                if ((bot + $(window).scrollTop()) >= ($(document).height() - $(window).height())) {
                    page+=1;
                    $.ajax({
                        type:"get",
//                        url:"http://172.16.9.59:8080/rbsvr/organs/"+encodeURI(id)+"/accounts?page="+encodeURI(page)+"&size="+encodeURI(size)+"&token="+encodeURI(token),
                        url:"<%=basePathWithoutContextPath%>/rbsvr/organs/"+encodeURI(id)+"/accounts?page="+encodeURI(page)+"&size="+encodeURI(size)+"&token="+encodeURI(token),
                        dataType:"json",
                        success:function(data){
                            var lists = JSON.stringify(data.result);
                            var myobj=eval("(" + lists + ")");
                            $.each(myobj,function(i,list){
                                accounts += '<tr class="includeinput"><td><input class="personId" style="height: 14px;" type="checkbox" name="checkbox" id="personId" value="'+list.account.accountId+'" data-name="'+list.account.userName+'"/></td >' +
                                    '<td>'+list.account.userName+'</td><td>'+list.userPosition+'</td><td>'+list.account.mobilePhone+'</td> </tr>';
                            });
                            $('#accounts').html(accounts);
                        }
                    });
                }
            });
    }

    var stakeholders = {
        stakeholderName:"",//关联人name
        stakeholderId:"",//关联人Id
        stakeholderType:"",//关联人类型
        statuses:"",//关联人状态[1绑定；0解绑]
        stakeholderOrganId:"",//关联用户所在组织Id
        stakeholderOrganName:""//关联用户所在组织Id
    };
    var inputValue;

    //选择组织
    function getSelectValue(id,name,children){
        stakeholders.stakeholderId = id;
        stakeholders.stakeholderName = name;
        stakeholders.stakeholderType = "2";
        stakeholders.statuses = "1";
        stakeholders.stakeholderOrganId = "";
        stakeholders.stakeholderOrganName = "";
        var selectValue = "";
        if(children){
            //有子节点不用添加
        }else{
            if($('#personList').html().indexOf(name)>=0){//已添加再次点击视为取消
                $('#personList').html($('#personList').html().replace("&nbsp;&nbsp;&nbsp;&nbsp;"+name,""));
                inputValue = $("#stakeholderList").val();//将对象从id=stakeholderList的input中取消
                $("#stakeholderList").val(inputValue.replace(JSON.stringify(stakeholders),""));
            }else{//没有添加时点击添加
                $('#personList').append(selectValue+"&nbsp;&nbsp;&nbsp;&nbsp;"+name);
                addStakeholder(stakeholders);
            }
        }

    }

    function customers() {
        var customers = "";
        $.ajax({
            type:"get",
//            url:"http://172.16.9.59:8080/rbsvr/customers?token="+encodeURI(token),
            url:"<%=basePathWithoutContextPath%>/rbsvr/customers?token="+encodeURI(token),
            dataType:"json",
            success:function(data){
                var lists = JSON.stringify(data.result);//JSON.stringify(obj)将JSON转为字符串。
                var myobj=eval("(" + lists + ")");//将字符串转化为对象
                $.each(myobj,function(i,list){
                    customers += '<tr><td class="includeinput1"><input class="customerId" style="height:14px;" type="checkbox" name="checkbox" value="'+list.customerId+'" data-name="'+list.customerName+'"/></td >' +
                        '<td>'+list.customerName+'</td>' +
                        '<td>'+list.address+'</td>' +
                        '<td>'+list.leader+'</td> </tr>';
                });
                $('#customers').html(customers);
            }
        });
    }

    // 个人列表全选/取消全部
    $("#checkAllChange").click(function() {
        var str='';
        if(this.checked == true) {
            $(".personId").each(function(index,item) {
                this.checked = true;
                if($('#personList').html().indexOf($(this).data('name'))>=0){
                    return;
                }else{
                    stakeholders.stakeholderId = $(this).val();
                    stakeholders.stakeholderName = $(this).data('name');
                    stakeholders.stakeholderType = "1";
                    stakeholders.statuses = "1";
                    stakeholders.stakeholderOrganId = organId;
                    stakeholders.stakeholderOrganName = organName;
                    addStakeholder(stakeholders);
                    str+="&nbsp;&nbsp;&nbsp;&nbsp;"+$(this).data('name');
                }
            });
            $('#personList').append(str);
        } else {
            var personList = $("#personList").html();
            var all = $('#accounts input[name=checkbox]:checkbox').size();
            $(".personId").each(function(index,item) {
                this.checked = false;
                if(index<=all){
                    var deleteStr = "&nbsp;&nbsp;&nbsp;&nbsp;"+$(this).data('name');
                    personList=personList.replace(deleteStr,"");
                    inputValue = $("#stakeholderList").val();
                    $("#stakeholderList").val(inputValue.replace(JSON.stringify(stakeholders),""));
                }
            });
            $('#personList').html(personList);
        }

    });
    //客户实体全选、取消全选
    $("#checkAll").click(function() {
        var str='';
        if(this.checked == true) {
            $(".customerId").each(function(index,item) {
                this.checked = true;
                if($('#personList').html().indexOf($(this).data('name'))>=0){
                    return;
                }else{
                    stakeholders.stakeholderId = $(this).val();
                    stakeholders.stakeholderName = $(this).data('name');
                    stakeholders.stakeholderType = "3";
                    stakeholders.statuses = "1";
                    stakeholders.stakeholderOrganId = "";
                    stakeholders.stakeholderOrganName = "";
                    addStakeholder(stakeholders);
                    str+="&nbsp;&nbsp;&nbsp;&nbsp;"+$(this).data('name');
                }
            });
            $('#personList').append(str);
        } else {
            var personList = $("#personList").html();
            var all = $('#customers input[name=checkbox]:checkbox').size();
            $(".customerId").each(function(index,item) {
                this.checked = false;
                if(index<=all){
                    var deleteStr = "&nbsp;&nbsp;&nbsp;&nbsp;"+$(this).data('name');
                    personList=personList.replace(deleteStr,"");
                    inputValue = $("#stakeholderList").val();
                    $("#stakeholderList").val(inputValue.replace(JSON.stringify(stakeholders),""));
                }
            });
            $('#personList').html(personList);
        }
    });
    //点击形式为整行选取
    $("#accounts").on("click", "td:not(.includeinput)", function(event){
        stakeholders.stakeholderId = $(this).parent().find('.personId').val();
        stakeholders.stakeholderName = $(this).parent().find('.personId').data('name');
        stakeholders.stakeholderType = "1";
        stakeholders.statuses = "1";
        stakeholders.stakeholderOrganId = organId;
        stakeholders.stakeholderOrganName = organName;
        if ($(this).parent().find(".personId").is(':checked')) {
            $(this).parent().find(".personId").prop("checked", false);
            inputValue = $("#stakeholderList").val();
            $("#stakeholderList").val(inputValue.replace(JSON.stringify(stakeholders),""));
            $('#personList').html($('#personList').html().replace("&nbsp;&nbsp;&nbsp;&nbsp;"+$(this).parent().find(".personId").data('name'),""));
        } else{
            $(this).parent().find(".personId").prop("checked", true);
            addStakeholder(stakeholders);
            var str = '';
            str+="&nbsp;&nbsp;&nbsp;&nbsp;"+$(this).parent().find(".personId").data('name');
            $('#personList').append(str);
        }
    });
    //个人列表中，选中或取消复选框，得到或取消table中的相应值
    $("#accounts").on("click", ".personId", function(event){
        var all = $('#accounts input[name=checkbox]:checkbox').size();
        var checked = $('#accounts input[name=checkbox]:checked').size();
        var str = '';
        if(this.checked == true){
            if(all === checked){
                $('#checkAllChange').prop('checked',true);//选中全选框
            }else{
                $('#checkAllChange').prop('checked',false);//取消全选框
            }
            stakeholders.stakeholderId = $(this).val();
            stakeholders.stakeholderName = $(this).data('name');
            stakeholders.stakeholderType = "1";
            stakeholders.statuses = "1";
            stakeholders.stakeholderOrganId = organId;
            stakeholders.stakeholderOrganName = organName;
            addStakeholder(stakeholders);
            str+="&nbsp;&nbsp;&nbsp;&nbsp;"+$(this).data('name');
            $('#personList').append(str);
        }else{
            $('#checkAllChange').prop('checked',false);
            inputValue = $("#stakeholderList").val();
            $("#stakeholderList").val(inputValue.replace(JSON.stringify(stakeholders),""));
            $('#personList').html($('#personList').html().replace("&nbsp;&nbsp;&nbsp;&nbsp;"+$(this).data('name'),""));
        }
    });
    //点击形式为整行选取
    $("#customers").on("click", "td:not(.includeinput1)", function(event){
        stakeholders.stakeholderId = $(this).parent().find('.customerId').val()
        stakeholders.stakeholderName = $(this).parent().find('.customerId').data('name');
        stakeholders.stakeholderType = "3";
        stakeholders.statuses = "1";
        stakeholders.stakeholderOrganId = "";
        stakeholders.stakeholderOrganName = "";
        if ($(this).parent().find(".customerId").is(':checked')) {
            $(this).parent().find(".customerId").prop("checked", false);
            inputValue = $("#stakeholderList").val();
            $("#stakeholderList").val(inputValue.replace(JSON.stringify(stakeholders),""));
            $('#personList').html($('#personList').html().replace("&nbsp;&nbsp;&nbsp;&nbsp;"+$(this).parent().find(".customerId").data('name'),""));
        } else{
            $(this).parent().find(".customerId").prop("checked", true);
            addStakeholder(stakeholders);
            var str = '';
            str+="&nbsp;&nbsp;&nbsp;&nbsp;"+$(this).parent().find(".customerId").data('name');
            $('#personList').append(str);
        }
    });
    //客户表格中，选中或取消复选框，得到或取消table中的相应值
    $("#customers").on("click", ".customerId", function(event){
        var all = $('#customers input[name=checkbox]:checkbox').size();
        var checked = $('#customers input[name=checkbox]:checked').size();
        var str = '';
        if(this.checked == true){
            if(all === checked){
                $('#checkAll').prop('checked',true);
            }else{
                $('#checkAll').prop('checked',false);
            }
            stakeholders.stakeholderId = $(this).val();
            stakeholders.stakeholderName = $(this).data('name');
            stakeholders.stakeholderType = "3";
            stakeholders.statuses = "1";
            stakeholders.stakeholderOrganId = "";
            stakeholders.stakeholderOrganName = "";
            addStakeholder(stakeholders);
            str+="&nbsp;&nbsp;&nbsp;&nbsp;"+$(this).data('name');
            $('#personList').append(str);
        }else{
            $('#checkAll').prop('checked',false);
            inputValue = $("#stakeholderList").val();
            $("#stakeholderList").val(inputValue.replace(JSON.stringify(stakeholders),""));
            $('#personList').html($('#personList').html().replace("&nbsp;&nbsp;&nbsp;&nbsp;"+$(this).data('name'),""));
        }

    });
    //添加关联人
    function addStakeholder(object){
        inputValue = $("#stakeholderList").val();
        if(inputValue == "" || inputValue == null){
            $("#stakeholderList").val(JSON.stringify(stakeholders));
        }else{
            $("#stakeholderList").val(inputValue+JSON.stringify(stakeholders));
        }
    }

</script>
</html>