<%--
  Created by IntelliJ IDEA.
  User: Administrator
  Date: 2020/5/25
  Time: 9:31
  To change this template use File | Settings | File Templates.
--%>
<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>选择商铺</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <!--css 私有引入-->
    <%--tab css文件--%>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/tab/pc/dist/css/tab.css"/>
    <%--树 css文件--%>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/third_party/ztree/dist/css/metroStyle/metroStyle.css" />
    <%--table css文件--%>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/third_party/iCheck-v1.0.2/skins/square/blue.css"/>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/table/pc/dist/css/table.css"/>
    <style>
        .ztree{
            overflow: hidden;
            height: 250px;
            overflow-y: auto;
        }
    </style>
</head>
<body>
<div class="wrapper">
    <!--内容区开始-->
    <section >
        <div style="width: 750px;margin: 0 auto;" class="f-pl15 f-pr15 f-pt15">
            <ul class="m-choose-list" id="chooseList"></ul>
        </div>
        <div id="repositoryItemsTab" style="width: 750px; margin: 0 auto;"></div>
    </section>

    <!--内容区结束-->
</div>

<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<!--js引入私有 tab组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/tab/pc/dist/js/tab.js"></script>
<!--js引入私有 树组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/third_party/ztree/dist/js/init-ztree.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/third_party/ztree/dist/js/jquery.ztree.all.min.js"></script>
<!--js引入私有 表格组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/third_party/iCheck-v1.0.2/icheck.min.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/table/pc/dist/js/table.js"></script>
<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/laypage.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/init-page.js"></script>
<script>

    //定义需要展示的tab的数组
    var tabTitleList = [];
    var isMulChoice = true; //默认多选
    /*初始化方法*/
    $().ready(function(){
        //获取是否支持多选
        isMulChoice = dyCom.getUrlParams("isMulChoice");
        if(isMulChoice && isMulChoice=='false'){
            isMulChoice = false;
        }
        //获取需要展示的tab tabList=0,1
        var tabTitleListTemp = dyCom.getUrlParams("tabTitleList");
        if (tabTitleListTemp) {
            tabTitleList = tabTitleListTemp.split(",");
        }
        //tab初始化
        tabInit();
    });

    /* 2.业务方法  */


    //tab初始化
    function tabInit() {
        var tabParemsTemp = [
            {
                id: 0,
                tabName: "适用景区",
                isInitAjax: true,
                isClickAjax: false,
                content: ""
            }
        ];
        var tabParems = [];
        if (tabTitleList.length > 0) {
            $(tabParemsTemp).each(function(i, n) {
                if (tabTitleList.indexOf(n.id.toString()) > -1) {
                    tabParems.push(n);
                }
            });
        } else {
            tabParems = tabParemsTemp;
        }
        tabParems[0].isInitAjax = true;
        tabParems[0].isClickAjax = false;
        var options = {
            contentDomId: "#repositoryItemsTab",
            isSlide: false,
            isInitAjax: false,
            isClickAjax: true,
            tabParems: tabParems,
            success: function(contentDom, tabIndex, tabData) {
                //初始化成功 需要初始化第一个数据
                setClickData(
                    contentDom.attr("id"),
                    tabIndex,
                    tabParems[tabIndex].id
                );
            },
            clickCallback: function(containerId, tabIndex, tabData) {
                //点击回调
                if (tabIndex > 0) {
                    setClickData(containerId, tabIndex, tabParems[tabIndex].id);
                }
            }
        };
        dyPlugins.Tab.init(options);
    }
    //tab项初始化
    function setClickData(containerId, tabIndex, tabTitleId) {
        var domId = ""; //渲染的dom节点
        var domLength = $("#" + containerId + " #tableDataList").length;
        if (domLength == 0) {
            //tabIndex tab头部的点击项的序序列号
            $("#" + containerId).html(
                "<div >" +
                '<div id="tableDataList" data-height="250"></div>' +
                '<div id="itemslaypage"></div>' +
                "</div>"
            );
            //加载配置项分类数据
            setTimeout(function() {
                getShopsList(containerId, tabIndex, tabTitleId, 0, 15);
            }, 10);
        }
    }

    /*获取配置项分类ajax需要的参数*/
    function getItemsParams(currPage,pageSize) {
        var paramsStr = "?page="+currPage+'&size='+pageSize;
        if (token) {
            paramsStr += "&token=" + token;
        }
        return paramsStr;
    }
    //商铺
    function getShopsList(containerId,tabIndex,tabTitleId,currPage,pageSize) {

        var itemTypeParams = getItemsParams(currPage,pageSize);
        var typeId = dyCom.getUrlParams("typeId");

        if(!typeId){
            typeId = 'mine';
        }

        var cgroupId = dyCom.getUrlParams("cgroupId"); //获取圈子ID  通过圈子 获取圈子下的 实体关联的商铺  目前没有接口

        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcardtypes/'+typeId+'/cmfrees'+itemTypeParams)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 渲染配置项列表
                setShopListView(containerId, tabIndex, tabTitleId, null, data);
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);

    }
    //渲染商铺表格数据
    function setShopListView(containerId,tabIndex,tabTitleId,customId,data) {
        //表格对象
        //数据表格渲染
        var dataList = [];
        if (data.result && data.result.length) {
            dataList = data.result;
        }
        var tableOption = {
            elem: "#" + containerId + " #tableDataList",
            data: dataList,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            width: "100%",
            height: "500",
            trData: [{ id: "itemId" }],
            cols: [
                {
                    type: "numbers",
                    field: "nums",
                    title: "NO.",
                    width: 50
                }, //序列号
                {
                    field: "mcName",
                    width: 120,
                    title: "景区名称",
                    callback: function(cdata) {
                        return (
                            '<div class="f-dn dataJson">' +
                            JSON.stringify(cdata) +
                            '</div><span class="f-db f-toe">' +
                            cdata.mcName +
                            "</span>"
                        );
                    }
                },
                {
                    field: "mcClassLv1",
                    width: 150,
                    title: "商品名称",
                    callback: function(cdata) {
                        return (
                            '<span class="f-db f-toe">' +
                            cdata.cmName +
                            "</span>"
                        );
                    }
                }
            ],
            init: function() {
                //初始化方法
                $("#" + containerId + " #tableDataList .dyui-table-main tr")
                    .off("click")
                    .on("click", function() {
                        var trDataString = $(this)
                            .find(".dataJson")
                            .text();
                        var trData = JSON.parse(trDataString);
                        setChooseData(0, trData);
                    });
            }
        };
        dyPlugins.Table.createTable(tableOption, 0);
        //初始化多选框

        //分页"#" + containerId+' #itemslaypage'
        if (data.totalPage) {
            dyPlugins.Page.init(
                $("#" + containerId + " #itemslaypage"),
                data.totalPage,
                data.currPage,
                data.pageSize,
                data.totalRows,
                function(pageData) {
                    getShopsList(
                        containerId,
                        tabIndex,
                        tabTitleId,
                        pageData.curr,
                        data.pageSize,
                        customId
                    );
                }
            );
        }
    }

    function getmcStatus(value) {
        //商铺状态
        var valueTemp = "";
        var mcStatus = [
            {
                id: "1",
                value: "适用"
            },
            {
                id: "0",
                value: "取消适用"
            }
        ];
        $(mcStatus).each(function(i, n) {
            if (n.id == value) {
                valueTemp = n.value;
            }
        });
        return valueTemp;
    }

    //选中的内容添加到选中序列中 type =0 商铺 、1 圈子
    function setChooseData(type, dataItem) {
        var liHtml =
            '<li data-id="' +
            dataItem.mcId +
            '" data-type="' +
            type +
            '">' +
            "<label>" +
            dataItem.mcName +
            "</label>" +
            '<span class="f-dn selectItemJson">' +
            JSON.stringify(dataItem) +
            "</span>" +
            '<i class="iconfont iconguanbi del"></i>' +
            "</li>";
        var checkSelectFlag = 0;
        if(isMulChoice){
            $("#chooseList li").each(function(i, n) {
                var idTemp = $(n).data("id");
                var typeTemp = $(n).data("type");
                if (type == typeTemp && idTemp == dataItem.mcId) {
                    checkSelectFlag = 1;
                }
            });
            if (!checkSelectFlag) {
                $("#chooseList").append(liHtml);
                //选中的项-删除操作 监听
                $("#chooseList .del").off("click").on("click", function() {
                    $(this).parent().remove();
                });
            }
        }else{
            $("#chooseList").html(liHtml);
            //选中的项-删除操作 监听
            $("#chooseList .del").off("click").on("click", function() {
                $(this).parent().remove();
            });
        }


    }

    //对外抛出的 获取选中的项的对象
    function getItemsList() {
        var listObj = [];
        $("#chooseList li").each(function(i, n) {
            var itemObj = $(n)
                .find(".selectItemJson")
                .text();
            if (itemObj) {
                itemObj = JSON.parse(itemObj);
                listObj.push(itemObj);
            }
        });
        return listObj;
    }

    //对外抛出的 回显内容
    function setItemsList(listObj) {
        $(listObj).each(function(i, n) {
            var type = 0;
            setChooseData(type, n);
        });
    }

    /*****************************父页面需要调用的方法 弹出层***************************************************/

    //父页面需要调用的方法 弹出层
    /*
    * tabTitleList 0,1,3,4  必填  0 自营商铺 sp  1 分销商铺 ag 3圈子下的实体的商铺(目前没有接口)
    * token 必填
    * 特殊情况 必填项
    * customId 当tabTitleList=1的时候 必填 其他时候不必填
    * cgroupId 当当tabTitleList=3的时候 必填 其他时候不必填
    *
    * */
    /*function parentFunction() {
        var childWindow = null;
        layer.open({
            id: "selectRepLayer",
            type: 2,
            title: "商铺",
            shadeClose: true,
            shade: 0.6,
            maxmin: true, //开启最大化最小化按钮
            area: ["750px", "560px"],
            content:
            ctx +
            "/mcards/choosemcfree?isMulChoice=false&tabTitleList=0,1&typeId=" + typeId + '&token=' +
            token,
            success: function(ee) {
                //初始化完成之后  例如修改的时候 需要处理
                var frameId = document
                    .getElementById("selectRepLayer")
                    .getElementsByTagName("iframe")[0].id;
                childWindow = $("#" + frameId)[0].contentWindow;
                // item  必须字段 objType itemId  name
                childWindow.setItemsList([]);
            },
            btn: ["确定", "取消"],
            yes: function(index) {
                var datalist = childWindow.getItemsList();
                console.log(datalist);
                layer.close(index);
            },
            btn2: function(index) {}
        });
    }*/


</script>


</body>
</html>
