<%--
  Created by IntelliJ IDEA.
  User: Administrator
  Date: 2020/5/25
  Time: 9:31
  To change this template use File | Settings | File Templates.
--%>
<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>选择商铺</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <!--css 私有引入-->
    <%--tab css文件--%>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/tab/pc/dist/css/tab.css"/>
    <%--树 css文件--%>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/third_party/ztree/dist/css/metroStyle/metroStyle.css" />
    <%--table css文件--%>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/third_party/iCheck-v1.0.2/skins/square/blue.css"/>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/table/pc/dist/css/table.css"/>
    <style>
        .ztree{
            overflow: hidden;
            height: 250px;
            overflow-y: auto;
        }
    </style>
</head>
<body>
<div class="wrapper">
    <!--内容区开始-->
    <section >
        <div style="width: 750px;margin: 0 auto;" class="f-pl15 f-pr15 f-pt15">
            <ul class="m-choose-list" id="chooseList"></ul>
        </div>
        <div id="repositoryItemsTab" style="width: 750px; margin: 0 auto;"></div>
    </section>

    <!--内容区结束-->
</div>

<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<!--js引入私有 tab组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/tab/pc/dist/js/tab.js"></script>
<!--js引入私有 树组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/third_party/ztree/dist/js/init-ztree.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/third_party/ztree/dist/js/jquery.ztree.all.min.js"></script>
<!--js引入私有 表格组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/third_party/iCheck-v1.0.2/icheck.min.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/table/pc/dist/js/table.js"></script>
<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/laypage.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/init-page.js"></script>
<script>

    //定义需要展示的tab的数组
    var tabTitleList = [];
    var isMulChoice = true; //默认多选
    /*初始化方法*/
    $().ready(function(){
        //获取是否支持多选
        isMulChoice = dyCom.getUrlParams("isMulChoice");
        if(isMulChoice && isMulChoice=='false'){
            isMulChoice = false;
        }
        //获取需要展示的tab tabList=0,1
        var tabTitleListTemp = dyCom.getUrlParams("tabTitleList");
        if (tabTitleListTemp) {
            tabTitleList = tabTitleListTemp.split(",");
        }
        //tab初始化
        tabInit();
    });

    /* 2.业务方法  */


    //tab初始化
    function tabInit() {
        var tabParemsTemp = [
            {
                id: 0,
                tabName: "自营商铺",
                isInitAjax: true,
                isClickAjax: false,
                content: ""
            },
            {
                id: 1,
                tabName: "分销商铺",
                isInitAjax: false,
                isClickAjax: true,
                content: ""
            },
            {
                id: 2,
                tabName: "平台实体商铺",
                isInitAjax: false,
                isClickAjax: true,
                content: ""
            },
            {
                id: 3,
                tabName: "其他商铺",
                isInitAjax: false,
                isClickAjax: true,
                content: ""
            }
        ];
        var tabParems = [];
        if (tabTitleList.length > 0) {
            $(tabParemsTemp).each(function(i, n) {
                if (tabTitleList.indexOf(n.id.toString()) > -1) {
                    tabParems.push(n);
                }
            });
        } else {
            tabParems = tabParemsTemp;
        }
        tabParems[0].isInitAjax = true;
        tabParems[0].isClickAjax = false;
        var options = {
            contentDomId: "#repositoryItemsTab",
            isSlide: false,
            isInitAjax: false,
            isClickAjax: true,
            tabParems: tabParems,
            success: function(contentDom, tabIndex, tabData) {
                //初始化成功 需要初始化第一个数据
                setClickData(
                    contentDom.attr("id"),
                    tabIndex,
                    tabParems[tabIndex].id
                );
            },
            clickCallback: function(containerId, tabIndex, tabData) {
                //点击回调
                if (tabIndex > 0) {
                    setClickData(containerId, tabIndex, tabParems[tabIndex].id);
                }
            }
        };
        dyPlugins.Tab.init(options);
    }
    //tab项初始化
    function setClickData(containerId, tabIndex, tabTitleId) {
        var domId = ""; //渲染的dom节点
        var domLength = $("#" + containerId + " #tableDataList").length;
        if (domLength == 0) {
            //tabIndex tab头部的点击项的序序列号
            $("#" + containerId).html(
                "<div >" +
                '<div id="tableDataList" data-height="250"></div>' +
                '<div id="itemslaypage"></div>' +
                "</div>"
            );
            //加载配置项分类数据
            setTimeout(function() {
                getShopsList(containerId, tabIndex, tabTitleId, 0, 15);
            }, 10);
        }
    }

    /*获取配置项分类ajax需要的参数*/
    function getItemsParams(currPage,pageSize) {
        var paramsStr = "?page="+currPage+'&size='+pageSize;
        if (token) {
            paramsStr += "&token=" + token;
        }
        return paramsStr;
    }
    //商铺
    function getShopsList(containerId,tabIndex,tabTitleId,currPage,pageSize) {

        var itemTypeParams = getItemsParams(currPage,pageSize);
        var customId = dyCom.getUrlParams("customId");
        var ctype = '';
        var nextStr = '';
        if(tabTitleId==0){
            ctype = 'sp';
        }else if(tabTitleId==1){
            ctype = 'ag';
        }else if(tabTitleId==2){
            ctype = 'cgroups';
            var cgroupId = dyCom.getUrlParams("cgroupId"); //获取圈子ID  通过圈子 获取圈子下的 实体关联的商铺  目前没有接口
            customId = cgroupId;
            nextStr = '/all';
        }else if(tabTitleId==3){
            // ctype = 'ag';
        }
        if(!customId){
            customId = 'mine';
        }



        var paramsJson = {
            restPath:encodeURI('/ebsvr/mcs/'+ctype+'/'+customId+'/mcs'+nextStr+itemTypeParams)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 渲染配置项列表
                setShopListView(containerId, tabIndex, tabTitleId, customId, data);
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);

    }
    //渲染商铺表格数据
    function setShopListView(containerId,tabIndex,tabTitleId,customId,data) {
        //表格对象
        //数据表格渲染
        var dataList = [];
        if (data.result && data.result.length) {
            dataList = data.result;
        }
        var tableOption = {
            elem: "#" + containerId + " #tableDataList",
            data: dataList,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            width: "100%",
            height: "500",
            trData: [{ id: "itemId" }],
            cols: [
                {
                    type: "numbers",
                    field: "nums",
                    title: "NO.",
                    width: 50
                }, //序列号
                {
                    field: "mcName",
                    width: 120,
                    title: "商铺名称",
                    callback: function(cdata) {
                        return (
                            '<div class="f-dn dataJson">' +
                            JSON.stringify(cdata) +
                            '</div><span class="f-db f-toe">' +
                            cdata.mcName +
                            "</span>"
                        );
                    }
                },
                {
                    field: "mcClassLv1",
                    width: 150,
                    title: "商铺类型",
                    callback: function(cdata) {
                        return (
                            '<span class="f-db f-toe">' +
                            getmcClass(cdata.mcClassLv1, cdata.mcClassLv2) +
                            "</span>"
                        );
                    }
                },

                {
                    field: "mcLevel",
                    width: 150,
                    title: "等级",
                    callback: function(cdata) {
                        return '<span class="f-db f-toe">' + cdata.mcLevel + "</span>";
                    }
                },
                {
                    field: "status",
                    width: 150,
                    title: "状态",
                    callback: function(cdata) {
                        return (
                            '<span class="f-db f-toe">' +
                            getmcStatus(cdata.status) +
                            "</span>"
                        );
                    }
                }
            ],
            init: function() {
                //初始化方法
                $("#" + containerId + " #tableDataList .dyui-table-main tr")
                    .off("click")
                    .on("click", function() {
                        var trDataString = $(this)
                            .find(".dataJson")
                            .text();
                        var trData = JSON.parse(trDataString);
                        setChooseData(0, trData);
                    });
            }
        };
        dyPlugins.Table.createTable(tableOption, 0);
        //初始化多选框

        //分页"#" + containerId+' #itemslaypage'
        if (data.totalPage) {
            dyPlugins.Page.init(
                $("#" + containerId + " #itemslaypage"),
                data.totalPage,
                data.currPage,
                data.pageSize,
                data.totalRows,
                function(pageData) {
                    getShopsList(
                        containerId,
                        tabIndex,
                        tabTitleId,
                        pageData.curr,
                        data.pageSize,
                        customId
                    );
                }
            );
        }
    }

    function getmcStatus(value) {
        //商铺状态
        var valueTemp = "";
        var mcStatus = [
            {
                id: "1",
                value: "正常"
            },
            {
                id: "3",
                value: "筹建中"
            },
            {
                id: "5",
                value: "修改中"
            },
            {
                id: "2",
                value: "待审核"
            },
            {
                id: "8",
                value: "关店审核中"
            },
            {
                id: "9",
                value: "已关店"
            },
            {
                id: "0",
                value: "已删除"
            }
        ];
        $(mcStatus).each(function(i, n) {
            if (n.id == value) {
                valueTemp = n.value;
            }
        });
        return valueTemp;
    }

    function getmcClass(class1, class2) {
        //商铺分类
        var valueTemp = "";
        var mcClass = [
            {
                id: "1002",
                value: "行",
                children: [
                    { id: "1002001", value: "飞机" },
                    { id: "1002002", value: "火车" },
                    { id: "1002003", value: "汽车" },
                    { id: "1002004", value: "租车" },
                    { id: "1002005", value: "签证" }
                ]
            },
            {
                id: "1006",
                value: "游",
                children: [
                    { id: "1006001", value: "景区" },
                    { id: "1006002", value: "滑雪场" },
                    { id: "1006004", value: "温泉" },
                    { id: "1006006", value: "旅行社" },
                    { id: "1006007", value: "生态园" },
                    { id: "1006008", value: "农家乐" },
                    { id: "1006009", value: "旅游服务公司" }
                ]
            },
            {
                id: "1001",
                value: "住",
                children: [
                    { id: "1001001", value: "宾馆酒店" },
                    { id: "1001003", value: "度假村" }
                ]
            },
            {
                id: "1003",
                value: "食",
                children: [
                    { id: "1003001", value: "饭店餐饮" },
                    { id: "1003003", value: "茶馆" },
                    { id: "1003004", value: "咖啡馆" },
                    { id: "1003007", value: "西餐厅" }
                ]
            },
            {
                id: "1005",
                value: "购",
                children: [
                    { id: "1005001", value: "商超" },
                    { id: "1005002", value: "专卖店" },
                    { id: "1005005", value: "特产品" },
                    { id: "1005006", value: "工艺品" },
                    { id: "1005101", value: "服装服饰" },
                    { id: "1005102", value: "婴童用品" },
                    { id: "1005103", value: "箱包皮具" },
                    { id: "1005104", value: "精品礼品" },
                    { id: "1005105", value: "护理化妆品" },
                    { id: "1005106", value: "珠宝" },
                    { id: "1005107", value: "电子产品" },
                    { id: "1005108", value: "家居家电" },
                    { id: "1005109", value: "日常用品" },
                    { id: "1005110", value: "特卖场" }
                ]
            },
            {
                id: "1004",
                value: "娱",
                children: [
                    { id: "1004001", value: "民族表演" },
                    { id: "1004002", value: "酒吧" },
                    { id: "1004004", value: "KTV" },
                    { id: "1004005", value: "会所/俱乐部" },
                    { id: "1004006", value: "运动健身" },
                    { id: "1004101", value: "儿童乐园" },
                    { id: "1004102", value: "影视" },
                    { id: "1004103", value: "游乐园" }
                ]
            },
            {
                id: "2005",
                value: "农村电商",
                children: [
                    { id: "2005003", value: "农资" },
                    { id: "2005004", value: "农产品" },
                    { id: "2005008", value: "供销社" }
                ]
            },
            {
                id: "3001",
                value: "党建",
                children: [
                    { id: "3001001", value: "党校" },
                    { id: "3001002", value: "专业机构" },
                    { id: "3001003", value: "出版社" }
                ]
            },
            {
                id: "3002",
                value: "企业培训",
                children: [{ id: "3002001", value: "企业培训" }]
            },
            {
                id: "3003",
                value: "K12",
                children: [
                    { id: "3003001", value: "婴幼儿" },
                    { id: "3003002", value: "小学" },
                    { id: "3003003", value: "初中" },
                    { id: "3003004", value: "高中" },
                    { id: "3003009", value: "综合" }
                ]
            },
            {
                id: "3004",
                value: "高等教育",
                children: [{ id: "3004001", value: "高等教育" }]
            },
            {
                id: "3005",
                value: "职业教育",
                children: [{ id: "3005001", value: "医学培训" }]
            },
            {
                id: "4001",
                value: "影视",
                children: [{ id: "4001001", value: "影视发行机构" }]
            }
        ];
        $(mcClass).each(function(i, n) {
            if (n.id == class1) {
                if (n.children) {
                    $(n.children).each(function(ii, nn) {
                        if (nn.id == class2) {
                            valueTemp = n.value + "-" + nn.value;
                        }
                    });
                }
            }
        });
        return valueTemp;
    }

    //选中的内容添加到选中序列中 type =0 商铺 、1 圈子
    function setChooseData(type, dataItem) {
        var liHtml =
            '<li data-id="' +
            dataItem.mcId +
            '" data-type="' +
            type +
            '">' +
            "<label>" +
            dataItem.mcName +
            "</label>" +
            '<span class="f-dn selectItemJson">' +
            JSON.stringify(dataItem) +
            "</span>" +
            '<i class="iconfont iconguanbi del"></i>' +
            "</li>";
        var checkSelectFlag = 0;
        if(isMulChoice){
            $("#chooseList li").each(function(i, n) {
                var idTemp = $(n).data("id");
                var typeTemp = $(n).data("type");
                if (type == typeTemp && idTemp == dataItem.mcId) {
                    checkSelectFlag = 1;
                }
            });
            if (!checkSelectFlag) {
                $("#chooseList").append(liHtml);
                //选中的项-删除操作 监听
                $("#chooseList .del").off("click").on("click", function() {
                    $(this).parent().remove();
                });
            }
        }else{
            $("#chooseList").html(liHtml);
            //选中的项-删除操作 监听
            $("#chooseList .del").off("click").on("click", function() {
                $(this).parent().remove();
            });
        }


    }

    //对外抛出的 获取选中的项的对象
    function getItemsList() {
        var listObj = [];
        $("#chooseList li").each(function(i, n) {
            var itemObj = $(n)
                .find(".selectItemJson")
                .text();
            if (itemObj) {
                itemObj = JSON.parse(itemObj);
                listObj.push(itemObj);
            }
        });
        return listObj;
    }

    //对外抛出的 回显内容
    function setItemsList(listObj) {
        $(listObj).each(function(i, n) {
            var type = 0;
            setChooseData(type, n);
        });
    }

    /*****************************父页面需要调用的方法 弹出层***************************************************/

    //父页面需要调用的方法 弹出层
    /*
    * tabTitleList 0,1,2,3  必填  0 自营商铺 sp  1 分销商铺 ag 2 查询指定平台全部关联的商铺（平台下实体的所有商铺，包括平台已绑定和未绑定的）
    * token 必填
    * 特殊情况 必填项
    * customId 当tabTitleList=1的时候 必填 其他时候不必填
    * cgroupId 当当tabTitleList=3的时候 必填 其他时候不必填
    *
    * */
    /*function parentFunction() {
        var childWindow = null;
        layer.open({
            id: "selectRepLayer",
            type: 2,
            title: "商铺",
            shadeClose: true,
            shade: 0.6,
            maxmin: true, //开启最大化最小化按钮
            area: ["750px", "560px"],
            content:
            ctx +
            "/stakeholders/storesorcgroups?tabTitleList=0,1,2,3&customId=&cgroupId=&token=" +
            token,
            success: function(ee) {
                //初始化完成之后  例如修改的时候 需要处理
                var frameId = document
                    .getElementById("selectRepLayer")
                    .getElementsByTagName("iframe")[0].id;
                childWindow = $("#" + frameId)[0].contentWindow;
                // item  必须字段 objType itemId  name
                childWindow.setItemsList([]);
            },
            btn: ["确定", "取消"],
            yes: function(index) {
                var datalist = childWindow.getItemsList();
                console.log(datalist);
                layer.close(index);
            },
            btn2: function(index) {}
        });
    }*/


</script>


</body>
</html>
