<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<c:set var="ctx" value="${pageContext.request.contextPath}"/>
<c:set var="static_js" value="${pageContext.request.contextPath}/static/js"/>
<c:set var="static_css" value="${pageContext.request.contextPath}/static/css"/>
<c:set var="static_images" value="${pageContext.request.contextPath}/static/images"/>
<c:set var="dist_bootstrap" value="${pageContext.request.contextPath}/dist/lib/bootstrap/"/>
<c:set var="dist_jquery" value="${pageContext.request.contextPath}/dist/lib/jquery"/>
<c:set var="dist_styles" value="${pageContext.request.contextPath}/dist/styles"/>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>商铺列表</title>
    <link href="${static_css}/bootstrap.min.css" rel="stylesheet">
    <link href="${static_css}/common.css" rel="stylesheet">
</head>
<body style="height: 100%">
<div class="body-div" id="loading">
    <!--内容-->
    <div class="main-content">
        <!--标题开始-->
        <div class="title">
        	<span>
        		选择商铺
        	</span>
        </div>
        <!--标题结束-->
        <div class="col-xs-12 swlDetail">
            <div class="col-xs-12">
                <form action="" id="chooseBo" name="chooseBo" method="get">
                    <div class="col-xs-12" style="height: 40px;">
                        <div class="col-xs-10" style="text-align: left;">
                            <input type="text" id="customerName" name="customerName" style="width:100%;height: 35px;border: 1px solid #888888; "/>
                        </div>
                        <div class="col-xs-2" style="text-align: right;">
                            <button type="submit" style="width:120px;height:35px;border:0;background-color: #0D8DDB;color: #FFFFFF;">搜索</button>
                        </div>
                    </div>
                </form>
                <div class="data-range new-border" style="padding: 0;">
                    <input type="hidden" id="hidMcId" name="hidMcId">
                    <input type="hidden" id="hidMcName" name="hidMcName">
                    <table id="table1" class="table table-striped table-bordered table-hover table-condensed">
                        <thead>
                        <tr>
                            <th></th>
                            <th>商铺名称</th>
                            <th>商铺大类</th>
                            <th>商铺小类</th>
                            <th>联系人名称</th>
                            <th>联系电话</th>
                        </tr>
                        </thead>
                        <tbody>
                        <c:choose>
                            <c:when test="${not empty merchants}">
                                <c:forEach items="${merchants}" var="merchant" varStatus="vs">
                                    <tr>
                                        <td class="card-describe1"><input type="radio" name="radio" style="width: 10px" value="${merchant.mcId}"></td>
                                        <td class="card-describe2">${merchant.mcName}</td>
                                        <td class="card-describe1">${merchant.mcClassLv1}</td>
                                        <td class="card-describe2">${merchant.mcClassLv2}</td>
                                        <td class="card-describe1">${merchant.linkName}</td>
                                        <td class="card-describe1">${merchant.phone}</td>
                                    </tr>
                                </c:forEach>
                            </c:when>
                        </c:choose>
                        </tbody>
                    </table>
                </div>
            </div>
            <%--<div class="col-xs-12">--%>
            <%--<div class="data-range new-border">--%>
            <%--<div class="col-xs-6" style="text-align: right;">--%>
            <%--<button type="button" style="width:120px;height:35px;border:0;background-color: #0D8DDB;color: #FFFFFF;">取消</button>--%>
            <%--</div>--%>
            <%--<div class="col-xs-6" style="text-align: left;">--%>
            <%--<button id="dialogDivBo" type="button" style="width:120px;height:35px;border:0;background-color: #0D8DDB;color: #FFFFFF;">确定</button>--%>
            <%--</div>--%>
            <%--</div>--%>
            <%--</div>--%>
        </div>
    </div>
</div>
</body>
<script src="${dist_jquery}/jquery.js" type="text/javascript" charset="utf-8"></script>
<script src="${dist_bootstrap}/bootstrap.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript">
    //鼠标经过按钮变色
    function currentMenuBtn() {
        $(".menu-btn").mouseover(function(){
            $(this).children().css("background-color","#8EB4E3");
        });
        $(".menu-btn").mouseout(function(){
            $(this).children().css("background-color","#bdbfbe");
        });
    }
    currentMenuBtn();
</script>
<script>
    $(function(){
        $(":radio").click(function(){
            var mcId = $('input:radio[name="radio"]:checked').val();
            var mcName = $("input:checked").parents('tr').find('td').eq(1).text();
            $("#hidMcId").val(mcId);
            $("#hidMcName").val(mcName);
        });
    })
</script>
</html>
