<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<c:set var="ctx" value="${pageContext.request.contextPath}"/>
<c:set var="static_js" value="${pageContext.request.contextPath}/static/js"/>
<c:set var="static_css" value="${pageContext.request.contextPath}/static/css"/>
<c:set var="static_images" value="${pageContext.request.contextPath}/static/images/applogo"/>
<c:set var="dist_bootstrap" value="${pageContext.request.contextPath}/dist/lib/bootstrap/"/>
<c:set var="dist_jquery" value="${pageContext.request.contextPath}/dist/lib/jquery"/>
<c:set var="dist_styles" value="${pageContext.request.contextPath}/dist/styles"/>

<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="edge"/>
    <meta name="viewport"
          content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no"/>
    <title>选择组织</title>
    <link href="${static_css}/bootstrap.min.css" rel="stylesheet">
    <link href="${static_css}/common.css" rel="stylesheet">
    <link href="${static_css}/font-awesome.min.css" rel="stylesheet">
    <link href="${static_css}/style.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="${static_css}/top.css"/>
    <style>
        html,body{
            width: 100%;
            height: 100%;
            background-color: #E7E7E7;
        }
        .title1{
            width: 100%;
            line-height: 45px;
            text-align: left;
            background-color: #FFFFFF;
            padding-left: 10px;
        }
        .jq-list{
            width: 22%;
            height: 50px;
            margin:20px 15px;
            float: left;
            text-align: center;
            background-color: #F4F6F5;
            padding-top: 10px;
            color: #080808;
            border: 1px solid #c9cbca;
        }
        .cm-list{
            width: 22%;
            height: 100px;
            margin:20px 15px;
            float: left;
            text-align: center;
            background-color: #F4F6F5;
            color: #080808;
            border: 1px solid #c9cbca;
        }
        .media-list {
            margin-bottom: 0px;
        }
        .media-body p{
            text-align: left;
        }
    </style>
</head>
<body>
<div style="width: 100%;height: 100%;">
    <nav class="navbar navbar-default navbar-fixed-top" style="margin-bottom: 10px;">
        <div class="container-fluid">
            <div  class="header clearfix" onclick="goBack()">
                <div class="header-left">
                    <img src="${static_images}/logo-70.png" class="avatar"/><span class="logo-desc">${customerName}实体管理门户页面</span>
                </div>
                <div class="navLeft header-right">
                    <ul>
                        <li>${sessionScope.tokenInfo.accountName}</li>
                        <li class="ments"></li>
                        <li>退出</li>
                    </ul>
                </div>
            </div>

        </div>
    </nav>
    <div class="col-xs-12" style="height: 50%;margin-top: 10px;overflow-y:scroll;">
        <input type="hidden" id="customerId" name="customerId" value="${customerId}">
        <input type="hidden" id="customerName" name="customerName" value="${customerName}">
        <div class="title1">
            <span>
                客户实体信息
            </span>
        </div>
        <div class="clearfix" style="width: 100%;height: auto;">
            <c:choose>
                <c:when test="${not empty customerList}">
                    <c:forEach items="${customerList}" var="customer">
                        <div class="jq-list" onclick="queryOrganList('${customer.customerId}','${customer.customerName}')">
                            ${customer.customerName}
                        </div>
                    </c:forEach>
                </c:when>
            </c:choose>
        </div>
    </div>
    <div class="col-xs-12" style="height: 37%;margin-top: 10px;overflow-y:scroll;">
        <div class="title1">
            <span>
                选择店铺/网点/机构
            </span>
        </div>
        <div id="organs" class="clearfix" style="width: 100%;height: auto;">
            <c:choose>
                <c:when test="${not empty organList}">
                    <c:forEach items="${organList}" var="organ">
                        <c:if test="${organ.organStatus == '1'}"><%--只展示正常的组织--%>
                        <div class="cm-list" onclick="chooseOrgan('${organ.organId}','${organ.organName}')">
                            <ul class="media-list">
                                <!--.media：该 class 允许将媒体对象里的多媒体（图像、视频、音频）浮动到内容区块的左边或者右边。-->
                                <li class="media">
                                    <a class="pull-left">
                                        <img class="media-object" src="${static_images}/logo-70.png"
                                             alt="通用的占位符图像">
                                    </a>
                                    <div class="media-body">
                                        <p style="width:160px; white-space:nowrap; text-overflow:ellipsis; overflow:hidden;">
                                            名称：${organ.organName}
                                        </p>
                                        <p style="width:160px; white-space:nowrap; text-overflow:ellipsis; overflow:hidden;">
                                            简介：${organ.organDesc}
                                        </p>
                                        <p>状态：
                                            <%--<c:if test="${organ.organStatus == '0'}">已删除</c:if>--%>
                                            <c:if test="${organ.organStatus == '1'}">正常</c:if>
                                        </p>
                                    </div>
                                </li>
                            </ul>
                        </div>
                        </c:if>
                    </c:forEach>
                </c:when>
            </c:choose>
        </div>
    </div>
</div>
</body>
<script src="${dist_jquery}/jquery.js" type="text/javascript" charset="utf-8"></script>
<script src="${dist_bootstrap}/bootstrap.min.js" type="text/javascript" charset="utf-8"></script>
<script>
    function chooseOrgan(organId,organName) {
        var customerId = $("#customerId").val();
        var customerName = $("#customerName").val();
        window.location.href="${ctx}/chooseOrgan/submit?customerId="+customerId+"&customerName="+customerName+"&organId="+organId+"&organName="+organName;
    }
    //获取客户实体对应的组织列表[查询 正常 的组织]
    function queryOrganList(customerId,customerName) {
        var token = '${sessionScope.token}';
        $("#customerId").val(customerId);
        $("#customerName").val(customerName);
        var organs = "";
        $.ajax({
            type:"get",
            url:"<%=baseResourcePath%>/rbsvr/organs/account/mine/organs?customerId="+encodeURI(customerId)+"&organStatus=1&token="+encodeURI(token),
            dataType:"json",
            success:function(data){
                var lists = JSON.stringify(data.result);//JSON.stringify(obj)将JSON转为字符串。
                var myobj=eval("(" + lists + ")");//将字符串转化为对象
                if(myobj != '' && myobj != null && typeof(myobj) != 'undefined' ){
                    $.each(myobj,function(i,list){
                        organs += '<div class="cm-list" onclick="chooseOrgan(\''+list.organId+'\',\''+list.organName+'\')">'+
                            '<ul class="media-list">'+
                            '<li class="media">'+
                            '<a class="pull-left">'+
                            '<img class="media-object" src="${static_images}/logo-70.png" alt="通用的占位符图像">'+
                            '</a>'+
                            '<div class="media-body">'+
                            '<p style="width:160px; white-space:nowrap; text-overflow:ellipsis; overflow:hidden;">'+
                            '名称：'+list.organName+'</p>'+
                            '<p style="width:160px; white-space:nowrap; text-overflow:ellipsis; overflow:hidden;">'+
                            '简介：'+list.organDesc+'</p>'+
                            '<p>状态：'+
                            '<c:if test="${list.organStatus == '0'}">已删除</c:if>'+
                            '<c:if test="${list.organStatus == '1'}">正常</c:if>'+
                            '</p>'+
                            '</div>'+
                            '</li>'+
                            '</ul>'+
                            '</div>';

                    });
                }
                $('#organs').html(organs);
            }
        });
    }

    function goBack() {
        window.location.href = "${ctx}";
    }
</script>
</html>
