<%--
  Created by IntelliJ IDEA.
  User: Administrator
  Date: 2020/5/25
  Time: 9:31
  To change this template use File | Settings | File Templates.
--%>
<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>选择商铺</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-header-js.jsp"%>
    <!--css 私有引入-->
    <%--tab css文件--%>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/tab/app/dist/css/tab.css"/>
    <%--树 css文件--%>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/third_party/ztree/dist/css/metroStyle/metroStyle.css" />
    <%--table css文件--%>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/third_party/iCheck-v1.0.2/skins/square/blue.css"/>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/table/app/dist/css/table.css"/>
    <%--pages css文件--%>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/pages/app/dist/css/ajax_pages_app.css"/>
    <style>
        .ztree{
            overflow: hidden;
            height: 5rem;
            overflow-y: auto;
        }
    </style>
</head>
<body>
<div class="wrapper">
    <!--内容区开始-->
    <section class="s-bg-ffffff">
        <div class="f-pA15">
            <ul class="m-choose-list" id="chooseList"></ul>
        </div>
        <div id="repositoryItemsTab"></div>
    </section>

    <!--内容区结束-->
</div>
<!--table 数据模板-->
<div id="tableDataListAlert" class="f-dn">
    <div class="m-table-list">

        <section class="content" id="scrollEvent" style="overflow: hidden;overflow-y: auto;">
            <table>
                <thead>
                <tr>
                    <th >NO.</th>
                    <th >名称</th>
                    <th >状态</th>
                </tr>
                </thead>
                <tbody id="tableDataList">

                </tbody>
            </table>
        </section>
    </div>
    <div id="dy-pages"></div>
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/app/include-global-var-script.jsp"%>
<!--js引入私有 tab组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/tab/app/dist/js/tab.js"></script>
<!--js引入私有 树组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/third_party/ztree/dist/js/init-ztree.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/third_party/ztree/dist/js/jquery.ztree.all.min.js"></script>
<!--js引入私有 表格组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/third_party/iCheck-v1.0.2/icheck.min.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/table/app/dist/js/table.js"></script>
<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/app/dist/js/ajax_pages_app_v1.2.js"></script>
<script>
    //定义需要展示的tab的数组
    var tabTitleList = [];
    var isMulChoice = true; //默认多选
    /*初始化方法*/
    $().ready(function(){
        dyCom.setScrollHeight('#scrollEvent',230);
        //获取是否支持多选
        isMulChoice = dyCom.getUrlParams("isMulChoice");
        if(isMulChoice && isMulChoice=='false'){
            isMulChoice = false;
        }
        //获取需要展示的tab tabList=0,1
        var tabTitleListTemp = dyCom.getUrlParams("tabTitleList");
        if (tabTitleListTemp) {
            tabTitleList = tabTitleListTemp.split(",");
        }
        //tab初始化
        tabInit();
    });

    /* 2.业务方法  */

    //tab初始化
    function tabInit() {
        var tabParemsTemp = [
            {
                id: 0,
                tabName: "自营商铺",
                isInitAjax: true,
                isClickAjax: false,
                content: ""
            },
            {
                id: 1,
                tabName: "分销商铺",
                isInitAjax: false,
                isClickAjax: true,
                content: ""
            },
            {
                id: 2,
                tabName: "平台实体商铺",
                isInitAjax: false,
                isClickAjax: true,
                content: ""
            },
            {
                id: 3,
                tabName: "其他商铺",
                isInitAjax: false,
                isClickAjax: true,
                content: ""
            }
        ];
        var tabParems = [];
        if(tabTitleList.length>0){
            $(tabParemsTemp).each(function(i,n){
                if (tabTitleList.indexOf(n.id.toString()) > -1) {
                    tabParems.push(n);
                }
            });
        }else{
            tabParems = tabParemsTemp;
        }
        tabParems[0].isInitAjax = true;
        tabParems[0].isClickAjax = false;
        var options = {
            contentDomId: "#repositoryItemsTab",
            isSlide: false,
            isInitAjax: false,
            isClickAjax: true,
            tabParems: tabParems,
            success: function(contentDom, tabIndex, tabData) {
                //初始化成功 需要初始化第一个数据
                setClickData(
                    contentDom.attr("id"),
                    tabIndex,
                    tabParems[tabIndex].id
                );
            },
            clickCallback: function(containerId, tabIndex, tabData) {
                //点击回调
                if(tabIndex>0){
                    setClickData(containerId, tabIndex, tabParems[tabIndex].id);
                }

            }
        };
        dyPlugins.Tab.init(options);
    }
    //tab项初始化
    function setClickData(containerId, tabIndex, tabTitleId) {
        var domId = ''; //渲染的dom节点
        //tabIndex tab头部的点击项的序序列号
        var domLength = $("#" + containerId + " #tableDataList").length;
        if (domLength == 0) {
            //tabIndex tab头部的点击项的序序列号
            $("#" + containerId).html($('#tableDataListAlert').html());
            //加载配置项分类数据
            setTimeout(function() {
                getShopsList('#'+containerId, tabIndex, tabTitleId);
            }, 10);
        }

    }

    /*获取ajax需要的参数*/
    function getItemsParams(){
        var paramsStr = '?';
        var paramsJson = [
            'page=$page',
            'size=$pageSize'
        ];
        if(token){
            paramsJson.push('token='+token);
        }
        paramsStr += paramsJson.join('&');
        return paramsStr;
    }
    //查询指定分类下的配置项
    function getShopsList(domId, tabIndex, tabTitleId) {
        var itemTypeParams = getItemsParams();
        var customId = dyCom.getUrlParams("customId");
        var ctype = '';
        var nextStr = '';
        if(tabTitleId==0){
            ctype = 'sp';
        }else if(tabTitleId==1){
            ctype = 'ag';
        }else if(tabTitleId==2){
            ctype = 'cgroups';
            var cgroupId = dyCom.getUrlParams("cgroupId"); //获取圈子ID  通过圈子 获取圈子下的 实体关联的商铺  目前没有接口
            customId = cgroupId;
            nextStr = '/all';
        }else if(tabTitleId==3){
            // ctype = 'ag';
        }
        if(!customId){
            customId = 'mine';
        }


        var paramsJson = {
            restPath:encodeURI('/ebsvr/mcs/'+ctype+'/'+customId+'/mcs'+nextStr+itemTypeParams)
        };
        var options = {
            contentDomId: domId+' #tableDataList', //填充内容的节点ID 如：“#myrelease_container”
            pagesDomId: domId+" #dy-pages",    //分页节点ID  "#dy-pages"
            scrollDom: $(domId+ ' #scrollEvent')[0],               //window对象  为了滑动使用 目前使用的是body滚动  所有传递的是window对象
            currPage: 0,                          //当前页 默认为0 从0开始计算页码
            pageSize: 30,                       //每页多少条
            itemHeight: 42,                  //每条的高度  为了计算滑动的当前页使用 需要计算目前所在的页
            static_image:'',
            ajaxParems:{                         //ajax请求的参数 对jquery的ajax 二次封装
                url: ctx+'/ajax/get',                        //请求地址  需要全地址
                type: "GET",                       //请求方式
                async: true,                        //异步|同步  默认true异步
                dataType: "JSON",             //数据格式
                data:paramsJson                              //ajax请求传参
            },
            callback:function(type,data){   //回调  ajax请求返回的数据  data
                //接收到数据 判断 type是否等于1如果等于1做业务处理  比如调用渲染页面方法
                if(type==1){
                    //1 渲染配置项列表
                    setShopListView(data,tabTitleId,domId+' #tableDataList');
                }else{
                    layer.open({
                        content: data
                        ,skin: 'msg'
                        ,time: 2 //2秒后自动关闭
                    });
                }
            }
        }
        dyPlugins.ajaxPages.Init(options);

    }
    //渲染配置项列表
    function setShopListView(data,tabTitleId,domId) {
        //数据表格渲染
        var dataList = [];
        if(data.result && data.result.length){
            dataList = data.result;
        }
        if(dataList.length){
            var contentLength = $(domId).find('tr').length;
            $(dataList).each(function(i,n){
                var trHtml =  '<tr>' +
                    '<td><span class="f-db" style="width: 0.4rem">'+(contentLength+i+1)+'</span></td>' +
                    '<td><div class="f-dn dataJson">'+JSON.stringify(n)+'</div><span class="f-db f-toe" style="width:3.4rem">'+n.mcName+'</span></td>' +
                    '<td><span class="f-db f-toe"  style="width: 1.0rem">'+getmcStatus(n.status)+'</span></td>' +
                    '</tr>';
                $(domId).append(trHtml);
            });
            //设置可以加载 分页组件
            dyPlugins.ajaxPages.setAjaxFlag(true);
            //初始化方法
            $(domId).find('tr').off('click').on('click',function(){
                var trDataString = $(this).find('.dataJson').text();
                var trData = JSON.parse(trDataString);
                setChooseData(0,trData);
            })
        }


    }
    function getmcStatus(value) {
        //商铺状态
        var valueTemp = "";
        var mcStatus = [
            {
                id: "1",
                value: "正常"
            },
            {
                id: "3",
                value: "筹建中"
            },
            {
                id: "5",
                value: "修改中"
            },
            {
                id: "2",
                value: "待审核"
            },
            {
                id: "8",
                value: "关店审核中"
            },
            {
                id: "9",
                value: "已关店"
            },
            {
                id: "0",
                value: "已删除"
            }
        ];
        $(mcStatus).each(function(i, n) {
            if (n.id == value) {
                valueTemp = n.value;
            }
        });
        return valueTemp;
    }
    //选中的内容添加到选中序列中 type =0 分类 、1 配置项
    function setChooseData(type,dataItem){
        var liHtml = '<li data-id="'+dataItem.mcId+'" data-type="'+type+'">' +
            '<label>'+dataItem.mcName+'</label>' +
            '<span class="f-dn selectItemJson">'+JSON.stringify(dataItem)+'</span>'+
            '<i class="iconfont iconguanbi del"></i>' +
            '</li>';
        var checkSelectFlag = 0;
        if(isMulChoice) {
            $('#chooseList li').each(function (i, n) {
                var idTemp = $(n).data('id');
                var typeTemp = $(n).data('type');
                if (type == typeTemp && idTemp == dataItem.mcId) {
                    checkSelectFlag = 1;
                }
            });
            if (!checkSelectFlag) {
                $('#chooseList').append(liHtml);
                //选中的项-删除操作 监听
                $('#chooseList .del').off('click').on('click', function () {
                    $(this).parent().remove();
                })
            }
        }else{
            $("#chooseList").html(liHtml);
            //选中的项-删除操作 监听
            $("#chooseList .del").off("click").on("click", function() {
                $(this).parent().remove();
            });
        }
    }

    //对外抛出的 获取选中的项的对象
    function getItemsList(){
        var listObj = [];
        $('#chooseList li').each(function(i,n){
            var itemObj = $(n).find('.selectItemJson').text();
            if(itemObj){
                itemObj = JSON.parse(itemObj);
                listObj.push(itemObj);
            }
        });
        return listObj;
    }
    //对外抛出的 回显内容
    function setItemsList(listObj){
        $(listObj).each(function(i,n){
            var type = 0;
            setChooseData(type,n);
        });
    }


    /*****************************************************父类调用组件***************************************************************/
    //父页面需要调用的方法 弹出层
    /*
    * tabTitleList 0,1,2,3  必填  0 自营商铺 sp  1 分销商铺 ag 2 查询指定平台全部关联的商铺（平台下实体的所有商铺，包括平台已绑定和未绑定的）
    * token 必填
    * 特殊情况 必填项
    * customId 当tabTitleList=1的时候 必填 其他时候不必填
    * cgroupId 当当tabTitleList=3的时候 必填 其他时候不必填
    *
    * */
    /*function parentFunction (){
        var iframeHtml = '<iframe id="shopListIframe" src="'+ctx+'/mcs/choosemc?isMulChoice=false&tabTitleList=0,1&customId='+supplierBoId+'&token='+token+'" style="height:100%;border: 0;" border="0"></iframe>';
        var childWindow = null;
        var pageii = layer.open({
            type: 1
            ,content: iframeHtml
            ,anim: 'left'
            ,btn: ['确定', '取消']
            ,style: 'position:fixed; right:0; top:50px; width:6rem; height:calc(100% - 50px); border: none; -webkit-animation-duration: .5s; animation-duration: .5s;',
            success:function(layObj){
                $(layObj).css('z-index',15);
                var iframePHeight = $(layObj).find('.layui-m-layerchild').height();
                $(layObj).find('.layui-m-layercont').css('height',(iframePHeight-50).toString()+'px');

                //初始化完成之后  例如修改的时候 需要处理
                childWindow = $(layObj).find("#shopListIframe")[0].contentWindow;
                // item  必须字段 objType itemId  name
                var dataList = [];
                if($("#mcId").val() && $("#mcName").val()){
                    dataList = [{'mcId':$("#mcId").val(),'mcName':$("#mcName").val()}];
                }
                if(childWindow.setItemsList){
                    childWindow.setItemsList(dataList);
                }else{
                    var setIntervalTime = setInterval(function(){
                        if(childWindow.setItemsList){
                            clearInterval(setIntervalTime);
                            childWindow.setItemsList(dataList);
                        }
                    },20);
                }
            }
            ,yes: function(index){
                var datalist = childWindow.getItemsList();
                if(datalist && datalist.length){
                    $("#mcId").val(datalist[0].mcId);
                    $("#mcName").val(datalist[0].mcName);
                }
                layer.close(index)
            }
            ,no: function(index){
                layer.close(index)
            }
        });
    }*/
</script>
</body>
</html>
