/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller;

import com.dayouzc.e2eplatform.core.context.E2EAppWebContext;
import com.dayouzc.e2eplatform.core.dto.equip.ConnectionInfoDTO;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/mcardtypes"})
public class MCardTypeQueryController {
    private static final Logger logger = LoggerFactory.getLogger(MCardTypeQueryController.class);

    @RequestMapping(value={"/operator/mine/mcardtypes"})
    public String queryMCardTypeOfMineAsOperator(Map<String, Object> model, HttpSession session, HttpServletRequest request) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/operator/listMine";
        }
        return "mcardmgr/pc/mcardtype/operator/listMine";
    }

    @RequestMapping(value={"/operator/{operatorBoId}/mcardtypes"})
    public String queryMCardTypeOfOperator(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="operatorBoId") String operatorBoId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("operatorBoId", operatorBoId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/operator/list";
        }
        return "mcardmgr/pc/mcardtype/operator/list";
    }

    @RequestMapping(value={"/sp/mine/mcardtypes"})
    public String queryMCardTypeOfMineAsSupplier(Map<String, Object> model, HttpSession session, HttpServletRequest request) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/sp/listMine";
        }
        return "mcardmgr/pc/mcardtype/sp/listMine";
    }

    @RequestMapping(value={"/sp/{supplierBoId}/mcardtypes"})
    public String queryMCardTypeOfSupplier(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="supplierBoId") String supplierBoId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("supplierBoId", supplierBoId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/sp/list";
        }
        return "mcardmgr/pc/mcardtype/sp/list";
    }

    @RequestMapping(value={"/ag/mine/mcardtypes"})
    public String queryMCardTypeOfMineAsAgency(Map<String, Object> model, HttpSession session, HttpServletRequest request) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/ag/listMine";
        }
        return "mcardmgr/pc/mcardtype/ag/listMine";
    }

    @RequestMapping(value={"/ag/{agencyBoId}/mcardtypes"})
    public String queryMCardTypeOfAgency(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="agencyBoId") String agencyBoId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("agencyBoId", agencyBoId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/ag/list";
        }
        return "mcardmgr/pc/mcardtype/ag/list";
    }

    @RequestMapping(value={"/sa/mine/mcardtypes"})
    public String queryMCardTypeOfSa(Map<String, Object> model, HttpSession session, HttpServletRequest request) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/sa/list";
        }
        return "mcardmgr/pc/mcardtype/sa/list";
    }

    @RequestMapping(value={""})
    public String queryMCardType(Map<String, Object> model, HttpSession session, HttpServletRequest request) {
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo((HttpServletRequest)request);
        return "forward:/mcardtypes/organ/" + tokenInfo.getOrganId() + "/mcardtypes";
    }

    @RequestMapping(value={"/organ/{organId}/mcardtypes"})
    public String queryMCardTypeOfOrgan(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="organId") String organId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("organId", organId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/organ/list";
        }
        return "mcardmgr/pc/mcardtype/organ/list";
    }

    @RequestMapping(value={"/mc/{mcId}/mcardtypes"})
    public String queryMCardTypeOfMc(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="mcId") String mcId, @RequestParam(value="currPage", required=false) String currPage) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        if (!StringUtils.isEmpty((CharSequence)mcId)) {
            session.setAttribute("mcId", (Object)mcId);
        }
        model.put("mcId", mcId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/mc/list";
        }
        return "mcardmgr/pc/mcardtype/mc/list";
    }

    @RequestMapping(value={"/mc/{mcId}/mcardtypes/manage"})
    public String queryMCardTypeOfMcForManage(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="mcId") String mcId, @RequestParam(value="currPage", required=false) String currPage) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        if (!StringUtils.isEmpty((CharSequence)mcId)) {
            session.setAttribute("mcId", (Object)mcId);
        }
        model.put("mcId", mcId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/mc/manage";
        }
        return "mcardmgr/pc/mcardtype/mc/manage";
    }

    @RequestMapping(value={"/bo/{boId}/mcardtypes/usable"})
    public String queryMCardTypeOfBoUsable(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="boId") String boId) {
        model.put("boId", boId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/bo/listUsable";
        }
        return "mcardmgr/pc/mcardtype/bo/listUsable";
    }

    @RequestMapping(value={"/mc/{mcId}/mcardtypes/usable"})
    public String queryMCardTypeOfMcUsable(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="mcId") String mcId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        if (!StringUtils.isEmpty((CharSequence)mcId)) {
            session.setAttribute("mcId", (Object)mcId);
        }
        mcId = (String)session.getAttribute("mcId");
        model.put("mcId", mcId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/mc/listUsable";
        }
        return "mcardmgr/pc/mcardtype/mc/listUsable";
    }

    @RequestMapping(value={"/{typeId}"})
    public String getMCardType(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="typeId") String typeId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("typeId", typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/info/baseinfo";
        }
        return "mcardmgr/pc/mcardtype/info/baseinfo";
    }

    @RequestMapping(value={"/{typeId}/manage"})
    public String manageMCardType(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="typeId") String typeId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("typeId", typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/info/manage";
        }
        return "mcardmgr/pc/mcardtype/info/manage";
    }

    @RequestMapping(value={"/{typeId}/details"})
    public String getMCardTypeDetail(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="typeId") String typeId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("typeId", typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/info/detail";
        }
        return "mcardmgr/pc/mcardtype/info/detail";
    }

    @RequestMapping(value={"/{typeId}/childtypes"})
    public String getChildTypeListOfMCardType(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="typeId") String typeId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("typeId", typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/info/childtype/list";
        }
        return "mcardmgr/pc/mcardtype/info/childtype/list";
    }

    @RequestMapping(value={"/{typeId}/childtypes/manage"})
    public String getChildTypeManageOfMCardType(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="typeId") String typeId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("typeId", typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/info/childtype/manage";
        }
        return "mcardmgr/pc/mcardtype/info/childtype/manage";
    }

    @RequestMapping(value={"/{typeId}/cmfrees"})
    public String queryCmfreeOfMCardType(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="typeId") String typeId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("typeId", typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/info/cmfree/list";
        }
        return "mcardmgr/pc/mcardtype/info/cmfree/list";
    }

    @RequestMapping(value={"/{typeId}/cmfrees/manage"})
    public String queryCmfreeManageOfMCardType(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="typeId") String typeId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("typeId", typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/info/cmfree/manage";
        }
        return "mcardmgr/pc/mcardtype/info/cmfree/manage";
    }

    @RequestMapping(value={"/{typeId}/mccatalogs"})
    public String queryMccatalogOfMCardType(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="typeId") String typeId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("typeId", typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/info/mccatalog/list";
        }
        return "mcardmgr/pc/mcardtype/info/mccatalog/list";
    }

    @RequestMapping(value={"/{typeId}/mccatalogs/manage"})
    public String queryMccatalogManageOfMCardType(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="typeId") String typeId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("typeId", typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/info/mccatalog/manage";
        }
        return "mcardmgr/pc/mcardtype/info/mccatalog/manage";
    }

    @RequestMapping(value={"/childtypes/{childtypeId}"})
    public String getMCardChildType(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="childtypeId") String childtypeId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("childtypeId", childtypeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/info/childtype/baseInfo";
        }
        return "mcardmgr/pc/mcardtype/info/childtype/baseInfo";
    }

    @RequestMapping(value={"/cmfrees/{cmfreeId}"})
    public String getMCardCmfree(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="cmfreeId") String cmfreeId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("cmfreeId", cmfreeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/info/cmfree/baseInfo";
        }
        return "mcardmgr/pc/mcardtype/info/cmfree/baseInfo";
    }

    @RequestMapping(value={"/mccatalogs/{mccatalogId}"})
    public String getMCardMccatalog(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="mccatalogId") String mccatalogId) {
        String token = E2EAppWebContext.getToken((HttpServletRequest)request);
        model.put("mccatalogId", mccatalogId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardtype/info/mccatalog/baseInfo";
        }
        return "mcardmgr/pc/mcardtype/info/mccatalog/baseInfo";
    }
}

