/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller;

import com.dayouzc.e2eapp.mcard.dto.McardRecordDTO;
import com.dayouzc.e2eapp.mcard.sdk.McardRecordSDK;
import com.dayouzc.e2eplatform.core.context.E2EAppWebContext;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import com.dayouzc.e2eplatform.core.dto.equip.ConnectionInfoDTO;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/userecords"})
public class MCardRecordController {
    private static final Logger logger = LoggerFactory.getLogger(MCardRecordController.class);

    @RequestMapping(value={"/sp/mine/userecords"})
    public String queryMCardRecordOfMineSpCustomer(Map<String, Object> model, HttpServletRequest request, @RequestParam(value="recordType", required=false) String recordType) {
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        model.put("boId", "mine");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/list_sp";
        }
        return "mcardmgr/pc/cardrecord/list/list_sp";
    }

    @RequestMapping(value={"/sp/{boId}/userecords"})
    public String queryMCardRecordOfSpCustomer(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="boId") String boId, @RequestParam(value="token", required=false) String token) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        model.put("boId", boId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/list_sp";
        }
        return "mcardmgr/pc/cardrecord/list/list_sp";
    }

    @RequestMapping(value={"/sp/{boId}/userecords/manage"})
    public String queryMCardRecordManageOfSpCustomer(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="boId") String boId, @RequestParam(value="token", required=false) String token) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        model.put("boId", boId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/manage_sp";
        }
        return "mcardmgr/pc/cardrecord/list/manage_sp";
    }

    @RequestMapping(value={"/cardtype/{typeId}/userecords"})
    public String queryMCardRecordOfCardType(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="typeId") String typeId, @RequestParam(value="token", required=false) String token) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        model.put("typeId", typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/list_cardType";
        }
        return "mcardmgr/pc/cardrecord/list/list_cardType";
    }

    @RequestMapping(value={"/cardtype/{typeId}/userecords/manage"})
    public String queryMCardRecordManageOfCardType(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="typeId") String typeId, @RequestParam(value="token", required=false) String token) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        model.put("typeId", typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/manage_cardType";
        }
        return "mcardmgr/pc/cardrecord/list/manage_cardType";
    }

    @RequestMapping(value={"/card/{cardNum}/userecords"})
    public String queryMCardRecordOfCard(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="cardNum") String cardNum, @RequestParam(value="token", required=false) String token) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        model.put("cardNum", cardNum);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/list_card";
        }
        return "mcardmgr/pc/cardrecord/list/list_card";
    }

    @RequestMapping(value={"/card/{cardNum}/userecords/manage"})
    public String queryMCardRecordManageOfCard(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="cardNum") String cardNum, @RequestParam(value="token", required=false) String token) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        model.put("cardNum", cardNum);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/manage_card";
        }
        return "mcardmgr/pc/cardrecord/list/manage_card";
    }

    @RequestMapping(value={"/mc/mine/userecords"})
    public String queryMCardRecordOfMineMc(Map<String, Object> model, HttpServletRequest request, @RequestParam(value="recordType", required=false) String recordType) {
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        model.put("mcId", "mine");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/list_mc";
        }
        return "mcardmgr/pc/cardrecord/list/list_mc";
    }

    @RequestMapping(value={"/mc/{mcId}/userecords"})
    public String queryMCardRecordOfMc(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="mcId") String mcId, @RequestParam(value="token", required=false) String token) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        model.put("mcId", mcId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/list_mc";
        }
        return "mcardmgr/pc/cardrecord/list/list_mc";
    }

    @RequestMapping(value={"/mc/{mcId}/userecords/manage"})
    public String queryMCardRecordManageOfMc(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="mcId") String mcId, @RequestParam(value="token", required=false) String token) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        model.put("mcId", mcId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/manage_mc";
        }
        return "mcardmgr/pc/cardrecord/list/manage_mc";
    }

    @RequestMapping(value={"/bo/mine/userecords"})
    public String queryMCardRecordOfMineBoCustomer(Map<String, Object> model, HttpServletRequest request, @RequestParam(value="recordType", required=false) String recordType) {
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        model.put("boId", "mine");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/list_bo";
        }
        return "mcardmgr/pc/cardrecord/list/list_bo";
    }

    @RequestMapping(value={"/bo/{boId}/userecords"})
    public String queryMCardRecordOfBoCustomer(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="boId") String boId, @RequestParam(value="token", required=false) String token) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        model.put("boId", boId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/list_bo";
        }
        return "mcardmgr/pc/cardrecord/list/list_bo";
    }

    @RequestMapping(value={"/bo/{boId}/userecords/manage"})
    public String queryMCardRecordManageOfBoCustomer(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="boId") String boId, @RequestParam(value="token", required=false) String token) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        model.put("boId", boId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/manage_bo";
        }
        return "mcardmgr/pc/cardrecord/list/manage_bo";
    }

    @RequestMapping(value={""})
    public String queryMCardRecord(Map<String, Object> model, HttpSession session, HttpServletRequest request, @RequestParam(value="token", required=false) String token) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        model.put("organId", "mine");
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/list_organ";
        }
        return "mcardmgr/pc/cardrecord/list/list_organ";
    }

    @RequestMapping(value={"/organ/{organId}/userecords"})
    public String queryMCardRecordOfOrgan(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="organId") String organId, @RequestParam(value="token", required=false) String token) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        model.put("organId", organId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/list_organ";
        }
        return "mcardmgr/pc/cardrecord/list/list_organ";
    }

    @RequestMapping(value={"/organ/{organId}/userecords/manage"})
    public String queryMCardRecordManageOfOrgan(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="organId") String organId, @RequestParam(value="token", required=false) String token) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        model.put("organId", organId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/list/manage_organ";
        }
        return "mcardmgr/pc/cardrecord/list/manage_organ";
    }

    @RequestMapping(value={"/{recordId}"})
    public String getMCardRecord(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="recordId") String recordId, @RequestParam(value="token", required=false) String token) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        PageRequest pageable = new PageRequest(0, 10);
        ResponseData responseData = McardRecordSDK.getInstance().getMCardRecord(recordId, token);
        if (responseData == null) {
            String msg = "[responseData] is null";
            model.put("msg", msg);
            return "common/errorPage";
        }
        if (!StringUtils.equals((CharSequence)responseData.getStatus(), (CharSequence)"10000")) {
            String msg = responseData.getMsg();
            model.put("msg", msg);
            return "common/errorPage";
        }
        McardRecordDTO mcardRecord = (McardRecordDTO)responseData.getResult();
        model.put("mcardRecord", mcardRecord);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/info/detail";
        }
        return "mcardmgr/pc/cardrecord/info/detail";
    }

    @RequestMapping(value={"/sp/reserve"})
    public String reserveOfSp(Map<String, Object> model, HttpSession session, HttpServletRequest request) {
        String token = (String)session.getAttribute("token");
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo((HttpServletRequest)request);
        model.put("customerId", tokenInfo.getCustomerId());
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/action/reserve_sp";
        }
        return "mcardmgr/pc/cardrecord/action/reserve_sp";
    }

    @RequestMapping(value={"/sp/use/makeup"})
    public String makeupCardRecordOfSp(Map<String, Object> model, HttpSession session, HttpServletRequest request) {
        String token = (String)session.getAttribute("token");
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo((HttpServletRequest)request);
        model.put("customerId", tokenInfo.getCustomerId());
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/action/useMakeup_sp";
        }
        return "mcardmgr/pc/cardrecord/action/useMakeup_sp";
    }

    @RequestMapping(value={"/bo/reserve"})
    public String reserveOfBo(Map<String, Object> model, HttpSession session, HttpServletRequest request) {
        String token = (String)session.getAttribute("token");
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo((HttpServletRequest)request);
        model.put("customerId", tokenInfo.getCustomerId());
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/action/reserve_bo";
        }
        return "mcardmgr/pc/cardrecord/action/reserve_bo";
    }

    @RequestMapping(value={"/bo/use/makeup"})
    public String makeupCardRecordOfBo(Map<String, Object> model, HttpSession session, HttpServletRequest request) {
        String token = (String)session.getAttribute("token");
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo((HttpServletRequest)request);
        model.put("customerId", tokenInfo.getCustomerId());
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/action/useMakeup_bo";
        }
        return "mcardmgr/pc/cardrecord/action/useMakeup_bo";
    }

    @RequestMapping(value={"/mc/reserve"})
    public String reserveOfMc(Map<String, Object> model, HttpSession session, HttpServletRequest request) {
        String token = (String)session.getAttribute("token");
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo((HttpServletRequest)request);
        model.put("customerId", tokenInfo.getCustomerId());
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/action/reserve_mc";
        }
        return "mcardmgr/pc/cardrecord/action/reserve_mc";
    }

    @RequestMapping(value={"/mc/use/makeup"})
    public String makeupCardRecordOfMc(Map<String, Object> model, HttpSession session, HttpServletRequest request) {
        String token = (String)session.getAttribute("token");
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo((HttpServletRequest)request);
        model.put("customerId", tokenInfo.getCustomerId());
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/cardrecord/action/useMakeup_mc";
        }
        return "mcardmgr/pc/cardrecord/action/useMakeup_mc";
    }
}

