/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller;

import com.dayouzc.e2eapp.lforder.dto.OrderInfoDTO;
import com.dayouzc.e2eapp.lforder.dto.RefundInfoDTO;
import com.dayouzc.e2eapp.lforder.sdk.OrderInfoSDK;
import com.dayouzc.e2eapp.mcard.dto.McardDeliverDetailDTO;
import com.dayouzc.e2eapp.mcard.dto.McardOrderDetailDTO;
import com.dayouzc.e2eapp.mcard.mcardmgr.web.dto.OrderInfoWrapperDTO;
import com.dayouzc.e2eapp.mcard.sdk.McardInfoSDK;
import com.dayouzc.e2eapp.mcard.sdk.McardOrderSDK;
import com.dayouzc.e2eplatform.core.context.E2EAppWebContext;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/mcardorders"})
public class MCardOrderController {
    private static final Logger logger = LoggerFactory.getLogger(MCardOrderController.class);

    @RequestMapping(value={"/{orderId}/detail"})
    public String getMCardOrderDetailList(Map<String, Object> model, HttpSession session, @PathVariable(value="orderId") String orderId, @RequestParam(value="token", required=false) String token) {
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        model.put("orderId", orderId);
        return "mcardmgr/pc/mcardorder/info/details";
    }

    @RequestMapping(value={"/{orderId}/delivers"})
    public String getMCardOrderDeliverDetailList(Map<String, Object> model, HttpSession session, @PathVariable(value="orderId") String orderId) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardOrderSDK.getInstance().getMCardOrderDeliverDetailList(orderId, token);
        model.put("mcardOrderDetail", responseData.getResult());
        return "mcardmgr/pc/mcardorder/info/delivers";
    }

    @RequestMapping(value={"/{orderId}/manage"})
    public String manageMCardOrderInfo(Map<String, Object> model, HttpSession session, @PathVariable(value="orderId") String orderId, @RequestParam(value="token", required=false) String token) {
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        model.put("orderId", orderId);
        return "mcardmgr/pc/mcardorder/info/manage";
    }

    @RequestMapping(value={"/sale"})
    public String sale(HttpServletRequest request) {
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardorder/action/sale";
        }
        return "mcardmgr/pc/mcardorder/action/sale";
    }

    @RequestMapping(value={"/saleB2B"})
    public String saleB2B(HttpServletRequest request) {
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardorder/action/sale_b2b";
        }
        return "mcardmgr/pc/mcardorder/action/sale_b2b";
    }

    @RequestMapping(value={"/upgrade"})
    public String upgrade(Map<String, Object> model, HttpSession session, @RequestParam(value="token", required=false) String token) {
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        return "mcardmgr/pc/mcardorder/action/upgrade";
    }

    @RequestMapping(value={"/upgrade/submit"})
    public String upgradeSubmit(Map<String, Object> model, HttpSession session, OrderInfoDTO orderInfoDTO) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardOrderSDK.getInstance().upgrade(orderInfoDTO, token);
        model.put("orderInfo", responseData.getResult());
        return "redirect:";
    }

    @RequestMapping(value={"/renewal"})
    public String renewal(Map<String, Object> model, HttpSession session, @RequestParam(value="token", required=false) String token) {
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        return "mcardmgr/pc/mcardorder/action/renewal";
    }

    @RequestMapping(value={"/renewal/submit"})
    public String renewalSubmit(Map<String, Object> model, HttpSession session, OrderInfoDTO orderInfoDTO) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardOrderSDK.getInstance().renewal(orderInfoDTO, token);
        model.put("orderInfo", responseData.getResult());
        return "redirect:";
    }

    @RequestMapping(value={"/gift"})
    public String giftCard(Map<String, Object> model, HttpSession session, @RequestParam(value="token", required=false) String token) {
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        return "mcardmgr/pc/mcardorder/action/gift";
    }

    @RequestMapping(value={"/gift/submit"})
    public String giftCardSubmit(Map<String, Object> model, HttpSession session, OrderInfoDTO orderInfoDTO) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardOrderSDK.getInstance().giftCard(orderInfoDTO, token);
        return "redirect:";
    }

    @RequestMapping(value={"/bookingB2B"})
    public String bookingB2B(Map<String, Object> model, HttpSession session, @RequestParam(value="typeId") String tyepId) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardInfoSDK.getInstance().getMCardinfo(tyepId, token);
        model.put("mcardInfo", responseData.getResult());
        return "mcardmgr/pc/mcardorder/action/booking_b2b";
    }

    @RequestMapping(value={"/bookingB2B/submit"})
    public String bookingB2BSubmit(Map<String, Object> model, HttpSession session, OrderInfoDTO orderInfoDTO) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardOrderSDK.getInstance().bookingB2B(orderInfoDTO, token);
        model.put("orderInfo", responseData.getResult());
        return "redirect:";
    }

    @RequestMapping(value={"/verify"})
    public String verify(Map<String, Object> model, HttpSession session, @RequestParam(value="orderId") String orderId) {
        String token = (String)session.getAttribute("token");
        OrderInfoDTO orderInfoDTO = new OrderInfoDTO();
        orderInfoDTO.setOrderId(orderId);
        ResponseData responseData = McardOrderSDK.getInstance().verify(orderInfoDTO, token);
        if (responseData == null) {
            String msg = "[responseData] is null";
            model.put("msg", msg);
            return "common/errorPage";
        }
        if (!StringUtils.equals((CharSequence)responseData.getStatus(), (CharSequence)"10000")) {
            String msg = responseData.getMsg();
            model.put("msg", msg);
            return "common/errorPage";
        }
        return "redirect:/mcardorders/" + orderId + "/manage";
    }

    @RequestMapping(value={"/cancel"})
    public String cancel(Map<String, Object> model, HttpSession session, @RequestParam(value="orderId") String orderId) {
        String token = (String)session.getAttribute("token");
        OrderInfoDTO orderInfo = new OrderInfoDTO();
        orderInfo.setOrderId(orderId);
        ResponseData responseData = McardOrderSDK.getInstance().cancel(orderInfo, token);
        if (responseData == null) {
            String msg = "[responseData] is null";
            model.put("msg", msg);
            return "common/errorPage";
        }
        if (!StringUtils.equals((CharSequence)responseData.getStatus(), (CharSequence)"10000")) {
            String msg = responseData.getMsg();
            model.put("msg", msg);
            return "common/errorPage";
        }
        return "redirect:/eborders/" + orderId + "/manage";
    }

    @RequestMapping(value={"/deliver"})
    public String deliver(Map<String, Object> model, HttpSession session, @RequestParam(value="orderId") String orderId) {
        String token = (String)session.getAttribute("token");
        return "mcardmgr/pc/mcardorder/action/deliver";
    }

    @RequestMapping(value={"/deliver/submit"})
    public String deliverSubmit(Map<String, Object> model, HttpSession session, OrderInfoWrapperDTO orderInfoWrapper) {
        String msg;
        ResponseData responseData;
        String token = (String)session.getAttribute("token");
        OrderInfoDTO orderInfoDTO = new OrderInfoDTO();
        BeanUtils.copyProperties((Object)orderInfoWrapper, (Object)orderInfoDTO);
        List orderDetailList = orderInfoWrapper.getOrderDetailList();
        if (orderDetailList != null && !orderDetailList.isEmpty()) {
            ArrayList<McardDeliverDetailDTO> deliverDetailList = new ArrayList<McardDeliverDetailDTO>();
            for (McardOrderDetailDTO orderDetail : orderDetailList) {
                McardDeliverDetailDTO deliverDetail = new McardDeliverDetailDTO();
                BeanUtils.copyProperties((Object)orderDetail, (Object)deliverDetail);
                deliverDetail.setDeliverQuantity(new Integer(orderDetail.getBuyNumber()));
                deliverDetailList.add(deliverDetail);
            }
            orderInfoDTO.setOrderDeliverDetails(deliverDetailList);
        }
        if ((responseData = McardOrderSDK.getInstance().deliver(orderInfoDTO, token)) == null) {
            msg = "[responseData] is null";
            model.put("msg", msg);
            return "common/errorPage";
        }
        if (!StringUtils.equals((CharSequence)responseData.getStatus(), (CharSequence)"10000")) {
            msg = responseData.getMsg();
            model.put("msg", msg);
            return "common/errorPage";
        }
        return "redirect:/mcardorders/" + orderInfoWrapper.getOrderId() + "/manage";
    }

    @RequestMapping(value={"/receipt"})
    public String receipt(Map<String, Object> model, HttpSession session, @RequestParam(value="orderId") String orderId) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = OrderInfoSDK.getInstance().getOrderInfo(orderId, token);
        model.put("orderInfo", responseData.getResult());
        return "mcardmgr/pc/mcardorder/action/receipt";
    }

    @RequestMapping(value={"/receipt/submit"})
    public String receiptSubmit(Map<String, Object> model, HttpSession session, OrderInfoDTO orderInfoDTO) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardOrderSDK.getInstance().receipt(orderInfoDTO, token);
        OrderInfoDTO orderInfo = (OrderInfoDTO)responseData.getResult();
        model.put("orderInfo", orderInfo);
        return "redirect:redirect:/eborders/" + orderInfo.getOrderId() + "/manage";
    }

    @RequestMapping(value={"/pickup"})
    public String pickup(Map<String, Object> model, HttpSession session, @RequestParam(value="orderId") String orderId) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = OrderInfoSDK.getInstance().getOrderInfo(orderId, token);
        model.put("orderInfo", responseData.getResult());
        return "mcardmgr/pc/mcardorder/action/pickup";
    }

    @RequestMapping(value={"/pickup/submit"})
    public String pickupSubmit(Map<String, Object> model, HttpSession session, OrderInfoDTO orderInfoDTO) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardOrderSDK.getInstance().pickup(orderInfoDTO, token);
        model.put("orderInfo", responseData.getResult());
        return "redirect:";
    }

    @RequestMapping(value={"/refunds/{refundId}/details"})
    public String getMCardOrderRefundDetailList(Map<String, Object> model, HttpSession session, @PathVariable(value="refundId") String refundId) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardOrderSDK.getInstance().getMCardOrderRefundDetailList(refundId, token);
        model.put("mcardInfoList", responseData.getResult());
        return "mcardmgr/pc/mcardorder/refund/details";
    }

    @RequestMapping(value={"/refunds/{refundId}/manage"})
    public String manageMCardOrderRefund(Map<String, Object> model, HttpSession session, @PathVariable(value="refundId") String refundId) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardOrderSDK.getInstance().getMCardOrderRefundDetailList(refundId, token);
        model.put("mcardInfoList", responseData.getResult());
        return "mcardmgr/pc/mcardorder/refund/details";
    }

    @RequestMapping(value={"/refund/apply"})
    public String refundApply(Map<String, Object> model, HttpSession session) {
        String token = (String)session.getAttribute("token");
        return "mcardmgr/pc/mcardorder/refund/apply";
    }

    @RequestMapping(value={"/refund/apply/submit"})
    public String refundApplySubmit(Map<String, Object> model, HttpSession session, RefundInfoDTO refundInfoDTO) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardOrderSDK.getInstance().refundApply(refundInfoDTO, token);
        model.put("refundInfo", responseData.getResult());
        return "redirect:";
    }

    @RequestMapping(value={"/refund/verify"})
    public String refundVerify(Map<String, Object> model, HttpSession session) {
        return "mcardmgr/pc/mcardorder/refund/verify";
    }

    @RequestMapping(value={"/refund/verify/submit"})
    public String refundVerifySubmit(Map<String, Object> model, HttpSession session, RefundInfoDTO refundInfoDTO) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardOrderSDK.getInstance().refundVerify(refundInfoDTO, token);
        model.put("refundInfo", responseData.getResult());
        return "redirect:";
    }
}

