/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller;

import com.dayouzc.e2eplatform.core.context.E2EAppWebContext;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/mcards"})
public class MCardInfoQueryController {
    private static final Logger logger = LoggerFactory.getLogger(MCardInfoQueryController.class);

    @RequestMapping(value={"/operator/mine/mcards"})
    public String queryMCardInfoOfMineAsOperator(Map<String, Object> model, HttpServletRequest request) {
        model.put("title", "\u6211\u8fd0\u8425\u7ba1\u7406\u4e0b\u7684\u5361");
        model.put("url", "/operator/mine/mcards");
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_op_mine";
    }

    @RequestMapping(value={"/operator/{operatorBoId}/mcards"})
    public String queryMCardInfoOfOperator(Map<String, Object> model, @PathVariable(value="operatorBoId") String operatorBoId, HttpServletRequest request) {
        model.put("title", "\u6307\u5b9a\u8fd0\u8425\u5546\u8fd0\u8425\u7ba1\u7406\u4e0b\u7684\u5361");
        model.put("url", "/operator/" + operatorBoId + "/mcards");
        model.put("operatorBoId", operatorBoId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_op";
    }

    @RequestMapping(value={"/sp/mine/mcards"})
    public String queryMCardInfoOfMineAsSupplier(Map<String, Object> model, HttpServletRequest request) {
        model.put("title", "\u6211\u53d1\u884c\u7684\u5361");
        model.put("url", "/sp/mine/mcards");
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_sp_mine";
    }

    @RequestMapping(value={"/sp/{supplierBoId}/mcards"})
    public String queryMCardInfoOfSupplier(Map<String, Object> model, @PathVariable(value="supplierBoId") String supplierBoId, HttpServletRequest request) {
        model.put("title", "\u6307\u5b9a\u5ba2\u6237\u5b9e\u4f53\u53d1\u884c\u7684\u5361");
        model.put("url", "/sp/" + supplierBoId + "/mcards");
        model.put("supplierBoId", supplierBoId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_sp";
    }

    @RequestMapping(value={"/sp/mine/mcards/manage"})
    public String manageOfMineCard(Map<String, Object> model, HttpServletRequest request) {
        model.put("title", "\u6211\u53d1\u884c\u7684\u5361\u7684\u7ba1\u7406\u9875\u9762");
        model.put("url", "/sp/mine/mcards");
        model.put("next", "manage");
        model.put("role", "1");
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/manage_sp_mine";
    }

    @RequestMapping(value={"/ag/mine/mcards"})
    public String queryMCardInfoOfMineAsAgency(Map<String, Object> model, HttpServletRequest request) {
        model.put("title", "\u6211\u4ee3\u7406\u7684\u5361");
        model.put("url", "/ag/mine/mcards");
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_ag_mine";
    }

    @RequestMapping(value={"/ag/{agencyBoId}/mcards"})
    public String queryMCardInfoOfAgency(Map<String, Object> model, @PathVariable(value="agencyBoId") String agencyBoId, HttpServletRequest request) {
        model.put("title", "\u6307\u5b9a\u5ba2\u6237\u5b9e\u4f53\u4ee3\u7406\u7684\u5361");
        model.put("url", "/ag/" + agencyBoId + "/mcards");
        model.put("agencyBoId", agencyBoId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_ag";
    }

    @RequestMapping(value={"/ag/mine/mcards/manage"})
    public String manageOfMineAsAgency(Map<String, Object> model, HttpServletRequest request) {
        model.put("title", "\u6211\u4ee3\u7406\u7684\u5361\u552e\u540e\u7ba1\u7406");
        model.put("url", "/ag/mine/mcards");
        model.put("next", "manage");
        model.put("role", "2");
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/manage_ag_mine";
    }

    @RequestMapping(value={"/bo/mine/mcards/usable"})
    public String queryMCardInfoOfMineBoUsable(Map<String, Object> model, HttpServletRequest request) {
        model.put("title", "\u6211\u9002\u7528\u7684\u5361");
        model.put("url", "/bo/mine/mcards/usable");
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_bo_usable_mine";
    }

    @RequestMapping(value={"/bo/{boId}/mcards/usable"})
    public String queryMCardInfoOfBoUsable(Map<String, Object> model, @PathVariable(value="boId") String boId, HttpServletRequest request) {
        model.put("title", "\u6307\u5b9a\u5ba2\u6237\u5b9e\u4f53\u9002\u7528\u7684\u5361");
        model.put("url", "/bo/" + boId + "/mcards/usable");
        model.put("boId", boId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_bo_usable";
    }

    @RequestMapping(value={""})
    public String queryMCardInfo(Map<String, Object> model, HttpServletRequest request) {
        model.put("title", "\u5f53\u524d\u7ec4\u7ec7\u7ecf\u8425\u8303\u56f4\uff08\u5e93\u5b58/\u9500\u552e\uff09\u5185\u7684\u5361");
        model.put("url", "/organ/mine/mcards");
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_organ_mine";
    }

    @RequestMapping(value={"/organ/{organId}/mcards"})
    public String queryMCardInfoOfOrgan(Map<String, Object> model, @PathVariable(value="organId") String organId, HttpServletRequest request) {
        model.put("title", "\u6839\u636e\u7f51\u70b9\uff08\u7ec4\u7ec7\u7ecf\u8425\u8303\u56f4\uff09\u8fdb\u884c\u67e5\u8be2");
        model.put("url", "/organ/" + organId + "/mcards");
        model.put("organId", organId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_organ";
    }

    @RequestMapping(value={"/organ/mine/mcards/manage"})
    public String manageMCardInfoOfOrgan(Map<String, Object> model, HttpServletRequest request) {
        model.put("title", "\u5f53\u524d\u7f51\u70b9\u7ecf\u8425\u8303\u56f4\uff08\u5e93\u5b58/\u9500\u552e\uff09\u7684\u5361\u7ba1\u7406");
        model.put("url", "/organ/mine/mcards");
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/manage_organ_mine";
    }

    @RequestMapping(value={"/mc/{mcId}/mcards"})
    public String queryMCardInfoOfMc(Map<String, Object> model, @PathVariable(value="mcId") String mcId, HttpServletRequest request) {
        model.put("title", "\u6307\u5b9a\u5546\u94fa\u53d1\u884c\u7684\u5361");
        model.put("url", "/mc/" + mcId + "/mcards");
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_mc";
    }

    @RequestMapping(value={"/mc/{mcId}/mcards/usable"})
    public String queryMCardInfoOfMcUsable(Map<String, Object> model, @PathVariable(value="mcId") String mcId, HttpServletRequest request) {
        model.put("title", "\u6307\u5b9a\u5546\u94fa\u9002\u7528\u7684\u5361");
        model.put("url", "/mc/" + mcId + "/mcards/usable");
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_mc_usable";
    }

    @RequestMapping(value={"/user/{accountId}/mcards"})
    public String getMCardInfoListOfUser(Map<String, Object> model, @PathVariable(value="accountId") String accountId, HttpServletRequest request) {
        model.put("title", "\u6307\u5b9a\u4e2a\u4eba\u7ed1\u5b9a\u7684\u5361\uff08\u4e70\u5bb6\uff09\u3002\u67e5\u8be2\u6307\u5b9a\u7528\u6237\u6240\u6709\u8d2d\u4e70\u7684\u5361");
        model.put("url", "/user/" + accountId + "/mcards");
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_user";
    }

    @RequestMapping(value={"/user/mine/mcards/sales"})
    public String queryMCardInfoOfMineSales(Map<String, Object> model, HttpServletRequest request) {
        model.put("title", "\u6211\u4e2a\u4eba\u9500\u552e\u7684\u5361\uff08\u5356\u5bb6\uff09");
        model.put("url", "/user/mine/mcard/sales");
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_user_mine_sale";
    }

    @RequestMapping(value={"/user/{accountId}/mcards/sales"})
    public String queryMCardInfoOfUserSales(Map<String, Object> model, @PathVariable(value="accountId") String accountId, HttpServletRequest request) {
        model.put("title", "\u6307\u5b9a\u4e2a\u4eba\u9500\u552e\u7684\u5361");
        model.put("url", "/user/" + accountId + "/mcards/sales");
        model.put("accountId", accountId);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_user_sale";
    }

    @RequestMapping(value={"/cardtype/{typeId}/mcards"})
    public String queryMCardsOfCardtype(Map<String, Object> model, @PathVariable(value="typeId") String typeId, HttpServletRequest request) {
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/list_card_type";
    }

    @RequestMapping(value={"/cardtype/{typeId}/mcards/manage"})
    public String queryMCardsOfCardtypeManage(Map<String, Object> model, @PathVariable(value="typeId") String typeId, HttpServletRequest request) {
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }
        return "mcardmgr/pc/mcardinfo/list/manage_card_type";
    }

    @RequestMapping(value={"/{cardNum}"})
    public String getMCardInfo(Map<String, Object> model, HttpSession session, @PathVariable(value="cardNum") String cardNum, HttpServletRequest request) {
        model.put("cardNum", cardNum);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/info/info";
        }
        return "mcardmgr/pc/mcardinfo/info/info";
    }

    @RequestMapping(value={"/{cardNum}/manage"})
    public String manageMCardInfo(Map<String, Object> model, HttpSession session, HttpServletRequest request, @PathVariable(value="cardNum") String cardNum) {
        model.put("cardNum", cardNum);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/info/manage";
        }
        return "mcardmgr/pc/mcardinfo/info/manage";
    }

    @RequestMapping(value={"/{cardNum}/detail"})
    public String getMCardInfoDetails(Map<String, Object> model, HttpSession session, @PathVariable(value="cardNum") String cardNum, HttpServletRequest request) {
        model.put("cardNum", cardNum);
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/info/detail";
        }
        return "mcardmgr/pc/mcardinfo/info/detail";
    }
}

