/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller;

import com.dayouzc.e2eapp.mcard.dto.McardInfoDTO;
import com.dayouzc.e2eapp.mcard.dto.McardOrderDetailDTO;
import com.dayouzc.e2eapp.mcard.sdk.McardInfoSDK;
import com.dayouzc.e2eplatform.core.context.E2EAppWebContext;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/mcards"})
public class MCardInfoActionController {
    private static final Logger logger = LoggerFactory.getLogger(MCardInfoActionController.class);

    @RequestMapping(value={"/bind"})
    public String bindCard(HttpServletRequest request, Map<String, Object> model, HttpSession session, @RequestParam(value="cardNum") String cardNum) {
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/action/bind";
        }
        return "mcardmgr/pc/mcardinfo/action/bind";
    }

    @RequestMapping(value={"/bind/submit"})
    public String bindCardSubmit(Map<String, Object> model, HttpSession session, McardInfoDTO mcardInfoDTO) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardInfoSDK.getInstance().bindCard(mcardInfoDTO, token);
        McardInfoDTO mcardInfo = (McardInfoDTO)responseData.getResult();
        model.put("responseData", mcardInfo);
        return "redirect:/mcards/sp/mine/mcards";
    }

    @RequestMapping(value={"/modify"})
    public String modifyBindInfo(HttpServletRequest request, Map<String, Object> model, HttpSession session, @RequestParam(value="cardNum") String cardNum) {
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/action/modify_bind";
        }
        return "mcardmgr/pc/mcardinfo/action/modify_bind";
    }

    @RequestMapping(value={"/modify/submit"})
    public String modifyBindInfoSubmit(Map<String, Object> model, HttpSession session, McardInfoDTO mcardInfoDTO) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardInfoSDK.getInstance().modifyBindInfo(mcardInfoDTO, token);
        return "redirect:/mcards/sp/mine/mcards";
    }

    @RequestMapping(value={"/unbind"})
    public String unbind(HttpServletRequest request, Map<String, Object> model, HttpSession session, @RequestParam(value="cardNum") String cardNum, @RequestParam(value="cardId") String cardId) {
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/action/unbind";
        }
        return "mcardmgr/pc/mcardinfo/action/unbind";
    }

    @RequestMapping(value={"/giftValidTime"})
    public String giftValidTime(Map<String, Object> model, HttpSession session, HttpServletRequest request, @RequestParam(value="cardNum") String cardNum) {
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/action/gift_valid_time";
        }
        return "mcardmgr/pc/mcardinfo/action/gift_valid_time";
    }

    @RequestMapping(value={"/giftValidTime/submit"})
    public String giftValidTimeSubmit(Map<String, Object> model, HttpSession session, McardInfoDTO mcardInfoDTO) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardInfoSDK.getInstance().giftValidTime(mcardInfoDTO, token);
        return "redirect:/mcards/sp/mine/mcards/manage";
    }

    @RequestMapping(value={"/renewal"})
    public String renewalCard(Map<String, Object> model, HttpSession session, HttpServletRequest request, @RequestParam(value="cardNum") String cardNum) {
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/action/renewal";
        }
        return "mcardmgr/pc/mcardinfo/action/renewal";
    }

    @RequestMapping(value={"/upgrade"})
    public String upgradeCard(Map<String, Object> model, HttpSession session, HttpServletRequest request, @RequestParam(value="cardNum") String cardNum) {
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/action/upgrade";
        }
        return "mcardmgr/pc/mcardinfo/action/upgrade";
    }

    @RequestMapping(value={"/freeze"})
    public String freezeCard(Map<String, Object> model, HttpSession session, HttpServletRequest request, @RequestParam(value="cardNum") String cardNum) {
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/action/freeze";
        }
        return "mcardmgr/pc/mcardinfo/action/freeze";
    }

    @RequestMapping(value={"/freeze/submit"})
    public String freezeCardSubmit(Map<String, Object> model, HttpSession session, McardInfoDTO mcardInfoDTO) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardInfoSDK.getInstance().frozenCard(mcardInfoDTO, token);
        McardInfoDTO mcardInfo = (McardInfoDTO)responseData.getResult();
        return "redirect:/mcards/" + mcardInfo.getCardNum();
    }

    @RequestMapping(value={"/change"})
    public String changeCard(Map<String, Object> model, HttpSession session, HttpServletRequest request) {
        String token = (String)session.getAttribute("token");
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/action/change";
        }
        return "mcardmgr/pc/mcardinfo/action/change";
    }

    @RequestMapping(value={"/change/submit"})
    public String changeCardSubmit(Map<String, Object> model, HttpSession session, McardInfoDTO mcardInfo) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardInfoSDK.getInstance().changeCard(mcardInfo, token);
        if (responseData == null) {
            String msg = "[responseData] is null";
            model.put("msg", msg);
            return "common/errorPage";
        }
        if (!StringUtils.equals((CharSequence)responseData.getStatus(), (CharSequence)"10000")) {
            String msg = responseData.getMsg();
            model.put("msg", msg);
            return "common/errorPage";
        }
        McardInfoDTO mcardInfoDto = (McardInfoDTO)responseData.getResult();
        return "redirect:";
    }

    @RequestMapping(value={"/giftCard"})
    public String giftCard(Map<String, Object> model, HttpSession session, HttpServletRequest request) {
        String token = (String)session.getAttribute("token");
        String screenOrientation = E2EAppWebContext.getContextParamValue((HttpServletRequest)request, (String)"screenOrientation");
        if (StringUtils.equals((CharSequence)screenOrientation, (CharSequence)"1")) {
            return "mcardmgr/app/mcardinfo/action/gift_card";
        }
        return "mcardmgr/pc/mcardinfo/action/gift_card";
    }

    @RequestMapping(value={"/giftCard/submit"})
    public String giftCardSubmit(Map<String, Object> model, @RequestParam(value="typeId") String typeId, @RequestParam(value="buyNumber") String buyNumber, @RequestParam(value="accepts") String accepts, HttpSession session) {
        String token = (String)session.getAttribute("token");
        McardOrderDetailDTO appData = new McardOrderDetailDTO();
        appData.setTypeId(typeId);
        appData.setBuyNumber(buyNumber);
        appData.setMemo(accepts);
        ResponseData responseData = McardInfoSDK.getInstance().giftCard(appData, token);
        model.put("result", responseData.getMsg());
        return "redirect:/mcards/giftCard";
    }
}

