/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller;

import com.dayouzc.e2eapp.mcard.dto.McardAllocateRecordDTO;
import com.dayouzc.e2eapp.mcard.sdk.McardAllocateSDK;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/allocates"})
public class MCardAllocateController {
    private static final Logger logger = LoggerFactory.getLogger(MCardAllocateController.class);

    @RequestMapping(value={"/bo/mine/allocates"})
    public String queryMCardAllocateRecordOfMineCustomer(Map<String, Object> model, HttpSession session, @RequestParam(value="token", required=false) String token) {
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            session.setAttribute("token", (Object)token);
        }
        token = (String)session.getAttribute("token");
        return "mcardmgr/pc/allocate/list/listOfMineBo";
    }

    @RequestMapping(value={"/bo/{boId}/allocates"})
    public String queryMCardAllocateRecordOfCustomer(Map<String, Object> model, HttpSession session, @PathVariable(value="boId") String boId) {
        String token = (String)session.getAttribute("token");
        model.put("boId", boId);
        return "mcardmgr/pc/allocate/list/listOfBo";
    }

    @RequestMapping(value={""})
    public String queryMCardAllocateRecord(Map<String, Object> model, HttpSession session, ModelMap map) {
        String token = (String)session.getAttribute("token");
        return "mcardmgr/pc/allocate/list/listOfMineOrgan";
    }

    @RequestMapping(value={"/organ/{organId}/allocates"})
    public String queryMCardAllocateRecordOfOrgan(Map<String, Object> model, HttpSession session, @PathVariable(value="organId") String organId) {
        String token = (String)session.getAttribute("token");
        model.put("organId", organId);
        return "mcardmgr/pc/allocate/list/listOfOrgan";
    }

    @RequestMapping(value={"/{recordId}"})
    public String getMCardAllocateRecord(Map<String, Object> model, HttpSession session, @PathVariable(value="recordId") String recordId) {
        String token = (String)session.getAttribute("token");
        model.put("recordId", recordId);
        return "mcardmgr/pc/allocate/info/detail";
    }

    @RequestMapping(value={"/allocate"})
    public String allocate(Map<String, Object> model, HttpSession session, ModelMap map) {
        String token = (String)session.getAttribute("token");
        return "mcardmgr/pc/allocate/action/allocate";
    }

    @RequestMapping(value={"/allocate/submit"})
    public String allocateSubmit(Map<String, Object> model, HttpSession session, McardAllocateRecordDTO mcardAllocateRecordDTO) {
        String token = (String)session.getAttribute("token");
        ResponseData responseData = McardAllocateSDK.getInstance().allocateApply(mcardAllocateRecordDTO, token);
        if (responseData == null) {
            String msg = "[responseData] is null";
            model.put("msg", msg);
            return "common/errorPage";
        }
        if (!StringUtils.equals((CharSequence)responseData.getStatus(), (CharSequence)"10000")) {
            String msg = responseData.getMsg();
            model.put("msg", msg);
            return "common/errorPage";
        }
        return "redirect:/allocates/bo/mine/allocates";
    }
}

