package com.dayouzc.e2eapp.mcard.mcardmgr.web.init;

import com.dayouzc.e2eapp.lforder.sdk.OrderInfoSDK;
import com.dayouzc.e2eapp.mcard.mcardmgr.web.config.E2ESvrConfig;
import com.dayouzc.e2eapp.mcard.sdk.*;
import com.dayouzc.e2eplatform.registerbind.sdk.TokenSDK;
import com.dayouzc.e2eplatform.registerbind.sdk.context.ContextSDK;
import com.dayouzc.e2eplatform.registerbind.sdk.equip.DeviceInfoSDK;
import com.dayouzc.e2eplatform.registerbind.sdk.equip.MyIServerSDK;
import com.dayouzc.e2eplatform.registerbind.sdk.people.AccountSDK;
import com.dayouzc.e2eplatform.registerbind.sdk.people.CustomerSDK;
import com.dayouzc.e2eplatform.registerbind.sdk.people.OrganSDK;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

/**
 * SDK初始化
 * <p>
 * Created by tyutNo4 on 2018/1/19.
 */
@Component
public class SDKinit implements CommandLineRunner {

    @Autowired
    private E2ESvrConfig e2ESvrConfig;

    /**
     *  初始化SDK
     * @param args
     * @throws Exception
     */
    @Override
    public void run(String... args) throws Exception {
        //令牌相关sdk
        ContextSDK.getInstance(e2ESvrConfig.getRbsvrIp(), e2ESvrConfig.getRbsvrPort(), e2ESvrConfig.getRbsvrContext());
        TokenSDK.getInstance(e2ESvrConfig.getRbsvrIp(), e2ESvrConfig.getRbsvrPort(), e2ESvrConfig.getRbsvrContext());

        //注册绑定
        AccountSDK.getInstance(e2ESvrConfig.getRbsvrIp(), e2ESvrConfig.getRbsvrPort(), e2ESvrConfig.getRbsvrContext());
        OrganSDK.getInstance(e2ESvrConfig.getRbsvrIp(), e2ESvrConfig.getRbsvrPort(), e2ESvrConfig.getRbsvrContext());
        CustomerSDK.getInstance(e2ESvrConfig.getRbsvrIp(), e2ESvrConfig.getRbsvrPort(), e2ESvrConfig.getRbsvrContext());
        MyIServerSDK.getInstance(e2ESvrConfig.getRbsvrIp(), e2ESvrConfig.getRbsvrPort(), e2ESvrConfig.getRbsvrContext());
        DeviceInfoSDK.getInstance(e2ESvrConfig.getRbsvrIp(), e2ESvrConfig.getRbsvrPort(), e2ESvrConfig.getRbsvrContext());

        //统一订单
        OrderInfoSDK.getInstance(e2ESvrConfig.getOrdersvrIp(), e2ESvrConfig.getOrdersvrPort(), e2ESvrConfig.getOrdersvrContext());

        //电商

        //会员卡
        McardInfoSDK.getInstance(e2ESvrConfig.getMcardsvrIp(), e2ESvrConfig.getMcardsvrPort(), e2ESvrConfig.getMcardsvrContext());
        McardOrderSDK.getInstance(e2ESvrConfig.getMcardsvrIp(), e2ESvrConfig.getMcardsvrPort(), e2ESvrConfig.getMcardsvrContext());
        McardTypeSDK.getInstance(e2ESvrConfig.getMcardsvrIp(), e2ESvrConfig.getMcardsvrPort(), e2ESvrConfig.getMcardsvrContext());
        McardAllocateSDK.getInstance(e2ESvrConfig.getMcardsvrIp(), e2ESvrConfig.getMcardsvrPort(), e2ESvrConfig.getMcardsvrContext());
        McardProduceSDK.getInstance(e2ESvrConfig.getMcardsvrIp(), e2ESvrConfig.getMcardsvrPort(), e2ESvrConfig.getMcardsvrContext());
        McardRecordSDK.getInstance(e2ESvrConfig.getMcardsvrIp(), e2ESvrConfig.getMcardsvrPort(), e2ESvrConfig.getMcardsvrContext());
    }
}
