package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller.common;

import com.dayouzc.e2eapp.mcard.mcardmgr.web.api.RegisterbindService;
import com.dayouzc.e2eapp.mcard.mcardmgr.web.controller.common.dto.TreeNodeDTODataList;
import com.dayouzc.e2eplatform.core.dto.people.OrganDTO;
import com.dayouzc.e2eplatform.core.util.JsonUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 关联人
 * @author fish
 */
@Controller
@RequestMapping("/stakeholders")
public class StakeholderController {

    private static final Logger logger  = LoggerFactory.getLogger(StakeholderController.class);

    @Autowired
    private RegisterbindService registerbindService;

    @RequestMapping("/addStakeholders")
    public String stakeholders(Map<String, Object> model,
                               HttpSession session) {

        String token = (String) session.getAttribute("token");
        //TODO 获取组织树
        List<OrganDTO> organList = new ArrayList<>();
        //调用/myiserver/organtree，返回List<OrganDTO>
        organList = registerbindService.getOrganTree(token);
        List<TreeNodeDTODataList> treeNodeList = new ArrayList<>();
        //判断非空，并封装成Ztree格式转json
        if(organList != null && organList.size()>0){
            for (OrganDTO dto:organList){
                TreeNodeDTODataList treeNode = new TreeNodeDTODataList();
                treeNode.setId(dto.getOrganId());
                if(StringUtils.isEmpty(dto.getPrdOrganId())){
                    treeNode.setpId("0");
                }else {
                    treeNode.setpId(dto.getPrdOrganId());
                }
                treeNode.setName(dto.getOrganName());
                treeNode.setOpen(true);
                treeNodeList.add(treeNode);
            }
        }
        String jsonStr = JsonUtil.toJson(treeNodeList);
        model.put("jsonStr", jsonStr);

        return "common/stakeholders";
    }

}
