package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller;

import com.dayouzc.e2eplatform.core.context.E2EAppWebContext;
import com.dayouzc.e2eplatform.core.dto.equip.ConnectionInfoDTO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.Map;

/**
 * Created by Mr.Liu on 2017/8/8.
 *
 * “/mcardtypes”是卡类型相关资源根目录，其中，查询类的主要包括：
 * 注：以下rest路径中id如果=mine，表示当前token中的实体/组织/个人等。
 *
 * 1.根据运营商（客户实体运营管理关系）查询
 * /operator/mine/mcardtypes	        我运营管理的卡类型页面。                * 查询当前用户所属客户实体作为运营商下管理的卡类型列表
 * /operator/{operatorBoId}/mcardtypes	指定运营商运营管理下的卡类型页面。      * 查询运营商客户实体下管理的卡类型列表
 *
 * 2.根据商户（客户实体业务关系）查询
 * /sp/mine/mcardtypes			        我发行的卡类型页面。                    * 查询当前用户所属客户实体发行的卡类型列表
 * /sp/{supplierBoId}/mcardtypes		指定客户实体发行的卡类型页面。
 * /ag/mine/mcardtypes			        我分销/代理的卡类型页面。               * 查询当前用户所属客户实体作为分销商分销的卡类型列表
 * /ag/{agencyBoId}/mcardtypes			指定客户实体分销/代理的卡类型页面。
 * /sa/mine/mcardtypes                  我总运营商的卡类型
 *
 * 3.根据网点（组织经营范围）进行查询
 * /		                            当前组织经营范围内的卡类型页面。        * 默认显示当前组织经营范围内的卡类型列表
 * /organ/{organId}/mcardtypes		    指定组织经营范围内的卡类型页面。
 *
 * 4.根据商铺merchant进行查询
 * /mc/{mcId}/mcardtypes			    指定商铺下发行的卡类型页面。
 * /mc/{mcId}/mcardtypes/manage	        指定商铺下发行的卡类型管理页面。
 *
 * 5.根据适用商铺查询
 * /bo/{boId}/mcardtypes/usable         指定客户实体的商铺适用的卡类型页面。    * 查询指定客户实体下的所有商铺适用的卡类型列表。
 * /mc/{mcId}/mcardtypes/usable	        指定商铺下适用的卡类型页面。
 *
 * 6.获取详情
 * /{typeId}						    卡类型的基本信息页面。
 * /{typeId}/manage				        卡类型管理页面。                            * 在这个页面，可以修改、上架/下架、管理子卡类型、管理年卡商铺目录、管理优惠商铺目录等
 * /{typeId}/details				    卡类型的详细信息页面。                      * 显示指定卡类型的详情，包括基本信息+子卡列表+年卡商铺目录+优惠商铺目录。
 *
 * /{typeId}/childtypes			        卡类型的子卡类型清单页面。
 * /{typeId}/childtypes/manage			卡类型的子卡类型清单管理页面。
 * /{typeId}/cmfrees				    卡类型的年卡商铺商品清单页面。
 * /{typeId}/cmfrees/manage				卡类型的年卡商铺商品清单管理页面。
 * /{typeId}/mccatalogs			        卡类型的优惠商铺商品目录页面。
 * /{typeId}/mccatalogs/manage			卡类型的优惠商铺商品目录管理页面。
 *
 * 7.获取卡类型相关信息的基本信息
 * /childtypes/{childtypeId}		    子卡类型的基本信息页面。
 * /cmfrees/{cmfreeId}				    卡类型的年卡商铺商品设置基本信息页面。     * 显示卡类型的年卡商铺商品基本信息。
 * /mccatalogs/{mccatalogId}		    卡类型的优惠商铺商品设置基本信息页面。     * 显示卡类型的优惠商铺基本信息。
 *
 */
@Controller
@RequestMapping("/mcardtypes")
public class MCardTypeQueryController {
    private static final Logger logger = LoggerFactory.getLogger(MCardTypeQueryController.class);


    //=========================================================================================根据运营商（客户实体运营管理关系）查询===========================================

    /**我运营管理的卡类型页面。
     * 查询当前用户所属客户实体作为运营商下管理的卡类型列表。
     */
    @RequestMapping(value = "/operator/mine/mcardtypes")
    public String queryMCardTypeOfMineAsOperator(Map<String, Object> model, HttpSession session, HttpServletRequest request) {
        String token = E2EAppWebContext.getToken(request);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/operator/listMine";
        }else{
            return "mcardmgr/pc/mcardtype/operator/listMine";
        }


    }

    /**指定运营商运营管理下的卡类型页面。
     * 查询运营商客户实体下管理的卡类型列表
     */
    @RequestMapping(value = "/operator/{operatorBoId}/mcardtypes")
    public String queryMCardTypeOfOperator(Map<String, Object> model, HttpSession session, HttpServletRequest request,
                                           @PathVariable("operatorBoId")String operatorBoId) {
        String token = E2EAppWebContext.getToken(request);

        model.put("operatorBoId",operatorBoId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/operator/list";
        }else{
            return "mcardmgr/pc/mcardtype/operator/list";
        }


    }

    //===========================================================================================根据商户（客户实体业务关系）查询===========================================

    /**我发行的卡类型页面。
     * 查询当前用户所属客户实体发行的卡类型列表
     */
    @RequestMapping(value = "/sp/mine/mcardtypes")
    public String queryMCardTypeOfMineAsSupplier(Map<String, Object> model,
                                                 HttpSession session, HttpServletRequest request) {
        String token = E2EAppWebContext.getToken(request);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/sp/listMine";
        }else{
            return "mcardmgr/pc/mcardtype/sp/listMine";
        }

    }

    /**指定客户实体发行的卡类型页面。
     *
     */
    @RequestMapping(value = "/sp/{supplierBoId}/mcardtypes")
    public String queryMCardTypeOfSupplier(Map<String, Object> model, HttpSession session, HttpServletRequest request,
                                           @PathVariable("supplierBoId")String supplierBoId) {

        String token = E2EAppWebContext.getToken(request);

        model.put("supplierBoId",supplierBoId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/sp/list";
        }else{
            return "mcardmgr/pc/mcardtype/sp/list";
        }


    }


    /**我分销/代理的卡类型页面。
     * 查询当前用户所属客户实体作为分销商分销的卡类型列表
     */
    @RequestMapping(value = "/ag/mine/mcardtypes")
    public String queryMCardTypeOfMineAsAgency(Map<String, Object> model,
                                               HttpSession session,
                                               HttpServletRequest request) {

        String token = E2EAppWebContext.getToken(request);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/ag/listMine";
        }else{
            return "mcardmgr/pc/mcardtype/ag/listMine";
        }
    }

    /**指定客户实体分销/代理的卡类型页面。
     *
     */
    @RequestMapping(value = "/ag/{agencyBoId}/mcardtypes")
    public String queryMCardTypeOfAgency(Map<String, Object> model, HttpSession session,
                                         HttpServletRequest request,
                                           @PathVariable("agencyBoId")String agencyBoId) {

        String token = E2EAppWebContext.getToken(request);

        model.put("agencyBoId",agencyBoId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/ag/list";
        }else{
            return "mcardmgr/pc/mcardtype/ag/list";
        }
    }
    /**总运营下的卡类型。
     *
     */
    @RequestMapping(value = "/sa/mine/mcardtypes")
    public String queryMCardTypeOfSa(Map<String, Object> model, HttpSession session, HttpServletRequest request) {

        String token = E2EAppWebContext.getToken(request);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/sa/list";
        }else{
            return "mcardmgr/pc/mcardtype/sa/list";
        }


    }

    //===========================================================================================根据网点（组织经营范围）进行查询======================================================
    /**当前组织经营范围内的卡类型页面。
     * 默认显示当前组织经营范围内的卡类型列表
     */
    @RequestMapping(value = "")
    public String queryMCardType(Map<String, Object> model, HttpSession session, HttpServletRequest request) {
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo(request);
        return "forward:/mcardtypes/organ/" + tokenInfo.getOrganId() + "/mcardtypes";
    }

    /**指定组织经营范围内的卡类型页面。
     *
     */
    @RequestMapping(value = "/organ/{organId}/mcardtypes")
    public String queryMCardTypeOfOrgan(Map<String, Object> model, HttpSession session, HttpServletRequest request,
                                 @PathVariable("organId")String organId) {

        String token = E2EAppWebContext.getToken(request);

        model.put("organId",organId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/organ/list";
        }else{
            return "mcardmgr/pc/mcardtype/organ/list";
        }

    }

    //==========================================================================================根据商铺merchant进行查询=========================================================

    /**指定商铺下发行的卡类型页面。
     */
    @RequestMapping(value = "/mc/{mcId}/mcardtypes")
    public String queryMCardTypeOfMc(Map<String, Object> model, HttpSession session, HttpServletRequest request,
                                    @PathVariable(value = "mcId") String mcId,
                                     @RequestParam(value = "currPage",required = false) String currPage) {
        String token = E2EAppWebContext.getToken(request);
        if(!StringUtils.isEmpty(mcId)) {
            session.setAttribute("mcId", mcId);
        }

        model.put("mcId",mcId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/mc/list";
        }else{
            return "mcardmgr/pc/mcardtype/mc/list";
        }

    }

    /**指定商铺下发行的卡类型管理页面。
     *
     */
    @RequestMapping(value = "/mc/{mcId}/mcardtypes/manage")
    public String queryMCardTypeOfMcForManage(Map<String, Object> model, HttpSession session,
                                              HttpServletRequest request,
                                              @PathVariable(value = "mcId") String mcId,
                                              @RequestParam(value = "currPage",required = false) String currPage) {
        String token = E2EAppWebContext.getToken(request);
        if(!StringUtils.isEmpty(mcId)) {
            session.setAttribute("mcId", mcId);
        }

        model.put("mcId",mcId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/mc/manage";
        }else{
            return "mcardmgr/pc/mcardtype/mc/manage";
        }

    }

    //=============================================================================================根据适用商铺查询============================================================================

    /**指定客户实体的商铺适用的卡类型页面。
     * 查询指定客户实体下的所有商铺适用的卡类型列表。
     */
    @RequestMapping(value = "/bo/{boId}/mcardtypes/usable")
    public String queryMCardTypeOfBoUsable(Map<String, Object> model, HttpSession session,HttpServletRequest request,
                                           @PathVariable("boId")String boId) {


        model.put("boId",boId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/bo/listUsable";
        }else{
            return "mcardmgr/pc/mcardtype/bo/listUsable";
        }
    }

    /**指定商铺下适用的卡类型页面。
     *
     */
    @RequestMapping(value = "/mc/{mcId}/mcardtypes/usable")
    public String queryMCardTypeOfMcUsable(Map<String, Object> model, HttpSession session, HttpServletRequest request,
                                        @PathVariable("mcId")String mcId) {
        String token = E2EAppWebContext.getToken(request);
        if(!StringUtils.isEmpty(mcId)) {
            session.setAttribute("mcId", mcId);
        }
        mcId = (String) session.getAttribute("mcId");


        model.put("mcId",mcId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/mc/listUsable";
        }else{
            return "mcardmgr/pc/mcardtype/mc/listUsable";
        }

    }

    //=======================================================================================================获取详情=========================================================================

    /**卡类型的基本信息页面。
     *
     */
    @RequestMapping(value = "/{typeId}")
    public String getMCardType(Map<String, Object> model, HttpSession session,
                               HttpServletRequest request,
                               @PathVariable("typeId")String typeId) {
        String token = E2EAppWebContext.getToken(request);

        model.put("typeId",typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/info/baseinfo";
        }else{
            return "mcardmgr/pc/mcardtype/info/baseinfo";
        }

    }

    /**卡类型管理页面。
     * 在这个页面，可以修改、上架/下架、管理子卡类型、管理年卡商铺目录、管理优惠商铺目录等
     *
     * @param typeId
     * @return
     */
    @RequestMapping(value = "/{typeId}/manage")
    public String manageMCardType(Map<String, Object> model, HttpSession session,
                                  HttpServletRequest request,
                                  @PathVariable("typeId")String typeId) {
        String token = E2EAppWebContext.getToken(request);

        model.put("typeId",typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/info/manage";
        }else{
            return "mcardmgr/pc/mcardtype/info/manage";
        }
    }


    /**卡类型的详细信息页面。
     * 显示指定卡类型的详情，包括基本信息+子卡列表+年卡商铺目录+优惠商铺目录。
     */
    @RequestMapping(value = "/{typeId}/details")
    public String getMCardTypeDetail(Map<String, Object> model, HttpSession session,
                                     HttpServletRequest request,
                                    @PathVariable("typeId")String typeId) {

        String token = E2EAppWebContext.getToken(request);

        model.put("typeId",typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/info/detail";
        }else{
            return "mcardmgr/pc/mcardtype/info/detail";
        }

    }
    /**卡类型的子卡类型清单页面。
     *
     */
    @RequestMapping(value = "/{typeId}/childtypes")
    public String getChildTypeListOfMCardType( Map<String, Object> model,HttpSession session, HttpServletRequest request,
                                                @PathVariable("typeId")String typeId) {

        String token = E2EAppWebContext.getToken(request);

        model.put("typeId",typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/info/childtype/list";
        }else{
            return "mcardmgr/pc/mcardtype/info/childtype/list";
        }
    }
    /**
     * 卡类型的子卡类型清单管理页面。
     *
     */
    @RequestMapping(value = "/{typeId}/childtypes/manage")
    public String getChildTypeManageOfMCardType( Map<String, Object> model,HttpSession session, HttpServletRequest request,
                                                @PathVariable("typeId")String typeId) {

        String token = E2EAppWebContext.getToken(request);

        model.put("typeId",typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/info/childtype/manage";
        }else{
            return "mcardmgr/pc/mcardtype/info/childtype/manage";
        }
    }
    /**卡类型的年卡商铺商品清单页面。
     */
    @RequestMapping(value = "/{typeId}/cmfrees")
    public String queryCmfreeOfMCardType(Map<String, Object> model,HttpSession session, HttpServletRequest request,
                                        @PathVariable("typeId")String typeId) {

        String token = E2EAppWebContext.getToken(request);

        model.put("typeId",typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/info/cmfree/list";
        }else{
            return "mcardmgr/pc/mcardtype/info/cmfree/list";
        }
    }
    /**卡类型的年卡商铺商品清单管理页面。
     */
    @RequestMapping(value = "/{typeId}/cmfrees/manage")
    public String queryCmfreeManageOfMCardType(Map<String, Object> model,HttpSession session, HttpServletRequest request,
                                        @PathVariable("typeId")String typeId) {

        String token = E2EAppWebContext.getToken(request);

        model.put("typeId",typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/info/cmfree/manage";
        }else{
            return "mcardmgr/pc/mcardtype/info/cmfree/manage";
        }
    }
    /**卡类型的优惠商铺商品目录页面。
     */
    @RequestMapping(value = "/{typeId}/mccatalogs")
    public String queryMccatalogOfMCardType(Map<String, Object> model,HttpSession session, HttpServletRequest request,
                                            @PathVariable("typeId")String typeId) {

        String token = E2EAppWebContext.getToken(request);

        model.put("typeId",typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/info/mccatalog/list";
        }else{
            return "mcardmgr/pc/mcardtype/info/mccatalog/list";
        }
    }

    /**卡类型的优惠商铺商品目录管理页面。
     */
    @RequestMapping(value = "/{typeId}/mccatalogs/manage")
    public String queryMccatalogManageOfMCardType(Map<String, Object> model,HttpSession session, HttpServletRequest request,
                                            @PathVariable("typeId")String typeId) {

        String token = E2EAppWebContext.getToken(request);

        model.put("typeId",typeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/info/mccatalog/manage";
        }else{
            return "mcardmgr/pc/mcardtype/info/mccatalog/manage";
        }
    }


    //==========================================================================================获取卡类型相关信息的基本信息=============================================================

    /**子卡类型的基本信息页面。
     */
    @RequestMapping(value = "/childtypes/{childtypeId}")
    public String getMCardChildType(Map<String, Object> model, HttpSession session, HttpServletRequest request,
                                    @PathVariable("childtypeId")String childtypeId) {

        String token = E2EAppWebContext.getToken(request);

        model.put("childtypeId",childtypeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/info/childtype/baseInfo";
        }else{
            return "mcardmgr/pc/mcardtype/info/childtype/baseInfo";
        }

    }

    /**卡类型的年卡商铺商品设置基本信息页面。
     * 显示卡类型的年卡商铺商品基本信息。
     */
    @RequestMapping(value = "/cmfrees/{cmfreeId}")
    public String getMCardCmfree(Map<String, Object> model, HttpSession session, HttpServletRequest request,
                                           @PathVariable("cmfreeId")String cmfreeId) {

        String token = E2EAppWebContext.getToken(request);

        model.put("cmfreeId",cmfreeId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/info/cmfree/baseInfo";
        }else{
            return "mcardmgr/pc/mcardtype/info/cmfree/baseInfo";
        }

    }

    /**卡类型的优惠商铺商品设置基本信息页面。
     * 显示卡类型的优惠商铺基本信息。
     */
    @RequestMapping(value = "/mccatalogs/{mccatalogId}")
    public String getMCardMccatalog(Map<String, Object> model, HttpSession session, HttpServletRequest request,
                                           @PathVariable("mccatalogId")String mccatalogId) {
        String token = E2EAppWebContext.getToken(request);

        model.put("mccatalogId",mccatalogId);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardtype/info/mccatalog/baseInfo";
        }else{
            return "mcardmgr/pc/mcardtype/info/mccatalog/baseInfo";
        }

    }

}
