package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller;

import com.dayouzc.e2eapp.mcard.dto.McardChildtypeDTO;
import com.dayouzc.e2eapp.mcard.dto.McardCmfreeDTO;
import com.dayouzc.e2eapp.mcard.dto.McardMccatalogDTO;
import com.dayouzc.e2eapp.mcard.dto.McardTypeDTO;
import com.dayouzc.e2eapp.mcard.sdk.McardTypeSDK;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import com.dayouzc.e2eplatform.core.dto.file.E2eDocDTO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by Mr.Liu on 2017/8/8.
 *
 * TODO 【规范】action类的rest路径上都不带参数，通过request参数实现。以下有4个需要修改并修改相应的引用。
 * TODO 【规范】“/actionname”表示操作类页面服务资源的rest路径，“/actionname/submit”表示submit执行。
 *
 * “/mcardtypes”是卡类型相关资源根目录，其中，操作类的主要包括：
 *
 * 1.卡类型 新建、修改等页面
 * /create		        新建卡类型页面
 * /modify		        修改卡类型页面
 *
 * 2.子卡类型新建、修改等页面
 * /childtypes/create	新建子卡类型页面
 * /childtypes/modify	修改子卡类型页面
 *
 * 3.年卡商铺目录新建、修改等页面
 * /cmfrees/create		新建年卡商铺目录页面
 * /cmfrees/modify		修改年卡商铺目录页面
 * /cmfrees/enable		设置年卡商铺目录有效/失效  TODO 暂未实现
 *
 * 4.优惠商铺目录新建、修改等页面
 * /mccatalogs/create	新建优惠商铺目录页面
 * /mccatalogs/modify	修改优惠商铺目录页面
 * /mccatalogs/enable	设置优惠商铺目录有效/失效  TODO 暂未实现
 *
 *
 */
@Controller
@RequestMapping("/mcardtypes")
public class MCardTypeActionController {
    private static final Logger logger = LoggerFactory.getLogger(MCardTypeActionController.class);


    //====================== 卡类型 新建、修改等页面
    /**
     * 新建卡类型页面
     * @param model
     * @param session
     */
    @RequestMapping(value = "/create")
    public String createMCardType(Map<String, Object> model, HttpSession session,
                                  @RequestParam(value = "mcId")String mcId) {
        String token = (String) session.getAttribute("token");
        String organId = (String) session.getAttribute("organId");
        model.put("mcId",mcId);
        model.put("organId",organId);
        return "mcardmgr/pc/mcardtype/action/mcardtype/create";
    }

    /**
     * 修改卡类型页面
     *
     * TODO action类的rest路径上都不带参数，通过request参数实现。
     * @param model
     * @param session
     * @return
     */
    @RequestMapping(value = "/{typeId}/modify")
    public String updateMCardType(Map<String, Object> model, HttpSession session,
                                 @PathVariable("typeId")String typeId) {
        String token = (String) session.getAttribute("token");

        model.put("typeId",typeId);
        return "mcardmgr/pc/mcardtype/action/mcardtype/modify";
    }


    //=============================================================================子卡类型新建、修改等页面==============================================================

    /**新建子卡类型页面
     *
     */
    @RequestMapping(value = "/childtypes/create")
    public String createChildType(Map<String, Object> model, HttpSession session,
                                  @RequestParam(value = "typeId")String typeId) {
        String token = (String) session.getAttribute("token");

        model.put("typeId",typeId);
        return "mcardmgr/pc/mcardtype/action/childtype/create";

    }


    /**修改子卡类型页面
     *
     * TODO action类的rest路径上都不带参数，通过request参数实现。
     */
    @RequestMapping(value = "/childtypes/{childtypeId}/modify")
    public String modifyChildType(Map<String, Object> model, HttpSession session,
                                  @PathVariable(value = "childtypeId")String childtypeId) {
        String token = (String) session.getAttribute("token");

        model.put("childtypeId",childtypeId);
        return "mcardmgr/pc/mcardtype/action/childtype/modify";
    }

    //=========================================================================================年卡商铺目录新建、修改等页面======================================================================

    /**新建年卡商铺目录页面
     *
     */
    @RequestMapping(value = "/cmfrees/create")
    public String createMcardCmfree(Map<String, Object> model, HttpSession session,
                                    @RequestParam(value = "typeId")String typeId) {
        String token = (String) session.getAttribute("token");

        model.put("typeId",typeId);
        return "mcardmgr/pc/mcardtype/action/cmfree/create";
    }


    /**
     * 修改年卡商铺目录页面
     * TODO action类的rest路径上都不带参数，通过request参数实现。
     */
    @RequestMapping(value = "/cmfrees/modify")
    public String modifyMcardCmfree(Map<String, Object> model, HttpSession session,
                                    @RequestParam(value = "cmfreeId")String cmfreeId) {
        String token = (String) session.getAttribute("token");

        model.put("cmfreeId",cmfreeId);
        return "mcardmgr/pc/mcardtype/action/cmfree/modify";
    }


    /**
     * 设置年卡商铺目录有效/失效
     * @param model
     * @param session
     * @param mcId
     * @return
     *
     * TODO 暂未实现
     *
     */
    @RequestMapping(value = "/cmfrees/enable")
    public String enableMcardCmfree(Map<String, Object> model, HttpSession session,
                                          @RequestParam(value = "mcId")String mcId) {
        String token = (String) session.getAttribute("token");
        //TODO 暂定
        model.put("mcId",mcId);
        return "redirect:";
    }

    //=================================================================================优惠商铺目录新建、修改等页面================================================================

    /**新建优惠商铺目录页面
     *
     */
    @RequestMapping(value = "/mccatalogs/create")
    public String createMcardMccatalog(Map<String, Object> model, HttpSession session,
                                    @RequestParam(value = "typeId")String typeId) {
        String token = (String) session.getAttribute("token");

        model.put("typeId",typeId);
        return "mcardmgr/pc/mcardtype/action/mccatalog/create";
    }


    /**
     * 修改优惠商铺目录页面
     * TODO action类的rest路径上都不带参数，通过request参数实现。
     */
    @RequestMapping(value = "/mccatalogs/modify")
    public String modifyMcardMccatalog(Map<String, Object> model, HttpSession session,
                                    @RequestParam(value = "mccatalogId")String mccatalogId) {
        String token = (String) session.getAttribute("token");

        model.put("mccatalogId",mccatalogId);
        return "mcardmgr/pc/mcardtype/action/mccatalog/modify";
    }


    /**
     * 设置优惠商铺目录有效/失效
     * @param model
     * @param session
     * @param mcId
     * @return
     *
     * TODO 暂未实现
     *
     */
    @RequestMapping(value = "/mccatalogs/enable")
    public String enableMcardMccatalog(Map<String, Object> model, HttpSession session,
                                          @RequestParam(value = "mcId")String mcId) {
        String token = (String) session.getAttribute("token");
        //TODO 暂定
        model.put("mcId",mcId);
        return "redirect:";
    }


}
