package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller;

import com.dayouzc.e2eapp.mcard.dto.McardProduceDTO;
import com.dayouzc.e2eapp.mcard.dto.McardTypeDTO;
import com.dayouzc.e2eapp.mcard.mcardmgr.web.controller.common.dto.E2eDocDTODataList;
import com.dayouzc.e2eapp.mcard.sdk.McardProduceSDK;
import com.dayouzc.e2eapp.mcard.sdk.McardTypeSDK;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import com.dayouzc.e2eplatform.core.dto.file.E2eDocDTO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by Mr.Liu on 2017/8/8.
 *
 * “/produces”是卡生产制卡的相关资源根目录，主要包括：
 *
 * 1.查询类
 * /		                    我（当前客户实体）的生产记录查询页。      * 查询当前客户实体的会员卡生产记录。
 * /manage	                    我（当前客户实体）的生产记录管理页。      * 查询当前客户实体的会员卡生产记录，并可进行管理操作，例如：制卡申请、制卡导入、等。
 *
 * /cardtype/{typeId}/produces	指定卡类型的生产记录页面。
 * /mc/{mcId}/produces			指定商铺的生产记录页面。                  * 查询指定商铺（发卡机构）的所有卡类型的生产记录
 * /card/{cardNum}/produces	    指定卡的生产记录页面。
 *
 * 2.查询详情
 * /{recordId}					卡生产记录基本信息页面。
 *
 * 2.操作类	生产制卡
 * /produce/apply			    生成制卡卡号文件     * 生成制卡卡号文件（根据卡号规则，生成卡号列表）。只以txt文件形式存在，不写库，可下载 TODO 待设计
 * /produce/import		        制卡导入页面     * 制卡导入。导入虚拟卡/实体卡，如果是实体卡，需要物理id
 *
 *
 */
@Controller
@RequestMapping("/produces")
public class MCardProduceController {
    private static final Logger logger = LoggerFactory.getLogger(MCardProduceController.class);

    //======================================================================================查询类=====================================================================

    /**根据客户实体查询	我（客户实体）的生产记录
     *
     */
    @RequestMapping(value = "")
    public String queryMCardProduce(Map<String, Object> model, HttpSession session) {
        String token = (String) session.getAttribute("token");

        return "mcardmgr/pc/produce/list/listOfMineCustomer";
    }

    /**根据客户实体查询	我（客户实体）的生产记录
     *
     */
    @RequestMapping(value = "/manage")
    public String manageMCardProduce(Map<String, Object> model, HttpSession session) {
        String token = (String) session.getAttribute("token");

        return "mcardmgr/pc/produce/list/manage";

    }

    /**
     * 根据卡类型查询
     * 查询指定卡类型的生产记录
     *
     */
    @RequestMapping(value = "/cardtype/{typeId}/produces")
    public String queryMCardProduceOfMCardType(Map<String, Object> model, HttpSession session,
                                    @RequestParam(value = "token",required = false) String token,
                                    @PathVariable(value = "typeId") String typeId) {

        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("typeId",typeId);
        return "mcardmgr/pc/produce/list/listOfCardType";


    }
    /**
     * 根据商铺查询
     * 查询指定商铺（发卡机构）的所有卡类型的生产记录
     *
     */
    @RequestMapping(value = "/mc/{mcId}/produces")
    public String queryMCardProduceOfMc(Map<String, Object> model, HttpSession session,
                                    @RequestParam(value = "token",required = false) String token,
                                    @PathVariable(value = "mcId") String mcId) {
        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("mcId",mcId);
        return "mcardmgr/pc/produce/list/listOfMc";


    }
    /**
     * 根据卡查询
     * 查询指定卡的生产记录
     *
     */
    @RequestMapping(value = "/card/{cardNum}/produces")
    public String getMCardProduceOfCard(Map<String, Object> model, HttpSession session,
                                    @RequestParam(value = "token",required = false) String token,
                                    @PathVariable(value = "cardNum") String cardNum) {

        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("cardNum",cardNum);
        return "mcardmgr/pc/produce/list/listOfCard";
    }
    /**
     * 获取详情
     * 生产记录基本信息页面
     *
     */
    @RequestMapping(value = "/{recordId}")
    public String getMCardProduce(Map<String, Object> model, HttpSession session,
                                    @RequestParam(value = "token",required = false) String token,
                                    @PathVariable(value = "recordId") String recordId) {

        token = (String) session.getAttribute("token");

        model.put("recordId",recordId);
        return "mcardmgr/pc/produce/info/baseinfo";
    }



    //=================================================================================操作类	生产制卡===================================================

    /**
     * 生成制卡卡号文件
     * 生成制卡卡号文件（根据卡号规则，生成卡号列表）。只以txt文件形式存在，不写库，可下载
     *
     * TODO 待设计
     */
    @RequestMapping(value = "/produce/apply")
    public String produce(Map<String, Object> model, HttpSession session,
                             @RequestParam(value = "token",required = false) String token) {

        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        return "mcardmgr/pc/produce/action/apply";
    }


    /**
     * 制卡导入页面
     * 制卡导入。导入虚拟卡/实体卡，如果是实体卡，需要物理id
     *
     */
    @RequestMapping(value = "/produce/import")
    public String produceImport(Map<String, Object> model, HttpSession session,
                           @RequestParam(value = "token",required = false) String token) {

        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        return "mcardmgr/pc/produce/action/import";

    }




}
