package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller;

import com.dayouzc.e2eapp.lforder.dto.OrderInfoDTO;
import com.dayouzc.e2eapp.lforder.dto.RefundInfoDTO;
import com.dayouzc.e2eapp.lforder.sdk.OrderInfoSDK;
import com.dayouzc.e2eapp.mcard.dto.McardDeliverDetailDTO;
import com.dayouzc.e2eapp.mcard.dto.McardInfoDTO;
import com.dayouzc.e2eapp.mcard.dto.McardOrderDetailDTO;
import com.dayouzc.e2eapp.mcard.dto.McardRefundDetailDTO;
import com.dayouzc.e2eapp.mcard.mcardmgr.web.dto.OrderInfoWrapperDTO;
import com.dayouzc.e2eapp.mcard.sdk.McardInfoSDK;
import com.dayouzc.e2eapp.mcard.sdk.McardOrderSDK;
import com.dayouzc.e2eplatform.core.context.E2EAppWebContext;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by Mr.Liu on 2017/8/7.
 *
 * “/mcardorders”是电商订单相关资源根目录，主要包括：
 *
 * 1.查询类
 * /{orderId}/detail		获取详情     * 获取订单订购明细（由各个业务系统实现）TODO 样式不统一【旧样式】
 * /{orderId}/delivers		获取订单发货明细（由各个业务系统实现）TODO 样式不统一【旧样式】 设计不合理 无法操作
 * /{orderId}/manage		订单管理页面     * 显示：基本信息、订单明细、等 工具栏：。。。TODO 样式不统一【旧样式】
 *
 * 2.操作类
 *
 * 2.1.下单（卖家）
 * /sale		销售下单（B2C）页面	销售下单，卖家发起（需指定销售明细）
 * /saleB2B	销售下单（B2B）页面	销售下单，卖家发起（需指定销售明细）TODO 样式不统一【旧样式】
 * /upgrade	卡升级页面 TODO 样式不统一【旧样式】 且 不可操作
 * /renewal	卡续费页面 TODO 样式不统一【旧样式】 且 不可操作
 * /gift		赠卡页面 TODO 样式不统一【旧样式】 且 不可操作
 *
 * 2.2.下单（买家）
 * /bookingB2B	购买下单（B2B）页面	购买下单，买家发起（需指定下单明细）TODO 样式不统一【旧样式】 且 不可操作
 *
 * 2.3.确认
 * /verify		商家确认订单页面  TODO 无jsp页面资源，建议ajax处理。ps.接口报错
 * /cancel		商家取消订单页面  TODO 无jsp页面资源，建议ajax处理。ps.接口报错
 *
 * 2.4.发货
 * /deliver	发货页面	发货（处理发货的商品）  TODO 样式不统一【旧样式】ps.接口报错
 * /receipt	收货确认页面	收货确认（确认发货的商品）TODO 页面未设计，代码未实现
 * /pickup		取货页面	核销/取货严重/上门取货（处理和确认发货的商品）TODO 页面未设计，代码未实现
 *
 * 3.退款单（卡）
 *
 * 3.1.查询类
 * /refunds/{refundId}/details	卡退款单明细页面	获取退款单明细（由各个业务系统实现）TODO 页面未设计，代码未实现
 * /refunds/{refundId}/manage	卡退款单管理页面     *显示：基本信息、退款明细、等 工具栏：。。。TODO 页面未设计，代码未实现
 *
 * 3.2.操作类
 * /refund/apply		卡退款申请页面	退款申请	退款申请（根据自身业务规则确认是否可发起退款申请）TODO 样式不统一【旧样式】 且 不可操作
 * /refund/verify		卡退款确认页面	退款确认	退款确认（根据自身业务规则确认是否可退款）TODO 样式不统一【旧样式】 且 不可操作
 */
@Controller
@RequestMapping("/mcardorders")
public class MCardOrderController {
    private static final Logger logger = LoggerFactory.getLogger(MCardOrderController.class);

    //================================================================================页面服务（查询类）====================================================
    /**
     * 获取详情
     * 获取订单订购明细（由各个业务系统实现）
     *
     */
    @RequestMapping(value = "/{orderId}/detail")
    public String getMCardOrderDetailList(
            Map<String, Object> model,
            HttpSession session,
            @PathVariable("orderId")String orderId,
            @RequestParam(value = "token",required = false)String token){
        if(StringUtils.isNotEmpty(token)){
            session.setAttribute("token",token);
        }
        token = (String)session.getAttribute("token");
        model.put("orderId", orderId);

        return "mcardmgr/pc/mcardorder/info/details";
    }

    /**获取订单发货明细（由各个业务系统实现）
     *
     */
    @RequestMapping(value = "/{orderId}/delivers")
    public String getMCardOrderDeliverDetailList(Map<String, Object> model, HttpSession session, @PathVariable("orderId")String orderId){
        String token = (String)session.getAttribute("token");
        ResponseData<List<McardDeliverDetailDTO>> responseData = McardOrderSDK.getInstance().getMCardOrderDeliverDetailList(orderId,token);
        model.put("mcardOrderDetail", responseData.getResult());
        return "mcardmgr/pc/mcardorder/info/delivers";
    }

    /**
     * 订单管理页面
     * 显示：基本信息、订单明细、等 工具栏：。。。
     */
    @RequestMapping(value = "/{orderId}/manage")
    public String manageMCardOrderInfo(
            Map<String, Object> model,
            HttpSession session,
            @PathVariable("orderId")String orderId,
            @RequestParam(value = "token",required = false)String token){
        if(StringUtils.isNotEmpty(token)){
            session.setAttribute("token",token);
        }
        token = (String)session.getAttribute("token");
        model.put("orderId", orderId);

        return "mcardmgr/pc/mcardorder/info/manage";
    }

    //============================================================================================== 页面服务（操作类）=====================================================================

    //----------------------------------------------------------------- 下单（卖家）
    /**销售下单（B2C）页面	销售下单，卖家发起（需指定销售明细）
     *
     */
    @RequestMapping(value = "/sale")
    public String sale(HttpServletRequest request){
        //1、校验

        //2、业务处理

        //3、响应
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardorder/action/sale";
        }else{
            return "mcardmgr/pc/mcardorder/action/sale";
        }
    }

    /**
     * 销售下单（B2B）页面	销售下单，卖家发起（需指定销售明细）
     * @param request
     * @return
     */
    @RequestMapping(value = "/saleB2B")
    public String saleB2B(HttpServletRequest request){

        //1、校验

        //2、业务处理

        //3、响应
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardorder/action/sale_b2b";
        }else{
            return "mcardmgr/pc/mcardorder/action/sale_b2b";
        }
    }

    /**卡升级页面
     *
     */
    @RequestMapping(value = "/upgrade")
    public String upgrade(Map<String, Object> model, HttpSession session,
                          @RequestParam(value = "token",required = false)String token){
        if(StringUtils.isNotEmpty(token)){
            session.setAttribute("token",token);
        }
        token = (String)session.getAttribute("token");

        return "mcardmgr/pc/mcardorder/action/upgrade";
    }
    @RequestMapping(value = "/upgrade/submit")
    public String upgradeSubmit(Map<String, Object> model, HttpSession session, OrderInfoDTO orderInfoDTO){
        String token = (String)session.getAttribute("token");
        ResponseData<OrderInfoDTO> responseData = McardOrderSDK.getInstance().upgrade(orderInfoDTO,token);
        model.put("orderInfo", responseData.getResult());
        return "redirect:";
    }

    /**卡续费页面
     *
     */
    @RequestMapping(value = "/renewal")
    public String renewal(Map<String, Object> model, HttpSession session,
                          @RequestParam(value = "token",required = false)String token){
        if(StringUtils.isNotEmpty(token)){
            session.setAttribute("token",token);
        }
        token = (String)session.getAttribute("token");

//        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().getMCardinfo(cardNum,token);
//        model.put("mcardInfo", responseData.getResult());

        return "mcardmgr/pc/mcardorder/action/renewal";
    }

    @RequestMapping(value = "/renewal/submit")
    public String renewalSubmit(Map<String, Object> model, HttpSession session, OrderInfoDTO orderInfoDTO){
        String token = (String)session.getAttribute("token");
        ResponseData<OrderInfoDTO> responseData = McardOrderSDK.getInstance().renewal(orderInfoDTO,token);
        model.put("orderInfo", responseData.getResult());
        return "redirect:";
    }

    /**赠卡页面
     *
     */
    @RequestMapping(value = "/gift")
    public String giftCard(Map<String, Object> model,
                           HttpSession session,
                           @RequestParam(value = "token",required = false)String token){

        if(StringUtils.isNotEmpty(token)){
            session.setAttribute("token",token);
        }
        token = (String)session.getAttribute("token");

        return "mcardmgr/pc/mcardorder/action/gift";
    }
    @RequestMapping(value = "/gift/submit")
    public String giftCardSubmit(Map<String, Object> model, HttpSession session, OrderInfoDTO orderInfoDTO){
        String token = (String) session.getAttribute("token");
        ResponseData<OrderInfoDTO> responseData = McardOrderSDK.getInstance().giftCard(orderInfoDTO,token);
        return "redirect:";
    }



    //------------------------------------------------------------------------------------- 下单（买家）
    /**购买下单（B2B）页面	购买下单，买家发起（需指定下单明细）
     *
     */
    @RequestMapping(value = "/bookingB2B")
    public String bookingB2B(Map<String, Object> model, HttpSession session, @RequestParam("typeId")String tyepId){
        String token = (String) session.getAttribute("token");
        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().getMCardinfo(tyepId,token);
        model.put("mcardInfo", responseData.getResult());
        return "mcardmgr/pc/mcardorder/action/booking_b2b";
    }
    @RequestMapping(value = "/bookingB2B/submit")
    public String bookingB2BSubmit(Map<String, Object> model, HttpSession session, OrderInfoDTO orderInfoDTO){
        String token = (String) session.getAttribute("token");
        ResponseData<OrderInfoDTO> responseData = McardOrderSDK.getInstance().bookingB2B(orderInfoDTO,token);
        model.put("orderInfo", responseData.getResult());
        return "redirect:";
    }
    //--------------------------------------------------------------------------------------- 确认
    /**商家确认/取消订单页面
     *
     */
    @RequestMapping(value = "/verify")
    public String verify(Map<String, Object> model, HttpSession session,
                         @RequestParam("orderId")String orderId){
        String token = (String) session.getAttribute("token");
        OrderInfoDTO orderInfoDTO = new OrderInfoDTO();
        orderInfoDTO.setOrderId(orderId);
        ResponseData<OrderInfoDTO> responseData = McardOrderSDK.getInstance().verify(orderInfoDTO,token);
        if (responseData == null) {
            String msg = "[responseData] is null";
            model.put("msg",msg);
            return "common/errorPage";
        } else if (!StringUtils.equals(responseData.getStatus(),"10000")) {
            String msg = responseData.getMsg();
            model.put("msg",msg);
            return "common/errorPage";
        } else {
            return "redirect:/mcardorders/"+orderId+"/manage";
        }
    }

    //--------------------------------- 取消
    /**
     *商家取消订单页面
     */
    @RequestMapping(value = "/cancel")
    public String cancel(
            Map<String, Object> model,
            HttpSession session,
            @RequestParam("orderId")String orderId){

        String token = (String) session.getAttribute("token");
        OrderInfoDTO orderInfo = new OrderInfoDTO();
        orderInfo.setOrderId(orderId);
        ResponseData<OrderInfoDTO> responseData = McardOrderSDK.getInstance().cancel(orderInfo,token);
        if (responseData == null) {
            String msg = "[responseData] is null";
            model.put("msg",msg);
            return "common/errorPage";
        } else if (!StringUtils.equals(responseData.getStatus(),"10000")) {
            String msg = responseData.getMsg();
            model.put("msg",msg);
            return "common/errorPage";
        } else {
            return "redirect:/eborders/" + orderId + "/manage";
        }
    }



    //--------------------------------- 发货
    /**发货页面	发货（处理发货的商品）
     *
     */
    @RequestMapping(value = "/deliver")
    public String deliver(Map<String, Object> model,
                          HttpSession session,
                          @RequestParam("orderId")String orderId){
        String token = (String) session.getAttribute("token");

        return "mcardmgr/pc/mcardorder/action/deliver";
    }


    @RequestMapping(value = "/deliver/submit")
    public String deliverSubmit(
            Map<String, Object> model,
            HttpSession session,
            OrderInfoWrapperDTO orderInfoWrapper){

        String token = (String) session.getAttribute("token");

        //将界面传值DTO转为后台服务需要的DTO
        OrderInfoDTO orderInfoDTO =new OrderInfoDTO();
        //拷贝订单信息
        BeanUtils.copyProperties(orderInfoWrapper, orderInfoDTO);

        //拷贝发货明细
        List<McardOrderDetailDTO> orderDetailList = orderInfoWrapper.getOrderDetailList();

        if(orderDetailList!=null && !orderDetailList.isEmpty()) {
            List<McardDeliverDetailDTO> deliverDetailList = new ArrayList<>();
            for(McardOrderDetailDTO orderDetail : orderDetailList){
                McardDeliverDetailDTO deliverDetail = new McardDeliverDetailDTO();
                BeanUtils.copyProperties(orderDetail, deliverDetail);
                deliverDetail.setDeliverQuantity(new Integer(orderDetail.getBuyNumber()));
                deliverDetailList.add(deliverDetail);
            }
            orderInfoDTO.setOrderDeliverDetails(deliverDetailList);
        }


        ResponseData<OrderInfoDTO> responseData = McardOrderSDK.getInstance().deliver(orderInfoDTO,token);

        if (responseData == null) {
            String msg = "[responseData] is null";
            model.put("msg", msg);
            return "common/errorPage";
        } else if (!StringUtils.equals(responseData.getStatus(), "10000")) {
            String msg = responseData.getMsg();
            model.put("msg", msg);
            return "common/errorPage";
        } else {
            return "redirect:/mcardorders/" + orderInfoWrapper.getOrderId() + "/manage";
        }


    }

    /**收货确认页面	收货确认（确认发货的商品）
     *
     */
    @RequestMapping(value = "/receipt")
    public String receipt(Map<String, Object> model, HttpSession session, @RequestParam("orderId")String orderId){
        //TODO 这个预留未来商家或快递员可以进行收货确认
        String token = (String) session.getAttribute("token");
        ResponseData<OrderInfoDTO> responseData = OrderInfoSDK.getInstance().getOrderInfo(orderId,token);
        model.put("orderInfo", responseData.getResult());

        return "mcardmgr/pc/mcardorder/action/receipt";
    }

    @RequestMapping(value = "/receipt/submit")
    public String receiptSubmit(Map<String, Object> model, HttpSession session, OrderInfoDTO orderInfoDTO){
        String token = (String) session.getAttribute("token");
        ResponseData<OrderInfoDTO> responseData = McardOrderSDK.getInstance().receipt(orderInfoDTO,token);
        OrderInfoDTO orderInfo = responseData.getResult();
        model.put("orderInfo", orderInfo);
        return "redirect:redirect:/eborders/" + orderInfo.getOrderId() + "/manage";
    }
    /**取货页面	核销/取货严重/上门取货（处理和确认发货的商品）
     *
     */
    @RequestMapping(value = "/pickup")
    public String pickup(Map<String, Object> model, HttpSession session, @RequestParam("orderId")String orderId){
        String token = (String) session.getAttribute("token");
        ResponseData<OrderInfoDTO> responseData = OrderInfoSDK.getInstance().getOrderInfo(orderId,token);
        model.put("orderInfo", responseData.getResult());

        return "mcardmgr/pc/mcardorder/action/pickup";
    }
    @RequestMapping(value = "/pickup/submit")
    public String pickupSubmit(Map<String, Object> model, HttpSession session, OrderInfoDTO orderInfoDTO){
        String token = (String) session.getAttribute("token");
        ResponseData<OrderInfoDTO> responseData = McardOrderSDK.getInstance().pickup(orderInfoDTO,token);
        model.put("orderInfo", responseData.getResult());
        return "redirect:";
    }


    //==================================================================================================================
    //                                                              退款单（卡）
    //==================================================================================================================

    //=========================页面服务（查询类）
    /** 卡退款单明细页面	获取退款单明细（由各个业务系统实现）
     *
     */
    @RequestMapping(value = "/refunds/{refundId}/details")
    public String getMCardOrderRefundDetailList(Map<String, Object> model, HttpSession session, @PathVariable("refundId")String refundId){
        String token = (String) session.getAttribute("token");
        ResponseData<List<McardRefundDetailDTO>> responseData = McardOrderSDK.getInstance().getMCardOrderRefundDetailList(refundId,token);
        model.put("mcardInfoList", responseData.getResult());
        return "mcardmgr/pc/mcardorder/refund/details";
    }

    /**
     * 卡退款单管理页面
     *显示：基本信息、退款明细、等 工具栏：。。。
     */
    @RequestMapping(value = "/refunds/{refundId}/manage")
    public String manageMCardOrderRefund(Map<String, Object> model, HttpSession session, @PathVariable("refundId")String refundId){
        String token = (String) session.getAttribute("token");
        ResponseData<List<McardRefundDetailDTO>> responseData = McardOrderSDK.getInstance().getMCardOrderRefundDetailList(refundId,token);
        model.put("mcardInfoList", responseData.getResult());
        return "mcardmgr/pc/mcardorder/refund/details";
    }

    //----------------------------------------------------------------------------------------页面服务（操作类）

    /**卡退款申请页面	退款申请	退款申请（根据自身业务规则确认是否可发起退款申请）
     *
     */
    @RequestMapping(value = "/refund/apply")
    public String refundApply(Map<String, Object> model, HttpSession session){
        String token = (String) session.getAttribute("token");


        return "mcardmgr/pc/mcardorder/refund/apply";
    }
    @RequestMapping(value = "/refund/apply/submit")
    public String refundApplySubmit(Map<String, Object> model, HttpSession session, RefundInfoDTO refundInfoDTO){

        String token = (String) session.getAttribute("token");
        ResponseData<RefundInfoDTO> responseData = McardOrderSDK.getInstance().refundApply(refundInfoDTO, token);
        model.put("refundInfo", responseData.getResult());
        return "redirect:";
    }
    /**卡退款确认页面	退款确认	退款确认（根据自身业务规则确认是否可退款）
     *
     */
    @RequestMapping(value = "/refund/verify")
    public String refundVerify(Map<String, Object> model, HttpSession session){
        return "mcardmgr/pc/mcardorder/refund/verify";
    }
    @RequestMapping(value = "/refund/verify/submit")
    public String refundVerifySubmit(Map<String, Object> model, HttpSession session, RefundInfoDTO refundInfoDTO){
        String token = (String) session.getAttribute("token");
        ResponseData<RefundInfoDTO> responseData = McardOrderSDK.getInstance().refundVerify(refundInfoDTO,token);
        model.put("refundInfo", responseData.getResult());
        return "redirect:";
    }


}
