package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller;

import com.dayouzc.e2eapp.mcard.dto.McardInfoDTO;
import com.dayouzc.e2eapp.mcard.sdk.McardInfoSDK;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import com.dayouzc.e2eplatform.core.util.ImportExcelUtil;
import com.dayouzc.e2eplatform.core.util.JsonUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

/**
 * Created by Mr.Liu on 2017/8/8.
 *
 * TODO 如果没有用了，则可以delete了。
 */
@Controller
@RequestMapping("/mcards")
public class MCardInfoAjaxController {
    private static final Logger logger = LoggerFactory.getLogger(MCardInfoAjaxController.class);

    /**
     * 描述：通过 jquery.form.js 插件提供的ajax方式上传文件
     * @param request
     * @param response
     * @throws Exception
     */
    @ResponseBody
    @RequestMapping(value="/upload/ajax")
    public  void  uploadCardAjax(HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;

        System.out.println("通过 jquery.form.js 提供的ajax方式上传文件！");

        InputStream in =null;
        List<List<Object>> listob = null;
        MultipartFile file = multipartRequest.getFile("upfile");
        if(file.isEmpty()){
            throw new Exception("文件不存在！");
        }

        in = file.getInputStream();
        listob = new ImportExcelUtil().getBankListByExcel(in,file.getOriginalFilename());

        //该处可调用service相应方法进行数据保存到数据库中，现只对数据输出
        for (int i = 0; i < listob.size(); i++) {
            List<Object> lo = listob.get(i);

            System.out.println("打印信息-->设备类型:"+lo.get(0)+"  设备SN："+lo.get(1)+"   设备型号："+lo.get(2)+"   设备型号版本："+lo.get(3));
        }

        PrintWriter out = null;
        response.setCharacterEncoding("utf-8");  //防止ajax接受到的中文信息乱码
        out = response.getWriter();
        out.print(listob);
        out.flush();
        out.close();
    }

    /**
     * ajax 获取卡详情
     * @param model
     * @param session
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/{cardNum}/ajax")
    public void getCardAjax(Map<String, Object> model, HttpSession session,
                                    HttpServletResponse response,
                                    @PathVariable("cardNum")String cardNum){

        String token = (String) session.getAttribute("token");

        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().getMCardinfo(cardNum,token);


        PrintWriter out = null;
        response.setCharacterEncoding("utf-8");  //防止ajax接受到的中文信息乱码
        try {
            out = response.getWriter();
            if (responseData == null) {
                String msg = "{\"msg\",\"[responseData] is null\"}";
                String jsonStr = JsonUtil.toJson(msg);
                out.print(jsonStr);
            } else if (!StringUtils.equals(responseData.getStatus(),"10000")) {
                String jsonStr = JsonUtil.toJson(responseData);
                out.print(jsonStr);
            } else {
                McardInfoDTO mcardInfoDTO = responseData.getResult();
                String jsonStr = JsonUtil.toJson(responseData);
                out.print(jsonStr);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            out.flush();
            out.close();
        }
    }


}
