package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller;

import com.dayouzc.e2eapp.mcard.dto.McardAllocateRecordDTO;
import com.dayouzc.e2eapp.mcard.sdk.McardAllocateSDK;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpSession;
import java.util.List;
import java.util.Map;

/**
 * Created by Mr.Liu on 2017/8/30.
 *
 * “/allocates”是卡库存调配的相关资源根目录，主要包括：
 * 注：以下rest路径中id如果=mine，表示当前token中的实体/组织/个人等。
 *
 * 1.根据客户实体查询
 * /bo/mine/allocates		    我的客户实体的调配记录
 * /bo/{boId}/allocates	        指定客户实体的调配记录	查询指定客户实体下的的调配记录
 *
 * 2.根据组织查询
 * /			                我的组织的调配记录 TODO 接口服务报错
 * /organ/{organId}/allocates	指定组织的调配记录	查询指定组织机构下的的调配记录  TODO 接口服务报错
 *
 * 3.获取详情
 * /{recordId}	                获取调配记录详情
 *
 * 4.操作类
 * /allocate		            卡调配页面
 *
 */
@Controller
@RequestMapping("/allocates")
public class MCardAllocateController {
    private static final Logger logger = LoggerFactory.getLogger(MCardAllocateController.class);

    //======================================================================================查询类=============================================================

    //----------------------------------------------根据客户实体查询

    /**我的客户实体的调配记录
     *
     */
    @RequestMapping(value = "/bo/mine/allocates")
    public String queryMCardAllocateRecordOfMineCustomer(Map<String, Object> model,HttpSession session,
                                                        @RequestParam(value = "token",required = false) String token) {

        if (StringUtils.isNotEmpty(token)){
            session.setAttribute("token",token);
        }
        token = (String) session.getAttribute("token");

        return "mcardmgr/pc/allocate/list/listOfMineBo";
    }
    /**指定客户实体的调配记录	查询指定客户实体下的的调配记录
     *
     */
    @RequestMapping(value = "/bo/{boId}/allocates")
    public String queryMCardAllocateRecordOfCustomer(Map<String, Object> model, HttpSession session,
                                                     @PathVariable("boId")String boId) {
        String token = (String) session.getAttribute("token");

        model.put("boId",boId);
        return "mcardmgr/pc/allocate/list/listOfBo";
    }

    //-----------------------------------------------------------根据组织查询

    /**我的组织的调配记录
     *
     */
    @RequestMapping(value = "")
    public String queryMCardAllocateRecord(Map<String, Object> model, HttpSession session, ModelMap map) {
        String token = (String) session.getAttribute("token");

        return "mcardmgr/pc/allocate/list/listOfMineOrgan";

    }
    /**指定组织的调配记录	查询指定组织机构下的的调配记录
     *
     */
    @RequestMapping(value = "/organ/{organId}/allocates")
    public String queryMCardAllocateRecordOfOrgan(Map<String, Object> model, HttpSession session,
                                                  @PathVariable("organId")String organId) {
        String token = (String) session.getAttribute("token");

        model.put("organId",organId);
        return "mcardmgr/pc/allocate/list/listOfOrgan";
    }

    //---------------------------------------------------------------获取详情

    /**获取调配记录详情
     *
     */
    @RequestMapping(value = "/{recordId}")
    public String getMCardAllocateRecord(Map<String, Object> model, HttpSession session,
                                         @PathVariable("recordId")String recordId) {

        String token = (String) session.getAttribute("token");

        model.put("recordId",recordId);
        return "mcardmgr/pc/allocate/info/detail";
    }


    //======================================================================================操作类==================================================================

    /**
     * 卡调配页面
     */
    @RequestMapping(value = "/allocate")
    public String allocate(Map<String, Object> model, HttpSession session, ModelMap map) {

        String token = (String) session.getAttribute("token");

        return "mcardmgr/pc/allocate/action/allocate";

    }
    @RequestMapping(value = "/allocate/submit")
    public String allocateSubmit(Map<String, Object> model, HttpSession session,
                                 McardAllocateRecordDTO mcardAllocateRecordDTO) {

        String token = (String) session.getAttribute("token");

        ResponseData<McardAllocateRecordDTO> responseData = McardAllocateSDK.getInstance().allocateApply(mcardAllocateRecordDTO,token);
        if (responseData == null) {
            String msg = "[responseData] is null";
            model.put("msg",msg);
            return "common/errorPage";
        } else if (!StringUtils.equals(responseData.getStatus(),"10000")) {
            String msg = responseData.getMsg();
            model.put("msg",msg);
            return "common/errorPage";
        } else {
            return "redirect:/allocates/bo/mine/allocates";
        }

    }
}
