package com.dayouzc.e2eapp.mcard.mcardmgr.web.api;

import com.dayouzc.e2eapp.mcard.mcardmgr.web.config.CommonConfig;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import com.dayouzc.e2eplatform.core.dto.equip.ConnectionInfoDTO;
import com.dayouzc.e2eplatform.core.dto.people.AccountDTO;
import com.dayouzc.e2eplatform.core.dto.people.OrganDTO;
import com.dayouzc.e2eplatform.core.util.HttpUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by dell on 2017/5/27.
 */
@Service
public class RegisterbindService {

    private static final Logger logger  = LoggerFactory.getLogger(RegisterbindService.class);

    @Autowired
    private CommonConfig commonConfig;
    public final ObjectMapper mapper = new ObjectMapper();

    /**
     * 查询组织下的用户列表
     * @param token
     * @return
     */
    public List<AccountDTO> getAccountList(String token){


        //组装DTO 如果需要的话

        //序列化 DTO

        //拼接URL ：IP +端口 + path + ?token=token
        //IP 从哪里拿 config.getString();
        String url = commonConfig.getRburl() + commonConfig.getRbContext(); //TODO

        url+="/accounts?token="+token+"&currPage=1&pageSize=100";
        logger.info("【查询组织下的用户列表】url:{}",url);

        //调用HttpUtils
        String jsonStr = null;
        try {

            jsonStr = HttpUtil.httpGet(url,null);
            logger.info("【查询组织下的用户列表】jsonStr:{}",jsonStr);

            if (jsonStr!=null) {
                //反序列化
                ResponseData<List<AccountDTO>> resData = new ResponseData<>();
                resData = mapper.readValue(jsonStr, new TypeReference<ResponseData<List<AccountDTO>>>() {
                });
                List<AccountDTO> list = resData.getResult();
                return list;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        //响应
        return null;
    }

    /**
     * 获取组织树
     * @param token
     * @return
     */
    public List<OrganDTO> getOrganTree(String token){
        //组装DTO 如果需要的话
        //序列化 DTO
        Map<String,String> map = new HashMap<String,String>();

        //拼接URL ：IP +端口 + path + ?token=token
        //IP 从哪里拿 config.getString();
        String url = commonConfig.getRburl() + commonConfig.getRbContext(); //TODO

        url+="/myiserver/organtree?token="+token;
        logger.info("【获取组织树】url:{}",url);

        //调用HttpUtils
        String jsonStr = HttpUtil.httpGet(url,map);
        logger.info("【获取组织树】jsonStr:{}",jsonStr);
        //反序列化

        try {
            if (jsonStr!=null) {
                ResponseData<List<OrganDTO>> resData = new ResponseData<>();
                resData = mapper.readValue(jsonStr, new TypeReference<ResponseData<List<OrganDTO>>>() {});
                List<OrganDTO> list = resData.getResult();

                return list;
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        //响应
        return null;

    }

    /**
     * 获取当前用户的链接信息
     * @param token
     * @return
     */
    public ConnectionInfoDTO getConnectionIno(String token) {

        //拼接URL ：IP +端口 + path + ?token=token
        //IP 从哪里拿 config.getString();
        String url = commonConfig.getRburl() + commonConfig.getRbContext();

        url +="/token/verify?token="+token;
        logger.info("【获取当前用户的链接信息】url:{}",url);
        //调用HttpUtils
        String jsonStr = HttpUtil.httpGet(url, null);
        logger.info("【获取当前用户的链接信息】jsonStr:{}",jsonStr);
        //反序列化

        try {

            if (jsonStr!=null) {
                ResponseData<ConnectionInfoDTO> resData = new ResponseData();
                resData = mapper.readValue(jsonStr, new TypeReference<ResponseData<ConnectionInfoDTO>>() {});
                ConnectionInfoDTO dto = resData.getResult();

                return dto;
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        //响应
        return null;
    }
}
