package com.dayouzc.e2eapp.mcard.mcardcsm.web.util.ssl;

import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HTTP;

import java.net.URI;
import java.security.KeyStore;
import java.util.List;



public class Tools {

	public static URI getURI(DefaultHttpClient client, List<NameValuePair> formparams, String getURL,String actionname){
		try{
			System.out.println("getURI=" +getURL);
			String port = "443";
			String protocl = getURL.split("://")[0];
			String url = getURL.split("://")[1];
			String certflag = "0";
			HttpParams httpparams = new BasicHttpParams();

			if(certflag.equals("0")){
				//不验证证书
				if(protocl.equals("https")) {
					// 测试模式不验证证书
					HttpProtocolParams.setVersion(httpparams, HttpVersion.HTTP_1_1);
					HttpProtocolParams.setContentCharset(httpparams, HTTP.UTF_8);
					KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
					trustStore.load(null, null);
					SSLSocketFactory sf = new ICBCSSLSocketFactory(trustStore);
					sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
					SchemeRegistry registry = new SchemeRegistry();
					registry.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));
					Scheme ssh = new Scheme("https", sf, Integer.parseInt(port));
					ClientConnectionManager ccm = new ThreadSafeClientConnManager(httpparams, registry);
					//client = new DefaultHttpClient(ccm, httpparams);
					client.getConnectionManager().getSchemeRegistry().register(ssh);
				} else {
					client = new DefaultHttpClient(httpparams);
				}
			}
			URI uri = URIUtils.createURI(protocl, url, -1, actionname, URLEncodedUtils.format(formparams, "UTF-8"),null);
			return uri;
		}catch (Exception e){
			e.printStackTrace();
			return null;
		}
	}

}
