package com.dayouzc.e2eapp.mcard.mcardcsm.web.tmp;

import com.dayouzc.e2eplatform.core.dto.equip.ConnectionInfoDTO;
import com.dayouzc.e2eplatform.core.util.DeviceUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;

/**
 * 令牌校验拦截器<br>
 *
 * @author tyutNo4
 * @date 2017/4/11
 */
public class ICBCTokenInterceptor implements HandlerInterceptor{
    private static final Logger logger = LoggerFactory.getLogger(ICBCTokenInterceptor.class);

    private static String rbweb_contextName = "mcardcsmweb";
    //去apk获取token的uri，绝对路径
    private static String uri_loginapk = "/" + rbweb_contextName + "/login/apk";
    //去微信获取token的uri，绝对路径
    private static String uri_loginweixin = "/" + rbweb_contextName + "/login/weixin";
    //去工行融e联获取token的uri，绝对路径
    private static String uri_loginicbcmims = "/" + rbweb_contextName + "/login/icbcmims";

    @Override
    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
        logger.info("");
        logger.info("=================== Web AOP - Token Interceptor start =======================");

        //记住request parameter中的uri参数，放入session，用于 业务处理完成后 获取uri 跳转回原始请求
        putOriginalUriInSession(httpServletRequest);

        //TODO 湖南公安服务平台对接，临时将code参数放session里
        String code = httpServletRequest.getParameter("code");
        if(StringUtils.isNotBlank(code)) {
            httpServletRequest.getSession().setAttribute("codeHntga", code);
        }

        //1. 从request中获取token，并校验
        String tokenFromRequest = httpServletRequest.getParameter("token");
        if(StringUtils.isNotBlank(tokenFromRequest)){
            //校验token是否合法且有效（包括：向rbsvr校验，TODO 同session里token校验？？？）
            if(ICBCE2EAppWebContext.verifyToken(httpServletRequest, tokenFromRequest)){
                ICBCE2EAppWebContext.loadContextParams(httpServletRequest);
                logger.info(" get token from request OK! ");
                return true;
            }
        }

        //2. 从session中获取token，并本地校验是否已过期
        String tokenFromSession = ICBCE2EAppWebContext.getToken(httpServletRequest);
        ConnectionInfoDTO tokenInfoFromSession = ICBCE2EAppWebContext.getTokenInfo(httpServletRequest);
        if(StringUtils.isNotBlank(tokenFromSession) && tokenInfoFromSession!=null){
            if(StringUtils.isNotBlank(tokenInfoFromSession.getTokenValidTime()) && tokenInfoFromSession.getTokenValidTime().compareTo(tokenInfoFromSession.getLastAccessTime())>=0 ){
                logger.info(" get token from session OK! ");
                return true;
            }
        }

        //3. 如果 request 和 session 里都没有token，或已失效，则获取
        //if 优先从app获取 OK，则：
        //      if 向rbsvr校验token OK，则：put到session里，并return；
        //      if 向rbsvr校验token NG，则：通知apk
		//else
        //      if 根据UA类型分别 从 微信/工行融e联/浏览器B 获取token OK，则：put到session里，并return；
		//      else if NG，则：抛出异常，跳转到错误提示页面。
        return getToken(httpServletRequest, httpServletResponse);
    }

    @Override
    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {

        logger.info("=================== Web AOP - Token Interceptor e n d =======================\n");
    }

    @Override
    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {

    }


    //-------------------- private function

    // 记住request parameter中的uri参数，放入session，用于 业务处理完成后 获取uri 跳转回原始请求
    private String putOriginalUriInSession(HttpServletRequest httpServletRequest){
//        String uri = httpServletRequest.getRequestURI();
        logger.info("request uri = [ " + httpServletRequest.getRequestURI() + " ]");

        String uri = httpServletRequest.getParameter("uri");
        logger.info("put original uri in session = [ " + uri + " ]");
        if(StringUtils.isNotBlank(uri)) {
            httpServletRequest.setAttribute("uri", uri);
            httpServletRequest.getSession().setAttribute("uri", uri);
        }
        return uri;
    }

    //重定向到指定的url
    private void redirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String url) throws IOException{
        StringBuffer redirectUrl = new StringBuffer(url);

        //获取请求报文【TODO是否需要保存，可以稍后考虑】
        //uri 跳转的时候，使用当前uri作为跳转的request parameter
//        String uri = (String)httpServletRequest.getSession().getAttribute("uri");
        StringBuffer uri = new StringBuffer(httpServletRequest.getRequestURI());
        Map<String, String[]> parameterMap = httpServletRequest.getParameterMap();
        if (parameterMap != null && !parameterMap.isEmpty()) {
            Set<Map.Entry<String, String[]>> entries = parameterMap.entrySet();
            int i = 0;
            for (Map.Entry<String, String[]> entry : entries) {
                if (i == 0) {
                    uri.append("?" + entry.getKey() + "=" + entry.getValue()[0]);
                } else {
                    uri.append("&" + entry.getKey() + "=" + entry.getValue()[0]);
                }
                i++;
            }
        }
        logger.info("original Url = [ " + uri.toString() + " ]");
        redirectUrl.append("?uri=").append(URLEncoder.encode(uri.toString(), "UTF-8"));

        //appId
        String appId = httpServletRequest.getParameter("appId");
        if (StringUtils.isNotEmpty(appId)) {
            httpServletRequest.setAttribute("appId", appId);
            httpServletRequest.getSession().setAttribute("appId", appId);

            redirectUrl.append("&appid=").append(appId);
        }

        //TODO 需将原始uri放在url的parameter中？？？
        logger.info("redirectUrl = [ " + redirectUrl + " ]");
        httpServletResponse.sendRedirect(redirectUrl.toString());
    }

    /**
     *  获取令牌
     * @param httpServletRequest
     * @param httpServletResponse
     * @return 如果获取成功，则返回true；如果跳转到其他uri去处理了，则返回false。
     */
    private boolean getToken(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        //1.判断客户端类型
        String clientType = handleUserAgent4ClientType(httpServletRequest);
        logger.info(" to get token with clientType = [ {} ]", clientType);

        //2.根据客户端类型跳转至各自获取令牌的实现方法中
        switch (clientType) {
            case "mobile weixin":   //手机微信
                return getMobileWeixinToken(httpServletRequest, httpServletResponse);
            case "icbc mims" :
                return getICBCMIMSToken(httpServletRequest, httpServletResponse);
            case "android webview": //安卓APP
                return getAndroidAppToken(httpServletRequest, httpServletResponse);
            case "ios webview" :
                return getIOSAppToken(httpServletRequest, httpServletResponse);
            case "browser": // PC/手机 浏览器
                return getPcBrowserToken(httpServletRequest, httpServletResponse);
            /*case "youpie app"://有派APP
                getYoupieAppToken(httpServletRequest, httpServletResponse, uri);
                break;
            case "mobile app"://手机APP（包含android、iOS）
                getMobileAppToken(httpServletRequest, httpServletResponse, uri);
                break;
            case "mobile browser"://手机浏览器
                getMobileBrowserToken(httpServletRequest, httpServletResponse, uri);
                break;
            case "pc browser"://PC浏览器
                getPcBrowserToken(httpServletRequest, httpServletResponse, uri);
                break;*/
            default:    //默认是PC浏览器
                return getPcBrowserToken(httpServletRequest, httpServletResponse);
        }
    }

    /**
     *  根据User-Agent判断客户端类型
     * @param httpServletRequest
     * @return  客户端类型
     */
    private String handleUserAgent4ClientType(HttpServletRequest httpServletRequest) {
        String clientType = "";
        if (DeviceUtils.isWeChat(httpServletRequest)) {
            clientType = "mobile weixin";
        } else if(DeviceUtils.isICBCMIMS(httpServletRequest)) {
            clientType = "icbc mims";
        } else if (DeviceUtils.isAndroidWebview(httpServletRequest)) {
            clientType = "android webview";
        } else if (DeviceUtils.isIOSWebview(httpServletRequest)) {
            clientType = "ios webview";
        } else {
            clientType = "browser";
        }

        httpServletRequest.getHeader("");//TODO 自定义header
        return clientType;
    }

    /**
     *  获取令牌_手机微信
     */
    private boolean getMobileWeixinToken(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        //跳转至中转controller获取openId， 需要考虑显示传输：appId or 做个映射
        redirect(httpServletRequest, httpServletResponse, uri_loginweixin);
        return false;
    }

    /**
     *  获取令牌_工行融e联
     */
    private boolean getICBCMIMSToken(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        //跳转至中转controller获取openId， 需要考虑显示传输：appId or 做个映射
        redirect(httpServletRequest, httpServletResponse, uri_loginicbcmims);
        return false;
    }

    /**
     *  获取令牌_安卓APP
     */
    private boolean getAndroidAppToken(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        //跳转至中转jsp（init.jsp)页面通过js调用app的获取令牌
//        httpServletRequest.getRequestDispatcher("/login/apk").forward(httpServletRequest, httpServletResponse);
        redirect(httpServletRequest, httpServletResponse, uri_loginapk);
        return false;
    }

    /**
     *  获取令牌_iOS APP
     */
    private boolean getIOSAppToken(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        //TODO web从iOS app 获取token的方法
        return false;
    }

    /**
     *  获取令牌_手机浏览器
     */
    private boolean getMobileBrowserToken(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        //仅仅是获取token，不一定需要用户信息
        logger.info(" get mobile brower token OK! ");
        return ICBCE2EAppWebContext.login(httpServletRequest);
    }

    /**
     *  获取令牌_PC浏览器      √
     * @param httpServletRequest
     * @param httpServletResponse
     */
    private boolean getPcBrowserToken(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        //仅仅是获取token，不一定需要用户信息
        logger.info(" get PC brower token OK! ");
        return ICBCE2EAppWebContext.login(httpServletRequest);
    }

}
