package com.dayouzc.e2eapp.mcard.mcardcsm.web.tmp;

import com.alibaba.fastjson.JSONObject;
import com.dayouzc.e2eplatform.core.dto.people.AccountDTO;
import com.dayouzc.e2eplatform.core.util.HttpUtils;
import com.dayouzc.e2eplatform.core.util.NetworkUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * 工行融e联获取令牌。
 *
 * Created by fish on 2018/12/7.
 */
@Controller
@RequestMapping("/login/icbcmims")
public class ICBCMIMSLoginController {
    private static final Logger logger = LoggerFactory.getLogger(ICBCMIMSLoginController.class);

    /** 公众号appid */
    private String appId = "x8eaGerBkD8LNWWKUqXa2Q==";
    private String appName = "融e联锦绣潇湘旅游卡";

    @RequestMapping("")
    public String getToken(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        putOriUri2Session(request, session);

        //openId
        Object openIdObj = session.getAttribute("openId");
        if (openIdObj == null || !(openIdObj instanceof String)) {//openId为空，需要重新获取
            String authorizeUrl = authorize(request, appId);
            return "redirect:" + authorizeUrl;
        }
        String openId = (String) openIdObj;

        //2 获取令牌 TODO
        //融e联公众号id
        String mimsPId = appId;
        //融e联公众号名称
        String mimsPName = appName;
        //待定
        String dyopenId = "";
        //融e联公众号获取的用户信息，包括：名称、手机号、等 TODO
        AccountDTO account = new AccountDTO();

        ICBCE2EAppWebContext.loginByICBCMIMS(request, openId, mimsPId, mimsPName, dyopenId, account);

        //3 重定向至源uri
        return redirectOriUri(request, response, session);
    }

    /**
     *  融e联授权代码组织
     * @return 返回授权完整uri
     * @param tappId
     */
    private String authorize(HttpServletRequest request, String tappId) {

        String basePath = NetworkUtils.getBasePath(request);
        logger.info("basePath = [ {} ]", basePath);

        String appId = tappId;
        String redirectUrl = basePath+"/login/icbcmims/oauth2";
        String scope = "userinfo";
        try {
            redirectUrl = URLEncoder.encode(redirectUrl, "UTF-8");
            appId = URLEncoder.encode(appId, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String url = "https://imapi.icbc.com.cn/open/oauth2?appid="+appId+"&redirect=" + redirectUrl +"&scope=" + scope;
        return url;
    }


    /**
     *  融e联授权回调
     * @return  获取openId
     */
    @RequestMapping(value = "/oauth2")
    public String oauth2(HttpServletRequest request, HttpSession session) throws IOException {

        //1 获取准备数据
        String code = request.getParameter("code");
        String state = request.getParameter("state");
        logger.info("公众号认证"+code);
        logger.info("state = [ " + state + " ]");

//        if(code ==null){
//            return new ForwardResolution("");//TODO
//        }

        String tokenUrl = "https://imapi.icbc.com.cn/open/oauth2/access_token";
        StringBuffer url = new StringBuffer(tokenUrl);

        String appId = this.appId;
        appId = URLEncoder.encode(appId, "UTF-8");
        code = URLEncoder.encode(code, "UTF-8");
        url.append("?appid=").append(appId);
        url.append("&code=").append(code);

        //2 获取openId
        String accessToken = HttpUtils.get(url.toString());
        logger.info("accessToken = [ " + accessToken + " ]");
        JSONObject jsonObject = JSONObject.parseObject(accessToken);
        String openId = jsonObject.getString("openid");
        String access_token = jsonObject.getString("access_token");

        session.setAttribute("openId", openId);

        //通过openid和access_token获取用户信息
        openId = URLEncoder.encode(openId, "UTF-8");
        access_token = URLEncoder.encode(access_token, "UTF-8");
        String getUserInfoUrl = "https://imapi.icbc.com.cn/open/oauth2/userinfo?access_token=" + access_token + "&openid=" + openId;
        String userInfo = HttpUtils.get(getUserInfoUrl);
        logger.info("userInfo = [ " + userInfo + " ]");
        JSONObject userInfoJsonObject = JSONObject.parseObject(userInfo);
        //TODO 报文字段	说明
//        subscribe	用户是否订阅该公众号标识，值为0时，代表此用户没有关注该公众号，拉取不到其余信息。
//        openid	用户的标识，对当前公众号唯一
//        nickname	用户的昵称
//        sex	用户的性别，值为1时是男性，值为0时是女性
//        city	用户所在城市
//        province	用户所在省份
//        portrait	用户头像
//        cisno	客户信息号，行内公众号返回，不存在则返回空
//        unino	统一认证号，行内公众号返回，不存在则返回空
//        ICBCUserid	统一通行证号，行内公众号返回，不存在则返回空
//        mobileno	手机号，scope为base、basevisit、baseinfo、userallow、companybase返回，不存在则返回空。其他的scope类型，该字段不返回（不是返回为空）

        //3 重定向至发起授权界面
        String redirectUrl = NetworkUtils.getBasePath(request) + "/login/icbcmims";
        return "redirect:" + redirectUrl;
    }

    //------------- private function

    //从request参数里取得原始uri，并放入session，用于submit时重定向
    private void putOriUri2Session(HttpServletRequest request, HttpSession session){
        String uri = request.getParameter("uri");
        if(StringUtils.isNotBlank(uri)) {
            session.setAttribute("uri", uri);
        }
    }

    //从session里取原始uri，并重定向
    private String redirectOriUri(HttpServletRequest request,
                                  HttpServletResponse response,
                                  HttpSession session){
        String url = (String) session.getAttribute("uri");
        try {
            response.sendRedirect(url + "?token=" + ICBCE2EAppWebContext.getToken(request));
            return null;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

}
