package com.dayouzc.e2eapp.mcard.mcardcsm.web.tmp;

import com.dayouzc.e2eplatform.core.context.E2EAppWebContext;
import com.dayouzc.e2eplatform.core.dto.equip.ConnectionInfoDTO;
import com.dayouzc.e2eplatform.registerbind.constant.TokenConstant;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;

/**
 * 对 上下文环境Context中用户信息 的校验拦截器。
 *
 * 如果Context中没有用户信息，则需要登录：
 * 1.如果是app，则由app处理用户登录；
 * 2.如果浏览器（微信/融e联/其他浏览器/等），则进入用户登录页面。
 *
 * @author fish
 * @date 2018/12/06
 */
public class ICBCContextAccountInterceptor implements HandlerInterceptor{
    private static final Logger logger = LoggerFactory.getLogger(ICBCContextAccountInterceptor.class);

    private static String rbweb_contextName = "rbweb";
    //向apk通知异常的页面uri，绝对路径
    private static String uri_notifyex2apk = "/" + rbweb_contextName + "/e2eerror/apk";
    //使用用户信息登录绑定的页面uri，绝对路径
    private static String uri_login = "/" + rbweb_contextName + "/login";

    @Override
    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
        logger.info("");
        logger.info("=================== Web AOP - Context Account Interceptor start =======================");
        logger.info("request uri = [ " + httpServletRequest.getRequestURI() + " ]");

        //获取context
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo(httpServletRequest);

        if(tokenInfo==null || StringUtils.isBlank(tokenInfo.getToken())){   //这种情况应该被TokenInterceptor拦截了，写此仅为了保证代码的完整性
            logger.info(" token is null :( ?????? ");
            return false;
        }else if(StringUtils.isBlank(tokenInfo.getAccountId())){    //token没有用户信息
            if(StringUtils.equals(tokenInfo.getAppType(), "APP")){  //if 是app，则：通知apk
                String status = TokenConstant.ErrorCode.EXCP_STATUS_ACCOUNT_ISNULL;
                String msg = TokenConstant.ErrorCode.map.get(TokenConstant.ErrorCode.EXCP_STATUS_ACCOUNT_ISNULL);

                //处理跳转url
                StringBuffer redirectUrl = new StringBuffer(uri_notifyex2apk);
                redirectUrl.append("?status=").append(status);
                redirectUrl.append("&msg=").append(msg);
                logger.info(" app type is APP, so redirect to [ " + redirectUrl );

                //跳转到js通知apk去处理用户login
                httpServletResponse.sendRedirect(redirectUrl.toString());
                return false;
            }else { //if 是浏览器（微信/融e联/其他浏览器），则：登录绑定用户页（含：注册用户页）
//                httpServletRequest.getRequestDispatcher(uri_login).forward(httpServletRequest, httpServletResponse);

                //处理跳转url
                StringBuffer redirectUrl = new StringBuffer(uri_login);

                String uri;
                String method = httpServletRequest.getMethod();
                // 只有get方法访问时才从parameter中获取；TODO post方式如何传递是个问题？
                if (StringUtils.equalsIgnoreCase("post", method)) {
                    //TODO uri 的优先获取方式需要考虑，按理说是获取当前访问页面的uri，和前面拦截器存储的uri没有逻辑关系
                    // post 方式时获取的是当前页面且不对参数进行处理 TODO 如果获取不到怎么办呢？
                    uri = (String) httpServletRequest.getSession().getAttribute("uri");
                } else {
                    // 其他get、put等分支
                    //TODO uri 的优先获取方式需要考虑，按理说是获取当前访问页面的uri，和前面拦截器存储的uri没有逻辑关系
                    StringBuffer uriBuffer = new StringBuffer(httpServletRequest.getRequestURI());
                    Map<String, String[]> parameterMap = httpServletRequest.getParameterMap();
                    if (parameterMap != null && !parameterMap.isEmpty()) {
                        Set<Map.Entry<String, String[]>> entries = parameterMap.entrySet();
                        int i = 0;
                        for (Map.Entry<String, String[]> entry : entries) {
                            if (i == 0) {
                                uriBuffer.append("?" + entry.getKey() + "=" + entry.getValue()[0]);
                            } else {
                                uriBuffer.append("&" + entry.getKey() + "=" + entry.getValue()[0]);
                            }
                            i++;
                        }
                    }
                    uri = uriBuffer.toString();
                }
                logger.info("original Url = [ " + uri.toString() + " ]");
                redirectUrl.append("?uri=").append(URLEncoder.encode(uri.toString(), "UTF-8"));
                redirectUrl.append("&token=").append(tokenInfo.getToken());
                logger.info(" app type is browser, so redirect to [ " + redirectUrl );

                //跳转到用户登录页面
                httpServletResponse.sendRedirect(redirectUrl.toString());
                return false;
            }
        }else { //token已有用户信息
            logger.info(" token has account info !");
            return true;
        }
    }

    @Override
    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {

        logger.info("=================== Web AOP - Context Account Interceptor e n d =======================\n");
    }

    @Override
    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {

    }

}
