package com.dayouzc.e2eapp.mcard.mcardcsm.web.controller;

import com.dayouzc.e2eapp.mcard.constant.McardInfoConstant;
import com.dayouzc.e2eapp.mcard.dto.*;
import com.dayouzc.e2eapp.mcard.sdk.McardInfoSDK;
import com.dayouzc.e2eapp.mcard.sdk.McardTypeSDK;
import com.dayouzc.e2eplatform.common.dto.VerifyCodeDTO;
import com.dayouzc.e2eplatform.common.sdk.VerifyCodeSDK;
import com.dayouzc.e2eplatform.core.common.ConditionRangeValue;
import com.dayouzc.e2eplatform.core.context.E2EAppWebContext;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import com.dayouzc.e2eplatform.core.dto.equip.ConnectionInfoDTO;
import com.dayouzc.e2eplatform.core.dto.people.AccountDTO;
import com.dayouzc.e2eplatform.core.util.BarcodeUtil;
import com.dayouzc.e2eplatform.core.util.JsonUtil;
import com.dayouzc.e2eplatform.core.util.QRCodeUtil;
import com.dayouzc.e2eplatform.registerbind.constant.AccountConstant;
import com.dayouzc.e2eplatform.registerbind.sdk.people.AccountSDK;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Mr.Liu on 2017/8/8.
 *
 * “/mcards”是卡相关资源根目录，主要包括：
 *
 * 1.查询类（买家角度）
 * /                        卡查询页面。            根据卡号查询并显示卡简要信息页面。如果指定了typeId参数，则校验输入的卡号是否为指定的卡类型。
 * /mine		            我的卡包页面。          list当前用户已绑定的卡（包括所有状态）。如果指定了typeId参数，则仅查询指定卡类型的卡。
 * /mine/hntga		        【湖南公安服务平台】我绑定的卡列表
 * /mine/activecodes	    我的激活码页面页面。    list当前用户购买的且待绑定的卡。如果指定了typeId参数，则仅查询指定卡类型的卡。
 * /mine/etickets		    我的电子门票页面。      list当前用户已绑定的卡（仅正常状态）的电子门票。如果指定了typeId参数，则仅查询指定卡类型的卡。
 *
 * /TODO 临时添加 后期会替代/mine/etickets资源
 * /mine/etickets/v2		我的卡包[预约系统 我的卡包]。 list当前用户已绑定的卡（仅正常状态）的电子门票列表和预约订单的列表
 *
 * /TODO 我的电子门票测试页面（新效果的测试页面）
 * /mine/eticketsTest       【测试新效果】我的电子门票页面。list当前用户已绑定的卡（仅正常状态）的电子门票。如果指定了typeId参数，则仅查询指定卡类型的卡。
 *
 * 2.卡 详情
 * /{cardNum}			    卡基本信息页面。        包括卡基本信息，以及绑定信息、验证码等。
 * /{cardNum}/detail	    卡详细信息页面。        包括卡基本信息以及相关信息的链接等。
 * /{cardNum}/brief         卡简要信息页面。        仅显示卡号/卡类型/状态等简要信息，如果显示绑定信息也需要加密显示。一般用于他人查询显示用。
 * /{cardNum}/suitablemc	会员卡适用景区页面。    显示会员卡适用景区列表。
 * /{cardNum}/reservemc	    会员卡可预约景区页面。  显示会员卡适用景区范围内可预约景区列表。
 *
 * 3.操作类(买家角度)
 * /bind		            会员卡绑定页面。        将指定的卡绑定到当前用户。
 * /bindForOther	        会员卡绑定代办页面      将指定的会员卡绑定到指定用户，用于帮人绑定。
 * /reserve			        会员卡预约页面。        如果指定了cardNum则显示指定卡的预约页面，否则可在我的所有卡之间切换。
 *
 */
@Controller
@RequestMapping("/mcards")
public class MCardInfoController {
    private static final Logger logger = LoggerFactory.getLogger(MCardInfoController.class);

    // ================兼容老系统数据 by 刘凡 2019年4月29日14:13:07 Start
    /** 卡类型状态 10：待审核 11：审核通过 12:审核驳回 13 ：自动审核通过 */
    private static final String MCARD_TYPE_STATUS_INIT = "11";
    /** 是否开通会员自主申请虚拟卡。 0：否 1：是 */
    private static final String MCARD_TYPE_IS_ABLE_APPLY_CARD = "1";

    // ================兼容老系统数据 by 刘凡 2019年4月29日14:13:07 end


    //====================== 查询类（买家角度）

    /** 卡查询页面。
     * 根据卡号查询并显示卡简要信息页面。如果指定了typeId参数，则校验输入的卡号是否为指定的卡类型。
     *
     *  TODO 0.参照常德等公众号的功能进行；1.输入卡号的提示；2.卡类型简介、主办单位、承办单位；3.同意条款。。。
     * @param cardNum   如果指定了卡号，则显示指定卡号的简要信息；否则，可以输入卡号查询。
     * @param typeId    如果指定了typeId，则校验卡号对应的卡类型是否匹配，如果不匹配，则提示且不显示卡简要信息。
     * @return
     */
    @RequestMapping(value = "")
    public String getMCardInfoInfo(Map<String, Object> model, HttpSession session,
                                   @RequestParam(value = "cardNum",required = false)String cardNum,
                                   @RequestParam(value = "typeId",required = false)String typeId){
        return "mcardcsm/mcardinfo/list/query";
    }

    /**我的卡包页面。
     * list当前用户已绑定的卡（包括所有状态）。如果指定了typeId参数，则仅查询指定卡类型的卡。
     */
    @RequestMapping(value = "/mine")
    public String getMCardInfoListOfMine(
            Map<String, Object> model,
            HttpSession session,
            @RequestParam(value = "token",required = false)String token) {

        if(StringUtils.isNoneEmpty(token)){
            session.setAttribute("token",token);
        }
        token = (String) session.getAttribute("token");

        Pageable pageable = new PageRequest(1,100);
        McardInfoDTO mcardInfoDTO = new McardInfoDTO();
        /*查询卡状态为"正常"的卡*/
        mcardInfoDTO.setCardStatus(McardInfoConstant.MCardStatus.NORMAL);
        ResponseData<List<McardInfoDTO>> responseData = McardInfoSDK.getInstance().getMCardInfoListOfMine( mcardInfoDTO, pageable,token);
        model.put("mcardInfoList", responseData.getResult());
        //3.推荐会员卡类型
        McardTypeDTO mcardType = new McardTypeDTO();
        /*默认查状态为“审核通过”的卡类型*/
        mcardType.setTypeStatus(MCARD_TYPE_STATUS_INIT);
        /*默认查询"开通会员自主申请虚拟卡"的卡类型 */
        mcardType.setIsAbleApplyCard(MCARD_TYPE_IS_ABLE_APPLY_CARD);
        ResponseData<List<McardTypeDTO>> responseDataCardType = McardTypeSDK.getInstance().queryMCardType(mcardType, null, null, token);
        model.put("mcardTypeList", responseDataCardType.getResult());

        return "mcardcsm/mcardinfo/list/list";
    }

    /*========================================TODO liufan 2019年10月30日19:14:54 添加支持对湖南公安服务平台旅游卡 START====================================================*/
    /**我的卡包页面。
     * list当前用户已绑定的卡（包括所有状态）。如果指定了typeId参数，则仅查询指定卡类型的卡。
     */
    @RequestMapping(value = "/mine/hntga")
    public String getMCardInfoListOfMineHntga(
            Map<String, Object> model,
            HttpSession session,
            HttpServletRequest request,
            @RequestParam(value = "code",required = false)String code,
            @RequestParam(value = "token",required = false)String token) {

        if(StringUtils.isNoneEmpty(token)){
            session.setAttribute("token",token);
        }
        token = (String) session.getAttribute("token");

        Pageable pageable = new PageRequest(1,100);
        McardInfoDTO mcardInfoDTO = new McardInfoDTO();
        /*查询卡状态为"正常"的卡*/
        mcardInfoDTO.setCardStatus(McardInfoConstant.MCardStatus.NORMAL);
        ResponseData<List<McardInfoDTO>> responseData = McardInfoSDK.getInstance().getMCardInfoListOfMine( mcardInfoDTO, pageable,token);
        if(responseData != null){
            if(StringUtils.equals(responseData.getStatus(),"10000")){
                List<McardInfoDTO> mcardInfos = responseData.getResult();
                if(mcardInfos != null && mcardInfos.size() > 0){
                    for(McardInfoDTO mc : mcardInfos){
                        /*卡号*/
                        String cardNum = mc.getCardNum();
                        /*条形码生成规则*/
                        String QRCodeRule = "K"+cardNum;
                        /*生成的二维码*/
//                        String QRCode = QRCodeUtil.generalQRCode(QRCodeRule,150,150);
                        /*生成的条形码*/
                        String barCode = BarcodeUtil.generateBarCode128(QRCodeRule,"0.4", "10");
                        mc.setCardNum2(barCode);
                    }

                    model.put("mcardInfoList", mcardInfos);
                }
            }
        }

        //湖南公安服务平台，获取用户身份证信息
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo(request);
        Map<String, String> sexMap = AccountConstant.Sex.map;
        Map<String, String> cardStatusMap = McardInfoConstant.MCardStatus.map;
        model.put("accountInfo",tokenInfo.getAccount());
        model.put("sexMap",sexMap);
        model.put("cardStatusMap",cardStatusMap);

        return "mcardcsm/mcardinfo/hntga/list";

    }
    /*========================================TODO liufan 2019年10月30日19:14:54 添加支持对湖南公安服务平台旅游卡  END====================================================*/


    /**我的激活码页面页面。
     * list当前用户购买的且待绑定的卡。如果指定了typeId参数，则仅查询指定卡类型的卡。
     *
     * TODO 区域标题块需要bold字体加粗
     */
    @RequestMapping(value = "/mine/activecodes")
    public String getMyActiveCodeList(Map<String, Object> model, HttpSession session,
                                      HttpServletRequest request,
                                      @RequestParam(value = "typeId",required = false)String typeId,
                                      @RequestParam(value = "token",required = false)String token){
        if(StringUtils.isNoneEmpty(token)){
            session.setAttribute("token",token);
        }
        token = (String) session.getAttribute("token");


        //1、获取我可激活的卡列表（我已购买，且状态=待激活的卡）
        ResponseData<List<McardInfoDTO>> responseData1 = McardInfoSDK.getInstance().getMCardActiveCodeListOfMine(typeId, null, null, token);
        model.put("mcardInfos", responseData1.getResult());

        //2、查询卡类型信息
        if(StringUtils.isNotBlank(typeId)) {
            ResponseData<McardTypeDTO> responseData = McardTypeSDK.getInstance().getMCardType(typeId, token);
            model.put("mcardType", responseData.getResult());
//        }else if(responseData1!=null && StringUtils.equals(responseData1.getStatus(), "10000") && responseData1.getResult()!=null && !responseData1.getResult().isEmpty()){
//            McardInfoDTO mcard = responseData1.getResult().get(0);
//            ResponseData<McardTypeDTO> responseData = McardTypeSDK.getInstance().getMCardType(mcard.getTypeId(), token);
//            model.put("mcardType", responseData.getResult());
        }
        //3.推荐会员卡类型
        McardTypeDTO mcardType = new McardTypeDTO();
        /*默认查状态为“审核通过”的卡类型*/
        mcardType.setTypeStatus(MCARD_TYPE_STATUS_INIT);
        /*默认查询"开通会员自主申请虚拟卡"的卡类型 */
        mcardType.setIsAbleApplyCard(MCARD_TYPE_IS_ABLE_APPLY_CARD);
        ResponseData<List<McardTypeDTO>> responseDataCardType = McardTypeSDK.getInstance().queryMCardType(mcardType, null, null, token);
        model.put("mcardTypeList", responseDataCardType.getResult());

        if(StringUtils.isNoneBlank(typeId)){
            return "mcardcsm/mcardinfo/list/activecodesByTypeId";
        }else{
            return "mcardcsm/mcardinfo/list/activecodes";
        }


    }

    /**我的电子门票页面。
     * list当前用户已绑定的卡（仅正常状态）的电子门票。如果指定了typeId参数，则仅查询指定卡类型的卡。
     *
     * TODO 应只包括正常状态的卡
     */
    @RequestMapping(value = "/mine/etickets")
    public String getMyETicketList(
            Map<String, Object> model,
            HttpSession session,
            @RequestParam(value = "typeId",required = false)String typeId,
            @RequestParam(value = "cardNum",required = false)String cardNum,
            @RequestParam(value = "token",required = false)String token){

//        if(StringUtils.isNoneEmpty(token)){
//            session.setAttribute("token",token);
//        }
//        token = (String) session.getAttribute("token");

        //1、查询卡类型信息
//        McardInfoDTO queryParam = new McardInfoDTO();
//        queryParam.setTypeId(typeId);
//        queryParam.setCardNum(cardNum);
//        queryParam.setCardStatus(McardInfoConstant.MCardStatus.NORMAL);
//        //我个人绑定的卡（买家）
//        ResponseData<List<McardInfoDTO>> responseData = McardInfoSDK.getInstance().getMCardInfoListOfMine(queryParam, null, token);
//        model.put("mcardInfos", responseData.getResult());

        //3.推荐会员卡类型 TODO 暂时隐藏 by ljn 2020年4月17日14:02:30
//        McardTypeDTO mcardType = new McardTypeDTO();
//        mcardType.setTypeId(typeId);
//        /*默认查状态为“审核通过”的卡类型*/
//        mcardType.setTypeStatus(MCARD_TYPE_STATUS_INIT);
//        /*默认查询"开通会员自主申请虚拟卡"的卡类型 */
//        mcardType.setIsAbleApplyCard(MCARD_TYPE_IS_ABLE_APPLY_CARD);
//        ResponseData<List<McardTypeDTO>> responseDataCardType = McardTypeSDK.getInstance().queryMCardType(mcardType, null, null, token);
//        model.put("mcardTypeList", responseDataCardType.getResult());

        return "mcardcsm/mcardinfo/list/etickets";
    }

    /**预约系统 我的卡包 。
     * list当前用户已绑定的卡（仅正常状态）的电子门票。包含 我的卡的列表和预约订单的列表
     *
     * TODO 测试新效果的页面
     */
    @RequestMapping(value = "/mine/etickets/v2")
    public String getMyETicketListV2(Map<String, Object> model, HttpSession session,
                                       @RequestParam(value = "typeId",required = false)String typeId,
                                       @RequestParam(value = "cardNum",required = false)String cardNum,
                                       @RequestParam(value = "token",required = false)String token){

        if(StringUtils.isNoneEmpty(token)){
            session.setAttribute("token",token);
        }
        token = (String) session.getAttribute("token");

        /*获取当前用户的信息*/
        ResponseData<AccountDTO> responseData = AccountSDK.getInstance().getAccountOfMine(token);
        if (responseData != null) {
            model.put("account", responseData.getResult());
        }
        Map<String, String> idTypeMap = AccountConstant.IdentityType.map;
        model.put("idTypeMap",idTypeMap);

        model.put("typeId", typeId);
        model.put("cardNum", cardNum);

        return "mcardcsm/mcardinfo/list/etickets_v2";
    }

    /**【测试】我的电子门票页面。
     * list当前用户已绑定的卡（仅正常状态）的电子门票。如果指定了typeId参数，则仅查询指定卡类型的卡。
     *
     * TODO 测试新效果的页面
     */
    @RequestMapping(value = "/mine/eticketsTest")
    public String getMyETicketListTest(Map<String, Object> model, HttpSession session,
                                   @RequestParam(value = "typeId",required = false)String typeId,
                                   @RequestParam(value = "cardNum",required = false)String cardNum,
                                   @RequestParam(value = "token",required = false)String token){

        if(StringUtils.isNoneEmpty(token)){
            session.setAttribute("token",token);
        }
        token = (String) session.getAttribute("token");

        //1、查询卡类型信息
//        McardInfoDTO queryParam = new McardInfoDTO();
//        queryParam.setTypeId(typeId);
//        queryParam.setCardNum(cardNum);
//        queryParam.setCardStatus(McardInfoConstant.MCardStatus.NORMAL);
//        //我个人绑定的卡（买家）
//        ResponseData<List<McardInfoDTO>> responseData = McardInfoSDK.getInstance().getMCardInfoListOfMine(queryParam, null, token);
//        model.put("mcardInfos", responseData.getResult());

        //3.推荐会员卡类型 TODO 暂时隐藏 by ljn 2020年4月17日14:02:30
//        McardTypeDTO mcardType = new McardTypeDTO();
//        mcardType.setTypeId(typeId);
//        /*默认查状态为“审核通过”的卡类型*/
//        mcardType.setTypeStatus(MCARD_TYPE_STATUS_INIT);
//        /*默认查询"开通会员自主申请虚拟卡"的卡类型 */
//        mcardType.setIsAbleApplyCard(MCARD_TYPE_IS_ABLE_APPLY_CARD);
//        ResponseData<List<McardTypeDTO>> responseDataCardType = McardTypeSDK.getInstance().queryMCardType(mcardType, null, null, token);
//        model.put("mcardTypeList", responseDataCardType.getResult());

        return "mcardcsm/mcardinfo/list/etickets_test";
    }
    //======================== 卡 详情

    /**卡基本信息页面。
     * 包括卡基本信息，以及绑定信息、验证码等。
     *
     * @param model
     * @param session
     * @return
     */
    @RequestMapping(value = "/{cardNum}")
    public String getMCardInfo(Map<String, Object> model, HttpSession session,
                                @PathVariable("cardNum")String cardNum) {

        String token = (String) session.getAttribute("token");

        //查询会员卡信息
        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().getMCardinfo(cardNum,token);
        if(responseData != null){
            McardInfoDTO mcardInfo = responseData.getResult();
            model.put("mcardInfo", mcardInfo);
            //获取卡类型信息
            ResponseData<McardTypeDTO> responseData1 = McardTypeSDK.getInstance().getMCardType( mcardInfo.getTypeId(),token);
            model.put("mcardType",responseData1.getResult());
        }
        //查询会员卡用卡记录
        ConditionRangeValue rangeValue = new ConditionRangeValue();
        PageRequest pageRequest = new PageRequest(1,100);
        ResponseData<List<McardRecordDTO>> responseData2 = McardInfoSDK.getInstance().queryMCardRecordOfCard(cardNum, rangeValue,
                pageRequest, token);
        model.put("mcardRecordList",responseData2.getResult());


        return "mcardcsm/mcardinfo/detail/baseinfo";

    }

    /**卡详细信息页面。
     * 包括卡基本信息以及相关信息的链接等。
     * @param model
     * @param session
     * @return
     */
    @RequestMapping(value = "/{cardNum}/detail")
    public String getMCardInfoDetails(Map<String, Object> model, HttpSession session,
                               @PathVariable("cardNum")String cardNum) {

        String token = (String) session.getAttribute("token");

        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().getMCardinfo(cardNum,token);

        if(responseData != null){
            McardInfoDTO mcardInfo = responseData.getResult();
            model.put("mcardInfo", mcardInfo);
            //获取卡类型信息
            ResponseData<McardTypeDTO> responseData1 = McardTypeSDK.getInstance().getMCardType( mcardInfo.getTypeId(),token);
            model.put("mcardType",responseData1.getResult());
        }

        return "mcardcsm/mcardinfo/detail/detail";
    }

    /**卡简要信息页面。
     * 仅显示卡号/卡类型/状态等简要信息，如果显示绑定信息也需要加密显示。一般用于他人查询显示用。
     *
     * TODO 功能需要实现，jsp需要写代码
     * @return
     */
    @RequestMapping(value = "/{cardNum}/brief")
    public String getMCardInfoBrief(Map<String, Object> model, HttpSession session,
                                      @PathVariable("cardNum")String cardNum) {
        String token = (String) session.getAttribute("token");

        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().getMCardinfo(cardNum,token);

        if(responseData != null){
            McardInfoDTO mcardInfo = responseData.getResult();
            model.put("mcardInfo", mcardInfo);
            //获取卡类型信息
            ResponseData<McardTypeDTO> responseData1 = McardTypeSDK.getInstance().getMCardType( mcardInfo.getTypeId(),token);
            model.put("mcardType",responseData1.getResult());
        }

        return "mcardcsm/mcardinfo/detail/brief";
    }

    /**会员卡适用景区页面。
     * 显示会员卡适用景区列表。
     *
     * TODO 这个页面服务和/{typeId}/suitablemc整合为一个，即只有一个实现代码和jsp，另一个直接redirect
     * @param cardNum
     * @return
     */
    @RequestMapping(value = "/{cardNum}/suitablemc")
    public String queryMcardSuitableMc(Map<String, Object> model, HttpSession session,
                               @PathVariable("cardNum")String cardNum) {
        String token = (String) session.getAttribute("token");
        Pageable pageable = new PageRequest(0,100);

        //查询卡信息
        ResponseData<McardInfoDTO> mcardInfoResponseData = McardInfoSDK.getInstance().getMCardinfo(cardNum, token);
        McardInfoDTO mcardInfo = mcardInfoResponseData.getResult();
        String typeId = mcardInfo.getTypeId();

        //卡类型的年卡商铺
        McardCmfreeDTO mcardCmfreeDTO = new McardCmfreeDTO();
        ResponseData<List<McardCmfreeDTO>> freeResponseData = McardTypeSDK.getInstance().queryCmfreeOfMCardType( typeId, mcardCmfreeDTO, null, pageable,token);

        //卡类型的优惠商铺
        McardMccatalogDTO mcardMccatalogDTO = new McardMccatalogDTO();
        ResponseData<List<McardMccatalogDTO>> logResponseData = McardTypeSDK.getInstance().queryMccatalogOfMCardType(typeId,mcardMccatalogDTO,null,pageable,token);

        if (freeResponseData != null) {
            List<McardCmfreeDTO> mcardCmfrees = freeResponseData.getResult();
            model.put("mcardCmfrees",mcardCmfrees);
        }

        if (logResponseData != null) {
            List<McardMccatalogDTO> mcardMccatalogs = logResponseData.getResult();
            model.put("mcardMccatalogs",mcardMccatalogs);
        }

        return "mcardcsm/mcardinfo/detail/suitable_mc";
    }

    /**会员卡可预约景区页面。
     * 显示会员卡适用景区范围内可预约景区列表。
     *
     * TODO 这个页面服务和/{typeId}/reservemc整合为一个，即只有一个实现代码和jsp，另一个直接redirect
     *
     * @param cardNum
     * @return
     */
    @RequestMapping(value = "/{cardNum}/reservemc")
    public String queryMcardReserveMc(Map<String, Object> model, HttpSession session,
                                       @PathVariable("cardNum")String cardNum) {

        String token = (String) session.getAttribute("token");
        Pageable pageable = new PageRequest(0,100);

        //查询卡信息
        ResponseData<McardInfoDTO> mcardInfoResponseData = McardInfoSDK.getInstance().getMCardinfo(cardNum, token);
        McardInfoDTO mcardInfo = mcardInfoResponseData.getResult();
        String typeId = mcardInfo.getTypeId();

        //卡类型的年卡商铺
        McardCmfreeDTO mcardCmfreeDTO = new McardCmfreeDTO();
        ResponseData<List<McardCmfreeDTO>> freeResponseData = McardTypeSDK.getInstance().queryCmfreeOfMCardType( typeId, mcardCmfreeDTO, null, pageable,token);

        //卡类型的优惠商铺
        McardMccatalogDTO mcardMccatalogDTO = new McardMccatalogDTO();
        ResponseData<List<McardMccatalogDTO>> logResponseData = McardTypeSDK.getInstance().queryMccatalogOfMCardType(typeId,mcardMccatalogDTO,null,pageable,token);

        if (freeResponseData != null) {
            List<McardCmfreeDTO> mcardCmfrees = freeResponseData.getResult();
            model.put("mcardCmfrees",mcardCmfrees);
        }

        if (logResponseData != null) {
            List<McardMccatalogDTO> mcardMccatalogs = logResponseData.getResult();
            model.put("mcardMccatalogs",mcardMccatalogs);
        }

        return "mcardcsm/mcardinfo/detail/reserve_mc";
    }


    //========================== 操作类(买家角度)


    /**会员卡绑定页面。
     * 将指定的卡绑定到当前用户。
     *
     * TODO 有个bug，bind后好像没有写入用户的证件信息？
     */
    @RequestMapping(value = "/bind")
    public String bindCard(
            Map<String, Object> model,
            HttpSession session,
            HttpServletRequest request,
            @RequestParam(value = "cardNum", required = false) String cardNum,
            @RequestParam(value = "typeId", required = false) String typeId,
            @RequestParam(value = "oriTypeId", required = false) String oriTypeId,
            @RequestParam(value = "uri",required = false)String uri) {

        String token = (String) session.getAttribute("token");
        Object isHntgaFromSession = session.getAttribute("isHntga");

        /*TODO 已改为ajax 方式获取数据。后期测试不出问题就删除此段代码*/
       /* if(StringUtils.isNotBlank(cardNum)){
            //获取会员卡信息
            ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().getMCardinfo(cardNum,token);
            if(responseData != null){
                McardInfoDTO mcardInfo = responseData.getResult();
                model.put("mcardInfo", mcardInfo);
                //获取卡类型信息
                ResponseData<McardTypeDTO> responseData1 = McardTypeSDK.getInstance().getMCardType( mcardInfo.getTypeId(),token);
                model.put("mcardType",responseData1.getResult());
            }
        }

        //获取当前用户信息
        ResponseData<AccountDTO> responseData2 = AccountSDK.getInstance().getAccountOfMine(token);
        model.put("accountInfo", responseData2.getResult());

        if (StringUtils.isNotBlank(typeId)) {
            ResponseData<McardTypeDTO> responseData = McardTypeSDK.getInstance().getMCardType(typeId, token);
            if (responseData != null) {
                McardTypeDTO mcardType = responseData.getResult();
                model.put("mcardType", mcardType);
            }
        }*/

        model.put("cardNum",cardNum);
        model.put("typeId",typeId);

        Map<String, String> cardStatusMap = McardInfoConstant.MCardStatus.map;
        model.put("cardStatusMap", cardStatusMap);
        /*前端js循环，需要在此处先转为json*/
        model.put("cardStatusMap2", JsonUtil.toJson(cardStatusMap));

        Map<String, String> identityTypeMap = AccountConstant.IdentityType.map;
        model.put("identityTypeMap", identityTypeMap);
        model.put("identityTypeMapJson", JsonUtil.toJson(identityTypeMap));
        model.put("idType", AccountConstant.IdentityType.ID);


        /*兼容 绑定成功后跳转 地址*/
        if (StringUtils.isNotEmpty(uri)) {
            model.put("uri", uri);
        } else if (isHntgaFromSession != null && StringUtils.equals("isHntga", (String) isHntgaFromSession)) {
            model.put("uri", "/mcards/mine/hntga");
        } else if (StringUtils.isNotEmpty(oriTypeId)) {
            model.put("uri", "/mcards/mine/etickets?typeId=" + oriTypeId);
        } else {
            model.put("uri", "/mcards/mine/etickets");
        }

        return "mcardcsm/mcardinfo/action/bind";
    }
    /**
     *
     * @param model
     * @param session
     * @param mcardInfoDTO  绑卡信息
     * @param oriTypeId 原始的代表来源的指定typeId
     * @param uri  不同业务场景下绑卡，回跳指定uri
     *
     * TODO 已改为ajax 方式 提交 数据。后期测试不出问题就删除此方法
     * @return
     */
    @RequestMapping(value = "/bind/submit")
    public String bindCardSubmit(
            Map<String, Object> model,
            HttpSession session,
            McardInfoDTO mcardInfoDTO,
            String oriTypeId,
            @RequestParam(value = "uri",required = false)String uri){
        String token = (String) session.getAttribute("token");
        Object isHntgaFromSession = session.getAttribute("isHntga");

        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().bindCard( mcardInfoDTO,token);
        McardInfoDTO mcardInfo = responseData.getResult();

        if (StringUtils.isNotEmpty(uri)) {
            return "redirect:" + uri;
        } else if (isHntgaFromSession != null && StringUtils.equals("isHntga", (String) isHntgaFromSession)) {
            return "redirect:/mcards/mine/hntga";
        } else if (StringUtils.isNotEmpty(oriTypeId)) {
            return "redirect:/mcards/mine/etickets?typeId=" + oriTypeId;
        } else {
            return "redirect:/mcards/mine/etickets";
        }
    }

    /**会员卡绑定代办页面。
     * 将指定的会员卡绑定到指定用户，用于帮人绑定。
     *
     * TODO 可以和bind页面整合为一个，没必要做成2个？？
     *
     */
    @RequestMapping(value = "/bindForOther")
    public String bindForOther(
            Map<String, Object> model,
            HttpSession session,
            @RequestParam(value = "cardNum", required = false) String cardNum,
            @RequestParam(value = "typeId", required = false) String typeId,
            @RequestParam(value = "oriTypeId", required = false) String oriTypeId,
            @RequestParam(value = "uri",required = false)String uri){

        String token = (String) session.getAttribute("token");
        Object isHntgaFromSession = session.getAttribute("isHntga");

        /*TODO 已改为ajax 方式获取数据。后期测试不出问题就删除此段代码*/
        /*if(StringUtils.isNotBlank(cardNum)) {
            //获取会员卡信息
            ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().getMCardinfo(cardNum, token);
            if (responseData != null) {
                McardInfoDTO mcardInfo = responseData.getResult();
                model.put("mcardInfo", mcardInfo);
                //获取卡类型信息
                ResponseData<McardTypeDTO> responseData1 = McardTypeSDK.getInstance().getMCardType(mcardInfo.getTypeId(), token);
                model.put("mcardType", responseData1.getResult());
            }
        }

        if (StringUtils.isNotBlank(typeId)) {
            ResponseData<McardTypeDTO> responseData = McardTypeSDK.getInstance().getMCardType(typeId, token);
            if (responseData != null) {
                McardTypeDTO mcardType = responseData.getResult();
                model.put("mcardType", mcardType);
            }
        }*/

        Map<String, String> cardStatusMap = McardInfoConstant.MCardStatus.map;
        model.put("cardStatusMap", cardStatusMap);
        /*前端js循环，需要在此处先转为json*/
        model.put("cardStatusMap2", JsonUtil.toJson(cardStatusMap));

        Map<String, String> identityTypeMap = AccountConstant.IdentityType.map;
        model.put("identityTypeMap", identityTypeMap);
        model.put("identityTypeMapJson", JsonUtil.toJson(identityTypeMap));
        model.put("idType", AccountConstant.IdentityType.ID);


         /*兼容 绑定成功后跳转 地址*/
        if (StringUtils.isNotEmpty(uri)) {
            model.put("uri", uri);
        } else if (isHntgaFromSession != null && StringUtils.equals("isHntga", (String) isHntgaFromSession)) {
            model.put("uri", "/mcards/mine/hntga");
        } else if (StringUtils.isNotEmpty(oriTypeId)) {
            model.put("uri", "/mcards/mine/etickets?typeId=" + oriTypeId);
        } else {
            model.put("uri", "/mcards/mine/etickets");
        }

        return "mcardcsm/mcardinfo/action/bindForOther";
    }
    /*TODO 已改为ajax 方式 提交 数据。后期测试不出问题就删除此方法*/
    @RequestMapping(value = "/bindForOther/submit")
    public String bindForOtherSubmit(Map<String, Object> model,
                                     HttpSession session,
                                     McardInfoDTO mcardInfoDTO,
                                     String oriTypeId,
                                     @RequestParam(value = "uri",required = false)String uri){

        String token = (String) session.getAttribute("token");
        Object isHntgaFromSession = session.getAttribute("isHntga");

        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().bindCard( mcardInfoDTO,token);
        model.put("mcardInfo", responseData.getResult());

        if (StringUtils.isNotEmpty(uri)) {
            return "redirect:" + uri;
        } else if (isHntgaFromSession != null && StringUtils.equals("isHntga", (String) isHntgaFromSession)) {
            return "redirect:/mcards/mine/hntga";
        } else if (StringUtils.isNotEmpty(oriTypeId)) {
            return "redirect:/mcards/mine/etickets?typeId=" + oriTypeId;
        } else {
            return "redirect:/mcards/mine/etickets";
        }
    }



    /**会员卡预约页面。
     * 如果指定了cardNum则显示指定卡的预约页面，否则可在我的所有卡之间切换。
     * @param cardNum           会员卡卡号
     * @param typeId            卡类型ID
     */
    @RequestMapping(value = "/reserve")
    public String book(
            @RequestParam(value = "cardNum",required = false)String cardNum,
            @RequestParam(value = "typeId",required = false)String typeId){

        //1、校验

        //2、业务逻辑

        //3、响应
        if (StringUtils.isBlank(cardNum)) {
            //卡号为空，跳入选择会员卡页面；
            return "mcardcsm/mcardinfo/action/selectCard";
        }else {
            //卡号不为空，跳入预约页面；
            return "mcardcsm/mcardinfo/action/reserve";
        }
    }
    @RequestMapping(value = "/reserve/submit")
    public String bookSubmit(Map<String, Object> model,
                             HttpSession session,
                             McardRecordDTO mcardRecord) {

        String token = (String) session.getAttribute("token");

        ResponseData<McardRecordDTO> responseData = McardInfoSDK.getInstance().reserve(mcardRecord, token);

        return "redirect:/userecords/card/"+mcardRecord.getCardNum()+"/userecords";
    }

    /*==================================================================2018年12月13日16:52:25 刘凡 获取会员卡的二维码和条形码=================================================================================================*/

    /**
     * 获取会员卡的二维码信息
     *
     * TODO 应改为svr rest
     *
     * @return
     */

    @RequestMapping(value = "/flushQRcode/{cardNum}",method= RequestMethod.POST)
    @ResponseBody
    public Object flushQRcode(Map<String, Object> model, HttpSession session,
                              @PathVariable("cardNum")String cardNum) {

        String token = (String) session.getAttribute("token");
        //生成验证码
        ResponseData<VerifyCodeDTO> responseData = VerifyCodeSDK.getInstance().generate("23", cardNum, token);
        String codeSource = responseData.getResult().getCode();

        //TODO 得判断什么情况下才会兼容老的pos验证  待补充
        //TODO 20190307 for 融e联上线，支持老的pos验证程序，改为固定内容
        ResponseData<McardInfoDTO> responseData2 = McardInfoSDK.getInstance().getMCardinfo(cardNum,token);
        String typeId = responseData2.getResult().getTypeId();

        codeSource = "http://cas.dayou.com.cn/cas/control?action=221&content={\"cardType\":\"" + typeId + "\",\"cardNum\":\"" + cardNum + "\"}";

        Map<String, String> result = new HashMap<String, String>();
        //生成二维码信息
        String qrCode = QRCodeUtil.generalQRCode(codeSource, 300, 300);

        /*条形码生成规则*/
        String QRCodeRule = "K"+cardNum;
        /*生成的条形码*/
        String barCode = BarcodeUtil.generateBarCode128(QRCodeRule,"0.6", "18");

        //TODO 接口调用报错时，得返回错误状态码。供前台判断使用  待补充
        result.put("qrCode", qrCode);
        result.put("barCode", barCode);
        return result;

    }


    /*==================================================================2018年12月13日16:52:25 刘凡 获取会员卡的二维码和条形码=================================================================================================*/

}
