package com.dayouzc.e2eapp.mcard.mcardcsm.web.controller;

import com.dayouzc.e2eapp.mcard.dto.McardInfoDTO;
import com.dayouzc.e2eapp.mcard.sdk.McardInfoSDK;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import com.dayouzc.e2eplatform.core.util.JsonUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

/**
 * Created by Mr.Liu on 2017/8/8.
 *
 * TODO 看看这个ajax是否已有使用。如果已有使用，则改为ajax调用svr的rest接口；如果没有使用，可删除此class
 *
 */
@Controller
@RequestMapping("/mcards")
public class MCardInfoAjaxController {
    private static final Logger logger = LoggerFactory.getLogger(MCardInfoAjaxController.class);

    /**
     * ajax 获取卡详情
     * @param model
     * @param session
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/{cardNum}/ajax")
    public void getCardAjax(Map<String, Object> model, HttpSession session,
                                    HttpServletResponse response,
                                    @PathVariable("cardNum")String cardNum){

        String token = (String) session.getAttribute("token");

        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().getMCardinfo(cardNum,token);


        PrintWriter out = null;
        response.setCharacterEncoding("utf-8");  //防止ajax接受到的中文信息乱码
        try {
            out = response.getWriter();
            if (responseData == null) {
                String msg = "{\"msg\",\"[responseData] is null\"}";
                String jsonStr = JsonUtil.toJson(msg);
                out.print(jsonStr);
            } else if (!StringUtils.equals(responseData.getStatus(),"10000")) {
                String jsonStr = JsonUtil.toJson(responseData);
                out.print(jsonStr);
            } else {
                McardInfoDTO mcardInfoDTO = responseData.getResult();
                String jsonStr = JsonUtil.toJson(responseData);
                out.print(jsonStr);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            out.flush();
            out.close();
        }
    }


}
