package com.dayouzc.e2eapp.mcard.mcardcsm.web.controller;

import com.crypto.RSAUtils;
import com.crypto.Sha1Utils;
import com.crypto.TripleDesUtils;
import com.dayouzc.e2eapp.mcard.mcardcsm.web.util.JSONObjectFromICBC;
import com.dayouzc.e2eplatform.core.context.E2EAppWebContext;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import com.dayouzc.e2eplatform.core.dto.equip.ConnectionInfoDTO;
import com.dayouzc.e2eplatform.core.dto.people.AccountDTO;
import com.dayouzc.e2eplatform.core.dto.people.AccountFeatureDTO;
import com.dayouzc.e2eplatform.core.exception.E2EServiceException;
import com.dayouzc.e2eplatform.core.sdk.SDKUtil;
import com.dayouzc.e2eplatform.core.util.HttpUtils;
import com.dayouzc.e2eplatform.core.util.JsonUtil;
import com.dayouzc.e2eplatform.core.util.NetworkUtils;
import com.dayouzc.e2eplatform.registerbind.constant.AccountConstant;
import com.dayouzc.e2eplatform.registerbind.sdk.people.AccountSDK;
import com.fasterxml.jackson.core.type.TypeReference;
import com.icbc.crypto.utils.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * /bind    激活融e联卡包。
 *      如果当前没有用户信息或者用户信息确实，则进入完善用户信息页面；
 *      否则进入激活融e联会员卡页面
 *
 *      TODO 完善用户信息抽取到aop里和rbweb里公共实现
 *      TODO 工行融e联卡包激活 改为 /icbcmims/activate
 *
 *      TODO util里的那几个class是否还有用？？？没有用就delete
 */
@Controller
@RequestMapping("/icbcmims")
public class IcbcMimsController {
    private static final Logger logger = LoggerFactory.getLogger(IcbcMimsController.class);

    //“锦绣潇湘”融e联公众号的appid。TODO 后期改为统一维护
    private String icbcmimsappid = "x8eaGerBkD8LNWWKUqXa2Q==";
    //融e联 key
    private String icbcmims_platform_pub_key = "/temp/icbcmims/platform_pub.key";
    private String icbcmims_thirdparty_priv_key = "/temp/icbcmims/priv.key";


    /**
     * 激活融e联卡包。
     */
    @RequestMapping(value = "/bind")
    public String bindAccount(Map<String, Object> model, HttpServletRequest request, HttpSession session) throws Exception {
        String token = (String) session.getAttribute("token");

        ResponseData<AccountDTO> requestData1 = AccountSDK.getInstance().getAccountOfMine(token);
        logger.debug("ResponseData = [ {} ]", JsonUtil.toJson(requestData1));
        if(requestData1==null || !StringUtils.equals(requestData1.getStatus(), "10000") || requestData1.getResult()==null){ //当前没有用户信息
            return "mcardcsm/icbcmims/bind";
        }else {
            AccountDTO account = requestData1.getResult();
            //获取用户在融e联当前公众号的是否已经激活融e联卡包
            String activateFlag = null;     //==1表示已激活融e联卡包，其他表示没有激活
            ResponseData<List<AccountFeatureDTO>> responseDataAcctFeatureList = AccountSDK.getInstance().queryMineAccountFeature(null, null, token);
            if(responseDataAcctFeatureList!=null && StringUtils.equals(responseDataAcctFeatureList.getStatus(), "10000")
                    && responseDataAcctFeatureList.getResult()!=null && !responseDataAcctFeatureList.getResult().isEmpty()){
                for(AccountFeatureDTO featureDTO : responseDataAcctFeatureList.getResult()){
                    if(featureDTO!=null && StringUtils.equals(featureDTO.getFeatureType(), AccountConstant.FeatureType.ICBCMIMS)
                            && StringUtils.equals(featureDTO.getExt1(), icbcmimsappid)){
                        activateFlag = featureDTO.getExt3();
                        break;
                    }
                }
            }

            //如果用户信息（姓名/手机号/证件类型/证件号码）缺失，则进入完善用户信息页面；
            if(StringUtils.isBlank(account.getUserName()) || StringUtils.isBlank(account.getMobilePhone())
                    || StringUtils.isBlank(account.getCertificateType()) || StringUtils.isBlank(account.getCertificateNumber())) {
                model.put("account", account);
                return "mcardcsm/icbcmims/bind";
            }if(StringUtils.equals(activateFlag, "1")){ //如果已经激活融e联卡包，则进入我的卡包页面
                return "redirect:/mcards/mine";
            }else{  //否则进入激活融e联会员卡jsp
                String basePath = NetworkUtils.getBasePath(request);
                logger.info("basePath = [ {} ]", basePath);
                String jsAPIUrl = basePath + "/icbcmims/bind";// 根据不同的界面配置不同的url
                String queryString = request.getQueryString();
                if (StringUtils.isNotEmpty(queryString)) {
                    jsAPIUrl = jsAPIUrl + "?" + queryString;
                }
                icbcmimsActivateInit(request, account, jsAPIUrl);
                return "mcardcsm/icbcmims/activate";
            }
        }
    }
    @RequestMapping(value = "/bind/submit")
    public String bindAccountSubmit(Map<String, Object> model,
                                    AccountDTO account,
                                    HttpServletRequest request,
                                    HttpServletResponse response,
                                    HttpSession session) throws Exception {
        String token = (String) session.getAttribute("token");
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo(request);
        if(tokenInfo==null || account==null
                || StringUtils.isBlank(account.getUserName()) || StringUtils.isBlank(account.getMobilePhone())
                || StringUtils.isBlank(account.getCertificateType()) || StringUtils.isBlank(account.getCertificateNumber())){
            throw new E2EServiceException("99999", "请输入完整用户绑定信息！");
        }
        AccountSDK.getInstance().modifyAccountMine(account, token);

        //如果当前在融e联下，则进入融e联激活会员卡jsp页面；否则进入我的激活码页面
        if(tokenInfo!=null && StringUtils.equals(tokenInfo.getAppType(), "ICBCMIMS")){
            String basePath = NetworkUtils.getBasePath(request);
            logger.info("basePath = [ {} ]", basePath);
            String jsAPIUrl = basePath + "/icbcmims/bind/submit";// 根据不同的界面配置不同的url
            String queryString = request.getQueryString();
            if (StringUtils.isNotEmpty(queryString)) {
                jsAPIUrl = jsAPIUrl + "?" + queryString;
            }
            icbcmimsActivateInit(request, account, jsAPIUrl);
            return "mcardcsm/icbcmims/activate";
        }else{
            return "redirect:/mcards/mine/activecodes";
        }
    }

    /**
     * 改为ICDN服务获取ticket
     * @param request
     * @param account
     * @param currentPath
     * @throws Exception
     */
    private void icbcmimsActivateInit(HttpServletRequest request, AccountDTO account, String currentPath) throws Exception {
        String token = E2EAppWebContext.getToken(request);

        //---cardInfo---
        request.setAttribute("cardNo", account.getMobilePhone());
        request.setAttribute("cardType", "1");
        request.setAttribute("endDate", "365");

        //---initInfo---
        // 必填，公众号的唯一标识
        String appId = icbcmimsappid;
        String timeStamp2 = Long.toString(System.currentTimeMillis());
        String nonceStr2 = UUID.randomUUID().toString();
        String jsAPITicket = getJsapiTicket(token);
        String decript = "jsapi_ticket=" + jsAPITicket + "&noncestr=" + nonceStr2 + "&timestamp=" + timeStamp2 +"&url=" + currentPath;
        logger.info("decript = [ {} ]", decript);
        String signature2 = byteToHex(decript);
        logger.info("signature2 = [ {} ]", signature2);

        request.setAttribute("appId", appId);
        request.setAttribute("timeStamp2", timeStamp2);
        request.setAttribute("nonceStr2", nonceStr2);
        request.setAttribute("signature2", signature2);

        //---others---
        String callBackUrl = request.getContextPath() + "/mcards/mine/activecodes";
        request.setAttribute("callBackUrl", callBackUrl);
    }

    /**
     * 融e联激活会员卡操作时的参数初始化
     *
     * @param request
     * @param account
     * @throws Exception
     */
    private void icbcmimsActivateInit2(HttpServletRequest request, AccountDTO account) throws Exception {
        String basePath = NetworkUtils.getBasePath(request);
        logger.info("basePath = [ {} ]", basePath);
        String jsAPIUrl = basePath + "/icbcmims/bind/submit";// 根据不同的支付界面配置不同的url

        String[] accessTokenArr = getAccessToken();
        String accessToken = URLEncoder.encode(accessTokenArr[0], "UTF-8");

        String callBackUrl = request.getContextPath() + "/mcards/mine/activecodes";

        //---cardInfo---
        request.setAttribute("cardNo", account.getMobilePhone());
        request.setAttribute("cardType", "1");
        request.setAttribute("endDate", "365");
        //---initInfo---
        // 必填，公众号的唯一标识
        String appId = icbcmimsappid;
        String timeStamp2 = Long.toString(System.currentTimeMillis());
        String nonceStr2 = UUID.randomUUID().toString();
        String jsAPITicketUrl = "https://imapi.icbc.com.cn/open/ticket/getticket?access_token=" + accessToken + "&type=jsapi";
        String jsAPITicket = getJsapiTicket(jsAPITicketUrl, accessTokenArr[1], accessTokenArr[0]);
        String decript = "jsapi_ticket=" + jsAPITicket + "&noncestr=" + nonceStr2 + "&timestamp=" + timeStamp2 +"&url=" + jsAPIUrl;
        String signature2 = byteToHex(decript);

        request.setAttribute("appId", appId);
        request.setAttribute("timeStamp2", timeStamp2);
        request.setAttribute("nonceStr2", nonceStr2);
        request.setAttribute("signature2", signature2);
        //---others---
        request.setAttribute("callBackUrl", callBackUrl);
    }

    /**
     * 获取accesstoken、sessionkey
     * @return  String[], 0:获取accesstoken;1:sessionkey
     * @throws Exception
     */
    private String[] getAccessToken() throws Exception {
        String [] retArr = new String[2];

        String appId = icbcmimsappid;
        String  timestamp = Long.toString(System.currentTimeMillis());
        //签名明文：
        String signature = appId + timestamp;
        //使用公众号的私钥生成签名密文，
        byte[] cipherText = RSAUtils.encryptByPrivateKey(signature.getBytes(), icbcmims_thirdparty_priv_key);
        //将密文通过base64转化成字符串
        signature = Base64.icbcbase64encode(cipherText);
        //base64转成字符串时，由于过长会导致结果出现\r，\n，因此替换掉
        signature = signature.replaceAll("\r","").replaceAll("\n", "");

        signature = URLEncoder.encode(signature, "UTF-8");
        appId = URLEncoder.encode(appId, "UTF-8");
        String url = "https://imapi.icbc.com.cn/open/token?signature=" + signature +  "&appid=" + appId + "&timestamp=" + timestamp;
        String result = HttpUtils.get(url.toString());
//        String result = HttpClientUtils.get(url.toString(), "UTF-8");
        logger.info("获取accesstoken、sessionkey result = [ " + result + " ]");

        JSONObjectFromICBC json = new JSONObjectFromICBC(result);
        JSONObjectFromICBC json2 = new JSONObjectFromICBC(json.get("token").toString());
        String accesstoken = (String) json2.get("accesstoken");
        String sessionkey =(String) json2.get("sessionkey");
        String expiredtime=(String) json2.get("expiredtime");
        JSONObjectFromICBC jso3= new JSONObjectFromICBC();
        jso3.put("expiredtime", expiredtime);
        jso3.put("accesstoken", accesstoken);
        jso3.put("sessionkey", sessionkey);

        //sha1校验 TODO 可以暂时不校验
        logger.info("-----执行sha1校验-----");
        String zhaiyao_c = json.getString("signature");
        String zhaiyao  = new String(RSAUtils.decryptByPublicKey(Base64.icbcbase64decode(zhaiyao_c), icbcmims_platform_pub_key));
        boolean ret = Sha1Utils.tokenValidate(jso3.toString().getBytes(), zhaiyao_c, icbcmims_platform_pub_key);
        if(ret) {
            logger.info("-----sha1校验成功-----");
            //获取sessionkey
            String key_c = json2.getString("sessionkey");
            String key = new String(RSAUtils.decryptByPrivateKey(Base64.icbcbase64decode(key_c), icbcmims_thirdparty_priv_key));
            retArr[0] = accesstoken;
            retArr[1] = key;
            logger.info("accesstoken = [ {} ]", accesstoken);
            logger.info("sessionkey = [ {} ]", key);
        }

        return retArr;
    }

    /**
     * 获取jsapi_ticket
     * @param url
     * @param sessionKey
     * @return
     */
    private String getJsapiTicket(String url, String sessionKey, String accessToken) throws IOException {

        /*String key = sessionKey;
        String type = "";
        String getUrl = "https://imapi.icbc.com.cn";

        List<NameValuePair> formparams = new ArrayList<NameValuePair>();
        DefaultHttpClient client = new DefaultHttpClient();
        String retStr="";
        byte [] sessionkey = Base64.icbcbase64decode(key);
        type="jsapi";
        formparams.add(new BasicNameValuePair("access_token",accessToken));
        formparams.add(new BasicNameValuePair("type",type));
        try{
            java.net.URI uri = Tools.getURI(client,formparams,getUrl,"/open/ticket/getticket");
            logger.info("uri = [ {} ]", uri);
            HttpGet httpGet = new HttpGet(uri);
            HttpResponse result = client.execute(httpGet);
            byte [] returnByte= IOUtils.toByteArray(result.getEntity().getContent());
            String returnString=new String(returnByte,"utf-8");
            System.out.println("returnString="+returnString);
            if(returnString.contains("errcode")){
                return returnString;
            }
            retStr = new String(TripleDesUtils.decrypt(returnByte, sessionkey),"utf-8");
            System.out.println("getAccessTicket:" +retStr);
            return retStr;
        }catch(Exception e){
            e.printStackTrace();
            return "";
        }*/

        /*try {
            String result = HttpClientUtils.get(url, "UTF-8");
            logger.info("获取jsapi_ticket result = [ {} ]", result);
            return result;
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }*/

        String result = HttpUtils.get(url);
        logger.info("获取jsapi_ticket result = [ {} ]", result);
        byte[] decrypt = TripleDesUtils.decrypt(result.getBytes("UTF-8"), Base64.icbcbase64decode(sessionKey));
        String decryptStr = new String(decrypt, "UTF-8");
        logger.info(" icbc mims 获取jsapi_ticket decrypt = [ {} ] ", decryptStr);
        com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject(decryptStr);
        String jsAPITicket = (String) jsonObject.get("ticket");

        return jsAPITicket;
    }

    //从ICDN获取ticket
    private String getJsapiTicket(String token) throws IOException {
        //TODO 调用icdn 获取 ticket 接口
        String defaultSvrIp = "localhost";
        String defaultSvrPort = "8081";
        String defaultContextName = "icdnsvr";
        String rootPath = "/icdn";
        String thisPath = "/icbcmims/ticket";
        String url = "http://" +defaultSvrIp + ":" + defaultSvrPort + "/" + defaultContextName + rootPath + thisPath;

        Map<String, String> params = SDKUtil.getDefaultParamMap(token, null, null);

        //调用HttpUtils
        ResponseData responseData = SDKUtil.httpGet(url,params,new TypeReference<ResponseData<String>>() {});

        if(responseData==null){
            throw new E2EServiceException("99999", "服务未响应！");
        }else if (StringUtils.equals(responseData.getStatus(), "10000")) {
            String jsAPITicket = (String) responseData.getResult();
            return jsAPITicket;
        }else{
            throw new E2EServiceException(responseData.getStatus(), responseData.getMsg());
        }
    }

    private String byteToHex(String temp) {
        MessageDigest crypt = null;
        try {
            crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(temp.getBytes("UTF-8"));
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        Formatter formatter = new Formatter();
        byte[] hash = crypt.digest();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }
}