package com.dayouzc.e2eapp.mcard.mcardcsm.web.util.hunan;

import com.alibaba.fastjson.JSONObject;
import com.dayouzc.e2eplatform.core.util.HttpUtils;
import com.dayouzc.e2eplatform.core.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

/**
 * 调用湖南省公安厅接口获取用户身份信息
 *
 * @author 李家宁
 * @date 2019/10/23 18:19
 */
public class HunanUtils {
    public static final Logger logger = LoggerFactory.getLogger(HunanUtils.class);

    /**
     * 通过随机码获取用户信息
     * @param code  随机码
     * @return
     */
    public static CertificateInfo getCertificateInfoByCode(String code) {
        try {
            System.out.println("code = [ " + code + " ]");
            logger.info("code = [ " + code + " ]");
            //1 校验
            //2 业务处理
            //2.1 获取用户信息
            String idUrl = "https://fwpt.hnga.gov.cn/apis/custom/hotel/getrediscs/" + code;
            String passwd = "c583f7465dd140dcaed1c2229b8431d9";
            String idResult = HttpUtils.post(idUrl, "");
            logger.info("hn gat get Id info by code result = [ " + idResult + " ]");
            JSONObject idObject = JSONObject.parseObject(idResult);
            String content = idObject.getString("data");

            //2.2 解密
            String decrypt = DesUtils.decrypt(content);
            System.out.println(decrypt);

            JSONObject jsonObject = JSONObject.parseObject(decrypt);
            CertificateInfo certificateInfo = new CertificateInfo();

            //2.3 封装
            Object username = jsonObject.get("username");
            String decrypt1 = GabAES.decrypt((String) username, passwd);
            certificateInfo.setUserName(decrypt1);
            Object usernum = jsonObject.get("usernum");
            String decrypt2 = GabAES.decrypt((String) usernum, passwd);
            certificateInfo.setCertificateNumber(decrypt2);
            Object userpic = jsonObject.get("userpic");
            String decrypt3 = GabAES.decrypt((String) userpic, passwd);
            certificateInfo.setUserPic(decrypt3);
            Object czrkxzz = jsonObject.get("czrkxzz");
            String decrypt4 = GabAES.decrypt((String) czrkxzz, passwd);
            certificateInfo.setAddress(decrypt4);
            Object xb = jsonObject.get("xb");
            String decrypt5 = GabAES.decrypt((String) xb, passwd);
            certificateInfo.setSex(decrypt5);
            Object mz = jsonObject.get("mz");
            String decrypt6 = GabAES.decrypt((String) mz, passwd);
            certificateInfo.setEthnic(decrypt6);
            Object czrksldwdmooo = jsonObject.get("czrksldwdmooo");
            String decrypt7 = GabAES.decrypt((String) czrksldwdmooo, passwd);
            certificateInfo.setOrgCode(decrypt7);
            Object czrksldwdm = jsonObject.get("czrksldwdm");
            String decrypt8 = GabAES.decrypt((String) czrksldwdm, passwd);
            certificateInfo.setOrgName(decrypt8);
            Object czrkyxqxqsrq = jsonObject.get("czrkyxqxqsrq");
            String decrypt9 = GabAES.decrypt((String) czrkyxqxqsrq, passwd);
            certificateInfo.setStartTime(decrypt9);
            Object czrkyxqxjzrq = jsonObject.get("czrkyxqxjzrq");
            String decrypt10 = GabAES.decrypt((String) czrkyxqxjzrq, passwd);
            certificateInfo.setEndTime(decrypt10);

            //3 响应
            System.out.println(JsonUtil.toJson(certificateInfo));
            return certificateInfo;
        } catch (IOException e) {
            e.printStackTrace();
            logger.error("", e);
            return null;
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("", e);
            return null;
        }
    }


}
