package com.dayouzc.e2eapp.mcard.mcardcsm.web.tmp;

import com.alibaba.fastjson.JSONObject;
import com.dayouzc.e2eplatform.core.util.HttpUtils;
import com.dayouzc.e2eplatform.core.util.NetworkUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 *  微信获取令牌
 *
 */
@Controller
@RequestMapping("/login/weixin")
public class WeixinLoginController {
    private static final Logger logger = LoggerFactory.getLogger(WeixinLoginController.class);

    /** 大有中城公众号 id */
    private static String wxappIdDyzc = "wx99c09335b1bc1cb0";
    /** 大有中城公众号 secret */
    private static String wxappSecretDyzc = "3853f2ac27ec96fb54f367e7af77972f";

    /** E2E平台的appid 和 微信公众号信息的映射关系 TODO 临时放在这里 */
    private static String[][] appidArray = {    //E2E平台的appid；微信公众号id；微信公众号secret；微信公众号名称
            {"wx99c09335b1bc1cb0", "wx99c09335b1bc1cb0", "3853f2ac27ec96fb54f367e7af77972f", "大有中城"},
            {"wxfa592f7d436f0831", "wxfa592f7d436f0831", "5845da1e86755e98fab02d1d8b4eb449", "锦绣潇湘旅游卡"},
            {"wx9ba5803971c12cc1", "wx9ba5803971c12cc1", "9473f7ef29bee2ededde3ddf8903fb64", "亲亲常德旅游卡"},
            {"wx5e8745ecb0b1b322", "wx5e8745ecb0b1b322", "4f52c8bbcab393b7edb3c8252a742935", "嗨游怀化旅游卡"},
            {"wx137bb8832cc6d238", "wx137bb8832cc6d238", "77a0322d5abb433c447c095e334bd919", "传奇娄底旅游卡"},
            {"wxf126bab52856e2b9", "wxf126bab52856e2b9", "a9ce567e6757f6ec96b7cc02e9b31046", "奇美邵阳旅游卡"},
            {"wxe7bfeeb823891a04", "wxe7bfeeb823891a04", "8c222f734f50f3c43b1acf411e84d485", "别样郴州旅游卡"},
            {"wxcf32c8ab6c844959", "wxcf32c8ab6c844959", "b514cbbccc9393e6341c5e2a15c246db", "美在永州旅游卡"},
            {"wx25db39a7e6733726", "wx25db39a7e6733726", "a3a493c8ca8490d7b59dc45544e0ea6d", "湘潭全域旅游卡"},
            {"wx2a89b24e6656abd0", "wx2a89b24e6656abd0", "6328778d4ab767c15985d24b28779c58", "奇美邵阳惠游卡"},
            {"111111", "", "", "益山益水益美益阳旅游卡"}
    };

    /**
     *  获取令牌
     *
     *  session里会存：
     *      appId：					大有的appid
     *      %wxappIdDyzc% openId：	大有中城公众号的openId
     *      %appId% openId：		当前公众号的openId
     *
     * @return
     */
    @RequestMapping("")
    public String getToken(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        logger.info("sessionId from client = [ " + session.getId() + " ]");
        //1 准备工作： 获取当前公众号 在E2E平台分配的appId
        putOriUri2Session(request, session);

        String appId = "";//大有appID
        // 1.1.先从request获取
        Object appIdFromRequest = request.getAttribute("appId");
        if (appIdFromRequest != null && appIdFromRequest instanceof String) {
            appId = (String) appIdFromRequest;
        }
        // 1.2.再从session获取
        if(StringUtils.isBlank(appId)){
            Object appIdFromSession = session.getAttribute("appId");
            if (appIdFromSession != null && appIdFromSession instanceof String) {
                appId = (String) appIdFromSession;
            }
        }
        // 1.3.最后，从配置文件获取 或者 是默认值
        if(StringUtils.isBlank(appId)){
            appId = "wx99c09335b1bc1cb0";//默认是 大有中城 公众号
        }
        // 1.4.将appId 放入session
        session.setAttribute("appId", appId);

        // 1.5.通过大有appId获取对应的公众号信息
        String tappId = getWxappId(appId);

        //2. 获取 openId
        String unionOpenId = "";    //用户在 大有中城 公众号的openid
        String openId = "";         //用户在 当前公众号 的 openId

        // 2.1. 从session获取
        Object unionOpenIdObj = session.getAttribute(wxappIdDyzc + "openId");
        if (unionOpenIdObj != null && unionOpenIdObj instanceof String) {
            unionOpenId = (String) unionOpenIdObj;
        }
        Object openIdObj = session.getAttribute(appId + "openId");
        if (openIdObj != null && openIdObj instanceof String) {
            openId = (String) openIdObj;
        }

        // 2.2. 如果当前不存在，则 从微信获取 用户在 大有中城 公众号的openid
        if (StringUtils.isBlank(unionOpenId)) {
            String authorizeUrl = getWxAuthorizeUrl(request, wxappIdDyzc);
            return "redirect:" + authorizeUrl;
        }

        // 2.3. 如果当前不存在，则 从微信获取 用户在 当前公众号 的 openId
        if(StringUtils.equals(wxappIdDyzc, tappId)){    //如果当前公众号就是大有中城公众号，则不用重复获取openid
            openId = unionOpenId;
        }else {
            if (StringUtils.isBlank(openId)) {
                String authorizeUrl = getWxAuthorizeUrl(request, tappId);
                return "redirect:" + authorizeUrl;
            }
        }

        //2 获取令牌
        ICBCE2EAppWebContext.loginByWechat(request, openId, tappId, getWxappName(appId), unionOpenId, null);

        //3 重定向至源uri
        return redirectOriUri(request, response, session);
    }

    /**
     *  微信授权回调
     * @return  获取openId
     */
    @RequestMapping(value = "/oauth2")
    public String oauth2(HttpServletRequest request, HttpSession session) throws IOException {
        logger.info("sessionId from weixin oauth2 = [ " + session.getId() + " ]");
        //1.从微信获取openid
        String dayouAppId = (String) session.getAttribute("appId");
        String openId = oauthAndGetOpenId(request, getWxappId(dayouAppId), getWxappSecret(dayouAppId));
        session.setAttribute(dayouAppId + "openId", openId);

        //2. 重定向至发起授权界面
        String redirectUrl = NetworkUtils.getBasePath(request) + "/login/weixin";
        return "redirect:" + redirectUrl;
    }

    /**
     *  微信授权回调_union
     * @return  获取openId
     */
    @RequestMapping(value = "/oauth2Union")
    public String oauth2Union(HttpServletRequest request, HttpSession session) throws IOException {
        logger.info("sessionId from weixin oauth2Union = [ " + session.getId() + " ]");
        //1.从微信获取openid
        String openId = oauthAndGetOpenId(request, wxappIdDyzc, wxappSecretDyzc);
        session.setAttribute( wxappIdDyzc + "openId", openId);

        //2 重定向至发起授权界面
        String redirectUrl = NetworkUtils.getBasePath(request) + "/login/weixin";
        return "redirect:" + redirectUrl;
    }


    //------------- private function

    //从request参数里取得原始uri，并放入session，用于submit时重定向
    private void putOriUri2Session(HttpServletRequest request, HttpSession session){
        String uri = request.getParameter("uri");
        if(StringUtils.isNotBlank(uri)) {
            session.setAttribute("uri", uri);
        }
    }

    //从session里取原始uri，并重定向
    private String redirectOriUri(HttpServletRequest request, HttpServletResponse response, HttpSession session){
        String url = (String) session.getAttribute("uri");
        logger.info("url from session = [ " + url + " ]");
        try {
            String joinSymbol = "?";
            if (StringUtils.contains(url, "?")) {
                joinSymbol = "&";
            }
            response.sendRedirect(url + joinSymbol + "token=" + ICBCE2EAppWebContext.getToken(request));
            return null;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    //---------------------- private function 微信相关处理

    /**
     *  微信授权代码组织
     * @param tappId
     * @return 返回授权完整uri
     */
    private String getWxAuthorizeUrl(HttpServletRequest request, String tappId) {
        //1.处理微信认证参数
        // 1.1.回调url
        String basePath = NetworkUtils.getBasePath(request);
        logger.info("basePath = " + basePath);
        String redirectUrl = basePath+"/login/weixin/oauth2";
        if(tappId==null || StringUtils.equals(tappId, wxappIdDyzc)){
            redirectUrl = basePath + "/login/weixin/oauth2Union";
        }
        try {
            redirectUrl = URLEncoder.encode(redirectUrl, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        // 1.2. appid
        String appId = tappId;
        if(tappId==null || StringUtils.equals(tappId, wxappIdDyzc)){
            appId = wxappIdDyzc;
        }
        // 1.3. state
        String state = "";//TODO 梳理需要传递的信息

        //2.返回
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid="+appId+"&redirect_uri=" + redirectUrl +"&response_type=code&scope=snsapi_base&state=" + state +"#wechat_redirect";
        return url;
    }

    //向微信发起请求获取openid
    private String oauthAndGetOpenId(HttpServletRequest request, String wxappId, String wxappSecret) throws IOException {
        //1 获取准备数据
        String code = request.getParameter("code");
        String state = request.getParameter("state");
        logger.info("公众号认证"+code);
        logger.info("state = [ " + state + " ]");

//        if(code ==null){
//            return new ForwardResolution("");//TODO
//        }

        String tokenUrl = "https://api.weixin.qq.com/sns/oauth2/access_token";
        StringBuffer url = new StringBuffer(tokenUrl);
        url.append("?appid=").append(wxappId);
        url.append("&secret=").append(wxappSecret);
        url.append("&code=").append(code);
        url.append("&grant_type=").append("authorization_code");

        //2 获取openId
        String accessToken = HttpUtils.get(url.toString());
        logger.info("accessToken = [ " + accessToken + " ]");
        JSONObject jsonObject = JSONObject.parseObject(accessToken);
        Object openIdObj = jsonObject.get("openid");
        String openId = "";
        if (openIdObj != null) {
            openId = (String) openIdObj;
        } else {
            //TODO 报错关闭窗口 or 重新获取
        }
        return openId;
    }

    //----------------------------- private function 关于appid

    //获取appId对应的微信公众号appid
    private String getWxappId(String appId){
        if(StringUtils.isBlank(appId)) return null;
        for(int i=0;i<appidArray.length; i++){
            if(StringUtils.equals(appId, appidArray[i][0])){
                return appidArray[i][1];
            }
        }
        return null;
    }
    //获取appId对应的微信公众号 名称
    private String getWxappName(String appId){
        if(StringUtils.isBlank(appId)) return null;
        for(int i=0;i<appidArray.length; i++){
            if(StringUtils.equals(appId, appidArray[i][0])){
                return appidArray[i][3];
            }
        }
        return null;
    }
    //获取appId对应的微信公众号 secret
    private String getWxappSecret(String appId){
        if(StringUtils.isBlank(appId)) return null;
        for(int i=0;i<appidArray.length; i++){
            if(StringUtils.equals(appId, appidArray[i][0])){
                return appidArray[i][2];
            }
        }
        return null;
    }


}
