package com.dayouzc.e2eapp.mcard.mcardcsm.web.tmp;

import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import com.dayouzc.e2eplatform.core.dto.equip.ConnectionInfoDTO;
import com.dayouzc.e2eplatform.core.dto.equip.EquipDTO;
import com.dayouzc.e2eplatform.core.dto.people.AccountDTO;
import com.dayouzc.e2eplatform.core.dto.people.AccountFeatureDTO;
import com.dayouzc.e2eplatform.core.util.DeviceUtils;
import com.dayouzc.e2eplatform.core.util.JsonUtil;
import com.dayouzc.e2eplatform.core.util.SpringUtils;
import com.dayouzc.e2eplatform.registerbind.constant.AccountConstant;
import com.dayouzc.e2eplatform.registerbind.constant.DeviceConstant;
import com.dayouzc.e2eplatform.registerbind.sdk.TokenSDK;
import com.dayouzc.e2eplatform.registerbind.sdk.equip.DeviceInfoSDK;
import com.dayouzc.e2eplatform.registerbind.sdk.people.AccountSDK;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 应用程序（Application）Client端 运行时的上下文环境Context。
 *
 * 1.Context的组成：
 *      主要包括当前连接信息（tokenInfo，里面包括人事物时地等信息）和token，以及一个环境参数的Map。
 * 2.App可通过相关login方法连接云端并获取token信息。
 *      一般在App启动时login调用；在token未获取成功、已失效等时需要再次login。
 * 3.App可通过loadContextParams方法，根据token的人事物时地等信息加载环境参数。
 *      一般在App启动并且login后调用。且在Context发生改变时需要重新调用以reload context。
 * 4.App可通过heartbeat方法保持与云端的连接，并上报例如当前最新位置、日志等信息。
 *      一般不超过30分钟调用一次（因token有效时间为30mins）。
 * 5.App可通过相关get方法获取Context相关信息。
 *
 * //TODO service端也需要处理appType，同时根据UA解析appid/name/ver等，微信根据公众号解析appid/name/ver等
 *
 * Created by fish on 2018/7/11.
 */
public class ICBCE2EAppWebContext {

    private static final Logger logger = LoggerFactory.getLogger(ICBCE2EAppWebContext.class);

    private static String rbsrv_ip = SpringUtils.getApplicationContext().getEnvironment().getProperty("e2e.svr.rbsvr-ip");
    private static String rbsrv_port = SpringUtils.getApplicationContext().getEnvironment().getProperty("e2e.svr.rbsvr-port");;
    private static String rbsrv_contextName = SpringUtils.getApplicationContext().getEnvironment().getProperty("e2e.svr.rbsvr-context");

    //================= Context Value
    //Web类应用的context存储在session中

//    /** 当前云端给本App组件分配的令牌 */
//    protected static String token;
//    /** 当前云端给本App组件分配的令牌对应的连接信息 */
//    protected static ConnectionInfoDTO tokenInfo;
//
//    /**当前环境参数。*/
//    protected static Map<String, String> contextParams;

    //==================== getter 方法（没有setter方法）
    /** get当前token */
    public static String getToken(HttpServletRequest httpServletRequest){
        //session中获取
        HttpSession session = httpServletRequest.getSession();
        String token = (String) session.getAttribute("token");
        return token;
    }

    /** get当前tokenInfo */
    public static ConnectionInfoDTO getTokenInfo(HttpServletRequest httpServletRequest){
        //session中获取
        HttpSession session = httpServletRequest.getSession();
        ConnectionInfoDTO tokenInfo = (ConnectionInfoDTO) session.getAttribute("tokenInfo");
        if(tokenInfo==null) return null;

        //refresh当前时间
        Date now = new Date();
        String timestr = DateFormatUtils.format( now, "yyyy-MM-dd HH:mm:ss");
        tokenInfo.setLastAccessTime(timestr);

        //如果token未失效，则递延失效时间
        if(StringUtils.isNotBlank(tokenInfo.getTokenValidTime()) && timestr.compareTo(tokenInfo.getTokenValidTime())<0){
            tokenInfo.setTokenValidTime(DateFormatUtils.format(DateUtils.addMinutes(now, 30), "yyyy-MM-dd HH:mm:ss"));
        }

        return tokenInfo;
    }

    /** get环境变量值 */
    public static Map<String, String> getContextParams(HttpServletRequest httpServletRequest){
        //session中获取
        HttpSession session = httpServletRequest.getSession();
        Map contextParams = (Map) session.getAttribute("contextParams");
        return contextParams;
    }

    /** get环境变量值 */
    public static String getContextParamValue(HttpServletRequest httpServletRequest, String key){
        //session中获取
        HttpSession session = httpServletRequest.getSession();
        Map contextParams = (Map) session.getAttribute("contextParams");

        if(contextParams==null) return null;
        if(StringUtils.isBlank(key)) return null;

        return (String)contextParams.get(key);
    }

    //==================== Login 获取token 的 处理方法

    /** 从APP中获取token TODO
     */
    public static boolean loginByApp(){
        return true;
    }

    /** 使用微信Login方法
     *
     * @param openId        用户微信公众号的openId；
     * @param weixinPId     微信公众号id；
     * @param weixinPName   微信公众号名称
     * @param dyopenId      在大有中城微信公众号的openId
     * @param account       微信公众号获取的用户信息，包括：名称、手机号、等
     */
    public static boolean loginByWechat(HttpServletRequest httpServletRequest, String openId, String weixinPId, String weixinPName, String dyopenId, AccountDTO account){
        // 0.初始化Context Param Value
        init(httpServletRequest);

        //  1.初始化login参数
        //物的信息
        ConnectionInfoDTO connectionInfoDTO = new ConnectionInfoDTO();
        connectionInfoDTO.setObjType(DeviceConstant.DeviceType.PERIPHER);
        //事的信息
        connectionInfoDTO.setAppType("WECHAT");
        String userAgent = httpServletRequest.getHeader("user-agent");
        connectionInfoDTO.setUserAgent(userAgent);
        //登录信息
        AccountFeatureDTO accountFeature = new AccountFeatureDTO();
        accountFeature.setFeatureType(AccountConstant.FeatureType.WECHAT);
        accountFeature.setFeatureValue(openId);
        accountFeature.setExt1(weixinPId);
        accountFeature.setExt2(weixinPName);
        accountFeature.setExt3(dyopenId);
        connectionInfoDTO.setAccountFeature(accountFeature);
        connectionInfoDTO.setAccount(account);

        //  2.调用sdk login
        ResponseData<ConnectionInfoDTO> handshakeResp = TokenSDK.getInstance(rbsrv_ip, rbsrv_port, rbsrv_contextName).loginByWechat(connectionInfoDTO, "");

        //  3.对login结果进行处理
        boolean result = handleLoginResult(httpServletRequest, handshakeResp, connectionInfoDTO);

        // 4.根据login信息获取 context 参数值
        loadContextParams(httpServletRequest);

        return result;
    }

    /** 使用工行融e联Login
     *
     * @param openId        融e联公众号用户id
     * @param mimsPId       融e联公众号id
     * @param mimsPName     融e联公众号名称
     * @param dyopenId      待定
     * @param account       融e联公众号获取的用户信息，包括：名称、手机号、等
     * @return
     */
    public static boolean loginByICBCMIMS(HttpServletRequest httpServletRequest, String openId, String mimsPId, String mimsPName, String dyopenId, AccountDTO account){
        // 0.初始化Context Param Value
        init(httpServletRequest);

        //  1.初始化login参数
        //物的信息
        ConnectionInfoDTO connectionInfoDTO = new ConnectionInfoDTO();
        connectionInfoDTO.setObjType(DeviceConstant.DeviceType.PERIPHER);
        //事的信息
        connectionInfoDTO.setAppType("ICBCMIMS");
        String userAgent = httpServletRequest.getHeader("user-agent");
        connectionInfoDTO.setUserAgent(userAgent);
        //登录信息
        AccountFeatureDTO accountFeature = new AccountFeatureDTO();
        accountFeature.setFeatureType(AccountConstant.FeatureType.ICBCMIMS);
        accountFeature.setFeatureValue(openId);
        accountFeature.setExt1(mimsPId);
        accountFeature.setExt2(mimsPName);
        accountFeature.setExt3(dyopenId);
        connectionInfoDTO.setAccountFeature(accountFeature);
        connectionInfoDTO.setAccount(account);

        //  2.调用sdk login
        ResponseData<ConnectionInfoDTO> handshakeResp = TokenSDK.getInstance(rbsrv_ip, rbsrv_port, rbsrv_contextName).loginByICBCMIMS(connectionInfoDTO, "");

        //  3.对login结果进行处理
        boolean result = handleLoginResult(httpServletRequest, handshakeResp, connectionInfoDTO);

        // 4.根据login信息获取 context 参数值
        loadContextParams(httpServletRequest);

        return result;

    }

    /** 使用浏览器Login，有用户信息。
     *
     * @param accountName   用户帐号。用户帐号和手机号二选一，手机号优先。
     * @param mobilePhone   用户手机号。用户帐号和手机号二选一，手机号优先。
     * @param password      用户密码。密码和验证码二选一，密码优先。
     * @param verifyCode    短信验证码。密码和验证码二选一，密码优先。
     */
    public static boolean login(HttpServletRequest httpServletRequest, String accountName, String mobilePhone, String password, String verifyCode){
        // 0.初始化Context Param Value
        init(httpServletRequest);

        //  1.初始化login参数
        //物的信息
        ConnectionInfoDTO connectionInfoDTO = new ConnectionInfoDTO();
        connectionInfoDTO.setObjType(DeviceConstant.DeviceType.PERIPHER);
        //事的信息
        connectionInfoDTO.setAppType("B");
        String userAgent = httpServletRequest.getHeader("user-agent");
        connectionInfoDTO.setUserAgent(userAgent);
        //登录信息
        AccountDTO account = new AccountDTO();
        account.setAccountName(accountName);
        account.setMobilePhone(mobilePhone);
        account.setPassword(password);
        connectionInfoDTO.setAccount(account);
        connectionInfoDTO.setVerifyCode(verifyCode);

        //  2.调用sdk login
        String token = getToken(httpServletRequest);    //获取之前的token
        ResponseData<ConnectionInfoDTO> handshakeResp = TokenSDK.getInstance(rbsrv_ip, rbsrv_port, rbsrv_contextName).login(connectionInfoDTO, token);

        //  3.对login结果进行处理
        boolean result = handleLoginResult(httpServletRequest, handshakeResp, connectionInfoDTO);

        // 4.根据login信息获取 context 参数值
        loadContextParams(httpServletRequest);

        return result;
    }

    /**
     * 使用浏览器Login，没有用户信息。
     */
    public static boolean login(HttpServletRequest httpServletRequest){
        // 0.初始化Context Param Value
        init(httpServletRequest);

        // 1.初始化login参数
        //物的信息
        ConnectionInfoDTO connectionInfoDTO = new ConnectionInfoDTO();
        connectionInfoDTO.setObjType(DeviceConstant.DeviceType.PERIPHER);
        //事的信息
        connectionInfoDTO.setAppType("B");
        String userAgent = httpServletRequest.getHeader("user-agent");
        connectionInfoDTO.setUserAgent(userAgent);

        // 2.调用sdk login
        String token = getToken(httpServletRequest);    //获取之前的token
        ResponseData<ConnectionInfoDTO> handshakeResp = TokenSDK.getInstance(rbsrv_ip, rbsrv_port, rbsrv_contextName).loginByBrowser(connectionInfoDTO, token);

        // 3.对login结果进行处理
        boolean result = handleLoginResult(httpServletRequest, handshakeResp, connectionInfoDTO);

        // 4.根据login信息获取 context 参数值
        loadContextParams(httpServletRequest);

        return result;
    }

    /**
     * 使用用户身份证信息登录。
     */
    public static boolean loginByIDCard(HttpServletRequest httpServletRequest, AccountDTO account){
        // 0.初始化Context Param Value
        init(httpServletRequest);

        // 1.初始化login参数
        //物的信息
        ConnectionInfoDTO connectionInfoDTO = new ConnectionInfoDTO();
        connectionInfoDTO.setObjType(DeviceConstant.DeviceType.PERIPHER);
        //事的信息
        connectionInfoDTO.setAppType("WECHAT");
        String userAgent = httpServletRequest.getHeader("user-agent");
        connectionInfoDTO.setUserAgent(userAgent);
        //登录信息
//        AccountFeatureDTO accountFeature = new AccountFeatureDTO();
//        accountFeature.setFeatureType(AccountConstant.FeatureType.WECHAT);
//        accountFeature.setFeatureValue(openId);
//        accountFeature.setExt1(weixinPId);
//        accountFeature.setExt2(weixinPName);
//        accountFeature.setExt3(dyopenId);
//        connectionInfoDTO.setAccountFeature(accountFeature);
        connectionInfoDTO.setAccount(account);

        // 2.调用sdk login
        String token = getToken(httpServletRequest);    //获取之前的token
        ResponseData<ConnectionInfoDTO> handshakeResp = TokenSDK.getInstance(rbsrv_ip, rbsrv_port, rbsrv_contextName).loginByIDCard(connectionInfoDTO, token);

        // 3.对login结果进行处理
        boolean result = handleLoginResult(httpServletRequest, handshakeResp, connectionInfoDTO);

        // 4.根据login信息获取 context 参数值
        loadContextParams(httpServletRequest);

        return result;
    }

    //TODO 切换用户
    public static boolean changeUser(){
        //TODO 上面的login，有可能login时带着用户和组织信息，直接进行校验后分配token
        //也有可能带着用户信息，后面根据需要再选择组织
        //也有可能没有用户和组织信息，

        return true;
    }

    /** 切换组织
     *
     * @param organId 新选择的组织id
     */
    public static boolean changeOrgan(HttpServletRequest httpServletRequest, String organId, String token){
        // 1.初始化login参数
        ConnectionInfoDTO connectionInfoDTO = new ConnectionInfoDTO();
        connectionInfoDTO.setOrganId(organId);

        // 2.调用sdk login
        ResponseData<ConnectionInfoDTO> handshakeResp = TokenSDK.getInstance(rbsrv_ip, rbsrv_port, rbsrv_contextName).chooseOrgan(connectionInfoDTO, token);

        // 3.对login结果进行处理
        boolean result = handleLoginResult(httpServletRequest, handshakeResp, connectionInfoDTO);

        // 4.根据login信息获取 context 参数值
        loadContextParams(httpServletRequest);

        return result;
    }

    public static boolean verifyToken(HttpServletRequest httpServletRequest, String token){
        // 1.初始化login参数
        ConnectionInfoDTO connectionInfoDTO = new ConnectionInfoDTO();
        String userAgent = httpServletRequest.getHeader("user-agent").toLowerCase();
        connectionInfoDTO.setUserAgent(userAgent);

        // 2.调用sdk 校验token
        ResponseData<ConnectionInfoDTO> handshakeResp = TokenSDK.getInstance(rbsrv_ip, rbsrv_port, rbsrv_contextName).verifyToken(token);

        // 3.对login结果进行处理
        return handleLoginResult(httpServletRequest, handshakeResp, connectionInfoDTO);
    }

    //==================== 心跳，保持连接
    //Web类应该没有心跳

//    /** 心跳，保持与云端的连接 */
//    public static boolean heartbeat(){
//        ResponseData heartbeatResp = TokenSDK.getInstance().heartbeat(token);
//        if(heartbeatResp==null){
//            logger.info("心跳失败！未找到上级云端平台/云平台");
//            return false;
//        }else if(!StringUtils.equals(heartbeatResp.getStatus(), "10000")){
//            logger.info("心跳失败！\nstatus：" + heartbeatResp.getStatus() + " \n msg：" + heartbeatResp.getMsg());
//            return false;
//        }else {
//            logger.info("心跳成功！");
//        }
//        return true;
//    }

    //==================== Context 处理方法

    /** 根据token的人事物时地等信息，加载环境参数。
     *
     * 主要包括：
     *  screenOrientation       屏幕方向。1竖屏；0横屏（默认）。
     *  ----- 云端状态及相关关系
     *  iserverStatus           云端状态。0待入库 1在库 3已出库 5在用 7报废
     *  iserverAccountBindType  当前用户和云端的关系。null未知；1管理员；2普通用户；3访客
     *  ----- 人相关关系
     *  userRole                当前用户和组织的关系。null未知；1负责人；2副手；3普通用户
     *
     *
     *  在以下情况需要调用此方法进行reload：
     *  1.切换用户、切换组织后；
     *  2.其他（例如：云端改变有派/终端的注册绑定关系、人和组织的角色等）
     */
    public static void loadContextParams(HttpServletRequest httpServletRequest){
        String token = getToken(httpServletRequest);
        ConnectionInfoDTO tokenInfo = getTokenInfo(httpServletRequest);

        //初始化清空ContextParams
        Map<String, String> contextParams = new HashMap<>();

        // 1.设置屏幕方向，默认为竖屏
        contextParams.put("screenOrientation", "1");
        if(tokenInfo!=null && StringUtils.equals(tokenInfo.getObjType(), DeviceConstant.DeviceType.ISERVER)){    //是有派
            contextParams.put("screenOrientation", "0");
        }else if(tokenInfo!=null && StringUtils.equals(tokenInfo.getObjType(), DeviceConstant.DeviceType.YOUPIE)){    //是有派
            contextParams.put("screenOrientation", "0");
        }else if(tokenInfo!=null && StringUtils.equals(tokenInfo.getObjType(), DeviceConstant.DeviceType.ISERVERARM)){    //是云端arm
            contextParams.put("screenOrientation", "0");
        }else if(!DeviceUtils.isMobileDevice(httpServletRequest)){    //false pc, ture mobile
            contextParams.put("screenOrientation", "0");
        }   //TODO 对于某些我们支持的终端，也要是横屏！！！

        // 2.要素间关系
        //  2.1.1.云端状态。0待入库 1在库 3已出库 5在用 7报废
        if(tokenInfo!=null && StringUtils.isNotBlank(tokenInfo.getIserverSn())) {
            ResponseData<EquipDTO> responseData = DeviceInfoSDK.getInstance().getEquip(tokenInfo.getIserverSn(), token);
            if(responseData!=null && responseData.getResult()!=null) {
                contextParams.put("iserverStatus", responseData.getResult().getEquipmentStatus());
            }
        }

        //  2.1.2.当前用户和云端的关系。null未知；1管理员；2普通用户；3访客
        if(tokenInfo!=null && StringUtils.isNotBlank(tokenInfo.getIserverSn()) && StringUtils.isNotBlank(tokenInfo.getAccountId())) {
            //TODO
//            ResponseData<IServerAccountBindInfoDTO> responseData = MyIServerSDK.getInstance().getiserver
            contextParams.put("iserverAccountBindType", null);
        }

        //  2.3.当前用户和组织的关系。null未知；1负责人；2副手；3普通用户
        if(tokenInfo!=null && StringUtils.isNotBlank(tokenInfo.getAccountId()) && StringUtils.isNotBlank(tokenInfo.getOrganId())) {
            //TODO
            contextParams.put("userRole", null);
        }
        HttpSession session = httpServletRequest.getSession();
        session.setAttribute("contextParams", contextParams);
    }

    //------------------------------- private function

    //初始化Context Param Value
    protected static void init(HttpServletRequest httpServletRequest){
        Map contextParams = new HashMap<>();

        // 设置屏幕方向，默认为竖屏
        contextParams.put("screenOrientation", "1");

        HttpSession session = httpServletRequest.getSession();
        session.setAttribute("contextParams", contextParams);
    }

    //处理Login 结果
    protected static boolean handleLoginResult(HttpServletRequest httpServletRequest, ResponseData<ConnectionInfoDTO> handshakeResp, ConnectionInfoDTO connectionInfoDTO){
        //获取当前时间，用于保存默认连接时 置最后访问时间
        Date now = new Date();
        String timestr = DateFormatUtils.format( now, "yyyy-MM-dd HH:mm:ss");

        //token将存储在session中
        HttpSession session = httpServletRequest.getSession();

        if(handshakeResp==null){
            logger.info("握手失败！未找到当前云端平台/云平台");

            //如果login失败，则保存默认的连接信息
            connectionInfoDTO.setLastAccessTime(timestr);
            session.setAttribute("tokenInfo", connectionInfoDTO);
            session.setAttribute("token", null);

            return false;
        }else if(!StringUtils.equals(handshakeResp.getStatus(), "10000")){
            logger.info("握手失败！\n    status：" + handshakeResp.getStatus() + " \n    msg：" + handshakeResp.getMsg());

            //如果login失败，则保存默认的连接信息
            //改为异常时不重置token和tokenInfo 。   modify by fish at 20181224
            connectionInfoDTO.setLastAccessTime(timestr);
//            session.setAttribute("tokenInfo", connectionInfoDTO);
//            session.setAttribute("token", null);

            return false;
        }else {
            ConnectionInfoDTO tokenInfo = handshakeResp.getResult();
            if(tokenInfo!=null && StringUtils.isNotEmpty(tokenInfo.getToken())){
                //TODO 湖南公安服务平台对接，临时从db获取account信息
                ResponseData<AccountDTO> currentAccountRespData = AccountSDK.getInstance().getAccountOfMine(tokenInfo.getToken());
                if(currentAccountRespData!=null && currentAccountRespData.getResult()!=null){
                    tokenInfo.setAccount(currentAccountRespData.getResult());
                }
                logger.info("HNTGA tokenInfo = " + JsonUtil.toJson(tokenInfo));

                session.setAttribute("tokenInfo", tokenInfo);
                session.setAttribute("token", tokenInfo.getToken());

                return true;
            }else {
                logger.info("握手失败！当前云端平台/云平台返回的token为空！");

                //如果login失败，则保存默认的连接信息
                connectionInfoDTO.setLastAccessTime(timestr);
                session.setAttribute("tokenInfo", connectionInfoDTO);
                session.setAttribute("token", null);

                return false;
            }
        }
    }
}
