package com.dayouzc.e2eapp.mcard.mcardcsm.web.tmp;

import com.dayouzc.e2eapp.mcard.mcardcsm.web.util.hunan.CertificateInfo;
import com.dayouzc.e2eapp.mcard.mcardcsm.web.util.hunan.HunanUtils;
import com.dayouzc.e2eplatform.core.context.E2EAppWebContext;
import com.dayouzc.e2eplatform.core.dto.equip.ConnectionInfoDTO;
import com.dayouzc.e2eplatform.core.dto.people.AccountDTO;
import com.dayouzc.e2eplatform.registerbind.constant.AccountConstant;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 对 湖南公安EID对接时对用户信息的获取 的校验拦截器。
 *
 * 如果是湖南公安的对接页面，则通过接口获取用户身份信息（身份证的信息，包括：证件号码/姓名/性别/民族/生日/地址/照片等），并进行相关逻辑处理。
 *
 * 注：
 * 20191220 从原ICBCContextAccountInterceptor中独立出来。
 *
 * @author fish
 * @date 2019/12/20
 */
public class HntgaContextAccountInterceptor implements HandlerInterceptor{
    private static final Logger logger = LoggerFactory.getLogger(HntgaContextAccountInterceptor.class);

    private static String rbweb_contextName = "rbweb";
    //向apk通知异常的页面uri，绝对路径
    private static String uri_notifyex2apk = "/" + rbweb_contextName + "/e2eerror/apk";
    //使用用户信息登录绑定的页面uri，绝对路径
    private static String uri_login = "/" + rbweb_contextName + "/login";

    @Override
    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
        logger.info("");
        logger.info("=================== Web AOP - HNTGA Context Account Interceptor start =======================");
        logger.info("request uri = [ " + httpServletRequest.getRequestURI() + " ]");

        //获取context
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo(httpServletRequest);

        if(tokenInfo==null || StringUtils.isBlank(tokenInfo.getToken())){   //这种情况应该被TokenInterceptor拦截了，写此仅为了保证代码的完整性
            logger.info(" token is null :( ?????? ");
            return false;
        }else if (isHntga(httpServletRequest, tokenInfo)){    //if 是微信，且是“湖南公安服务平台”，则：自动获取用户身份证信息，并进行相关用户信息处理
                httpServletRequest.getSession().setAttribute("isHntga", "isHntga");
                //1. 获取用户详细信息（从湖南公安服务平台获取身份证详情）
                AccountDTO accountDTO = gatherIDCardInfo(httpServletRequest);

                //2. 调用sdk，使用用户身份证信息登录。  TODO 目前service是直接根据用户身份证信息update，未来可改为根据需要（例如：只有身份证有效期有更新）update
                ICBCE2EAppWebContext.loginByIDCard(httpServletRequest, accountDTO);

                //3. return continue
                logger.info(" login by account idcard info !");
                return true;
        }else {
            logger.info(" token has account info !");
            return true;
        }
    }

    @Override
    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {

        logger.info("=================== Web AOP - HNTGA Context Account Interceptor e n d =======================\n");
    }

    @Override
    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {

    }

    //判断 是微信，且是“湖南公安服务平台”
    private boolean isHntga(HttpServletRequest httpServletRequest, ConnectionInfoDTO tokenInfo){
        //判断是否微信
        if(!StringUtils.equals(tokenInfo.getAppType(), "WECHAT")){
            return false;
        }

        //判断是否是湖南公安服务平台  TODO 暂时使用访问uri判断，未来可改为通过appid判断
        String uri = (String)httpServletRequest.getSession().getAttribute("uri");
        if(StringUtils.isBlank(uri)){
            uri = httpServletRequest.getRequestURI();
        }
        return uri.contains("/mine/hntga");
    }

    //从湖南公安服务平台获取用户身份证信息
    private AccountDTO gatherIDCardInfo(HttpServletRequest request){
        Object codeObj = request.getSession().getAttribute("codeHntga");
        if(codeObj==null) return null;

        String codeHntga = codeObj.toString(); //TODO

        CertificateInfo certificateInfo = HunanUtils.getCertificateInfoByCode(codeHntga);
        if(certificateInfo == null) return null;

        AccountDTO accountDTO = new AccountDTO();
        accountDTO.setUserName(certificateInfo.getUserName());
        accountDTO.setCertificateNumber(certificateInfo.getCertificateNumber());
        accountDTO.setUserPic(certificateInfo.getUserPic());
        accountDTO.setAddress(certificateInfo.getAddress());
        String sex = null;
        if(StringUtils.equals(certificateInfo.getSex(), "男")){
            sex = AccountConstant.Sex.MALE;
        }else if(StringUtils.equals(certificateInfo.getSex(), "女")){
            sex = AccountConstant.Sex.FEMALE;
        }else{
        }
        accountDTO.setSex(sex);
        accountDTO.setEthnic(certificateInfo.getEthnic());
        accountDTO.setOrgCode(certificateInfo.getOrgCode());
        accountDTO.setOrgName(certificateInfo.getOrgName());
        accountDTO.setStartTime(certificateInfo.getStartTime());
        accountDTO.setEndTime(certificateInfo.getEndTime());
        return accountDTO;
    }

}
