package com.dayouzc.e2eapp.mcard.mcardcsm.web.dto;

import com.dayouzc.e2eapp.mcard.dto.McardDeliverDetailDTO;
import com.dayouzc.e2eapp.mcard.dto.McardOrderDetailDTO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;
import java.util.List;

/**
 *  订单包装类<br>
 *      在OrderInfoDTO的基础之上明确订单明细、订单发货明细的泛型<br>
 * Created by tyutNo4 on 2017/12/11.
 */
public class OrderInfoWrapperDTO {

    /** 平台订单编号  */
    private String orderId ;
    /** 应用订单编号（销售商或渠道） */
    private String appOrderNo ;
    /** 供应商订单编号*/
    private String spOrderNo  ;
    /** 订单下单的token  */
    private String token;

    //================== 卖家
    /** 销售客户id */
    private String saleBoId;
    /** 销售客户*/
    private String saleBoName ;
    /** 销售商铺id */
    private String saleOrganId;
    /** 销售商铺*/
    private String saleOrganName ;

    //================== 商家
    /** 合作伙伴ID */
    private String partnerId  ;
    /** 合作伙伴名称  */
    private String partnerName;
    /** 商铺ID  */
    private String mcId ;
    /** 商铺名称*/
    private String mcName  ;

    //======================= 订单类型
    /** "订单类型：B2B：B2B订单;  B2C：B2C订单;B2B2C：代购订单" */
    private String orderType  ;
    /** "销售类型  11：销售订单；12：会员卡优惠销售订单;21：续费订单；（对原有订单的延续）;22：升级订单；（对原有订单的改单，需补差价或退 */
    private String saleType;

    //========================== 买家
    /** "买家会员ID。如果是B2C或B2B2C订单，则是AccountId;如果是B2B订单，则是MCID" */
    private String buyerId ;
    /** 联系人  */
    private String userName;
    /** 手机号  */
    private String mobile  ;
    /** 证件类型*/
    private String certificateType  ;
    /** 身份证号*/
    private String certificateNumber;
    /** 会员卡类型 */
    private String mcardType  ;
    /** 会员卡名称 */
    private String mcardName  ;
    /** 会员卡id*/
    private String mcardId ;
    /** 会员卡号*/
    private String mcardNum;

    //========================= 订单内容
    /** 商品名称*/
    private String orderName  ;
    /** 订单描述*/
    private String orderDes;
    /** 订单商品数（种） */
    private String orderCmNum1;
    private String orderCmNum2;
    /** 订单商品数量（单品）*/

    //========================= 订单金额
    /** 订单金额=商品金额+附加费用+运费-客户优惠金额*/
    private Integer orderAmount;
    /** 订单积分价格，对于以积分标价的商品而言*/
    private String orderIntegral ;

    //========================== 订单金额明细
    /** 商品金额*/
    private Integer cmBill  ;
    /** 运费 */
    private Integer carriage;
    /** 附加费用*/
    private Integer feeAdditional ;
    /** 附加费用说明  */
    private String feeAdditionalDesc;
    /** 客户优惠金额  */
    private Integer favAmount  ;

    //============================= 支付信息
    /** 支付方式*/
    private String payMethod  ;
    /** 支付渠道*/
    private String payChannel ;
    /** 支付用户ID */
    private String payUserId  ;
    /** 支付人  */
    private String payMan  ;
    /** 支付结果 成功、失败 */
    private String paymentResult ;
    /** 支付记录编号  */
    private String recordId;
    /** 支付记录时间  */
    private String recordTime ;
    /** 支付流水序号  */
    private String recordNumber  ;
    /** 实际支付金额  */
    private Integer payMoney;
    /** 实际支付积分  */
    private Integer payIntegral;
    /** 是否使用积分：0否，1是 */
    private String useIntegral;
    /** 实际支付红包金额（优惠金额） */
    private Integer payHongbao ;
    /** 红包ID  */
    private String hongbaoId  ;
    /** 是否应奖励积分*/
    private String integralRule  ;
    /** 可获得积分 */
    private String addIntegral;

    //================================= 退款信息
    /** 退款金额*/
    private String refundAmount  ;
    /** 手续费  */
    private String factorage  ;
    /** 退款原因*/
    private String refundReason  ;
    /** 退款时间*/
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date refundTime ;

    //================================ 物流信息
    /** 收件人省*/
    private String lgProvinceCode;
    /***/
    private String lgProvince ;
    /** 收件人市*/
    private String lgCityCode ;
    /***/
    private String lgCity  ;
    /** 收件人县*/
    private String lgCountyCode  ;
    /***/
    private String lgCounty;
    /** 收件人姓名 */
    private String lgRecipient;
    /** 收件人手机 */
    private String lgPhone ;
    /** 收货地址*/
    private String lgAddrress ;
    /** 收货邮编*/
    private String lgZipcode  ;
    /** "配送方式：1邮寄；2自取；3电子配送"*/
    private String lgSendtype ;
    /** 期望送货时间  */
    private String lgSenddate ;
    /** 发货员ID*/
    private String lgSenderId ;
    /** 发货员姓名 */
    private String lgSenderName  ;
    /** 快递类型*/
    private String lgExpressType ;
    /** 快递人  */
    private String lgExpressName ;
    /** 快递单号*/
    private String lgExpressNum  ;

    //========================== 发票信息
    /** "发票类型 0：个人 ;1：单位;9：不需要发票"*/
    private String receiptType;
    /** 发票抬头 发票类型设置为单位时需要填写 */
    private String receiptName;
    /** 发票单位税号*/
    private String receiptTaxnum;
    /** 发票获取方式 0：邮寄；1：到店取 */
    private String receiptRecv;
    /** 发票备注 发票备注信息，可写邮寄地址*/
    private String receiptDesc;

    //=============================== 状态
    /** "订单状态 9：待确认  0：待支付 1：已取消 2：已支付 3：已完成 4：申请退款 5：退款中 6：已退款 7：退款失败 8：已发货" */
    private String orderStatus;
    /** 订单结果*/
    private String orderResult;
    /** 支付状态*/
    private String payStatus  ;
    /** 结算状态*/
    private String clearStatus;
    /** 订单创建时间  */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createDate ;
    /** 订单确认时间  */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date verifyDate ;
    /** 订单失效时间  */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date failureTime;
    /** 备注 */
    private String memo ;

    //============================ 关联子对象
    /** 订单明细 */
    private List<McardOrderDetailDTO> orderDetails;
    /** 订单发货明细 */
    private List<McardDeliverDetailDTO> orderDeliverDetails;


    //----------------- setter and getter

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getAppOrderNo() {
        return appOrderNo;
    }

    public void setAppOrderNo(String appOrderNo) {
        this.appOrderNo = appOrderNo;
    }

    public String getSpOrderNo() {
        return spOrderNo;
    }

    public void setSpOrderNo(String spOrderNo) {
        this.spOrderNo = spOrderNo;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getSaleBoId() {
        return saleBoId;
    }

    public void setSaleBoId(String saleBoId) {
        this.saleBoId = saleBoId;
    }

    public String getSaleBoName() {
        return saleBoName;
    }

    public void setSaleBoName(String saleBoName) {
        this.saleBoName = saleBoName;
    }

    public String getSaleOrganId() {
        return saleOrganId;
    }

    public void setSaleOrganId(String saleOrganId) {
        this.saleOrganId = saleOrganId;
    }

    public String getSaleOrganName() {
        return saleOrganName;
    }

    public void setSaleOrganName(String saleOrganName) {
        this.saleOrganName = saleOrganName;
    }

    public String getPartnerId() {
        return partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getPartnerName() {
        return partnerName;
    }

    public void setPartnerName(String partnerName) {
        this.partnerName = partnerName;
    }

    public String getMcId() {
        return mcId;
    }

    public void setMcId(String mcId) {
        this.mcId = mcId;
    }

    public String getMcName() {
        return mcName;
    }

    public void setMcName(String mcName) {
        this.mcName = mcName;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getSaleType() {
        return saleType;
    }

    public void setSaleType(String saleType) {
        this.saleType = saleType;
    }

    public String getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(String buyerId) {
        this.buyerId = buyerId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getCertificateType() {
        return certificateType;
    }

    public void setCertificateType(String certificateType) {
        this.certificateType = certificateType;
    }

    public String getCertificateNumber() {
        return certificateNumber;
    }

    public void setCertificateNumber(String certificateNumber) {
        this.certificateNumber = certificateNumber;
    }

    public String getMcardType() {
        return mcardType;
    }

    public void setMcardType(String mcardType) {
        this.mcardType = mcardType;
    }

    public String getMcardName() {
        return mcardName;
    }

    public void setMcardName(String mcardName) {
        this.mcardName = mcardName;
    }

    public String getMcardId() {
        return mcardId;
    }

    public void setMcardId(String mcardId) {
        this.mcardId = mcardId;
    }

    public String getMcardNum() {
        return mcardNum;
    }

    public void setMcardNum(String mcardNum) {
        this.mcardNum = mcardNum;
    }

    public String getOrderName() {
        return orderName;
    }

    public void setOrderName(String orderName) {
        this.orderName = orderName;
    }

    public String getOrderDes() {
        return orderDes;
    }

    public void setOrderDes(String orderDes) {
        this.orderDes = orderDes;
    }

    public String getOrderCmNum1() {
        return orderCmNum1;
    }

    public void setOrderCmNum1(String orderCmNum1) {
        this.orderCmNum1 = orderCmNum1;
    }

    public String getOrderCmNum2() {
        return orderCmNum2;
    }

    public void setOrderCmNum2(String orderCmNum2) {
        this.orderCmNum2 = orderCmNum2;
    }

    public Integer getOrderAmount() {
        return orderAmount;
    }

    public void setOrderAmount(Integer orderAmount) {
        this.orderAmount = orderAmount;
    }

    public String getOrderIntegral() {
        return orderIntegral;
    }

    public void setOrderIntegral(String orderIntegral) {
        this.orderIntegral = orderIntegral;
    }

    public Integer getCmBill() {
        return cmBill;
    }

    public void setCmBill(Integer cmBill) {
        this.cmBill = cmBill;
    }

    public Integer getCarriage() {
        return carriage;
    }

    public void setCarriage(Integer carriage) {
        this.carriage = carriage;
    }

    public Integer getFeeAdditional() {
        return feeAdditional;
    }

    public void setFeeAdditional(Integer feeAdditional) {
        this.feeAdditional = feeAdditional;
    }

    public String getFeeAdditionalDesc() {
        return feeAdditionalDesc;
    }

    public void setFeeAdditionalDesc(String feeAdditionalDesc) {
        this.feeAdditionalDesc = feeAdditionalDesc;
    }

    public Integer getFavAmount() {
        return favAmount;
    }

    public void setFavAmount(Integer favAmount) {
        this.favAmount = favAmount;
    }

    public String getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(String payMethod) {
        this.payMethod = payMethod;
    }

    public String getPayChannel() {
        return payChannel;
    }

    public void setPayChannel(String payChannel) {
        this.payChannel = payChannel;
    }

    public String getPayUserId() {
        return payUserId;
    }

    public void setPayUserId(String payUserId) {
        this.payUserId = payUserId;
    }

    public String getPayMan() {
        return payMan;
    }

    public void setPayMan(String payMan) {
        this.payMan = payMan;
    }

    public String getPaymentResult() {
        return paymentResult;
    }

    public void setPaymentResult(String paymentResult) {
        this.paymentResult = paymentResult;
    }

    public String getRecordId() {
        return recordId;
    }

    public void setRecordId(String recordId) {
        this.recordId = recordId;
    }

    public String getRecordTime() {
        return recordTime;
    }

    public void setRecordTime(String recordTime) {
        this.recordTime = recordTime;
    }

    public String getRecordNumber() {
        return recordNumber;
    }

    public void setRecordNumber(String recordNumber) {
        this.recordNumber = recordNumber;
    }

    public Integer getPayMoney() {
        return payMoney;
    }

    public void setPayMoney(Integer payMoney) {
        this.payMoney = payMoney;
    }

    public Integer getPayIntegral() {
        return payIntegral;
    }

    public void setPayIntegral(Integer payIntegral) {
        this.payIntegral = payIntegral;
    }

    public String getUseIntegral() {
        return useIntegral;
    }

    public void setUseIntegral(String useIntegral) {
        this.useIntegral = useIntegral;
    }

    public Integer getPayHongbao() {
        return payHongbao;
    }

    public void setPayHongbao(Integer payHongbao) {
        this.payHongbao = payHongbao;
    }

    public String getHongbaoId() {
        return hongbaoId;
    }

    public void setHongbaoId(String hongbaoId) {
        this.hongbaoId = hongbaoId;
    }

    public String getIntegralRule() {
        return integralRule;
    }

    public void setIntegralRule(String integralRule) {
        this.integralRule = integralRule;
    }

    public String getAddIntegral() {
        return addIntegral;
    }

    public void setAddIntegral(String addIntegral) {
        this.addIntegral = addIntegral;
    }

    public String getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(String refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getFactorage() {
        return factorage;
    }

    public void setFactorage(String factorage) {
        this.factorage = factorage;
    }

    public String getRefundReason() {
        return refundReason;
    }

    public void setRefundReason(String refundReason) {
        this.refundReason = refundReason;
    }

    public Date getRefundTime() {
        return refundTime;
    }

    public void setRefundTime(Date refundTime) {
        this.refundTime = refundTime;
    }

    public String getLgProvinceCode() {
        return lgProvinceCode;
    }

    public void setLgProvinceCode(String lgProvinceCode) {
        this.lgProvinceCode = lgProvinceCode;
    }

    public String getLgProvince() {
        return lgProvince;
    }

    public void setLgProvince(String lgProvince) {
        this.lgProvince = lgProvince;
    }

    public String getLgCityCode() {
        return lgCityCode;
    }

    public void setLgCityCode(String lgCityCode) {
        this.lgCityCode = lgCityCode;
    }

    public String getLgCity() {
        return lgCity;
    }

    public void setLgCity(String lgCity) {
        this.lgCity = lgCity;
    }

    public String getLgCountyCode() {
        return lgCountyCode;
    }

    public void setLgCountyCode(String lgCountyCode) {
        this.lgCountyCode = lgCountyCode;
    }

    public String getLgCounty() {
        return lgCounty;
    }

    public void setLgCounty(String lgCounty) {
        this.lgCounty = lgCounty;
    }

    public String getLgRecipient() {
        return lgRecipient;
    }

    public void setLgRecipient(String lgRecipient) {
        this.lgRecipient = lgRecipient;
    }

    public String getLgPhone() {
        return lgPhone;
    }

    public void setLgPhone(String lgPhone) {
        this.lgPhone = lgPhone;
    }

    public String getLgAddrress() {
        return lgAddrress;
    }

    public void setLgAddrress(String lgAddrress) {
        this.lgAddrress = lgAddrress;
    }

    public String getLgZipcode() {
        return lgZipcode;
    }

    public void setLgZipcode(String lgZipcode) {
        this.lgZipcode = lgZipcode;
    }

    public String getLgSendtype() {
        return lgSendtype;
    }

    public void setLgSendtype(String lgSendtype) {
        this.lgSendtype = lgSendtype;
    }

    public String getLgSenddate() {
        return lgSenddate;
    }

    public void setLgSenddate(String lgSenddate) {
        this.lgSenddate = lgSenddate;
    }

    public String getLgSenderId() {
        return lgSenderId;
    }

    public void setLgSenderId(String lgSenderId) {
        this.lgSenderId = lgSenderId;
    }

    public String getLgSenderName() {
        return lgSenderName;
    }

    public void setLgSenderName(String lgSenderName) {
        this.lgSenderName = lgSenderName;
    }

    public String getLgExpressType() {
        return lgExpressType;
    }

    public void setLgExpressType(String lgExpressType) {
        this.lgExpressType = lgExpressType;
    }

    public String getLgExpressName() {
        return lgExpressName;
    }

    public void setLgExpressName(String lgExpressName) {
        this.lgExpressName = lgExpressName;
    }

    public String getLgExpressNum() {
        return lgExpressNum;
    }

    public void setLgExpressNum(String lgExpressNum) {
        this.lgExpressNum = lgExpressNum;
    }

    public String getReceiptType() {
        return receiptType;
    }

    public void setReceiptType(String receiptType) {
        this.receiptType = receiptType;
    }

    public String getReceiptName() {
        return receiptName;
    }

    public void setReceiptName(String receiptName) {
        this.receiptName = receiptName;
    }

    public String getReceiptTaxnum() {
        return receiptTaxnum;
    }

    public OrderInfoWrapperDTO setReceiptTaxnum(String receiptTaxnum) {
        this.receiptTaxnum = receiptTaxnum;
        return this;
    }

    public String getReceiptRecv() {
        return receiptRecv;
    }

    public void setReceiptRecv(String receiptRecv) {
        this.receiptRecv = receiptRecv;
    }

    public String getReceiptDesc() {
        return receiptDesc;
    }

    public void setReceiptDesc(String receiptDesc) {
        this.receiptDesc = receiptDesc;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getOrderResult() {
        return orderResult;
    }

    public void setOrderResult(String orderResult) {
        this.orderResult = orderResult;
    }

    public String getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
    }

    public String getClearStatus() {
        return clearStatus;
    }

    public void setClearStatus(String clearStatus) {
        this.clearStatus = clearStatus;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getVerifyDate() {
        return verifyDate;
    }

    public void setVerifyDate(Date verifyDate) {
        this.verifyDate = verifyDate;
    }

    public Date getFailureTime() {
        return failureTime;
    }

    public void setFailureTime(Date failureTime) {
        this.failureTime = failureTime;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<McardOrderDetailDTO> getOrderDetails() {
        return orderDetails;
    }

    public void setOrderDetails(List<McardOrderDetailDTO> orderDetails) {
        this.orderDetails = orderDetails;
    }

    public List<McardDeliverDetailDTO> getOrderDeliverDetails() {
        return orderDeliverDetails;
    }

    public void setOrderDeliverDetails(List<McardDeliverDetailDTO> orderDeliverDetails) {
        this.orderDeliverDetails = orderDeliverDetails;
    }
}
