package com.dayouzc.e2eapp.mcard.mcardcsm.web.controller;

import com.dayouzc.e2eapp.ebusiness.dto.MerchantDTO;
import com.dayouzc.e2eapp.ebusiness.sdk.MerchantSDK;
import com.dayouzc.e2eapp.mcard.dto.McardChildtypeDTO;
import com.dayouzc.e2eapp.mcard.dto.McardCmfreeDTO;
import com.dayouzc.e2eapp.mcard.dto.McardMccatalogDTO;
import com.dayouzc.e2eapp.mcard.dto.McardTypeDTO;
import com.dayouzc.e2eapp.mcard.sdk.McardTypeSDK;
import com.dayouzc.e2eplatform.core.common.ConditionRangeValue;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpSession;
import java.util.List;
import java.util.Map;

/**
 * Created by Mr.Liu on 2017/8/8.
 *
 * “/mcardtypes”是卡类型相关资源根目录，主要包括：
 *
 * 查询类（买家角度）
 *
 * 1.作为消费者查询页面
 * /		                        卡类型查询页面。        显示卡类型列表。
 * /childtypes	                    子卡类型查询页面。      显示子卡类型列表。
 *
 * 2.作为消费者详情页面  卡类型
 * /{typeId}		                卡类型基本信息页面。    显示指定卡类型的基本信息，仅用于显示用。
 * /{typeId}/detail		            卡类型详情和购买页面。  显示指定卡类型的基本信息、使用须知、适用景区等详细信息，并可进行下单购买。
 * /{typeId}/intro		            会员卡介绍页面。        显示卡类型简介和图文详情。如果指定了cardNum参数则显示卡号（仅显示）。
 * /{typeId}/suitablemc     	    会员卡适用景区页面。    显示指定卡类型的适用景区和优惠商铺清单。如果指定了cardNum参数则显示卡号（仅显示）。
 * /{typeId}/memo		            会员卡使用须知页面。    如果指定了cardNum参数则显示卡号（仅显示）。
 * /{typeId}/aboutus	            会员卡关于我们页面。    显示指定卡类型的关联商铺和商户信息。如果指定了cardNum参数则显示卡号（仅显示）。
 * /{typeId}/reservemc	            会员卡可预约景区页面。  显示指定卡类型的可预约景区列表。如果指定了cardNum参数则显示卡号（仅显示）。
 *
 * 3.作为消费者详情页面  子卡类型
 * /childtypes/{childtypeId}		子卡类型基本信息页面。 显示指定子卡类型的基本信息，仅用于显示用。
 * /childtypes/{childtypeId}/detail	子卡类型详情页面。     显示指定子卡类型的详细信息，并可进行下单购买。
 *
 */
@Controller
@RequestMapping("/mcardtypes")
public class MCardTypeController {

    private static final Logger logger = LoggerFactory.getLogger(MCardTypeController.class);

    //==================查询类（买家角度）

    //--------------------------- 作为消费者查询页面

    /**卡类型查询页面。
     * 显示卡类型列表。
     *
     */
    @RequestMapping(value = "")
    public String queryMCardType(Map<String, Object> model,
                                 HttpSession session) {
        String token = (String) session.getAttribute("token");

        return "mcardcsm/mcardtype/list/list";
    }

    /**子卡类型查询页面。
     * 显示子卡类型列表。
     */
    @RequestMapping(value = "/childtypes")
    public String queryChildtype(Map<String, Object> model,
                                 HttpSession session) {
        String token = (String) session.getAttribute("token");


        return "mcardcsm/childtype/list/list";
    }


    //--------------------------- 作为消费者详情页面  卡类型

    /**卡类型基本信息页面。
     * 显示指定卡类型的基本信息，仅用于显示用。
     */
    @RequestMapping(value = "/{typeId}")
    public String getMCardType(Map<String, Object> model, HttpSession session, @PathVariable("typeId")String typeId) {
        String token = (String) session.getAttribute("token");
        //1、查询卡类型信息
        ResponseData<McardTypeDTO> responseData1 = McardTypeSDK.getInstance().getMCardType( typeId,token);
        model.put("mcardType", responseData1.getResult());

        //2、查询子卡类型信息
        ResponseData<List<McardChildtypeDTO>> responseData2 = McardTypeSDK.getInstance().getChildTypeListOfMCardType(typeId, token);
        model.put("childTypeList", responseData2.getResult());

        //3、查询年卡适用商铺目录
        McardCmfreeDTO cmfreeParam = new McardCmfreeDTO();
        PageRequest pageRequest = new PageRequest(1,100);
        ConditionRangeValue rangeValue = new ConditionRangeValue();
        ResponseData<List<McardCmfreeDTO>> responseData3 = McardTypeSDK.getInstance().queryCmfreeOfMCardType(typeId, cmfreeParam, rangeValue, pageRequest, token);
        model.put("mcardCmfreeList", responseData3.getResult());

        return "mcardcsm/mcardtype/detail/baseinfo";
    }

    /**卡类型详情和购买页面。
     * 显示指定卡类型的基本信息、使用须知、适用景区等详细信息，并可进行下单购买。
     * TODO 1.点击“虚拟卡/实体卡”后浏览器进度条有显示，是因为？2.如果没有子卡种类，无法购买？3.简介/图文详情/使用规则/？4.适用景区
     */
    @RequestMapping(value = "/{typeId}/detail")
    public String getMCardTypeDetail(Map<String, Object> model,
                                    HttpSession session,
                                    @PathVariable("typeId")String typeId) {
        String token = (String) session.getAttribute("token");

        return "mcardcsm/mcardtype/detail/detail";
    }

    /**会员卡介绍页面。
     * 显示卡类型简介和图文详情。
     *
     * @param cardNum   如果指定了cardNum参数则显示卡号（仅显示）。
     * @return
     */
    @RequestMapping(value = "/{typeId}/intro")
    public String getMCardTypeIntro(Map<String, Object> model, HttpSession session,
                                    @PathVariable("typeId")String typeId,
                                    @RequestParam(value = "cardNum",required = false) String cardNum) {
        String token = (String) session.getAttribute("token");

        //1、查询卡类型信息
        ResponseData<McardTypeDTO> responseData = McardTypeSDK.getInstance().getMCardType( typeId,token);
        model.put("mcardType", responseData.getResult());
        model.put("cardNum", cardNum);

        return "mcardcsm/mcardtype/detail/intro";
    }

    /**会员卡适用景区页面。
     * 显示指定卡类型的适用景区和优惠商铺清单。如果指定了cardNum参数则显示卡号（仅显示）。
     *
     * @param cardNum   如果指定了cardNum参数则显示卡号（仅显示）。
     * @return
     */
    @RequestMapping(value = "/{typeId}/suitablemc")
    public String queryMcardSuitableMc(Map<String, Object> model, HttpSession session,
                                       @PathVariable("typeId")String typeId,
                                       @RequestParam(value = "cardNum",required = false) String cardNum) {

        String token = (String) session.getAttribute("token");
        Pageable pageable = new PageRequest(0,100);
        //1、查询卡类型信息
        ResponseData<McardTypeDTO> responseData = McardTypeSDK.getInstance().getMCardType( typeId,token);
        model.put("mcardType", responseData.getResult());
        model.put("cardNum", cardNum);

        //卡类型的年卡商铺
        McardCmfreeDTO mcardCmfreeDTO = new McardCmfreeDTO();
        ResponseData<List<McardCmfreeDTO>> freeResponseData = McardTypeSDK.getInstance().queryCmfreeOfMCardType( typeId, mcardCmfreeDTO, null, pageable,token);

        //卡类型的优惠商铺 TODO 会员卡的适用景区如何查询展示？？？？
//        McardMccatalogDTO mcardMccatalogDTO = new McardMccatalogDTO();
//        ResponseData<List<McardMccatalogDTO>> logResponseData = McardTypeSDK.getInstance().queryMccatalogOfMCardType(typeId,mcardMccatalogDTO,null,pageable,token);

        if (freeResponseData != null) {
            List<McardCmfreeDTO> mcardCmfrees = freeResponseData.getResult();
            model.put("mcardCmfrees",mcardCmfrees);
        }

/*        if (logResponseData != null) {
            List<McardMccatalogDTO> mcardMccatalogs = logResponseData.getResult();
            model.put("mcardMccatalogs",mcardMccatalogs);
        }*/

        return "mcardcsm/mcardtype/detail/suitablemc";
    }

    /**会员卡使用须知页面。
     * 会员卡使用须知
     * TODO memo字段是使用须知
     * @param cardNum   如果指定了cardNum参数则显示卡号（仅显示）。
     * @return
     */
    @RequestMapping(value = "/{typeId}/memo")
    public String getMCardTypeMemo(Map<String, Object> model, HttpSession session,
                                   @PathVariable("typeId")String typeId,
                                   @RequestParam(value = "cardNum",required = false) String cardNum) {
        String token = (String) session.getAttribute("token");

        //1、查询卡类型信息
        ResponseData<McardTypeDTO> responseData = McardTypeSDK.getInstance().getMCardType( typeId,token);
        model.put("mcardType", responseData.getResult());
        model.put("cardNum", cardNum);

        return "mcardcsm/mcardtype/detail/memo";
    }

    /**会员卡关于我们页面。
     * 显示指定卡类型的关联商铺和商户信息。
     *
     * @param cardNum   如果指定了cardNum参数则显示卡号（仅显示）。
     * @return
     */
    @RequestMapping(value = "/{typeId}/aboutus")
    public String getMCardTypeAboutUs(Map<String, Object> model, HttpSession session,
                                      @PathVariable("typeId")String typeId,
                                      @RequestParam(value = "cardNum",required = false) String cardNum) {
        String token = (String) session.getAttribute("token");

        //1、查询卡类型信息
        ResponseData<McardTypeDTO> responseData1 = McardTypeSDK.getInstance().getMCardType( typeId,token);
        McardTypeDTO mcardTypeDTO = responseData1.getResult();
        model.put("mcardType", mcardTypeDTO);
        model.put("cardNum", cardNum);

        //2. 查询卡类型的商铺信息
        ResponseData<MerchantDTO> responseDataMc = MerchantSDK.getInstance().getMerchant(mcardTypeDTO.getMcId(), token);
        model.put("mc", responseDataMc.getResult());

        return "mcardcsm/mcardtype/detail/aboutus";
    }

    /**会员卡可预约景区页面。
     * 显示指定卡类型的可预约景区列表。如果指定了cardNum参数则显示卡号（仅显示）。
     *
     * @param cardNum   如果指定了cardNum参数则显示卡号（仅显示）。
     * @return
     */
    @RequestMapping(value = "/{typeId}/reservemc")
    public String queryMcardReserveMc(Map<String, Object> model, HttpSession session,
                                      @PathVariable("typeId")String typeId,
                                      @RequestParam(value = "cardNum",required = false) String cardNum) {
        String token = (String) session.getAttribute("token");
        Pageable pageable = new PageRequest(0,100);

        //1、查询卡类型信息
        ResponseData<McardTypeDTO> responseData = McardTypeSDK.getInstance().getMCardType( typeId,token);
        model.put("mcardType", responseData.getResult());
        model.put("cardNum", cardNum);


        //卡类型的年卡商铺
        McardCmfreeDTO mcardCmfreeDTO = new McardCmfreeDTO();
        ResponseData<List<McardCmfreeDTO>> freeResponseData = McardTypeSDK.getInstance().queryCmfreeOfMCardType( typeId, mcardCmfreeDTO, null, pageable,token);

        //卡类型的优惠商铺
        McardMccatalogDTO mcardMccatalogDTO = new McardMccatalogDTO();
        ResponseData<List<McardMccatalogDTO>> logResponseData = McardTypeSDK.getInstance().queryMccatalogOfMCardType(typeId,mcardMccatalogDTO,null,pageable,token);

        if (freeResponseData != null) {
            List<McardCmfreeDTO> mcardCmfrees = freeResponseData.getResult();
            model.put("mcardCmfrees",mcardCmfrees);
        }

        if (logResponseData != null) {
            List<McardMccatalogDTO> mcardMccatalogs = logResponseData.getResult();
            model.put("mcardMccatalogs",mcardMccatalogs);
        }

        return "mcardcsm/mcardinfo/detail/reserve_mc";
    }

    /**
     * 会员卡  我的激活码 TODO 作废，待删除
     * @param model
     * @param session
     * @return
     */
    @RequestMapping(value = "/{typeId}/activecodes")
    public String getMCardTypeActiveCodes(Map<String, Object> model, HttpSession session,
                                      @PathVariable("typeId")String typeId) {
        return "redirect:/mcards/mine/activecodes?typeId=" + typeId;
    }

    /**
     * 会员卡 电子门票 TODO 作废，待删除
     * @param model
     * @param session
     * @return
     */
    @RequestMapping(value = "/{typeId}/etickets")
    public String getMCardTypeETickets(Map<String, Object> model, HttpSession session,
                                      @PathVariable("typeId")String typeId) {
        return "redirect:/mcards/mine/etickets?typeId=" + typeId;
    }

    /**
     * 会员卡 预约 TODO 作废，待删除
     * @param model
     * @param session
     * @return
     */
    @RequestMapping(value = "/{typeId}/book")
    public String bookMCardType(Map<String, Object> model, HttpSession session,
                                      @PathVariable("typeId")String typeId) {
        return "redirect:/mcards/reserve?typeId=" + typeId;
    }


    //--------------------------- 作为消费者详情页面  子卡类型

    /**子卡类型基本信息页面。
     * 显示指定子卡类型的基本信息，仅用于显示用。
     */
    @RequestMapping(value = "/childtypes/{childtypeId}")
    public String getChildtype(Map<String, Object> model, HttpSession session, @PathVariable("childtypeId")String  childtypeId) {
        String token = (String) session.getAttribute("token");

        ResponseData<McardChildtypeDTO> responseData = McardTypeSDK.getInstance().getMCardChildType( childtypeId,token);

        if(responseData != null){
            McardChildtypeDTO mcardChildtype = responseData.getResult();
            model.put("mcardChildtype", mcardChildtype);

            Pageable pageable = new PageRequest(1,100);
            if(mcardChildtype != null){
                //卡类型的年卡商铺
                McardCmfreeDTO mcardCmfreeDTO = new McardCmfreeDTO();
                ResponseData<List<McardCmfreeDTO>> freeResponseData = McardTypeSDK.getInstance().queryCmfreeOfMCardType( mcardChildtype.getTypeId(), mcardCmfreeDTO, null, pageable,token);

                //卡类型的优惠商铺
                McardMccatalogDTO mcardMccatalogDTO = new McardMccatalogDTO();
                ResponseData<List<McardMccatalogDTO>> logResponseData = McardTypeSDK.getInstance().queryMccatalogOfMCardType(mcardChildtype.getTypeId(),mcardMccatalogDTO,null,pageable,token);

                if (freeResponseData != null) {
                    List<McardCmfreeDTO> mcardCmfrees = freeResponseData.getResult();
                    model.put("mcardMcfrees",mcardCmfrees);
                }

                if (logResponseData != null) {
                    List<McardMccatalogDTO> mcardMccatalogs = logResponseData.getResult();
                    model.put("mcardMccatalogs",mcardMccatalogs);
                }
            }

        }

        return "mcardcsm/childtype/detail/baseinfo";
    }

    /**子卡类型详情页面。
     * 显示指定子卡类型的详细信息，并可进行下单购买。
     */
    @RequestMapping(value = "/childtypes/{childtypeId}/detail")
    public String getChildtypeDetail(Map<String, Object> model, HttpSession session) {
        //TODO SDK中没有找到
        return "mcardcsm/childtype/detail/detail";
    }

}
