package com.dayouzc.e2eapp.mcard.mcardcsm.web.controller;

import com.dayouzc.e2eapp.ebusiness.dto.CommodityDTO;
import com.dayouzc.e2eapp.ebusiness.dto.MerchantDTO;
import com.dayouzc.e2eapp.ebusiness.sdk.CommoditySDK;
import com.dayouzc.e2eapp.ebusiness.sdk.MerchantSDK;
import com.dayouzc.e2eapp.mcard.dto.McardRecordDTO;
import com.dayouzc.e2eapp.mcard.sdk.McardInfoSDK;
import com.dayouzc.e2eplatform.core.common.ConditionRangeValue;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpSession;
import java.util.List;
import java.util.Map;

/**
 * Created by Mr.Liu on 2017/8/8.
 *
 * “/userecords”是用卡记录相关资源根目录，主要包括：
 *
 * 1.查询类（买家角度）
 * /card/{cardNum}/userecords	指定会员卡的用卡记录页面。   查询指定卡的用卡记录；指定recordType参数可查询指定类型的用卡记录；如未指定查询时间段，则默认查询当前年度的。
 *
 * 2.查询详情（TODO 是否需要，待定）
 * /{recordId}                  用卡记录基本信息页。
 * /{recordId}/detail           用卡记录详情页。
 *
 * 2.操作类（买家角度）
 * 2.1.使用（商家角度）
 * /reserve		            预约页面。

 */
@Controller
@RequestMapping("/userecords")
public class MCardRecordController {
    private static final Logger logger = LoggerFactory.getLogger(MCardRecordController.class);

    //============================== 查询类（买家角度）

    /**
     * 指定会员卡的用卡记录页面
     * 查询指定卡的用卡记录；指定recordType参数可查询指定类型的用卡记录；如未指定查询时间段，则默认查询当前年度的。
     * @param cardNum           卡号
     * @param recordType        记录类型
     * @return
     */
    @RequestMapping(value = "/card/{cardNum}/userecords")
    public String queryMCardRecordOfCard(
            @PathVariable(value = "cardNum") String cardNum,
            @RequestParam(value = "recordType",required = false)String recordType) {

        //1、校验

        //2、业务处理

        //3、响应
        return "mcardcsm/cardrecord/list/listOfCard";
    }

    //===================== 操作类（买家角度）
    /**预约页面。
     *
     */
    @RequestMapping(value = "/reserve")
    public String reserve(
            Map<String, Object> model,
            HttpSession session,
            @RequestParam("mcId")String mcId) {

        String token = (String) session.getAttribute("token");
        //获取预约商铺信息
        ResponseData<MerchantDTO> mcResponseData = MerchantSDK.getInstance().getMerchant(mcId,token);
        if(mcResponseData != null){
            MerchantDTO mc = mcResponseData.getResult();
            model.put("mc",mc);
            //获取预约商品信息
            ConditionRangeValue rangeValue = new ConditionRangeValue();
            Pageable pageable = new PageRequest(0,100);
            ResponseData<List<CommodityDTO>> cmResponseData = CommoditySDK.getInstance().queryCommodityOfMerchant(mcId, null, rangeValue,pageable,token);
            if(cmResponseData != null){
                List<CommodityDTO> cms = cmResponseData.getResult();
                model.put("cms",cms);
            }
        }

        return "mcardcsm/cardrecord/action/reserve";
    }
    @RequestMapping(value = "/reserve/submit")
    public String reserveSubmit(
            Map<String, Object> model,
            HttpSession session,
            McardRecordDTO mcardRecordDTO ) {
        String token = (String) session.getAttribute("token");

        ResponseData<McardRecordDTO> responseData = McardInfoSDK.getInstance().reserve( mcardRecordDTO,token);
        model.put("mcardRecord", responseData.getResult());
        return "redirect:";
    }
}
