package com.dayouzc.e2eapp.mcard.mcardcsm.web.controller;

import com.alibaba.fastjson.JSONObject;
import com.dayouzc.e2eapp.lforder.constant.OrderConstant;
import com.dayouzc.e2eapp.lforder.dto.OrderInfoDTO;
import com.dayouzc.e2eapp.lforder.dto.RefundInfoDTO;
import com.dayouzc.e2eapp.lforder.sdk.OrderInfoSDK;
import com.dayouzc.e2eapp.mcard.dto.McardDeliverDetailDTO;
import com.dayouzc.e2eapp.mcard.dto.McardInfoDTO;
import com.dayouzc.e2eapp.mcard.dto.McardOrderDetailDTO;
import com.dayouzc.e2eapp.mcard.dto.McardTypeDTO;
import com.dayouzc.e2eapp.mcard.mcardcsm.web.dto.OrderInfoWrapperDTO;
import com.dayouzc.e2eapp.mcard.sdk.McardInfoSDK;
import com.dayouzc.e2eapp.mcard.sdk.McardOrderSDK;
import com.dayouzc.e2eapp.mcard.sdk.McardTypeSDK;
import com.dayouzc.e2eapp.payment.model.base.PayRequest;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import com.dayouzc.e2eplatform.core.util.JsonUtil;
import com.dayouzc.e2eplatform.core.util.NetworkUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Mr.Liu on 2017/8/7.
 *
 * “/mcardorders”是卡订单相关资源根目录，主要包括：
 *
 * 1.订单
 * 1.1.查询类
 * /{orderId}/details		        卡订单详情页。	      显示订单基本信息、卡订单明细、订单退款信息等。
 * /{orderId}/delivers		        卡订单发货信息页。    显示订单基本信息、发货明细。
 *
 * 1.2.操作类
 * /booking		                    购买下单（B2C）页面。     买家发起（需指定下单明细）
 * /upgrade		                    卡升级页面。              如果指定了cardNum参数，则不可修改卡号；否则可输入。
 * /renewal		                    卡续费页面。              如果指定了cardNum参数，则不可修改卡号；否则可输入。
 * /cancel		                    取消订单页面。
 * /receipt	                        收货确认页面。
 *
 * 2.退款单
 * 2.1.查询类
 * /refunds/{refundId}/details		退款单详情页面。	显示退款单基本信息、退款单明细等
 *
 * 2.2.操作类
 * /refund/apply			        退款申请页面。
 *
 */
@Controller
@RequestMapping("/mcardorders")
public class MCardOrderController {
    private static final Logger logger = LoggerFactory.getLogger(MCardOrderController.class);
    private String tokenTemp = "1546f97f-4fb0-4d16-95ea-3e7c85961f01";


    //================================= 页面服务（查询类）

    /**卡订单详情页。
     * 显示订单基本信息、卡订单明细、订单退款信息等。
     */
    @RequestMapping(value = "/{orderId}/details")
    public String getMCardOrderDetailList(Map<String, Object> model, HttpSession session, @PathVariable(value = "orderId") String orderId){
        String token = (String)session.getAttribute("token");
        ResponseData<List<McardOrderDetailDTO>> responseData = McardOrderSDK.getInstance().getMCardOrderDetailList(orderId,token);
        model.put("mcardOrderDetailList", responseData.getResult());
        return "mcardcsm/mcardorder/info/details";
    }

    /**卡订单发货信息页。
     * 显示订单基本信息、发货明细。
     */
    @RequestMapping(value = "/{orderId}/delivers")
    public String getMCardOrderDeliverDetailList(Map<String, Object> model, HttpSession session, @PathVariable(value = "orderId") String orderId){
        String token = (String)session.getAttribute("token");
        ResponseData<List<McardDeliverDetailDTO>> responseData = McardOrderSDK.getInstance().getMCardOrderDeliverDetailList( orderId,token);
        model.put("mcardOrderDetailList", responseData.getResult());
        return "mcardcsm/mcardorder/info/delivers";
    }

    //================================= 页面服务（操作类）

    //--------------------------------- 下单（买家）

    /**购买下单（B2C）页面。
     * 买家发起（需指定下单明细）。
     *
     * TODO 如果购买的实体卡，则不能电子配送；如果是虚拟卡，则只能电子配送
     *  source 标记下单的来源：cm 商品详情下单，cart 购物车下单
     */
    @RequestMapping(value = "/booking")
    public String booking(
            Map<String, Object> model,
            HttpServletRequest request,
            HttpSession session,
            OrderInfoWrapperDTO orderInfoWrapperDTO,
            @RequestParam("source")String source) throws UnsupportedEncodingException {

        String token = (String)session.getAttribute("token");
        logger.info("orderInfoWrapperDTO = [ " + JsonUtil.toJson(orderInfoWrapperDTO) + " ]");
        //1 校验

        //2 业务处理
        if(StringUtils.equals(source,"cart")){
            /*获取cookie购物车*/
        /*cookie中所有商品信息的字符串*/
            String shopCartStr = "";
        /*商品对象数组*/
            String[] cartCmObj = new String[]{};
        /*商品数组集合*/
            List<String[]> cartcms = new ArrayList<>();
        /*获取需要购买的商品集合*/
            List<McardOrderDetailDTO> orderDetails = new ArrayList<>();

            Map<String,Cookie> cookieMap = ReadCookies(request);
            if(cookieMap.containsKey("shopCart")){
                shopCartStr = URLDecoder.decode(cookieMap.get("shopCart").getValue(), "UTF-8");
            }
            if(StringUtils.isNoneEmpty(shopCartStr)){
                cartCmObj = shopCartStr.split("\\|\\$\\|");
            }
            if(cartCmObj.length > 0){
                for (int i = 0; i < cartCmObj.length; i++ ){
                /*单个商品信息数组*/
                    String[] cmInfo = cartCmObj[i].split("\\|\\|");
                    cartcms.add(cmInfo);
                }
            }

        /*购物车界面已选中的商品Id字符串*/
            String checkedCmIds = "";
        /*商品Id数组*/
            String[] cmIds = new String[]{};
            if(orderInfoWrapperDTO.getOrderDetails() != null && orderInfoWrapperDTO.getOrderDetails().size()>0){
                checkedCmIds = orderInfoWrapperDTO.getOrderDetails().get(0).getTypeId();
                if(StringUtils.isEmpty(checkedCmIds)){
                    checkedCmIds = orderInfoWrapperDTO.getOrderDetails().get(0).getChildtypeId();
                }
            }
            if(StringUtils.isNoneEmpty(checkedCmIds)){
                cmIds = checkedCmIds.split(",");
            }
            if(cmIds.length > 0 && cartcms != null && cartcms.size()>0){
                for (int n = 0; n < cmIds.length; n++) {
                    for (int t = 0; t <cartcms.size(); t++){
                        String[] cm = cartcms.get(t);
                    /*将选中的商品Id与cookie中商品Id比较获取cookie中商品的详细信息*/
                        if(StringUtils.equals(cmIds[n],cm[0])){
                            McardOrderDetailDTO orderDetail = new McardOrderDetailDTO();
                            orderDetail.setMcId(cm[4]);/*商铺Id*/
                            if(StringUtils.equals(cm[5],"card")){/*根据卡类型判断*/
                                orderDetail.setTypeId(cm[0]);/*商品Id*/
                                orderDetail.setTypeName(cm[1]);/*商品名称*/
                            }else if(StringUtils.equals(cm[5],"childCard")) {/*根据卡类型判断*/
                                orderDetail.setChildtypeId(cm[0]);/*商品Id*/
                                orderDetail.setChildtypeName(cm[1]);/*商品名称*/
                            }
                            orderDetail.setCardPrice(cm[3]);/*商品价格*/
                            orderDetail.setBuyNumber(cm[2]);/*商品数量*/
                            orderDetail.setIsVirtualCard(cm[6]);/*是否是虚拟卡*/
                            orderDetails.add(orderDetail);

                        }
                    }
                }
                orderInfoWrapperDTO.setOrderDetails(orderDetails);
                orderInfoWrapperDTO.setMcId(cartcms.get(0)[4]);
                orderInfoWrapperDTO.setMcName(cartcms.get(0)[5]);
            }
        }


        model.put("orderInfoWrapper", orderInfoWrapperDTO);

        //3 响应
        return "mcardcsm/mcardorder/action/booking";
    }

    @RequestMapping(value = "/booking/submit")
    public void bookingSubmit(
            Map<String, Object> model,
            HttpSession session,
            HttpServletRequest request,
            HttpServletResponse response,
            PrintWriter writer,
            OrderInfoWrapperDTO orderInfoWrapperDTO) throws UnsupportedEncodingException {

        String token = (String)session.getAttribute("token");

        //2.2 下单
        OrderInfoDTO orderInfoDTOReq = new OrderInfoDTO();
        BeanUtils.copyProperties(orderInfoWrapperDTO, orderInfoDTOReq);
//        orderInfoDTOReq.setCarriage(0);        //TODO 运费暂时为0
        orderInfoDTOReq.setFavAmount(0);       //TODO 优惠金额暂时为0
        orderInfoDTOReq.setFeeAdditional(0);   //TODO 附近费用暂时为0
        ResponseData<OrderInfoDTO> responseData = McardOrderSDK.getInstance().booking(orderInfoDTOReq, token);
        if (responseData == null || !StringUtils.equals("10000", responseData.getStatus())) {
            return;
        }
        OrderInfoDTO orderInfoDTORes = responseData.getResult();
        if (orderInfoDTORes == null) {
            return;
        }

        //2.3 确认
//        orderInfoDTOReq.setOrderId(orderInfoDTORes.getOrderId());
//        McardOrderSDK.getInstance().verify(orderInfoDTOReq, token);

        //2.4 支付
        String jsAPITicket = "";//TODO 暂时先不传
        String basePathWithoutContextPath = NetworkUtils.getBasePathWithoutContextPath(request);
        PayRequest payRequest = new PayRequest();
        payRequest.setOrderId(orderInfoDTORes.getOrderId());
        payRequest.setPaymentAmount(orderInfoDTORes.getOrderAmount().toString());
        //TODO 其他参数如何处理？？？ ①appId拿不到了②typeId也拿不到，临时从卡号中获取
        String typeId = orderInfoWrapperDTO.getOrderDetails().get(0).getTypeId();
        payRequest.setCallBackUrl(NetworkUtils.getBasePath(request) + "/mcards/bind?token=" + token  + "&typeId=" + typeId);//TODO
        if (StringUtils.equals(orderInfoDTORes.getSaleBoId(), "f4c20762ccfc561b45d27f78d2b453ea") || StringUtils.equals(orderInfoDTORes.getSaleBoId(), "cfbb4ba6ba3785590e1515e988d149fd")) {
            // 如果 是湘西分销则跳转至订单详情
            payRequest.setCallBackUrl(NetworkUtils.getBasePathWithoutContextPath(request) + "/ebmccsmweb/orders/"+responseData.getResult().getOrderId()+"/detail?token=" + token);//TODO
        }

        if (StringUtils.equals(orderInfoDTORes.getSaleBoId(), "86546818cc1c51b8114f73b0b969a00c") || StringUtils.equals(orderInfoDTORes.getSaleBoId(), "1a37433012bbf3e4a32085498938ff94")) {
            // 如果是工行公众号聚合支付
            // 临时使用payChannel来标识
            payRequest.setPayChannel("icbc_aggregate_pay");
        }

        String payInfo = JSONObject.toJSONString(payRequest);//TODO
        String url = basePathWithoutContextPath + "/payweb/cashier/launch?jsAPITicket=" + jsAPITicket + "&payInfo=" + URLEncoder.encode(payInfo, "UTF-8") + "&token=" + token;
        String responseStr = null;

        try {
            response.sendRedirect(url.toString());
        } catch (IOException e) {
            logger.error("支付重定向失败", e);
            e.printStackTrace();
        }
        /*try {
            //直接response 输出调用结果，重定向至收银台
            responseStr = HttpUtils.get(url);
            writer.write(responseStr);
        } catch (IOException e) {
            e.printStackTrace();
        }*/
    }

    /**卡升级页面。
     *
     * @param cardNum   如果指定了cardNum参数，则不可修改卡号；否则可输入。
     */
    @RequestMapping(value = "/upgrade")
    public String upgrade(Map<String, Object> model,
                          HttpSession session,
                          @RequestParam("cardNum")String cardNum){

        String token = (String)session.getAttribute("token");
        //获取会员卡信息
        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().getMCardinfo(cardNum,token);
        if(responseData != null){
            McardInfoDTO mcardInfo = responseData.getResult();
            model.put("mcardInfo", mcardInfo);
            //获取卡类型信息
            ResponseData<McardTypeDTO> responseData1 = McardTypeSDK.getInstance().getMCardType( mcardInfo.getTypeId(),token);
            model.put("mcardType",responseData1.getResult());
        }

        //TODO 根据卡类型查询升级策略


        return "mcardcsm/mcardorder/action/upgrade";
    }
    @RequestMapping(value = "/upgrade/submit")
    public String upgradeSubmit(Map<String, Object> model, HttpSession session, OrderInfoDTO orderInfoDTO){
        String token = (String)session.getAttribute("token");
        ResponseData<OrderInfoDTO> responseData = McardOrderSDK.getInstance().upgrade( orderInfoDTO,token);
        model.put("orderInfo", responseData.getResult());
        return "redirect:";
    }

    /**卡续费页面。
     *
     * @param cardNum   如果指定了cardNum参数，则不可修改卡号；否则可输入。
     */
    @RequestMapping(value = "/renewal")
    public String renewal(Map<String, Object> model,
                          HttpSession session,
                          @RequestParam("cardNum")String cardNum){

        String token = (String)session.getAttribute("token");
        //获取会员卡信息
        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().getMCardinfo(cardNum,token);
        if(responseData != null){
            McardInfoDTO mcardInfo = responseData.getResult();
            model.put("mcardInfo", mcardInfo);
            //获取卡类型信息
            ResponseData<McardTypeDTO> responseData1 = McardTypeSDK.getInstance().getMCardType( mcardInfo.getTypeId(),token);
            model.put("mcardType",responseData1.getResult());
        }

        return "mcardcsm/mcardorder/action/renewal";
    }
    @RequestMapping(value = "/renewal/submit")
    public void renewalSubmit(
            Map<String, Object> model,
            HttpSession session,
            HttpServletRequest request,
            HttpServletResponse response,
            PrintWriter writer,
            OrderInfoWrapperDTO orderInfoWrapperDTO) throws UnsupportedEncodingException {

        String token = (String)session.getAttribute("token");

        //2.2 下单
        OrderInfoDTO orderInfoDTOReq = new OrderInfoDTO();
        BeanUtils.copyProperties(orderInfoWrapperDTO, orderInfoDTOReq);
        orderInfoDTOReq.setCarriage(0);        //TODO 运费暂时为0
        orderInfoDTOReq.setFavAmount(0);       //TODO 优惠金额暂时为0
        orderInfoDTOReq.setFeeAdditional(0);   //TODO 附近费用暂时为0
        orderInfoDTOReq.setOrderType(OrderConstant.OrderType.B2C);   //TODO 指定订单类型
        orderInfoDTOReq.setSaleType(OrderConstant.OrderSaleType.RENEWAL);      //TODO 指定销售类型 “续费”
        ResponseData<OrderInfoDTO> responseData = McardOrderSDK.getInstance().booking(orderInfoDTOReq, token);
        if (responseData == null || !StringUtils.equals("10000", responseData.getStatus())) {
            return;
        }
        OrderInfoDTO orderInfoDTORes = responseData.getResult();
        if (orderInfoDTORes == null) {
            return;
        }

        //2.3 支付
        String jsAPITicket = "";//TODO 暂时先不传
        String basePathWithoutContextPath = NetworkUtils.getBasePathWithoutContextPath(request);
        PayRequest payRequest = new PayRequest();
        payRequest.setOrderId(orderInfoDTORes.getOrderId());
        payRequest.setPaymentAmount(orderInfoDTORes.getOrderAmount().toString());
        payRequest.setCallBackUrl(NetworkUtils.getBasePath(request) + "/mcards/"+orderInfoWrapperDTO.getOrderDetails().get(0).getCardNum()+"?token=" + token);//TODO
        String payInfo = JSONObject.toJSONString(payRequest);//TODO
        String url = basePathWithoutContextPath + "/payweb/cashier/launch?jsAPITicket=" + jsAPITicket + "&payInfo=" + URLEncoder.encode(payInfo, "UTF-8") + "&token=" + token;
        String responseStr = null;

        try {
            response.sendRedirect(url.toString());
        } catch (IOException e) {
            logger.error("支付重定向失败", e);
            e.printStackTrace();
        }
//        try {
//            //直接response 输出调用结果，重定向至收银台
//            responseStr = HttpUtils.get(url);
//            writer.write(responseStr);
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
    }
    //--------------------------------- 确认

    /**取消订单页面。
     *
     */
    @RequestMapping(value = "/cancel")
    public String cancel(Map<String, Object> model, HttpSession session, @RequestParam("orderId")String orderId){
        String token = (String)session.getAttribute("token");

        ResponseData<OrderInfoDTO> responseData = OrderInfoSDK.getInstance().getOrderInfo( orderId,token);
        model.put("orderInfo", responseData.getResult());
        return "mcardcsm/mcardorder/action/cancel";
    }
    @RequestMapping(value = "/cancel/submit")
    public String cancelSubmit(Map<String, Object> model, HttpSession session, OrderInfoDTO orderInfoDTO){
        String token = (String)session.getAttribute("token");
        ResponseData<OrderInfoDTO> responseData = OrderInfoSDK.getInstance().cancel( orderInfoDTO,token);
        model.put("orderInfo", responseData.getResult());
        return "redirect:";
    }


    //--------------------------------- 发货

    /**收货确认页面。
     *
     */
    @RequestMapping(value = "/receipt")
    public String receipt(Map<String, Object> model, HttpSession session, @RequestParam("orderId")String orderId){
        String token = (String)session.getAttribute("token");

        ResponseData<OrderInfoDTO> responseData = OrderInfoSDK.getInstance().getOrderInfo( orderId,token);
        model.put("orderInfo", responseData.getResult());
        return "mcardcsm/mcardorder/action/receipt";
    }
    @RequestMapping(value = "/receipt/submit")
    public String receiptSubmit(Map<String, Object> model, HttpSession session, OrderInfoDTO orderInfoDTO){
        String token = (String)session.getAttribute("token");
        ResponseData<OrderInfoDTO> responseData = OrderInfoSDK.getInstance().receipt( orderInfoDTO,token);
        model.put("orderInfo", responseData.getResult());
        return "redirect:";
    }


    //=============================
    // 退款单（卡）
    //==============================

    //========================= 页面服务（查询类）

    /** 退款单详情页面。
     * 显示退款单基本信息、退款单明细等
     */
    @RequestMapping(value = "/refunds/{refundId}/details")
    public String getMCardOrderRefundDetailList(Map<String, Object> model, HttpSession session, @RequestParam("refundId")String refundId){
        String token = (String)session.getAttribute("token");
        //TODO 返回对象没有明确
        ResponseData responseData = McardOrderSDK.getInstance().getMCardOrderRefundDetailList( refundId,token);
        model.put("orderInfo", responseData.getResult());


        return "mcardmgr/mcardorder/refund/details";
    }

    //========================= 页面服务（操作类）

    /**退款申请页面。
     *
     */
    @RequestMapping(value = "/refund/apply")
    public String refundApply(Map<String, Object> model, HttpSession session, @RequestParam("orderId")String orderId){
        String token = (String)session.getAttribute("token");

        ResponseData<OrderInfoDTO> responseData = OrderInfoSDK.getInstance().getOrderInfo( orderId,token);
        model.put("orderInfo", responseData.getResult());
        return "mcardmgr/mcardorder/refund/apply";
    }
    @RequestMapping(value = "/refund/apply/submit")
    public String refundApplySubmit(Map<String, Object> model, HttpSession session, RefundInfoDTO refundInfoDTO){
        String token = (String)session.getAttribute("token");
        ResponseData<RefundInfoDTO> responseData = McardOrderSDK.getInstance().refundApply( refundInfoDTO,token);
        model.put("orderInfo", responseData.getResult());
        return "redirect:";
    }

    /*****************************************2019年3月21日14:52:42 liufan ***************************************************************************************************/
    /*将cookie转化为map*/
    private static Map<String,Cookie> ReadCookies(HttpServletRequest request){
        Map<String,Cookie> cookieMap = new HashMap<String,Cookie>();
        Cookie[] cookies = request.getCookies();
        if(null!=cookies){
            for(Cookie cookie : cookies){
                cookieMap.put(cookie.getName(),cookie);
            }
        }
        return cookieMap;
    }
/*****************************************2019年3月21日14:52:42 liufan ***************************************************************************************************/
}
