package com.dayouzc.e2eapp.mcard.mcardcsm.web;

import com.dayouzc.e2eplatform.core.aop.ContextAccountFullInterceptor;
import com.dayouzc.e2eplatform.core.aop.ContextAccountInterceptor;
import com.dayouzc.e2eplatform.core.aop.TokenInterceptor;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

/**
 * Created by tyutNo4 on 2017/4/11.
 */
@Configuration
public class McardCsmConfigurer extends WebMvcConfigurerAdapter {

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        //对当前context有无token的拦截
        registry.addInterceptor(new TokenInterceptor())
                /* 有效规则 */
                .addPathPatterns("/**")   // 正式环境使用
//                .addPathPatterns("/xxx")   // 测试时使用
                /* 排斥规则 */
                // 系统自带ajax转发功能，默认不需要令牌，故排斥，请勿删除
                .excludePathPatterns("/ajax/**")
                .excludePathPatterns("/error")
                ;
        //对当前context有无用户的拦截
        registry.addInterceptor(new ContextAccountInterceptor())
                /* 有效规则 */
                .addPathPatterns("/orders/**")   // 统一订单
                .addPathPatterns("/refunds/**")   // 退款单
                .addPathPatterns("/eborders/**")   // 电商订单
                .addPathPatterns("/mcardorders/**")   // 卡订单
                .addPathPatterns("/cart/**")   // 购物车
                .addPathPatterns("/mcards/mine/**")   // 我的卡
                .addPathPatterns("/icbcmims/**")   // 工行融e联
                .addPathPatterns("/mcardtypes/*/detail")   // 卡详情
                .addPathPatterns("/mcards/bind")   // 会员卡绑定页面
                .addPathPatterns("/mcards/reserve")   // 会员卡预约页面
                /* 排斥规则 */
//                .excludePathPatterns("/login/**")
                .excludePathPatterns("/mcards/mine/hntga")  //湖南公安对接页面
        ;
        //对当前context中用户信息是否完整的拦截
        registry.addInterceptor(new ContextAccountFullInterceptor())
                /* 有效规则 */
                .addPathPatterns("/icbcmims/**")   // 工行融e联
                /* 排斥规则 */
//                .excludePathPatterns("/mcards/mine")
//                .excludePathPatterns("/mcards/mine/hntga")
        ;

        super.addInterceptors(registry);

    }


}
